/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TerminologyDataFormat {
    CSV("CSV"),
    TMX("TMX"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TerminologyDataFormat> VALUE_MAP;
    private final String value;

    private TerminologyDataFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TerminologyDataFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TerminologyDataFormat> knownValues() {
        EnumSet<TerminologyDataFormat> knownValues = EnumSet.allOf(TerminologyDataFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TerminologyDataFormat.class, TerminologyDataFormat::toString);
    }
}

