/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The custom terminology applied to the input text by Amazon Translate for the translated text response. This is
 * optional in the response and will only be present if you specified terminology input in the request. Currently, only
 * one terminology can be applied per TranslateText request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AppliedTerminology implements SdkPojo, Serializable,
        ToCopyableBuilder<AppliedTerminology.Builder, AppliedTerminology> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AppliedTerminology::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<Term>> TERMS_FIELD = SdkField
            .<List<Term>> builder(MarshallingType.LIST)
            .memberName("Terms")
            .getter(getter(AppliedTerminology::terms))
            .setter(setter(Builder::terms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Terms").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Term> builder(MarshallingType.SDK_POJO)
                                            .constructor(Term::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TERMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<Term> terms;

    private AppliedTerminology(BuilderImpl builder) {
        this.name = builder.name;
        this.terms = builder.terms;
    }

    /**
     * <p>
     * The name of the custom terminology applied to the input text by Amazon Translate for the translated text
     * response.
     * </p>
     * 
     * @return The name of the custom terminology applied to the input text by Amazon Translate for the translated text
     *         response.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Terms property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTerms() {
        return terms != null && !(terms instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The specific terms of the custom terminology applied to the input text by Amazon Translate for the translated
     * text response. A maximum of 250 terms will be returned, and the specific terms applied will be the first 250
     * terms in the source text.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTerms} method.
     * </p>
     * 
     * @return The specific terms of the custom terminology applied to the input text by Amazon Translate for the
     *         translated text response. A maximum of 250 terms will be returned, and the specific terms applied will be
     *         the first 250 terms in the source text.
     */
    public final List<Term> terms() {
        return terms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTerms() ? terms() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppliedTerminology)) {
            return false;
        }
        AppliedTerminology other = (AppliedTerminology) obj;
        return Objects.equals(name(), other.name()) && hasTerms() == other.hasTerms() && Objects.equals(terms(), other.terms());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AppliedTerminology").add("Name", name()).add("Terms", hasTerms() ? terms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Terms":
            return Optional.ofNullable(clazz.cast(terms()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppliedTerminology, T> g) {
        return obj -> g.apply((AppliedTerminology) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AppliedTerminology> {
        /**
         * <p>
         * The name of the custom terminology applied to the input text by Amazon Translate for the translated text
         * response.
         * </p>
         * 
         * @param name
         *        The name of the custom terminology applied to the input text by Amazon Translate for the translated
         *        text response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The specific terms of the custom terminology applied to the input text by Amazon Translate for the translated
         * text response. A maximum of 250 terms will be returned, and the specific terms applied will be the first 250
         * terms in the source text.
         * </p>
         * 
         * @param terms
         *        The specific terms of the custom terminology applied to the input text by Amazon Translate for the
         *        translated text response. A maximum of 250 terms will be returned, and the specific terms applied will
         *        be the first 250 terms in the source text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terms(Collection<Term> terms);

        /**
         * <p>
         * The specific terms of the custom terminology applied to the input text by Amazon Translate for the translated
         * text response. A maximum of 250 terms will be returned, and the specific terms applied will be the first 250
         * terms in the source text.
         * </p>
         * 
         * @param terms
         *        The specific terms of the custom terminology applied to the input text by Amazon Translate for the
         *        translated text response. A maximum of 250 terms will be returned, and the specific terms applied will
         *        be the first 250 terms in the source text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terms(Term... terms);

        /**
         * <p>
         * The specific terms of the custom terminology applied to the input text by Amazon Translate for the translated
         * text response. A maximum of 250 terms will be returned, and the specific terms applied will be the first 250
         * terms in the source text.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Term>.Builder} avoiding the need to create
         * one manually via {@link List<Term>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Term>.Builder#build()} is called immediately and its result
         * is passed to {@link #terms(List<Term>)}.
         * 
         * @param terms
         *        a consumer that will call methods on {@link List<Term>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #terms(List<Term>)
         */
        Builder terms(Consumer<Term.Builder>... terms);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<Term> terms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AppliedTerminology model) {
            name(model.name);
            terms(model.terms);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<Term.Builder> getTerms() {
            List<Term.Builder> result = TermListCopier.copyToBuilder(this.terms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTerms(Collection<Term.BuilderImpl> terms) {
            this.terms = TermListCopier.copyFromBuilder(terms);
        }

        @Override
        @Transient
        public final Builder terms(Collection<Term> terms) {
            this.terms = TermListCopier.copy(terms);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder terms(Term... terms) {
            terms(Arrays.asList(terms));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder terms(Consumer<Term.Builder>... terms) {
            terms(Stream.of(terms).map(c -> Term.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AppliedTerminology build() {
            return new AppliedTerminology(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
