/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The term being translated by the custom terminology.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Term implements SdkPojo, Serializable, ToCopyableBuilder<Term.Builder, Term> {
    private static final SdkField<String> SOURCE_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceText").getter(getter(Term::sourceText)).setter(setter(Builder::sourceText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceText").build()).build();

    private static final SdkField<String> TARGET_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetText").getter(getter(Term::targetText)).setter(setter(Builder::targetText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TEXT_FIELD,
            TARGET_TEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sourceText;

    private final String targetText;

    private Term(BuilderImpl builder) {
        this.sourceText = builder.sourceText;
        this.targetText = builder.targetText;
    }

    /**
     * <p>
     * The source text of the term being translated by the custom terminology.
     * </p>
     * 
     * @return The source text of the term being translated by the custom terminology.
     */
    public final String sourceText() {
        return sourceText;
    }

    /**
     * <p>
     * The target text of the term being translated by the custom terminology.
     * </p>
     * 
     * @return The target text of the term being translated by the custom terminology.
     */
    public final String targetText() {
        return targetText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceText());
        hashCode = 31 * hashCode + Objects.hashCode(targetText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Term)) {
            return false;
        }
        Term other = (Term) obj;
        return Objects.equals(sourceText(), other.sourceText()) && Objects.equals(targetText(), other.targetText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Term").add("SourceText", sourceText()).add("TargetText", targetText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceText":
            return Optional.ofNullable(clazz.cast(sourceText()));
        case "TargetText":
            return Optional.ofNullable(clazz.cast(targetText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Term, T> g) {
        return obj -> g.apply((Term) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Term> {
        /**
         * <p>
         * The source text of the term being translated by the custom terminology.
         * </p>
         * 
         * @param sourceText
         *        The source text of the term being translated by the custom terminology.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceText(String sourceText);

        /**
         * <p>
         * The target text of the term being translated by the custom terminology.
         * </p>
         * 
         * @param targetText
         *        The target text of the term being translated by the custom terminology.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetText(String targetText);
    }

    static final class BuilderImpl implements Builder {
        private String sourceText;

        private String targetText;

        private BuilderImpl() {
        }

        private BuilderImpl(Term model) {
            sourceText(model.sourceText);
            targetText(model.targetText);
        }

        public final String getSourceText() {
            return sourceText;
        }

        public final void setSourceText(String sourceText) {
            this.sourceText = sourceText;
        }

        @Override
        @Transient
        public final Builder sourceText(String sourceText) {
            this.sourceText = sourceText;
            return this;
        }

        public final String getTargetText() {
            return targetText;
        }

        public final void setTargetText(String targetText) {
            this.targetText = targetText;
        }

        @Override
        @Transient
        public final Builder targetText(String targetText) {
            this.targetText = targetText;
            return this;
        }

        @Override
        public Term build() {
            return new Term(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
