/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The encryption key used to encrypt this object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EncryptionKey implements SdkPojo, Serializable, ToCopyableBuilder<EncryptionKey.Builder, EncryptionKey> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(EncryptionKey::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(EncryptionKey::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String id;

    private EncryptionKey(BuilderImpl builder) {
        this.type = builder.type;
        this.id = builder.id;
    }

    /**
     * <p>
     * The type of encryption key used by Amazon Translate to encrypt custom terminologies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EncryptionKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of encryption key used by Amazon Translate to encrypt custom terminologies.
     * @see EncryptionKeyType
     */
    public final EncryptionKeyType type() {
        return EncryptionKeyType.fromValue(type);
    }

    /**
     * <p>
     * The type of encryption key used by Amazon Translate to encrypt custom terminologies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EncryptionKeyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of encryption key used by Amazon Translate to encrypt custom terminologies.
     * @see EncryptionKeyType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the encryption key being used to encrypt the custom terminology.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the encryption key being used to encrypt the custom terminology.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionKey)) {
            return false;
        }
        EncryptionKey other = (EncryptionKey) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EncryptionKey").add("Type", typeAsString()).add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionKey, T> g) {
        return obj -> g.apply((EncryptionKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EncryptionKey> {
        /**
         * <p>
         * The type of encryption key used by Amazon Translate to encrypt custom terminologies.
         * </p>
         * 
         * @param type
         *        The type of encryption key used by Amazon Translate to encrypt custom terminologies.
         * @see EncryptionKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionKeyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of encryption key used by Amazon Translate to encrypt custom terminologies.
         * </p>
         * 
         * @param type
         *        The type of encryption key used by Amazon Translate to encrypt custom terminologies.
         * @see EncryptionKeyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptionKeyType
         */
        Builder type(EncryptionKeyType type);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the encryption key being used to encrypt the custom terminology.
         * </p>
         * 
         * @param id
         *        The Amazon Resource Name (ARN) of the encryption key being used to encrypt the custom terminology.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionKey model) {
            type(model.type);
            id(model.id);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(EncryptionKeyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public EncryptionKey build() {
            return new EncryptionKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
