/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.translate.model.AppliedTerminology;
import software.amazon.awssdk.services.translate.model.AppliedTerminologyListCopier;
import software.amazon.awssdk.services.translate.model.TranslateResponse;
import software.amazon.awssdk.services.translate.model.TranslatedDocument;
import software.amazon.awssdk.services.translate.model.TranslationSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TranslateDocumentResponse
extends TranslateResponse
implements ToCopyableBuilder<Builder, TranslateDocumentResponse> {
    private static final SdkField<TranslatedDocument> TRANSLATED_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TranslatedDocument").getter(TranslateDocumentResponse.getter(TranslateDocumentResponse::translatedDocument)).setter(TranslateDocumentResponse.setter(Builder::translatedDocument)).constructor(TranslatedDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranslatedDocument").build()}).build();
    private static final SdkField<String> SOURCE_LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceLanguageCode").getter(TranslateDocumentResponse.getter(TranslateDocumentResponse::sourceLanguageCode)).setter(TranslateDocumentResponse.setter(Builder::sourceLanguageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLanguageCode").build()}).build();
    private static final SdkField<String> TARGET_LANGUAGE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetLanguageCode").getter(TranslateDocumentResponse.getter(TranslateDocumentResponse::targetLanguageCode)).setter(TranslateDocumentResponse.setter(Builder::targetLanguageCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLanguageCode").build()}).build();
    private static final SdkField<List<AppliedTerminology>> APPLIED_TERMINOLOGIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AppliedTerminologies").getter(TranslateDocumentResponse.getter(TranslateDocumentResponse::appliedTerminologies)).setter(TranslateDocumentResponse.setter(Builder::appliedTerminologies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedTerminologies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AppliedTerminology::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TranslationSettings> APPLIED_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AppliedSettings").getter(TranslateDocumentResponse.getter(TranslateDocumentResponse::appliedSettings)).setter(TranslateDocumentResponse.setter(Builder::appliedSettings)).constructor(TranslationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSLATED_DOCUMENT_FIELD, SOURCE_LANGUAGE_CODE_FIELD, TARGET_LANGUAGE_CODE_FIELD, APPLIED_TERMINOLOGIES_FIELD, APPLIED_SETTINGS_FIELD));
    private final TranslatedDocument translatedDocument;
    private final String sourceLanguageCode;
    private final String targetLanguageCode;
    private final List<AppliedTerminology> appliedTerminologies;
    private final TranslationSettings appliedSettings;

    private TranslateDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.translatedDocument = builder.translatedDocument;
        this.sourceLanguageCode = builder.sourceLanguageCode;
        this.targetLanguageCode = builder.targetLanguageCode;
        this.appliedTerminologies = builder.appliedTerminologies;
        this.appliedSettings = builder.appliedSettings;
    }

    public final TranslatedDocument translatedDocument() {
        return this.translatedDocument;
    }

    public final String sourceLanguageCode() {
        return this.sourceLanguageCode;
    }

    public final String targetLanguageCode() {
        return this.targetLanguageCode;
    }

    public final boolean hasAppliedTerminologies() {
        return this.appliedTerminologies != null && !(this.appliedTerminologies instanceof SdkAutoConstructList);
    }

    public final List<AppliedTerminology> appliedTerminologies() {
        return this.appliedTerminologies;
    }

    public final TranslationSettings appliedSettings() {
        return this.appliedSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.translatedDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppliedTerminologies() ? this.appliedTerminologies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.appliedSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranslateDocumentResponse)) {
            return false;
        }
        TranslateDocumentResponse other = (TranslateDocumentResponse)((Object)obj);
        return Objects.equals(this.translatedDocument(), other.translatedDocument()) && Objects.equals(this.sourceLanguageCode(), other.sourceLanguageCode()) && Objects.equals(this.targetLanguageCode(), other.targetLanguageCode()) && this.hasAppliedTerminologies() == other.hasAppliedTerminologies() && Objects.equals(this.appliedTerminologies(), other.appliedTerminologies()) && Objects.equals(this.appliedSettings(), other.appliedSettings());
    }

    public final String toString() {
        return ToString.builder((String)"TranslateDocumentResponse").add("TranslatedDocument", (Object)this.translatedDocument()).add("SourceLanguageCode", (Object)this.sourceLanguageCode()).add("TargetLanguageCode", (Object)this.targetLanguageCode()).add("AppliedTerminologies", this.hasAppliedTerminologies() ? this.appliedTerminologies() : null).add("AppliedSettings", (Object)this.appliedSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TranslatedDocument": {
                return Optional.ofNullable(clazz.cast(this.translatedDocument()));
            }
            case "SourceLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.sourceLanguageCode()));
            }
            case "TargetLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.targetLanguageCode()));
            }
            case "AppliedTerminologies": {
                return Optional.ofNullable(clazz.cast(this.appliedTerminologies()));
            }
            case "AppliedSettings": {
                return Optional.ofNullable(clazz.cast(this.appliedSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TranslateDocumentResponse, T> g) {
        return obj -> g.apply((TranslateDocumentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranslateResponse.BuilderImpl
    implements Builder {
        private TranslatedDocument translatedDocument;
        private String sourceLanguageCode;
        private String targetLanguageCode;
        private List<AppliedTerminology> appliedTerminologies = DefaultSdkAutoConstructList.getInstance();
        private TranslationSettings appliedSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(TranslateDocumentResponse model) {
            super(model);
            this.translatedDocument(model.translatedDocument);
            this.sourceLanguageCode(model.sourceLanguageCode);
            this.targetLanguageCode(model.targetLanguageCode);
            this.appliedTerminologies(model.appliedTerminologies);
            this.appliedSettings(model.appliedSettings);
        }

        public final TranslatedDocument.Builder getTranslatedDocument() {
            return this.translatedDocument != null ? this.translatedDocument.toBuilder() : null;
        }

        public final void setTranslatedDocument(TranslatedDocument.BuilderImpl translatedDocument) {
            this.translatedDocument = translatedDocument != null ? translatedDocument.build() : null;
        }

        @Override
        public final Builder translatedDocument(TranslatedDocument translatedDocument) {
            this.translatedDocument = translatedDocument;
            return this;
        }

        public final String getSourceLanguageCode() {
            return this.sourceLanguageCode;
        }

        public final void setSourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
        }

        @Override
        public final Builder sourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
            return this;
        }

        public final String getTargetLanguageCode() {
            return this.targetLanguageCode;
        }

        public final void setTargetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
        }

        @Override
        public final Builder targetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
            return this;
        }

        public final List<AppliedTerminology.Builder> getAppliedTerminologies() {
            List<AppliedTerminology.Builder> result = AppliedTerminologyListCopier.copyToBuilder(this.appliedTerminologies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppliedTerminologies(Collection<AppliedTerminology.BuilderImpl> appliedTerminologies) {
            this.appliedTerminologies = AppliedTerminologyListCopier.copyFromBuilder(appliedTerminologies);
        }

        @Override
        public final Builder appliedTerminologies(Collection<AppliedTerminology> appliedTerminologies) {
            this.appliedTerminologies = AppliedTerminologyListCopier.copy(appliedTerminologies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appliedTerminologies(AppliedTerminology ... appliedTerminologies) {
            this.appliedTerminologies(Arrays.asList(appliedTerminologies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appliedTerminologies(Consumer<AppliedTerminology.Builder> ... appliedTerminologies) {
            this.appliedTerminologies(Stream.of(appliedTerminologies).map(c -> (AppliedTerminology)((AppliedTerminology.Builder)AppliedTerminology.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TranslationSettings.Builder getAppliedSettings() {
            return this.appliedSettings != null ? this.appliedSettings.toBuilder() : null;
        }

        public final void setAppliedSettings(TranslationSettings.BuilderImpl appliedSettings) {
            this.appliedSettings = appliedSettings != null ? appliedSettings.build() : null;
        }

        @Override
        public final Builder appliedSettings(TranslationSettings appliedSettings) {
            this.appliedSettings = appliedSettings;
            return this;
        }

        @Override
        public TranslateDocumentResponse build() {
            return new TranslateDocumentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranslateResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TranslateDocumentResponse> {
        public Builder translatedDocument(TranslatedDocument var1);

        default public Builder translatedDocument(Consumer<TranslatedDocument.Builder> translatedDocument) {
            return this.translatedDocument((TranslatedDocument)((TranslatedDocument.Builder)TranslatedDocument.builder().applyMutation(translatedDocument)).build());
        }

        public Builder sourceLanguageCode(String var1);

        public Builder targetLanguageCode(String var1);

        public Builder appliedTerminologies(Collection<AppliedTerminology> var1);

        public Builder appliedTerminologies(AppliedTerminology ... var1);

        public Builder appliedTerminologies(Consumer<AppliedTerminology.Builder> ... var1);

        public Builder appliedSettings(TranslationSettings var1);

        default public Builder appliedSettings(Consumer<TranslationSettings.Builder> appliedSettings) {
            return this.appliedSettings((TranslationSettings)((TranslationSettings.Builder)TranslationSettings.builder().applyMutation(appliedSettings)).build());
        }
    }
}

