/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The content and content type of a document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Document implements SdkPojo, Serializable, ToCopyableBuilder<Document.Builder, Document> {
    private static final SdkField<SdkBytes> CONTENT_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("Content").getter(getter(Document::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(Document::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            CONTENT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final SdkBytes content;

    private final String contentType;

    private Document(BuilderImpl builder) {
        this.content = builder.content;
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * The <code>Content</code>field type is Binary large object (blob). This object contains the document content
     * converted into base64-encoded binary data. If you use one of the AWS SDKs, the SDK performs the Base64-encoding
     * on this field before sending the request.
     * </p>
     * 
     * @return The <code>Content</code>field type is Binary large object (blob). This object contains the document
     *         content converted into base64-encoded binary data. If you use one of the AWS SDKs, the SDK performs the
     *         Base64-encoding on this field before sending the request.
     */
    public final SdkBytes content() {
        return content;
    }

    /**
     * <p>
     * Describes the format of the document. You can specify one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>text/html</code> - The input data consists of HTML content. Amazon Translate translates only the text in
     * the HTML element.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>text/plain</code> - The input data consists of unformatted text. Amazon Translate translates every
     * character in the content.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>application/vnd.openxmlformats-officedocument.wordprocessingml.document</code> - The input data consists of
     * a Word document (.docx).
     * </p>
     * </li>
     * </ul>
     * 
     * @return Describes the format of the document. You can specify one of the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>text/html</code> - The input data consists of HTML content. Amazon Translate translates only the
     *         text in the HTML element.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>text/plain</code> - The input data consists of unformatted text. Amazon Translate translates every
     *         character in the content.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>application/vnd.openxmlformats-officedocument.wordprocessingml.document</code> - The input data
     *         consists of a Word document (.docx).
     *         </p>
     *         </li>
     */
    public final String contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Document)) {
            return false;
        }
        Document other = (Document) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(contentType(), other.contentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Document").add("Content", content() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ContentType", contentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Document, T> g) {
        return obj -> g.apply((Document) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Document> {
        /**
         * <p>
         * The <code>Content</code>field type is Binary large object (blob). This object contains the document content
         * converted into base64-encoded binary data. If you use one of the AWS SDKs, the SDK performs the
         * Base64-encoding on this field before sending the request.
         * </p>
         * 
         * @param content
         *        The <code>Content</code>field type is Binary large object (blob). This object contains the document
         *        content converted into base64-encoded binary data. If you use one of the AWS SDKs, the SDK performs
         *        the Base64-encoding on this field before sending the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(SdkBytes content);

        /**
         * <p>
         * Describes the format of the document. You can specify one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>text/html</code> - The input data consists of HTML content. Amazon Translate translates only the text
         * in the HTML element.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>text/plain</code> - The input data consists of unformatted text. Amazon Translate translates every
         * character in the content.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>application/vnd.openxmlformats-officedocument.wordprocessingml.document</code> - The input data
         * consists of a Word document (.docx).
         * </p>
         * </li>
         * </ul>
         * 
         * @param contentType
         *        Describes the format of the document. You can specify one of the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>text/html</code> - The input data consists of HTML content. Amazon Translate translates only the
         *        text in the HTML element.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>text/plain</code> - The input data consists of unformatted text. Amazon Translate translates
         *        every character in the content.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>application/vnd.openxmlformats-officedocument.wordprocessingml.document</code> - The input data
         *        consists of a Word document (.docx).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes content;

        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(Document model) {
            content(model.content);
            contentType(model.contentType);
        }

        public final ByteBuffer getContent() {
            return content == null ? null : content.asByteBuffer();
        }

        public final void setContent(ByteBuffer content) {
            content(content == null ? null : SdkBytes.fromByteBuffer(content));
        }

        @Override
        public final Builder content(SdkBytes content) {
            this.content = content;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public Document build() {
            return new Document(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
