/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.translate.model.CreateParallelDataRequest;
import software.amazon.awssdk.services.translate.model.CreateParallelDataResponse;
import software.amazon.awssdk.services.translate.model.DeleteParallelDataRequest;
import software.amazon.awssdk.services.translate.model.DeleteParallelDataResponse;
import software.amazon.awssdk.services.translate.model.DeleteTerminologyRequest;
import software.amazon.awssdk.services.translate.model.DeleteTerminologyResponse;
import software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobRequest;
import software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobResponse;
import software.amazon.awssdk.services.translate.model.GetParallelDataRequest;
import software.amazon.awssdk.services.translate.model.GetParallelDataResponse;
import software.amazon.awssdk.services.translate.model.GetTerminologyRequest;
import software.amazon.awssdk.services.translate.model.GetTerminologyResponse;
import software.amazon.awssdk.services.translate.model.ImportTerminologyRequest;
import software.amazon.awssdk.services.translate.model.ImportTerminologyResponse;
import software.amazon.awssdk.services.translate.model.ListLanguagesRequest;
import software.amazon.awssdk.services.translate.model.ListLanguagesResponse;
import software.amazon.awssdk.services.translate.model.ListParallelDataRequest;
import software.amazon.awssdk.services.translate.model.ListParallelDataResponse;
import software.amazon.awssdk.services.translate.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.translate.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.translate.model.ListTerminologiesRequest;
import software.amazon.awssdk.services.translate.model.ListTerminologiesResponse;
import software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest;
import software.amazon.awssdk.services.translate.model.ListTextTranslationJobsResponse;
import software.amazon.awssdk.services.translate.model.StartTextTranslationJobRequest;
import software.amazon.awssdk.services.translate.model.StartTextTranslationJobResponse;
import software.amazon.awssdk.services.translate.model.StopTextTranslationJobRequest;
import software.amazon.awssdk.services.translate.model.StopTextTranslationJobResponse;
import software.amazon.awssdk.services.translate.model.TagResourceRequest;
import software.amazon.awssdk.services.translate.model.TagResourceResponse;
import software.amazon.awssdk.services.translate.model.TranslateDocumentRequest;
import software.amazon.awssdk.services.translate.model.TranslateDocumentResponse;
import software.amazon.awssdk.services.translate.model.TranslateTextRequest;
import software.amazon.awssdk.services.translate.model.TranslateTextResponse;
import software.amazon.awssdk.services.translate.model.UntagResourceRequest;
import software.amazon.awssdk.services.translate.model.UntagResourceResponse;
import software.amazon.awssdk.services.translate.model.UpdateParallelDataRequest;
import software.amazon.awssdk.services.translate.model.UpdateParallelDataResponse;
import software.amazon.awssdk.services.translate.paginators.ListLanguagesPublisher;
import software.amazon.awssdk.services.translate.paginators.ListParallelDataPublisher;
import software.amazon.awssdk.services.translate.paginators.ListTerminologiesPublisher;
import software.amazon.awssdk.services.translate.paginators.ListTextTranslationJobsPublisher;

/**
 * Service client for accessing Amazon Translate asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@link SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * Provides translation of the input content from the source language to the target language.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface TranslateAsyncClient extends AwsClient {
    String SERVICE_NAME = "translate";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "translate";

    /**
     * <p>
     * Creates a parallel data resource in Amazon Translate by importing an input file from Amazon S3. Parallel data
     * files contain examples that show how you want segments of text to be translated. By adding parallel data, you can
     * influence the style, tone, and word choice in your translation output.
     * </p>
     *
     * @param createParallelDataRequest
     * @return A Java Future containing the result of the CreateParallelData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>InvalidRequestException The request that you made is not valid. Check your request to determine why
     *         it's not valid and then retry the request.</li>
     *         <li>LimitExceededException The specified limit has been exceeded. Review your request and retry it with a
     *         quantity below the stated limit.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>TooManyTagsException You have added too many tags to this resource. The maximum is 50 tags.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>ConcurrentModificationException Another modification is being made. That modification must complete
     *         before you can make your change.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.CreateParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/CreateParallelData" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateParallelDataResponse> createParallelData(CreateParallelDataRequest createParallelDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a parallel data resource in Amazon Translate by importing an input file from Amazon S3. Parallel data
     * files contain examples that show how you want segments of text to be translated. By adding parallel data, you can
     * influence the style, tone, and word choice in your translation output.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateParallelDataRequest.Builder} avoiding the
     * need to create one manually via {@link CreateParallelDataRequest#builder()}
     * </p>
     *
     * @param createParallelDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.CreateParallelDataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateParallelData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>InvalidRequestException The request that you made is not valid. Check your request to determine why
     *         it's not valid and then retry the request.</li>
     *         <li>LimitExceededException The specified limit has been exceeded. Review your request and retry it with a
     *         quantity below the stated limit.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>TooManyTagsException You have added too many tags to this resource. The maximum is 50 tags.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>ConcurrentModificationException Another modification is being made. That modification must complete
     *         before you can make your change.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.CreateParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/CreateParallelData" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateParallelDataResponse> createParallelData(
            Consumer<CreateParallelDataRequest.Builder> createParallelDataRequest) {
        return createParallelData(CreateParallelDataRequest.builder().applyMutation(createParallelDataRequest).build());
    }

    /**
     * <p>
     * Deletes a parallel data resource in Amazon Translate.
     * </p>
     *
     * @param deleteParallelDataRequest
     * @return A Java Future containing the result of the DeleteParallelData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another modification is being made. That modification must complete
     *         before you can make your change.</li>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.DeleteParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DeleteParallelData" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteParallelDataResponse> deleteParallelData(DeleteParallelDataRequest deleteParallelDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a parallel data resource in Amazon Translate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteParallelDataRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteParallelDataRequest#builder()}
     * </p>
     *
     * @param deleteParallelDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.DeleteParallelDataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteParallelData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another modification is being made. That modification must complete
     *         before you can make your change.</li>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.DeleteParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DeleteParallelData" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteParallelDataResponse> deleteParallelData(
            Consumer<DeleteParallelDataRequest.Builder> deleteParallelDataRequest) {
        return deleteParallelData(DeleteParallelDataRequest.builder().applyMutation(deleteParallelDataRequest).build());
    }

    /**
     * <p>
     * A synchronous action that deletes a custom terminology.
     * </p>
     *
     * @param deleteTerminologyRequest
     * @return A Java Future containing the result of the DeleteTerminology operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.DeleteTerminology
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DeleteTerminology" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTerminologyResponse> deleteTerminology(DeleteTerminologyRequest deleteTerminologyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A synchronous action that deletes a custom terminology.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTerminologyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTerminologyRequest#builder()}
     * </p>
     *
     * @param deleteTerminologyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.DeleteTerminologyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTerminology operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.DeleteTerminology
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DeleteTerminology" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteTerminologyResponse> deleteTerminology(
            Consumer<DeleteTerminologyRequest.Builder> deleteTerminologyRequest) {
        return deleteTerminology(DeleteTerminologyRequest.builder().applyMutation(deleteTerminologyRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with an asynchronous batch translation job including name, ID, status, source and
     * target languages, input/output S3 buckets, and so on.
     * </p>
     *
     * @param describeTextTranslationJobRequest
     * @return A Java Future containing the result of the DescribeTextTranslationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.DescribeTextTranslationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DescribeTextTranslationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTextTranslationJobResponse> describeTextTranslationJob(
            DescribeTextTranslationJobRequest describeTextTranslationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with an asynchronous batch translation job including name, ID, status, source and
     * target languages, input/output S3 buckets, and so on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTextTranslationJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTextTranslationJobRequest#builder()}
     * </p>
     *
     * @param describeTextTranslationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeTextTranslationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.DescribeTextTranslationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DescribeTextTranslationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeTextTranslationJobResponse> describeTextTranslationJob(
            Consumer<DescribeTextTranslationJobRequest.Builder> describeTextTranslationJobRequest) {
        return describeTextTranslationJob(DescribeTextTranslationJobRequest.builder()
                .applyMutation(describeTextTranslationJobRequest).build());
    }

    /**
     * <p>
     * Provides information about a parallel data resource.
     * </p>
     *
     * @param getParallelDataRequest
     * @return A Java Future containing the result of the GetParallelData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.GetParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/GetParallelData" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetParallelDataResponse> getParallelData(GetParallelDataRequest getParallelDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a parallel data resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetParallelDataRequest.Builder} avoiding the need
     * to create one manually via {@link GetParallelDataRequest#builder()}
     * </p>
     *
     * @param getParallelDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.GetParallelDataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetParallelData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.GetParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/GetParallelData" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetParallelDataResponse> getParallelData(
            Consumer<GetParallelDataRequest.Builder> getParallelDataRequest) {
        return getParallelData(GetParallelDataRequest.builder().applyMutation(getParallelDataRequest).build());
    }

    /**
     * <p>
     * Retrieves a custom terminology.
     * </p>
     *
     * @param getTerminologyRequest
     * @return A Java Future containing the result of the GetTerminology operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.GetTerminology
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/GetTerminology" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTerminologyResponse> getTerminology(GetTerminologyRequest getTerminologyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a custom terminology.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTerminologyRequest.Builder} avoiding the need to
     * create one manually via {@link GetTerminologyRequest#builder()}
     * </p>
     *
     * @param getTerminologyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.GetTerminologyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTerminology operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.GetTerminology
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/GetTerminology" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTerminologyResponse> getTerminology(Consumer<GetTerminologyRequest.Builder> getTerminologyRequest) {
        return getTerminology(GetTerminologyRequest.builder().applyMutation(getTerminologyRequest).build());
    }

    /**
     * <p>
     * Creates or updates a custom terminology, depending on whether one already exists for the given terminology name.
     * Importing a terminology with the same name as an existing one will merge the terminologies based on the chosen
     * merge strategy. The only supported merge strategy is OVERWRITE, where the imported terminology overwrites the
     * existing terminology of the same name.
     * </p>
     * <p>
     * If you import a terminology that overwrites an existing one, the new terminology takes up to 10 minutes to fully
     * propagate. After that, translations have access to the new terminology.
     * </p>
     *
     * @param importTerminologyRequest
     * @return A Java Future containing the result of the ImportTerminology operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>LimitExceededException The specified limit has been exceeded. Review your request and retry it with a
     *         quantity below the stated limit.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>TooManyTagsException You have added too many tags to this resource. The maximum is 50 tags.</li>
     *         <li>ConcurrentModificationException Another modification is being made. That modification must complete
     *         before you can make your change.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ImportTerminology
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ImportTerminology" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ImportTerminologyResponse> importTerminology(ImportTerminologyRequest importTerminologyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a custom terminology, depending on whether one already exists for the given terminology name.
     * Importing a terminology with the same name as an existing one will merge the terminologies based on the chosen
     * merge strategy. The only supported merge strategy is OVERWRITE, where the imported terminology overwrites the
     * existing terminology of the same name.
     * </p>
     * <p>
     * If you import a terminology that overwrites an existing one, the new terminology takes up to 10 minutes to fully
     * propagate. After that, translations have access to the new terminology.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportTerminologyRequest.Builder} avoiding the need
     * to create one manually via {@link ImportTerminologyRequest#builder()}
     * </p>
     *
     * @param importTerminologyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.ImportTerminologyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ImportTerminology operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>LimitExceededException The specified limit has been exceeded. Review your request and retry it with a
     *         quantity below the stated limit.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>TooManyTagsException You have added too many tags to this resource. The maximum is 50 tags.</li>
     *         <li>ConcurrentModificationException Another modification is being made. That modification must complete
     *         before you can make your change.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ImportTerminology
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ImportTerminology" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ImportTerminologyResponse> importTerminology(
            Consumer<ImportTerminologyRequest.Builder> importTerminologyRequest) {
        return importTerminology(ImportTerminologyRequest.builder().applyMutation(importTerminologyRequest).build());
    }

    /**
     * <p>
     * Provides a list of languages (RFC-5646 codes and names) that Amazon Translate supports.
     * </p>
     *
     * @param listLanguagesRequest
     * @return A Java Future containing the result of the ListLanguages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>UnsupportedDisplayLanguageCodeException Requested display language code is not supported.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ListLanguages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListLanguages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLanguagesResponse> listLanguages(ListLanguagesRequest listLanguagesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of languages (RFC-5646 codes and names) that Amazon Translate supports.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLanguagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListLanguagesRequest#builder()}
     * </p>
     *
     * @param listLanguagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.ListLanguagesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListLanguages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>UnsupportedDisplayLanguageCodeException Requested display language code is not supported.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ListLanguages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListLanguages" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLanguagesResponse> listLanguages(Consumer<ListLanguagesRequest.Builder> listLanguagesRequest) {
        return listLanguages(ListLanguagesRequest.builder().applyMutation(listLanguagesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listLanguages(software.amazon.awssdk.services.translate.model.ListLanguagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListLanguagesPublisher publisher = client.listLanguagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListLanguagesPublisher publisher = client.listLanguagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.translate.model.ListLanguagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.translate.model.ListLanguagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLanguages(software.amazon.awssdk.services.translate.model.ListLanguagesRequest)} operation.</b>
     * </p>
     *
     * @param listLanguagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>UnsupportedDisplayLanguageCodeException Requested display language code is not supported.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ListLanguages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListLanguages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLanguagesPublisher listLanguagesPaginator(ListLanguagesRequest listLanguagesRequest) {
        return new ListLanguagesPublisher(this, listLanguagesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listLanguages(software.amazon.awssdk.services.translate.model.ListLanguagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListLanguagesPublisher publisher = client.listLanguagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListLanguagesPublisher publisher = client.listLanguagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.translate.model.ListLanguagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.translate.model.ListLanguagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLanguages(software.amazon.awssdk.services.translate.model.ListLanguagesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLanguagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListLanguagesRequest#builder()}
     * </p>
     *
     * @param listLanguagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.ListLanguagesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>UnsupportedDisplayLanguageCodeException Requested display language code is not supported.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ListLanguages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListLanguages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLanguagesPublisher listLanguagesPaginator(Consumer<ListLanguagesRequest.Builder> listLanguagesRequest) {
        return listLanguagesPaginator(ListLanguagesRequest.builder().applyMutation(listLanguagesRequest).build());
    }

    /**
     * <p>
     * Provides a list of your parallel data resources in Amazon Translate.
     * </p>
     *
     * @param listParallelDataRequest
     * @return A Java Future containing the result of the ListParallelData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ListParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListParallelData" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListParallelDataResponse> listParallelData(ListParallelDataRequest listParallelDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of your parallel data resources in Amazon Translate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListParallelDataRequest.Builder} avoiding the need
     * to create one manually via {@link ListParallelDataRequest#builder()}
     * </p>
     *
     * @param listParallelDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.ListParallelDataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListParallelData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ListParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListParallelData" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListParallelDataResponse> listParallelData(
            Consumer<ListParallelDataRequest.Builder> listParallelDataRequest) {
        return listParallelData(ListParallelDataRequest.builder().applyMutation(listParallelDataRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listParallelData(software.amazon.awssdk.services.translate.model.ListParallelDataRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListParallelDataPublisher publisher = client.listParallelDataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListParallelDataPublisher publisher = client.listParallelDataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.translate.model.ListParallelDataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.translate.model.ListParallelDataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listParallelData(software.amazon.awssdk.services.translate.model.ListParallelDataRequest)} operation.</b>
     * </p>
     *
     * @param listParallelDataRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ListParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListParallelData" target="_top">AWS
     *      API Documentation</a>
     */
    default ListParallelDataPublisher listParallelDataPaginator(ListParallelDataRequest listParallelDataRequest) {
        return new ListParallelDataPublisher(this, listParallelDataRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listParallelData(software.amazon.awssdk.services.translate.model.ListParallelDataRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListParallelDataPublisher publisher = client.listParallelDataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListParallelDataPublisher publisher = client.listParallelDataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.translate.model.ListParallelDataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.translate.model.ListParallelDataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listParallelData(software.amazon.awssdk.services.translate.model.ListParallelDataRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListParallelDataRequest.Builder} avoiding the need
     * to create one manually via {@link ListParallelDataRequest#builder()}
     * </p>
     *
     * @param listParallelDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.ListParallelDataRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ListParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListParallelData" target="_top">AWS
     *      API Documentation</a>
     */
    default ListParallelDataPublisher listParallelDataPaginator(Consumer<ListParallelDataRequest.Builder> listParallelDataRequest) {
        return listParallelDataPaginator(ListParallelDataRequest.builder().applyMutation(listParallelDataRequest).build());
    }

    /**
     * <p>
     * Lists all tags associated with a given Amazon Translate resource. For more information, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags associated with a given Amazon Translate resource. For more information, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Provides a list of custom terminologies associated with your account.
     * </p>
     *
     * @param listTerminologiesRequest
     * @return A Java Future containing the result of the ListTerminologies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ListTerminologies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTerminologies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTerminologiesResponse> listTerminologies(ListTerminologiesRequest listTerminologiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of custom terminologies associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTerminologiesRequest.Builder} avoiding the need
     * to create one manually via {@link ListTerminologiesRequest#builder()}
     * </p>
     *
     * @param listTerminologiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.ListTerminologiesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTerminologies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ListTerminologies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTerminologies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTerminologiesResponse> listTerminologies(
            Consumer<ListTerminologiesRequest.Builder> listTerminologiesRequest) {
        return listTerminologies(ListTerminologiesRequest.builder().applyMutation(listTerminologiesRequest).build());
    }

    /**
     * <p>
     * Provides a list of custom terminologies associated with your account.
     * </p>
     *
     * @return A Java Future containing the result of the ListTerminologies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ListTerminologies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTerminologies" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTerminologiesResponse> listTerminologies() {
        return listTerminologies(ListTerminologiesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTerminologies(software.amazon.awssdk.services.translate.model.ListTerminologiesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListTerminologiesPublisher publisher = client.listTerminologiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListTerminologiesPublisher publisher = client.listTerminologiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.translate.model.ListTerminologiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.translate.model.ListTerminologiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTerminologies(software.amazon.awssdk.services.translate.model.ListTerminologiesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ListTerminologies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTerminologies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTerminologiesPublisher listTerminologiesPaginator() {
        return listTerminologiesPaginator(ListTerminologiesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTerminologies(software.amazon.awssdk.services.translate.model.ListTerminologiesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListTerminologiesPublisher publisher = client.listTerminologiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListTerminologiesPublisher publisher = client.listTerminologiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.translate.model.ListTerminologiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.translate.model.ListTerminologiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTerminologies(software.amazon.awssdk.services.translate.model.ListTerminologiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTerminologiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ListTerminologies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTerminologies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTerminologiesPublisher listTerminologiesPaginator(ListTerminologiesRequest listTerminologiesRequest) {
        return new ListTerminologiesPublisher(this, listTerminologiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTerminologies(software.amazon.awssdk.services.translate.model.ListTerminologiesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListTerminologiesPublisher publisher = client.listTerminologiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListTerminologiesPublisher publisher = client.listTerminologiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.translate.model.ListTerminologiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.translate.model.ListTerminologiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTerminologies(software.amazon.awssdk.services.translate.model.ListTerminologiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTerminologiesRequest.Builder} avoiding the need
     * to create one manually via {@link ListTerminologiesRequest#builder()}
     * </p>
     *
     * @param listTerminologiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.ListTerminologiesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ListTerminologies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTerminologies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTerminologiesPublisher listTerminologiesPaginator(
            Consumer<ListTerminologiesRequest.Builder> listTerminologiesRequest) {
        return listTerminologiesPaginator(ListTerminologiesRequest.builder().applyMutation(listTerminologiesRequest).build());
    }

    /**
     * <p>
     * Gets a list of the batch translation jobs that you have submitted.
     * </p>
     *
     * @param listTextTranslationJobsRequest
     * @return A Java Future containing the result of the ListTextTranslationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is not valid. Check your request to determine why
     *         it's not valid and then retry the request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InvalidFilterException The filter specified for the operation is not valid. Specify a different
     *         filter.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ListTextTranslationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTextTranslationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTextTranslationJobsResponse> listTextTranslationJobs(
            ListTextTranslationJobsRequest listTextTranslationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the batch translation jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTextTranslationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTextTranslationJobsRequest#builder()}
     * </p>
     *
     * @param listTextTranslationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTextTranslationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is not valid. Check your request to determine why
     *         it's not valid and then retry the request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InvalidFilterException The filter specified for the operation is not valid. Specify a different
     *         filter.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ListTextTranslationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTextTranslationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTextTranslationJobsResponse> listTextTranslationJobs(
            Consumer<ListTextTranslationJobsRequest.Builder> listTextTranslationJobsRequest) {
        return listTextTranslationJobs(ListTextTranslationJobsRequest.builder().applyMutation(listTextTranslationJobsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTextTranslationJobs(software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListTextTranslationJobsPublisher publisher = client.listTextTranslationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListTextTranslationJobsPublisher publisher = client.listTextTranslationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.translate.model.ListTextTranslationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.translate.model.ListTextTranslationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTextTranslationJobs(software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTextTranslationJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is not valid. Check your request to determine why
     *         it's not valid and then retry the request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InvalidFilterException The filter specified for the operation is not valid. Specify a different
     *         filter.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ListTextTranslationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTextTranslationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTextTranslationJobsPublisher listTextTranslationJobsPaginator(
            ListTextTranslationJobsRequest listTextTranslationJobsRequest) {
        return new ListTextTranslationJobsPublisher(this, listTextTranslationJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTextTranslationJobs(software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListTextTranslationJobsPublisher publisher = client.listTextTranslationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListTextTranslationJobsPublisher publisher = client.listTextTranslationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.translate.model.ListTextTranslationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.translate.model.ListTextTranslationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTextTranslationJobs(software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTextTranslationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTextTranslationJobsRequest#builder()}
     * </p>
     *
     * @param listTextTranslationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is not valid. Check your request to determine why
     *         it's not valid and then retry the request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InvalidFilterException The filter specified for the operation is not valid. Specify a different
     *         filter.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.ListTextTranslationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTextTranslationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTextTranslationJobsPublisher listTextTranslationJobsPaginator(
            Consumer<ListTextTranslationJobsRequest.Builder> listTextTranslationJobsRequest) {
        return listTextTranslationJobsPaginator(ListTextTranslationJobsRequest.builder()
                .applyMutation(listTextTranslationJobsRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous batch translation job. Use batch translation jobs to translate large volumes of text
     * across multiple documents at once. For batch translation, you can input documents with different source languages
     * (specify <code>auto</code> as the source language). You can specify one or more target languages. Batch
     * translation translates each input document into each of the target languages. For more information, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/async.html">Asynchronous batch processing</a>.
     * </p>
     * <p>
     * Batch translation jobs can be described with the <a>DescribeTextTranslationJob</a> operation, listed with the
     * <a>ListTextTranslationJobs</a> operation, and stopped with the <a>StopTextTranslationJob</a> operation.
     * </p>
     *
     * @param startTextTranslationJobRequest
     * @return A Java Future containing the result of the StartTextTranslationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>UnsupportedLanguagePairException Amazon Translate does not support translation from the language of
     *         the source text into the requested target language. For more information, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</li>
     *         <li>InvalidRequestException The request that you made is not valid. Check your request to determine why
     *         it's not valid and then retry the request.</li>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.StartTextTranslationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/StartTextTranslationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartTextTranslationJobResponse> startTextTranslationJob(
            StartTextTranslationJobRequest startTextTranslationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous batch translation job. Use batch translation jobs to translate large volumes of text
     * across multiple documents at once. For batch translation, you can input documents with different source languages
     * (specify <code>auto</code> as the source language). You can specify one or more target languages. Batch
     * translation translates each input document into each of the target languages. For more information, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/async.html">Asynchronous batch processing</a>.
     * </p>
     * <p>
     * Batch translation jobs can be described with the <a>DescribeTextTranslationJob</a> operation, listed with the
     * <a>ListTextTranslationJobs</a> operation, and stopped with the <a>StopTextTranslationJob</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTextTranslationJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartTextTranslationJobRequest#builder()}
     * </p>
     *
     * @param startTextTranslationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.StartTextTranslationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartTextTranslationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>UnsupportedLanguagePairException Amazon Translate does not support translation from the language of
     *         the source text into the requested target language. For more information, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</li>
     *         <li>InvalidRequestException The request that you made is not valid. Check your request to determine why
     *         it's not valid and then retry the request.</li>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.StartTextTranslationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/StartTextTranslationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartTextTranslationJobResponse> startTextTranslationJob(
            Consumer<StartTextTranslationJobRequest.Builder> startTextTranslationJobRequest) {
        return startTextTranslationJob(StartTextTranslationJobRequest.builder().applyMutation(startTextTranslationJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops an asynchronous batch translation job that is in progress.
     * </p>
     * <p>
     * If the job's state is <code>IN_PROGRESS</code>, the job will be marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state. Otherwise, the job is put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * Asynchronous batch translation jobs are started with the <a>StartTextTranslationJob</a> operation. You can use
     * the <a>DescribeTextTranslationJob</a> or <a>ListTextTranslationJobs</a> operations to get a batch translation
     * job's <code>JobId</code>.
     * </p>
     *
     * @param stopTextTranslationJobRequest
     * @return A Java Future containing the result of the StopTextTranslationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.StopTextTranslationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/StopTextTranslationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopTextTranslationJobResponse> stopTextTranslationJob(
            StopTextTranslationJobRequest stopTextTranslationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an asynchronous batch translation job that is in progress.
     * </p>
     * <p>
     * If the job's state is <code>IN_PROGRESS</code>, the job will be marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state. Otherwise, the job is put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * Asynchronous batch translation jobs are started with the <a>StartTextTranslationJob</a> operation. You can use
     * the <a>DescribeTextTranslationJob</a> or <a>ListTextTranslationJobs</a> operations to get a batch translation
     * job's <code>JobId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopTextTranslationJobRequest.Builder} avoiding the
     * need to create one manually via {@link StopTextTranslationJobRequest#builder()}
     * </p>
     *
     * @param stopTextTranslationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.StopTextTranslationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StopTextTranslationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.StopTextTranslationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/StopTextTranslationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StopTextTranslationJobResponse> stopTextTranslationJob(
            Consumer<StopTextTranslationJobRequest.Builder> stopTextTranslationJobRequest) {
        return stopTextTranslationJob(StopTextTranslationJobRequest.builder().applyMutation(stopTextTranslationJobRequest)
                .build());
    }

    /**
     * <p>
     * Associates a specific tag with a resource. A tag is a key-value pair that adds as a metadata to a resource. For
     * more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your
     * resources</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>ConcurrentModificationException Another modification is being made. That modification must complete
     *         before you can make your change.</li>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>TooManyTagsException You have added too many tags to this resource. The maximum is 50 tags.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a specific tag with a resource. A tag is a key-value pair that adds as a metadata to a resource. For
     * more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your
     * resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>ConcurrentModificationException Another modification is being made. That modification must complete
     *         before you can make your change.</li>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>TooManyTagsException You have added too many tags to this resource. The maximum is 50 tags.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Translates the input document from the source language to the target language. This synchronous operation
     * supports text, HTML, or Word documents as the input document. <code>TranslateDocument</code> supports
     * translations from English to any supported language, and from any supported language to English. Therefore,
     * specify either the source language code or the target language code as “en” (English).
     * </p>
     * <p>
     * If you set the <code>Formality</code> parameter, the request will fail if the target language does not support
     * formality. For a list of target languages that support formality, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-formality.html">Setting
     * formality</a>.
     * </p>
     *
     * @param translateDocumentRequest
     * @return A Java Future containing the result of the TranslateDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is not valid. Check your request to determine why
     *         it's not valid and then retry the request.</li>
     *         <li>LimitExceededException The specified limit has been exceeded. Review your request and retry it with a
     *         quantity below the stated limit.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>UnsupportedLanguagePairException Amazon Translate does not support translation from the language of
     *         the source text into the requested target language. For more information, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceUnavailableException The Amazon Translate service is temporarily unavailable. Wait a bit and
     *         then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.TranslateDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/TranslateDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TranslateDocumentResponse> translateDocument(TranslateDocumentRequest translateDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Translates the input document from the source language to the target language. This synchronous operation
     * supports text, HTML, or Word documents as the input document. <code>TranslateDocument</code> supports
     * translations from English to any supported language, and from any supported language to English. Therefore,
     * specify either the source language code or the target language code as “en” (English).
     * </p>
     * <p>
     * If you set the <code>Formality</code> parameter, the request will fail if the target language does not support
     * formality. For a list of target languages that support formality, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-formality.html">Setting
     * formality</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TranslateDocumentRequest.Builder} avoiding the need
     * to create one manually via {@link TranslateDocumentRequest#builder()}
     * </p>
     *
     * @param translateDocumentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.TranslateDocumentRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TranslateDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is not valid. Check your request to determine why
     *         it's not valid and then retry the request.</li>
     *         <li>LimitExceededException The specified limit has been exceeded. Review your request and retry it with a
     *         quantity below the stated limit.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>UnsupportedLanguagePairException Amazon Translate does not support translation from the language of
     *         the source text into the requested target language. For more information, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceUnavailableException The Amazon Translate service is temporarily unavailable. Wait a bit and
     *         then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.TranslateDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/TranslateDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TranslateDocumentResponse> translateDocument(
            Consumer<TranslateDocumentRequest.Builder> translateDocumentRequest) {
        return translateDocument(TranslateDocumentRequest.builder().applyMutation(translateDocumentRequest).build());
    }

    /**
     * <p>
     * Translates input text from the source language to the target language. For a list of available languages and
     * language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported
     * languages</a>.
     * </p>
     *
     * @param translateTextRequest
     * @return A Java Future containing the result of the TranslateText operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is not valid. Check your request to determine why
     *         it's not valid and then retry the request.</li>
     *         <li>TextSizeLimitExceededException The size of the text you submitted exceeds the size limit. Reduce the
     *         size of the text or use a smaller document and then retry your request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>UnsupportedLanguagePairException Amazon Translate does not support translation from the language of
     *         the source text into the requested target language. For more information, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</li>
     *         <li>DetectedLanguageLowConfidenceException The confidence that Amazon Comprehend accurately detected the
     *         source language is low. If a low confidence level is acceptable for your application, you can use the
     *         language in the exception to call Amazon Translate again. For more information, see the <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectDominantLanguage.html"
     *         >DetectDominantLanguage</a> operation in the <i>Amazon Comprehend Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceUnavailableException The Amazon Translate service is temporarily unavailable. Wait a bit and
     *         then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.TranslateText
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/TranslateText" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TranslateTextResponse> translateText(TranslateTextRequest translateTextRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Translates input text from the source language to the target language. For a list of available languages and
     * language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported
     * languages</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TranslateTextRequest.Builder} avoiding the need to
     * create one manually via {@link TranslateTextRequest#builder()}
     * </p>
     *
     * @param translateTextRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.TranslateTextRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TranslateText operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException The request that you made is not valid. Check your request to determine why
     *         it's not valid and then retry the request.</li>
     *         <li>TextSizeLimitExceededException The size of the text you submitted exceeds the size limit. Reduce the
     *         size of the text or use a smaller document and then retry your request.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>UnsupportedLanguagePairException Amazon Translate does not support translation from the language of
     *         the source text into the requested target language. For more information, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.</li>
     *         <li>DetectedLanguageLowConfidenceException The confidence that Amazon Comprehend accurately detected the
     *         source language is low. If a low confidence level is acceptable for your application, you can use the
     *         language in the exception to call Amazon Translate again. For more information, see the <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectDominantLanguage.html"
     *         >DetectDominantLanguage</a> operation in the <i>Amazon Comprehend Developer Guide</i>.</li>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>ServiceUnavailableException The Amazon Translate service is temporarily unavailable. Wait a bit and
     *         then retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.TranslateText
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/TranslateText" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TranslateTextResponse> translateText(Consumer<TranslateTextRequest.Builder> translateTextRequest) {
        return translateText(TranslateTextRequest.builder().applyMutation(translateTextRequest).build());
    }

    /**
     * <p>
     * Removes a specific tag associated with an Amazon Translate resource. For more information, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>ConcurrentModificationException Another modification is being made. That modification must complete
     *         before you can make your change.</li>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a specific tag associated with an Amazon Translate resource. For more information, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>ConcurrentModificationException Another modification is being made. That modification must complete
     *         before you can make your change.</li>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a previously created parallel data resource by importing a new input file from Amazon S3.
     * </p>
     *
     * @param updateParallelDataRequest
     * @return A Java Future containing the result of the UpdateParallelData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another modification is being made. That modification must complete
     *         before you can make your change.</li>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>InvalidRequestException The request that you made is not valid. Check your request to determine why
     *         it's not valid and then retry the request.</li>
     *         <li>LimitExceededException The specified limit has been exceeded. Review your request and retry it with a
     *         quantity below the stated limit.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.UpdateParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/UpdateParallelData" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateParallelDataResponse> updateParallelData(UpdateParallelDataRequest updateParallelDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a previously created parallel data resource by importing a new input file from Amazon S3.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateParallelDataRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateParallelDataRequest#builder()}
     * </p>
     *
     * @param updateParallelDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.UpdateParallelDataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateParallelData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConcurrentModificationException Another modification is being made. That modification must complete
     *         before you can make your change.</li>
     *         <li>InvalidParameterValueException The value of the parameter is not valid. Review the value of the
     *         parameter you are using to correct it, and then retry your operation.</li>
     *         <li>InvalidRequestException The request that you made is not valid. Check your request to determine why
     *         it's not valid and then retry the request.</li>
     *         <li>LimitExceededException The specified limit has been exceeded. Review your request and retry it with a
     *         quantity below the stated limit.</li>
     *         <li>TooManyRequestsException You have made too many requests within a short period of time. Wait for a
     *         short time and then try your request again.</li>
     *         <li>ConflictException There was a conflict processing the request. Try your request again.</li>
     *         <li>ResourceNotFoundException The resource you are looking for has not been found. Review the resource
     *         you're looking for and see if a different resource will accomplish your needs before retrying the revised
     *         request.</li>
     *         <li>InternalServerException An internal server error occurred. Retry your request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TranslateException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample TranslateAsyncClient.UpdateParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/UpdateParallelData" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateParallelDataResponse> updateParallelData(
            Consumer<UpdateParallelDataRequest.Builder> updateParallelDataRequest) {
        return updateParallelData(UpdateParallelDataRequest.builder().applyMutation(updateParallelDataRequest).build());
    }

    @Override
    default TranslateServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link TranslateAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static TranslateAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link TranslateAsyncClient}.
     */
    static TranslateAsyncClientBuilder builder() {
        return new DefaultTranslateAsyncClientBuilder();
    }
}
