/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.translate.TranslateAsyncClient;
import software.amazon.awssdk.services.translate.internal.UserAgentUtils;
import software.amazon.awssdk.services.translate.model.ListTerminologiesRequest;
import software.amazon.awssdk.services.translate.model.ListTerminologiesResponse;

public class ListTerminologiesPublisher
implements SdkPublisher<ListTerminologiesResponse> {
    private final TranslateAsyncClient client;
    private final ListTerminologiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTerminologiesPublisher(TranslateAsyncClient client, ListTerminologiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTerminologiesPublisher(TranslateAsyncClient client, ListTerminologiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTerminologiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTerminologiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTerminologiesResponseFetcher
    implements AsyncPageFetcher<ListTerminologiesResponse> {
        private ListTerminologiesResponseFetcher() {
        }

        public boolean hasNextPage(ListTerminologiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTerminologiesResponse> nextPage(ListTerminologiesResponse previousPage) {
            if (previousPage == null) {
                return ListTerminologiesPublisher.this.client.listTerminologies(ListTerminologiesPublisher.this.firstRequest);
            }
            return ListTerminologiesPublisher.this.client.listTerminologies((ListTerminologiesRequest)((Object)ListTerminologiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

