/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the format and S3 location of the parallel data input file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParallelDataConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ParallelDataConfig.Builder, ParallelDataConfig> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Uri")
            .getter(getter(ParallelDataConfig::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(ParallelDataConfig::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD, FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("S3Uri", S3_URI_FIELD);
                    put("Format", FORMAT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final String format;

    private ParallelDataConfig(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.format = builder.format;
    }

    /**
     * <p>
     * The URI of the Amazon S3 folder that contains the parallel data input file. The folder must be in the same Region
     * as the API endpoint you are calling.
     * </p>
     * 
     * @return The URI of the Amazon S3 folder that contains the parallel data input file. The folder must be in the
     *         same Region as the API endpoint you are calling.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * The format of the parallel data input file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ParallelDataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the parallel data input file.
     * @see ParallelDataFormat
     */
    public final ParallelDataFormat format() {
        return ParallelDataFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the parallel data input file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ParallelDataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the parallel data input file.
     * @see ParallelDataFormat
     */
    public final String formatAsString() {
        return format;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParallelDataConfig)) {
            return false;
        }
        ParallelDataConfig other = (ParallelDataConfig) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(formatAsString(), other.formatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParallelDataConfig").add("S3Uri", s3Uri()).add("Format", formatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ParallelDataConfig, T> g) {
        return obj -> g.apply((ParallelDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParallelDataConfig> {
        /**
         * <p>
         * The URI of the Amazon S3 folder that contains the parallel data input file. The folder must be in the same
         * Region as the API endpoint you are calling.
         * </p>
         * 
         * @param s3Uri
         *        The URI of the Amazon S3 folder that contains the parallel data input file. The folder must be in the
         *        same Region as the API endpoint you are calling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * The format of the parallel data input file.
         * </p>
         * 
         * @param format
         *        The format of the parallel data input file.
         * @see ParallelDataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParallelDataFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the parallel data input file.
         * </p>
         * 
         * @param format
         *        The format of the parallel data input file.
         * @see ParallelDataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParallelDataFormat
         */
        Builder format(ParallelDataFormat format);
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(ParallelDataConfig model) {
            s3Uri(model.s3Uri);
            format(model.format);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ParallelDataFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        @Override
        public ParallelDataConfig build() {
            return new ParallelDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
