/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input configuration properties for requesting a batch translation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputDataConfig implements SdkPojo, Serializable, ToCopyableBuilder<InputDataConfig.Builder, InputDataConfig> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Uri")
            .getter(getter(InputDataConfig::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(InputDataConfig::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD,
            CONTENT_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("S3Uri", S3_URI_FIELD);
                    put("ContentType", CONTENT_TYPE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final String contentType;

    private InputDataConfig(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * The URI of the AWS S3 folder that contains the input files. Amazon Translate translates all the files in the
     * folder and all its sub-folders. The folder must be in the same Region as the API endpoint you are calling.
     * </p>
     * 
     * @return The URI of the AWS S3 folder that contains the input files. Amazon Translate translates all the files in
     *         the folder and all its sub-folders. The folder must be in the same Region as the API endpoint you are
     *         calling.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * Describes the format of the data that you submit to Amazon Translate as input. You can specify one of the
     * following multipurpose internet mail extension (MIME) types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>text/html</code>: The input data consists of one or more HTML files. Amazon Translate translates only the
     * text that resides in the <code>html</code> element in each file.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>text/plain</code>: The input data consists of one or more unformatted text files. Amazon Translate
     * translates every character in this type of input.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>application/vnd.openxmlformats-officedocument.wordprocessingml.document</code>: The input data consists of
     * one or more Word documents (.docx).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>application/vnd.openxmlformats-officedocument.presentationml.presentation</code>: The input data consists
     * of one or more PowerPoint Presentation files (.pptx).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>application/vnd.openxmlformats-officedocument.spreadsheetml.sheet</code>: The input data consists of one or
     * more Excel Workbook files (.xlsx).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>application/x-xliff+xml</code>: The input data consists of one or more XML Localization Interchange File
     * Format (XLIFF) files (.xlf). Amazon Translate supports only XLIFF version 1.2.
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * If you structure your input data as HTML, ensure that you set this parameter to <code>text/html</code>. By doing
     * so, you cut costs by limiting the translation to the contents of the <code>html</code> element in each file.
     * Otherwise, if you set this parameter to <code>text/plain</code>, your costs will cover the translation of every
     * character.
     * </p>
     * </important>
     * 
     * @return Describes the format of the data that you submit to Amazon Translate as input. You can specify one of the
     *         following multipurpose internet mail extension (MIME) types:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>text/html</code>: The input data consists of one or more HTML files. Amazon Translate translates
     *         only the text that resides in the <code>html</code> element in each file.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>text/plain</code>: The input data consists of one or more unformatted text files. Amazon Translate
     *         translates every character in this type of input.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>application/vnd.openxmlformats-officedocument.wordprocessingml.document</code>: The input data
     *         consists of one or more Word documents (.docx).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>application/vnd.openxmlformats-officedocument.presentationml.presentation</code>: The input data
     *         consists of one or more PowerPoint Presentation files (.pptx).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>application/vnd.openxmlformats-officedocument.spreadsheetml.sheet</code>: The input data consists
     *         of one or more Excel Workbook files (.xlsx).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>application/x-xliff+xml</code>: The input data consists of one or more XML Localization Interchange
     *         File Format (XLIFF) files (.xlf). Amazon Translate supports only XLIFF version 1.2.
     *         </p>
     *         </li>
     *         </ul>
     *         <important>
     *         <p>
     *         If you structure your input data as HTML, ensure that you set this parameter to <code>text/html</code>.
     *         By doing so, you cut costs by limiting the translation to the contents of the <code>html</code> element
     *         in each file. Otherwise, if you set this parameter to <code>text/plain</code>, your costs will cover the
     *         translation of every character.
     *         </p>
     */
    public final String contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDataConfig)) {
            return false;
        }
        InputDataConfig other = (InputDataConfig) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(contentType(), other.contentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputDataConfig").add("S3Uri", s3Uri()).add("ContentType", contentType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InputDataConfig, T> g) {
        return obj -> g.apply((InputDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputDataConfig> {
        /**
         * <p>
         * The URI of the AWS S3 folder that contains the input files. Amazon Translate translates all the files in the
         * folder and all its sub-folders. The folder must be in the same Region as the API endpoint you are calling.
         * </p>
         * 
         * @param s3Uri
         *        The URI of the AWS S3 folder that contains the input files. Amazon Translate translates all the files
         *        in the folder and all its sub-folders. The folder must be in the same Region as the API endpoint you
         *        are calling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * Describes the format of the data that you submit to Amazon Translate as input. You can specify one of the
         * following multipurpose internet mail extension (MIME) types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>text/html</code>: The input data consists of one or more HTML files. Amazon Translate translates only
         * the text that resides in the <code>html</code> element in each file.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>text/plain</code>: The input data consists of one or more unformatted text files. Amazon Translate
         * translates every character in this type of input.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>application/vnd.openxmlformats-officedocument.wordprocessingml.document</code>: The input data consists
         * of one or more Word documents (.docx).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>application/vnd.openxmlformats-officedocument.presentationml.presentation</code>: The input data
         * consists of one or more PowerPoint Presentation files (.pptx).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>application/vnd.openxmlformats-officedocument.spreadsheetml.sheet</code>: The input data consists of
         * one or more Excel Workbook files (.xlsx).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>application/x-xliff+xml</code>: The input data consists of one or more XML Localization Interchange
         * File Format (XLIFF) files (.xlf). Amazon Translate supports only XLIFF version 1.2.
         * </p>
         * </li>
         * </ul>
         * <important>
         * <p>
         * If you structure your input data as HTML, ensure that you set this parameter to <code>text/html</code>. By
         * doing so, you cut costs by limiting the translation to the contents of the <code>html</code> element in each
         * file. Otherwise, if you set this parameter to <code>text/plain</code>, your costs will cover the translation
         * of every character.
         * </p>
         * </important>
         * 
         * @param contentType
         *        Describes the format of the data that you submit to Amazon Translate as input. You can specify one of
         *        the following multipurpose internet mail extension (MIME) types:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>text/html</code>: The input data consists of one or more HTML files. Amazon Translate translates
         *        only the text that resides in the <code>html</code> element in each file.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>text/plain</code>: The input data consists of one or more unformatted text files. Amazon
         *        Translate translates every character in this type of input.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>application/vnd.openxmlformats-officedocument.wordprocessingml.document</code>: The input data
         *        consists of one or more Word documents (.docx).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>application/vnd.openxmlformats-officedocument.presentationml.presentation</code>: The input data
         *        consists of one or more PowerPoint Presentation files (.pptx).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>application/vnd.openxmlformats-officedocument.spreadsheetml.sheet</code>: The input data
         *        consists of one or more Excel Workbook files (.xlsx).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>application/x-xliff+xml</code>: The input data consists of one or more XML Localization
         *        Interchange File Format (XLIFF) files (.xlf). Amazon Translate supports only XLIFF version 1.2.
         *        </p>
         *        </li>
         *        </ul>
         *        <important>
         *        <p>
         *        If you structure your input data as HTML, ensure that you set this parameter to <code>text/html</code>
         *        . By doing so, you cut costs by limiting the translation to the contents of the <code>html</code>
         *        element in each file. Otherwise, if you set this parameter to <code>text/plain</code>, your costs will
         *        cover the translation of every character.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDataConfig model) {
            s3Uri(model.s3Uri);
            contentType(model.contentType);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public InputDataConfig build() {
            return new InputDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
