/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLanguagesRequest extends TranslateRequest implements
        ToCopyableBuilder<ListLanguagesRequest.Builder, ListLanguagesRequest> {
    private static final SdkField<String> DISPLAY_LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayLanguageCode").getter(getter(ListLanguagesRequest::displayLanguageCodeAsString))
            .setter(setter(Builder::displayLanguageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayLanguageCode").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLanguagesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListLanguagesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_LANGUAGE_CODE_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DisplayLanguageCode", DISPLAY_LANGUAGE_CODE_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                    put("MaxResults", MAX_RESULTS_FIELD);
                }
            });

    private final String displayLanguageCode;

    private final String nextToken;

    private final Integer maxResults;

    private ListLanguagesRequest(BuilderImpl builder) {
        super(builder);
        this.displayLanguageCode = builder.displayLanguageCode;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The language code for the language to use to display the language names in the response. The language code is
     * <code>en</code> by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #displayLanguageCode} will return {@link DisplayLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #displayLanguageCodeAsString}.
     * </p>
     * 
     * @return The language code for the language to use to display the language names in the response. The language
     *         code is <code>en</code> by default.
     * @see DisplayLanguageCode
     */
    public final DisplayLanguageCode displayLanguageCode() {
        return DisplayLanguageCode.fromValue(displayLanguageCode);
    }

    /**
     * <p>
     * The language code for the language to use to display the language names in the response. The language code is
     * <code>en</code> by default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #displayLanguageCode} will return {@link DisplayLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #displayLanguageCodeAsString}.
     * </p>
     * 
     * @return The language code for the language to use to display the language names in the response. The language
     *         code is <code>en</code> by default.
     * @see DisplayLanguageCode
     */
    public final String displayLanguageCodeAsString() {
        return displayLanguageCode;
    }

    /**
     * <p>
     * Include the NextToken value to fetch the next group of supported languages.
     * </p>
     * 
     * @return Include the NextToken value to fetch the next group of supported languages.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in each response.
     * </p>
     * 
     * @return The maximum number of results to return in each response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(displayLanguageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLanguagesRequest)) {
            return false;
        }
        ListLanguagesRequest other = (ListLanguagesRequest) obj;
        return Objects.equals(displayLanguageCodeAsString(), other.displayLanguageCodeAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLanguagesRequest").add("DisplayLanguageCode", displayLanguageCodeAsString())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisplayLanguageCode":
            return Optional.ofNullable(clazz.cast(displayLanguageCodeAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListLanguagesRequest, T> g) {
        return obj -> g.apply((ListLanguagesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranslateRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListLanguagesRequest> {
        /**
         * <p>
         * The language code for the language to use to display the language names in the response. The language code is
         * <code>en</code> by default.
         * </p>
         * 
         * @param displayLanguageCode
         *        The language code for the language to use to display the language names in the response. The language
         *        code is <code>en</code> by default.
         * @see DisplayLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DisplayLanguageCode
         */
        Builder displayLanguageCode(String displayLanguageCode);

        /**
         * <p>
         * The language code for the language to use to display the language names in the response. The language code is
         * <code>en</code> by default.
         * </p>
         * 
         * @param displayLanguageCode
         *        The language code for the language to use to display the language names in the response. The language
         *        code is <code>en</code> by default.
         * @see DisplayLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DisplayLanguageCode
         */
        Builder displayLanguageCode(DisplayLanguageCode displayLanguageCode);

        /**
         * <p>
         * Include the NextToken value to fetch the next group of supported languages.
         * </p>
         * 
         * @param nextToken
         *        Include the NextToken value to fetch the next group of supported languages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in each response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in each response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranslateRequest.BuilderImpl implements Builder {
        private String displayLanguageCode;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLanguagesRequest model) {
            super(model);
            displayLanguageCode(model.displayLanguageCode);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getDisplayLanguageCode() {
            return displayLanguageCode;
        }

        public final void setDisplayLanguageCode(String displayLanguageCode) {
            this.displayLanguageCode = displayLanguageCode;
        }

        @Override
        public final Builder displayLanguageCode(String displayLanguageCode) {
            this.displayLanguageCode = displayLanguageCode;
            return this;
        }

        @Override
        public final Builder displayLanguageCode(DisplayLanguageCode displayLanguageCode) {
            this.displayLanguageCode(displayLanguageCode == null ? null : displayLanguageCode.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLanguagesRequest build() {
            return new ListLanguagesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
