/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information for filtering a list of translation jobs. For more information, see
 * <a>ListTextTranslationJobs</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextTranslationJobFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<TextTranslationJobFilter.Builder, TextTranslationJobFilter> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(TextTranslationJobFilter::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatus").getter(getter(TextTranslationJobFilter::jobStatusAsString))
            .setter(setter(Builder::jobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()).build();

    private static final SdkField<Instant> SUBMITTED_BEFORE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmittedBeforeTime").getter(getter(TextTranslationJobFilter::submittedBeforeTime))
            .setter(setter(Builder::submittedBeforeTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmittedBeforeTime").build())
            .build();

    private static final SdkField<Instant> SUBMITTED_AFTER_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("SubmittedAfterTime").getter(getter(TextTranslationJobFilter::submittedAfterTime))
            .setter(setter(Builder::submittedAfterTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubmittedAfterTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            JOB_STATUS_FIELD, SUBMITTED_BEFORE_TIME_FIELD, SUBMITTED_AFTER_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("JobName", JOB_NAME_FIELD);
                    put("JobStatus", JOB_STATUS_FIELD);
                    put("SubmittedBeforeTime", SUBMITTED_BEFORE_TIME_FIELD);
                    put("SubmittedAfterTime", SUBMITTED_AFTER_TIME_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String jobName;

    private final String jobStatus;

    private final Instant submittedBeforeTime;

    private final Instant submittedAfterTime;

    private TextTranslationJobFilter(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.jobStatus = builder.jobStatus;
        this.submittedBeforeTime = builder.submittedBeforeTime;
        this.submittedAfterTime = builder.submittedAfterTime;
    }

    /**
     * <p>
     * Filters the list of jobs by name.
     * </p>
     * 
     * @return Filters the list of jobs by name.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * Filters the list of jobs based by job status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return Filters the list of jobs based by job status.
     * @see JobStatus
     */
    public final JobStatus jobStatus() {
        return JobStatus.fromValue(jobStatus);
    }

    /**
     * <p>
     * Filters the list of jobs based by job status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #jobStatus} will
     * return {@link JobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #jobStatusAsString}.
     * </p>
     * 
     * @return Filters the list of jobs based by job status.
     * @see JobStatus
     */
    public final String jobStatusAsString() {
        return jobStatus;
    }

    /**
     * <p>
     * Filters the list of jobs based on the time that the job was submitted for processing and returns only the jobs
     * submitted before the specified time. Jobs are returned in ascending order, oldest to newest.
     * </p>
     * 
     * @return Filters the list of jobs based on the time that the job was submitted for processing and returns only the
     *         jobs submitted before the specified time. Jobs are returned in ascending order, oldest to newest.
     */
    public final Instant submittedBeforeTime() {
        return submittedBeforeTime;
    }

    /**
     * <p>
     * Filters the list of jobs based on the time that the job was submitted for processing and returns only the jobs
     * submitted after the specified time. Jobs are returned in descending order, newest to oldest.
     * </p>
     * 
     * @return Filters the list of jobs based on the time that the job was submitted for processing and returns only the
     *         jobs submitted after the specified time. Jobs are returned in descending order, newest to oldest.
     */
    public final Instant submittedAfterTime() {
        return submittedAfterTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(submittedBeforeTime());
        hashCode = 31 * hashCode + Objects.hashCode(submittedAfterTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextTranslationJobFilter)) {
            return false;
        }
        TextTranslationJobFilter other = (TextTranslationJobFilter) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(jobStatusAsString(), other.jobStatusAsString())
                && Objects.equals(submittedBeforeTime(), other.submittedBeforeTime())
                && Objects.equals(submittedAfterTime(), other.submittedAfterTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextTranslationJobFilter").add("JobName", jobName()).add("JobStatus", jobStatusAsString())
                .add("SubmittedBeforeTime", submittedBeforeTime()).add("SubmittedAfterTime", submittedAfterTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "JobStatus":
            return Optional.ofNullable(clazz.cast(jobStatusAsString()));
        case "SubmittedBeforeTime":
            return Optional.ofNullable(clazz.cast(submittedBeforeTime()));
        case "SubmittedAfterTime":
            return Optional.ofNullable(clazz.cast(submittedAfterTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TextTranslationJobFilter, T> g) {
        return obj -> g.apply((TextTranslationJobFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextTranslationJobFilter> {
        /**
         * <p>
         * Filters the list of jobs by name.
         * </p>
         * 
         * @param jobName
         *        Filters the list of jobs by name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * Filters the list of jobs based by job status.
         * </p>
         * 
         * @param jobStatus
         *        Filters the list of jobs based by job status.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(String jobStatus);

        /**
         * <p>
         * Filters the list of jobs based by job status.
         * </p>
         * 
         * @param jobStatus
         *        Filters the list of jobs based by job status.
         * @see JobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobStatus
         */
        Builder jobStatus(JobStatus jobStatus);

        /**
         * <p>
         * Filters the list of jobs based on the time that the job was submitted for processing and returns only the
         * jobs submitted before the specified time. Jobs are returned in ascending order, oldest to newest.
         * </p>
         * 
         * @param submittedBeforeTime
         *        Filters the list of jobs based on the time that the job was submitted for processing and returns only
         *        the jobs submitted before the specified time. Jobs are returned in ascending order, oldest to newest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedBeforeTime(Instant submittedBeforeTime);

        /**
         * <p>
         * Filters the list of jobs based on the time that the job was submitted for processing and returns only the
         * jobs submitted after the specified time. Jobs are returned in descending order, newest to oldest.
         * </p>
         * 
         * @param submittedAfterTime
         *        Filters the list of jobs based on the time that the job was submitted for processing and returns only
         *        the jobs submitted after the specified time. Jobs are returned in descending order, newest to oldest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submittedAfterTime(Instant submittedAfterTime);
    }

    static final class BuilderImpl implements Builder {
        private String jobName;

        private String jobStatus;

        private Instant submittedBeforeTime;

        private Instant submittedAfterTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TextTranslationJobFilter model) {
            jobName(model.jobName);
            jobStatus(model.jobStatus);
            submittedBeforeTime(model.submittedBeforeTime);
            submittedAfterTime(model.submittedAfterTime);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobStatus() {
            return jobStatus;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatus jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final Instant getSubmittedBeforeTime() {
            return submittedBeforeTime;
        }

        public final void setSubmittedBeforeTime(Instant submittedBeforeTime) {
            this.submittedBeforeTime = submittedBeforeTime;
        }

        @Override
        public final Builder submittedBeforeTime(Instant submittedBeforeTime) {
            this.submittedBeforeTime = submittedBeforeTime;
            return this;
        }

        public final Instant getSubmittedAfterTime() {
            return submittedAfterTime;
        }

        public final void setSubmittedAfterTime(Instant submittedAfterTime) {
            this.submittedAfterTime = submittedAfterTime;
        }

        @Override
        public final Builder submittedAfterTime(Instant submittedAfterTime) {
            this.submittedAfterTime = submittedAfterTime;
            return this;
        }

        @Override
        public TextTranslationJobFilter build() {
            return new TextTranslationJobFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
