/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A supported language.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Language implements SdkPojo, Serializable, ToCopyableBuilder<Language.Builder, Language> {
    private static final SdkField<String> LANGUAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageName").getter(getter(Language::languageName)).setter(setter(Builder::languageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageName").build()).build();

    private static final SdkField<String> LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LanguageCode").getter(getter(Language::languageCode)).setter(setter(Builder::languageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LanguageCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_NAME_FIELD,
            LANGUAGE_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("LanguageName", LANGUAGE_NAME_FIELD);
                    put("LanguageCode", LANGUAGE_CODE_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String languageName;

    private final String languageCode;

    private Language(BuilderImpl builder) {
        this.languageName = builder.languageName;
        this.languageCode = builder.languageCode;
    }

    /**
     * <p>
     * Language name of the supported language.
     * </p>
     * 
     * @return Language name of the supported language.
     */
    public final String languageName() {
        return languageName;
    }

    /**
     * <p>
     * Language code for the supported language.
     * </p>
     * 
     * @return Language code for the supported language.
     */
    public final String languageCode() {
        return languageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(languageName());
        hashCode = 31 * hashCode + Objects.hashCode(languageCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Language)) {
            return false;
        }
        Language other = (Language) obj;
        return Objects.equals(languageName(), other.languageName()) && Objects.equals(languageCode(), other.languageCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Language").add("LanguageName", languageName()).add("LanguageCode", languageCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LanguageName":
            return Optional.ofNullable(clazz.cast(languageName()));
        case "LanguageCode":
            return Optional.ofNullable(clazz.cast(languageCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Language, T> g) {
        return obj -> g.apply((Language) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Language> {
        /**
         * <p>
         * Language name of the supported language.
         * </p>
         * 
         * @param languageName
         *        Language name of the supported language.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageName(String languageName);

        /**
         * <p>
         * Language code for the supported language.
         * </p>
         * 
         * @param languageCode
         *        Language code for the supported language.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languageCode(String languageCode);
    }

    static final class BuilderImpl implements Builder {
        private String languageName;

        private String languageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(Language model) {
            languageName(model.languageName);
            languageCode(model.languageCode);
        }

        public final String getLanguageName() {
            return languageName;
        }

        public final void setLanguageName(String languageName) {
            this.languageName = languageName;
        }

        @Override
        public final Builder languageName(String languageName) {
            this.languageName = languageName;
            return this;
        }

        public final String getLanguageCode() {
            return languageCode;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        @Override
        public Language build() {
            return new Language(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
