/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.translate.model.TerminologyDataLocation;
import software.amazon.awssdk.services.translate.model.TerminologyProperties;
import software.amazon.awssdk.services.translate.model.TranslateResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTerminologyResponse
extends TranslateResponse
implements ToCopyableBuilder<Builder, GetTerminologyResponse> {
    private static final SdkField<TerminologyProperties> TERMINOLOGY_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TerminologyProperties").getter(GetTerminologyResponse.getter(GetTerminologyResponse::terminologyProperties)).setter(GetTerminologyResponse.setter(Builder::terminologyProperties)).constructor(TerminologyProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminologyProperties").build()}).build();
    private static final SdkField<TerminologyDataLocation> TERMINOLOGY_DATA_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TerminologyDataLocation").getter(GetTerminologyResponse.getter(GetTerminologyResponse::terminologyDataLocation)).setter(GetTerminologyResponse.setter(Builder::terminologyDataLocation)).constructor(TerminologyDataLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminologyDataLocation").build()}).build();
    private static final SdkField<TerminologyDataLocation> AUXILIARY_DATA_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuxiliaryDataLocation").getter(GetTerminologyResponse.getter(GetTerminologyResponse::auxiliaryDataLocation)).setter(GetTerminologyResponse.setter(Builder::auxiliaryDataLocation)).constructor(TerminologyDataLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuxiliaryDataLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMINOLOGY_PROPERTIES_FIELD, TERMINOLOGY_DATA_LOCATION_FIELD, AUXILIARY_DATA_LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TerminologyProperties", TERMINOLOGY_PROPERTIES_FIELD);
            this.put("TerminologyDataLocation", TERMINOLOGY_DATA_LOCATION_FIELD);
            this.put("AuxiliaryDataLocation", AUXILIARY_DATA_LOCATION_FIELD);
        }
    });
    private final TerminologyProperties terminologyProperties;
    private final TerminologyDataLocation terminologyDataLocation;
    private final TerminologyDataLocation auxiliaryDataLocation;

    private GetTerminologyResponse(BuilderImpl builder) {
        super(builder);
        this.terminologyProperties = builder.terminologyProperties;
        this.terminologyDataLocation = builder.terminologyDataLocation;
        this.auxiliaryDataLocation = builder.auxiliaryDataLocation;
    }

    public final TerminologyProperties terminologyProperties() {
        return this.terminologyProperties;
    }

    public final TerminologyDataLocation terminologyDataLocation() {
        return this.terminologyDataLocation;
    }

    public final TerminologyDataLocation auxiliaryDataLocation() {
        return this.auxiliaryDataLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.terminologyProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminologyDataLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.auxiliaryDataLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTerminologyResponse)) {
            return false;
        }
        GetTerminologyResponse other = (GetTerminologyResponse)((Object)obj);
        return Objects.equals(this.terminologyProperties(), other.terminologyProperties()) && Objects.equals(this.terminologyDataLocation(), other.terminologyDataLocation()) && Objects.equals(this.auxiliaryDataLocation(), other.auxiliaryDataLocation());
    }

    public final String toString() {
        return ToString.builder((String)"GetTerminologyResponse").add("TerminologyProperties", (Object)this.terminologyProperties()).add("TerminologyDataLocation", (Object)this.terminologyDataLocation()).add("AuxiliaryDataLocation", (Object)this.auxiliaryDataLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TerminologyProperties": {
                return Optional.ofNullable(clazz.cast(this.terminologyProperties()));
            }
            case "TerminologyDataLocation": {
                return Optional.ofNullable(clazz.cast(this.terminologyDataLocation()));
            }
            case "AuxiliaryDataLocation": {
                return Optional.ofNullable(clazz.cast(this.auxiliaryDataLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetTerminologyResponse, T> g) {
        return obj -> g.apply((GetTerminologyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranslateResponse.BuilderImpl
    implements Builder {
        private TerminologyProperties terminologyProperties;
        private TerminologyDataLocation terminologyDataLocation;
        private TerminologyDataLocation auxiliaryDataLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTerminologyResponse model) {
            super(model);
            this.terminologyProperties(model.terminologyProperties);
            this.terminologyDataLocation(model.terminologyDataLocation);
            this.auxiliaryDataLocation(model.auxiliaryDataLocation);
        }

        public final TerminologyProperties.Builder getTerminologyProperties() {
            return this.terminologyProperties != null ? this.terminologyProperties.toBuilder() : null;
        }

        public final void setTerminologyProperties(TerminologyProperties.BuilderImpl terminologyProperties) {
            this.terminologyProperties = terminologyProperties != null ? terminologyProperties.build() : null;
        }

        @Override
        public final Builder terminologyProperties(TerminologyProperties terminologyProperties) {
            this.terminologyProperties = terminologyProperties;
            return this;
        }

        public final TerminologyDataLocation.Builder getTerminologyDataLocation() {
            return this.terminologyDataLocation != null ? this.terminologyDataLocation.toBuilder() : null;
        }

        public final void setTerminologyDataLocation(TerminologyDataLocation.BuilderImpl terminologyDataLocation) {
            this.terminologyDataLocation = terminologyDataLocation != null ? terminologyDataLocation.build() : null;
        }

        @Override
        public final Builder terminologyDataLocation(TerminologyDataLocation terminologyDataLocation) {
            this.terminologyDataLocation = terminologyDataLocation;
            return this;
        }

        public final TerminologyDataLocation.Builder getAuxiliaryDataLocation() {
            return this.auxiliaryDataLocation != null ? this.auxiliaryDataLocation.toBuilder() : null;
        }

        public final void setAuxiliaryDataLocation(TerminologyDataLocation.BuilderImpl auxiliaryDataLocation) {
            this.auxiliaryDataLocation = auxiliaryDataLocation != null ? auxiliaryDataLocation.build() : null;
        }

        @Override
        public final Builder auxiliaryDataLocation(TerminologyDataLocation auxiliaryDataLocation) {
            this.auxiliaryDataLocation = auxiliaryDataLocation;
            return this;
        }

        @Override
        public GetTerminologyResponse build() {
            return new GetTerminologyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends TranslateResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTerminologyResponse> {
        public Builder terminologyProperties(TerminologyProperties var1);

        default public Builder terminologyProperties(Consumer<TerminologyProperties.Builder> terminologyProperties) {
            return this.terminologyProperties((TerminologyProperties)((TerminologyProperties.Builder)TerminologyProperties.builder().applyMutation(terminologyProperties)).build());
        }

        public Builder terminologyDataLocation(TerminologyDataLocation var1);

        default public Builder terminologyDataLocation(Consumer<TerminologyDataLocation.Builder> terminologyDataLocation) {
            return this.terminologyDataLocation((TerminologyDataLocation)((TerminologyDataLocation.Builder)TerminologyDataLocation.builder().applyMutation(terminologyDataLocation)).build());
        }

        public Builder auxiliaryDataLocation(TerminologyDataLocation var1);

        default public Builder auxiliaryDataLocation(Consumer<TerminologyDataLocation.Builder> auxiliaryDataLocation) {
            return this.auxiliaryDataLocation((TerminologyDataLocation)((TerminologyDataLocation.Builder)TerminologyDataLocation.builder().applyMutation(auxiliaryDataLocation)).build());
        }
    }
}

