/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateParallelDataRequest extends TranslateRequest implements
        ToCopyableBuilder<CreateParallelDataRequest.Builder, CreateParallelDataRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateParallelDataRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateParallelDataRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ParallelDataConfig> PARALLEL_DATA_CONFIG_FIELD = SdkField
            .<ParallelDataConfig> builder(MarshallingType.SDK_POJO).memberName("ParallelDataConfig")
            .getter(getter(CreateParallelDataRequest::parallelDataConfig)).setter(setter(Builder::parallelDataConfig))
            .constructor(ParallelDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelDataConfig").build())
            .build();

    private static final SdkField<EncryptionKey> ENCRYPTION_KEY_FIELD = SdkField
            .<EncryptionKey> builder(MarshallingType.SDK_POJO).memberName("EncryptionKey")
            .getter(getter(CreateParallelDataRequest::encryptionKey)).setter(setter(Builder::encryptionKey))
            .constructor(EncryptionKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKey").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateParallelDataRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateParallelDataRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            PARALLEL_DATA_CONFIG_FIELD, ENCRYPTION_KEY_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final ParallelDataConfig parallelDataConfig;

    private final EncryptionKey encryptionKey;

    private final String clientToken;

    private final List<Tag> tags;

    private CreateParallelDataRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.parallelDataConfig = builder.parallelDataConfig;
        this.encryptionKey = builder.encryptionKey;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A custom name for the parallel data resource in Amazon Translate. You must assign a name that is unique in the
     * account and region.
     * </p>
     * 
     * @return A custom name for the parallel data resource in Amazon Translate. You must assign a name that is unique
     *         in the account and region.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A custom description for the parallel data resource in Amazon Translate.
     * </p>
     * 
     * @return A custom description for the parallel data resource in Amazon Translate.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies the format and S3 location of the parallel data input file.
     * </p>
     * 
     * @return Specifies the format and S3 location of the parallel data input file.
     */
    public final ParallelDataConfig parallelDataConfig() {
        return parallelDataConfig;
    }

    /**
     * Returns the value of the EncryptionKey property for this object.
     * 
     * @return The value of the EncryptionKey property for this object.
     */
    public final EncryptionKey encryptionKey() {
        return encryptionKey;
    }

    /**
     * <p>
     * A unique identifier for the request. This token is automatically generated when you use Amazon Translate through
     * an AWS SDK.
     * </p>
     * 
     * @return A unique identifier for the request. This token is automatically generated when you use Amazon Translate
     *         through an AWS SDK.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags to be associated with this resource. A tag is a key-value pair that adds metadata to a resource. Each tag
     * key for the resource must be unique. For more information, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to be associated with this resource. A tag is a key-value pair that adds metadata to a resource.
     *         Each tag key for the resource must be unique. For more information, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(parallelDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateParallelDataRequest)) {
            return false;
        }
        CreateParallelDataRequest other = (CreateParallelDataRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(parallelDataConfig(), other.parallelDataConfig())
                && Objects.equals(encryptionKey(), other.encryptionKey()) && Objects.equals(clientToken(), other.clientToken())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateParallelDataRequest").add("Name", name()).add("Description", description())
                .add("ParallelDataConfig", parallelDataConfig()).add("EncryptionKey", encryptionKey())
                .add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ParallelDataConfig":
            return Optional.ofNullable(clazz.cast(parallelDataConfig()));
        case "EncryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ParallelDataConfig", PARALLEL_DATA_CONFIG_FIELD);
        map.put("EncryptionKey", ENCRYPTION_KEY_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateParallelDataRequest, T> g) {
        return obj -> g.apply((CreateParallelDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranslateRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateParallelDataRequest> {
        /**
         * <p>
         * A custom name for the parallel data resource in Amazon Translate. You must assign a name that is unique in
         * the account and region.
         * </p>
         * 
         * @param name
         *        A custom name for the parallel data resource in Amazon Translate. You must assign a name that is
         *        unique in the account and region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A custom description for the parallel data resource in Amazon Translate.
         * </p>
         * 
         * @param description
         *        A custom description for the parallel data resource in Amazon Translate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies the format and S3 location of the parallel data input file.
         * </p>
         * 
         * @param parallelDataConfig
         *        Specifies the format and S3 location of the parallel data input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelDataConfig(ParallelDataConfig parallelDataConfig);

        /**
         * <p>
         * Specifies the format and S3 location of the parallel data input file.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParallelDataConfig.Builder} avoiding the
         * need to create one manually via {@link ParallelDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParallelDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #parallelDataConfig(ParallelDataConfig)}.
         * 
         * @param parallelDataConfig
         *        a consumer that will call methods on {@link ParallelDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parallelDataConfig(ParallelDataConfig)
         */
        default Builder parallelDataConfig(Consumer<ParallelDataConfig.Builder> parallelDataConfig) {
            return parallelDataConfig(ParallelDataConfig.builder().applyMutation(parallelDataConfig).build());
        }

        /**
         * Sets the value of the EncryptionKey property for this object.
         *
         * @param encryptionKey
         *        The new value for the EncryptionKey property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(EncryptionKey encryptionKey);

        /**
         * Sets the value of the EncryptionKey property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EncryptionKey.Builder} avoiding the need
         * to create one manually via {@link EncryptionKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EncryptionKey.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionKey(EncryptionKey)}.
         * 
         * @param encryptionKey
         *        a consumer that will call methods on {@link EncryptionKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionKey(EncryptionKey)
         */
        default Builder encryptionKey(Consumer<EncryptionKey.Builder> encryptionKey) {
            return encryptionKey(EncryptionKey.builder().applyMutation(encryptionKey).build());
        }

        /**
         * <p>
         * A unique identifier for the request. This token is automatically generated when you use Amazon Translate
         * through an AWS SDK.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier for the request. This token is automatically generated when you use Amazon
         *        Translate through an AWS SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Tags to be associated with this resource. A tag is a key-value pair that adds metadata to a resource. Each
         * tag key for the resource must be unique. For more information, see <a
         * href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
         * </p>
         * 
         * @param tags
         *        Tags to be associated with this resource. A tag is a key-value pair that adds metadata to a resource.
         *        Each tag key for the resource must be unique. For more information, see <a
         *        href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags to be associated with this resource. A tag is a key-value pair that adds metadata to a resource. Each
         * tag key for the resource must be unique. For more information, see <a
         * href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
         * </p>
         * 
         * @param tags
         *        Tags to be associated with this resource. A tag is a key-value pair that adds metadata to a resource.
         *        Each tag key for the resource must be unique. For more information, see <a
         *        href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags to be associated with this resource. A tag is a key-value pair that adds metadata to a resource. Each
         * tag key for the resource must be unique. For more information, see <a
         * href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.translate.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.translate.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.translate.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.translate.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranslateRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private ParallelDataConfig parallelDataConfig;

        private EncryptionKey encryptionKey;

        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateParallelDataRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            parallelDataConfig(model.parallelDataConfig);
            encryptionKey(model.encryptionKey);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ParallelDataConfig.Builder getParallelDataConfig() {
            return parallelDataConfig != null ? parallelDataConfig.toBuilder() : null;
        }

        public final void setParallelDataConfig(ParallelDataConfig.BuilderImpl parallelDataConfig) {
            this.parallelDataConfig = parallelDataConfig != null ? parallelDataConfig.build() : null;
        }

        @Override
        public final Builder parallelDataConfig(ParallelDataConfig parallelDataConfig) {
            this.parallelDataConfig = parallelDataConfig;
            return this;
        }

        public final EncryptionKey.Builder getEncryptionKey() {
            return encryptionKey != null ? encryptionKey.toBuilder() : null;
        }

        public final void setEncryptionKey(EncryptionKey.BuilderImpl encryptionKey) {
            this.encryptionKey = encryptionKey != null ? encryptionKey.build() : null;
        }

        @Override
        public final Builder encryptionKey(EncryptionKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateParallelDataRequest build() {
            return new CreateParallelDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
