/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTextTranslationJobResponse extends TranslateResponse implements
        ToCopyableBuilder<DescribeTextTranslationJobResponse.Builder, DescribeTextTranslationJobResponse> {
    private static final SdkField<TextTranslationJobProperties> TEXT_TRANSLATION_JOB_PROPERTIES_FIELD = SdkField
            .<TextTranslationJobProperties> builder(MarshallingType.SDK_POJO)
            .memberName("TextTranslationJobProperties")
            .getter(getter(DescribeTextTranslationJobResponse::textTranslationJobProperties))
            .setter(setter(Builder::textTranslationJobProperties))
            .constructor(TextTranslationJobProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextTranslationJobProperties")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TEXT_TRANSLATION_JOB_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TextTranslationJobProperties textTranslationJobProperties;

    private DescribeTextTranslationJobResponse(BuilderImpl builder) {
        super(builder);
        this.textTranslationJobProperties = builder.textTranslationJobProperties;
    }

    /**
     * <p>
     * An object that contains the properties associated with an asynchronous batch translation job.
     * </p>
     * 
     * @return An object that contains the properties associated with an asynchronous batch translation job.
     */
    public final TextTranslationJobProperties textTranslationJobProperties() {
        return textTranslationJobProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(textTranslationJobProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTextTranslationJobResponse)) {
            return false;
        }
        DescribeTextTranslationJobResponse other = (DescribeTextTranslationJobResponse) obj;
        return Objects.equals(textTranslationJobProperties(), other.textTranslationJobProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTextTranslationJobResponse")
                .add("TextTranslationJobProperties", textTranslationJobProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TextTranslationJobProperties":
            return Optional.ofNullable(clazz.cast(textTranslationJobProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TextTranslationJobProperties", TEXT_TRANSLATION_JOB_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTextTranslationJobResponse, T> g) {
        return obj -> g.apply((DescribeTextTranslationJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranslateResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTextTranslationJobResponse> {
        /**
         * <p>
         * An object that contains the properties associated with an asynchronous batch translation job.
         * </p>
         * 
         * @param textTranslationJobProperties
         *        An object that contains the properties associated with an asynchronous batch translation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textTranslationJobProperties(TextTranslationJobProperties textTranslationJobProperties);

        /**
         * <p>
         * An object that contains the properties associated with an asynchronous batch translation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextTranslationJobProperties.Builder}
         * avoiding the need to create one manually via {@link TextTranslationJobProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextTranslationJobProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #textTranslationJobProperties(TextTranslationJobProperties)}.
         * 
         * @param textTranslationJobProperties
         *        a consumer that will call methods on {@link TextTranslationJobProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textTranslationJobProperties(TextTranslationJobProperties)
         */
        default Builder textTranslationJobProperties(Consumer<TextTranslationJobProperties.Builder> textTranslationJobProperties) {
            return textTranslationJobProperties(TextTranslationJobProperties.builder()
                    .applyMutation(textTranslationJobProperties).build());
        }
    }

    static final class BuilderImpl extends TranslateResponse.BuilderImpl implements Builder {
        private TextTranslationJobProperties textTranslationJobProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTextTranslationJobResponse model) {
            super(model);
            textTranslationJobProperties(model.textTranslationJobProperties);
        }

        public final TextTranslationJobProperties.Builder getTextTranslationJobProperties() {
            return textTranslationJobProperties != null ? textTranslationJobProperties.toBuilder() : null;
        }

        public final void setTextTranslationJobProperties(TextTranslationJobProperties.BuilderImpl textTranslationJobProperties) {
            this.textTranslationJobProperties = textTranslationJobProperties != null ? textTranslationJobProperties.build()
                    : null;
        }

        @Override
        public final Builder textTranslationJobProperties(TextTranslationJobProperties textTranslationJobProperties) {
            this.textTranslationJobProperties = textTranslationJobProperties;
            return this;
        }

        @Override
        public DescribeTextTranslationJobResponse build() {
            return new DescribeTextTranslationJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
