/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTerminologyRequest extends TranslateRequest implements
        ToCopyableBuilder<GetTerminologyRequest.Builder, GetTerminologyRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetTerminologyRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TERMINOLOGY_DATA_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TerminologyDataFormat").getter(getter(GetTerminologyRequest::terminologyDataFormatAsString))
            .setter(setter(Builder::terminologyDataFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminologyDataFormat").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            TERMINOLOGY_DATA_FORMAT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String terminologyDataFormat;

    private GetTerminologyRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.terminologyDataFormat = builder.terminologyDataFormat;
    }

    /**
     * <p>
     * The name of the custom terminology being retrieved.
     * </p>
     * 
     * @return The name of the custom terminology being retrieved.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The data format of the custom terminology being retrieved.
     * </p>
     * <p>
     * If you don't specify this parameter, Amazon Translate returns a file with the same format as the file that was
     * imported to create the terminology.
     * </p>
     * <p>
     * If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify the
     * same format as the input file that was imported to create it. Otherwise, Amazon Translate throws an error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #terminologyDataFormat} will return {@link TerminologyDataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #terminologyDataFormatAsString}.
     * </p>
     * 
     * @return The data format of the custom terminology being retrieved.</p>
     *         <p>
     *         If you don't specify this parameter, Amazon Translate returns a file with the same format as the file
     *         that was imported to create the terminology.
     *         </p>
     *         <p>
     *         If you specify this parameter when you retrieve a multi-directional terminology resource, you must
     *         specify the same format as the input file that was imported to create it. Otherwise, Amazon Translate
     *         throws an error.
     * @see TerminologyDataFormat
     */
    public final TerminologyDataFormat terminologyDataFormat() {
        return TerminologyDataFormat.fromValue(terminologyDataFormat);
    }

    /**
     * <p>
     * The data format of the custom terminology being retrieved.
     * </p>
     * <p>
     * If you don't specify this parameter, Amazon Translate returns a file with the same format as the file that was
     * imported to create the terminology.
     * </p>
     * <p>
     * If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify the
     * same format as the input file that was imported to create it. Otherwise, Amazon Translate throws an error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #terminologyDataFormat} will return {@link TerminologyDataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #terminologyDataFormatAsString}.
     * </p>
     * 
     * @return The data format of the custom terminology being retrieved.</p>
     *         <p>
     *         If you don't specify this parameter, Amazon Translate returns a file with the same format as the file
     *         that was imported to create the terminology.
     *         </p>
     *         <p>
     *         If you specify this parameter when you retrieve a multi-directional terminology resource, you must
     *         specify the same format as the input file that was imported to create it. Otherwise, Amazon Translate
     *         throws an error.
     * @see TerminologyDataFormat
     */
    public final String terminologyDataFormatAsString() {
        return terminologyDataFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(terminologyDataFormatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTerminologyRequest)) {
            return false;
        }
        GetTerminologyRequest other = (GetTerminologyRequest) obj;
        return Objects.equals(name(), other.name())
                && Objects.equals(terminologyDataFormatAsString(), other.terminologyDataFormatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTerminologyRequest").add("Name", name())
                .add("TerminologyDataFormat", terminologyDataFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "TerminologyDataFormat":
            return Optional.ofNullable(clazz.cast(terminologyDataFormatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("TerminologyDataFormat", TERMINOLOGY_DATA_FORMAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTerminologyRequest, T> g) {
        return obj -> g.apply((GetTerminologyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TranslateRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTerminologyRequest> {
        /**
         * <p>
         * The name of the custom terminology being retrieved.
         * </p>
         * 
         * @param name
         *        The name of the custom terminology being retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data format of the custom terminology being retrieved.
         * </p>
         * <p>
         * If you don't specify this parameter, Amazon Translate returns a file with the same format as the file that
         * was imported to create the terminology.
         * </p>
         * <p>
         * If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify
         * the same format as the input file that was imported to create it. Otherwise, Amazon Translate throws an
         * error.
         * </p>
         * 
         * @param terminologyDataFormat
         *        The data format of the custom terminology being retrieved.</p>
         *        <p>
         *        If you don't specify this parameter, Amazon Translate returns a file with the same format as the file
         *        that was imported to create the terminology.
         *        </p>
         *        <p>
         *        If you specify this parameter when you retrieve a multi-directional terminology resource, you must
         *        specify the same format as the input file that was imported to create it. Otherwise, Amazon Translate
         *        throws an error.
         * @see TerminologyDataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TerminologyDataFormat
         */
        Builder terminologyDataFormat(String terminologyDataFormat);

        /**
         * <p>
         * The data format of the custom terminology being retrieved.
         * </p>
         * <p>
         * If you don't specify this parameter, Amazon Translate returns a file with the same format as the file that
         * was imported to create the terminology.
         * </p>
         * <p>
         * If you specify this parameter when you retrieve a multi-directional terminology resource, you must specify
         * the same format as the input file that was imported to create it. Otherwise, Amazon Translate throws an
         * error.
         * </p>
         * 
         * @param terminologyDataFormat
         *        The data format of the custom terminology being retrieved.</p>
         *        <p>
         *        If you don't specify this parameter, Amazon Translate returns a file with the same format as the file
         *        that was imported to create the terminology.
         *        </p>
         *        <p>
         *        If you specify this parameter when you retrieve a multi-directional terminology resource, you must
         *        specify the same format as the input file that was imported to create it. Otherwise, Amazon Translate
         *        throws an error.
         * @see TerminologyDataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TerminologyDataFormat
         */
        Builder terminologyDataFormat(TerminologyDataFormat terminologyDataFormat);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranslateRequest.BuilderImpl implements Builder {
        private String name;

        private String terminologyDataFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTerminologyRequest model) {
            super(model);
            name(model.name);
            terminologyDataFormat(model.terminologyDataFormat);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getTerminologyDataFormat() {
            return terminologyDataFormat;
        }

        public final void setTerminologyDataFormat(String terminologyDataFormat) {
            this.terminologyDataFormat = terminologyDataFormat;
        }

        @Override
        public final Builder terminologyDataFormat(String terminologyDataFormat) {
            this.terminologyDataFormat = terminologyDataFormat;
            return this;
        }

        @Override
        public final Builder terminologyDataFormat(TerminologyDataFormat terminologyDataFormat) {
            this.terminologyDataFormat(terminologyDataFormat == null ? null : terminologyDataFormat.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTerminologyRequest build() {
            return new GetTerminologyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
