/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.translate.model.ConcurrentModificationException;
import software.amazon.awssdk.services.translate.model.ConflictException;
import software.amazon.awssdk.services.translate.model.CreateParallelDataRequest;
import software.amazon.awssdk.services.translate.model.CreateParallelDataResponse;
import software.amazon.awssdk.services.translate.model.DeleteParallelDataRequest;
import software.amazon.awssdk.services.translate.model.DeleteParallelDataResponse;
import software.amazon.awssdk.services.translate.model.DeleteTerminologyRequest;
import software.amazon.awssdk.services.translate.model.DeleteTerminologyResponse;
import software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobRequest;
import software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobResponse;
import software.amazon.awssdk.services.translate.model.DetectedLanguageLowConfidenceException;
import software.amazon.awssdk.services.translate.model.GetParallelDataRequest;
import software.amazon.awssdk.services.translate.model.GetParallelDataResponse;
import software.amazon.awssdk.services.translate.model.GetTerminologyRequest;
import software.amazon.awssdk.services.translate.model.GetTerminologyResponse;
import software.amazon.awssdk.services.translate.model.ImportTerminologyRequest;
import software.amazon.awssdk.services.translate.model.ImportTerminologyResponse;
import software.amazon.awssdk.services.translate.model.InternalServerException;
import software.amazon.awssdk.services.translate.model.InvalidFilterException;
import software.amazon.awssdk.services.translate.model.InvalidParameterValueException;
import software.amazon.awssdk.services.translate.model.InvalidRequestException;
import software.amazon.awssdk.services.translate.model.LimitExceededException;
import software.amazon.awssdk.services.translate.model.ListLanguagesRequest;
import software.amazon.awssdk.services.translate.model.ListLanguagesResponse;
import software.amazon.awssdk.services.translate.model.ListParallelDataRequest;
import software.amazon.awssdk.services.translate.model.ListParallelDataResponse;
import software.amazon.awssdk.services.translate.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.translate.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.translate.model.ListTerminologiesRequest;
import software.amazon.awssdk.services.translate.model.ListTerminologiesResponse;
import software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest;
import software.amazon.awssdk.services.translate.model.ListTextTranslationJobsResponse;
import software.amazon.awssdk.services.translate.model.ResourceNotFoundException;
import software.amazon.awssdk.services.translate.model.ServiceUnavailableException;
import software.amazon.awssdk.services.translate.model.StartTextTranslationJobRequest;
import software.amazon.awssdk.services.translate.model.StartTextTranslationJobResponse;
import software.amazon.awssdk.services.translate.model.StopTextTranslationJobRequest;
import software.amazon.awssdk.services.translate.model.StopTextTranslationJobResponse;
import software.amazon.awssdk.services.translate.model.TagResourceRequest;
import software.amazon.awssdk.services.translate.model.TagResourceResponse;
import software.amazon.awssdk.services.translate.model.TextSizeLimitExceededException;
import software.amazon.awssdk.services.translate.model.TooManyRequestsException;
import software.amazon.awssdk.services.translate.model.TooManyTagsException;
import software.amazon.awssdk.services.translate.model.TranslateDocumentRequest;
import software.amazon.awssdk.services.translate.model.TranslateDocumentResponse;
import software.amazon.awssdk.services.translate.model.TranslateException;
import software.amazon.awssdk.services.translate.model.TranslateTextRequest;
import software.amazon.awssdk.services.translate.model.TranslateTextResponse;
import software.amazon.awssdk.services.translate.model.UnsupportedDisplayLanguageCodeException;
import software.amazon.awssdk.services.translate.model.UnsupportedLanguagePairException;
import software.amazon.awssdk.services.translate.model.UntagResourceRequest;
import software.amazon.awssdk.services.translate.model.UntagResourceResponse;
import software.amazon.awssdk.services.translate.model.UpdateParallelDataRequest;
import software.amazon.awssdk.services.translate.model.UpdateParallelDataResponse;
import software.amazon.awssdk.services.translate.paginators.ListLanguagesIterable;
import software.amazon.awssdk.services.translate.paginators.ListParallelDataIterable;
import software.amazon.awssdk.services.translate.paginators.ListTerminologiesIterable;
import software.amazon.awssdk.services.translate.paginators.ListTextTranslationJobsIterable;

/**
 * Service client for accessing Amazon Translate. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Provides translation of the input content from the source language to the target language.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface TranslateClient extends AwsClient {
    String SERVICE_NAME = "translate";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "translate";

    /**
     * <p>
     * Creates a parallel data resource in Amazon Translate by importing an input file from Amazon S3. Parallel data
     * files contain examples that show how you want segments of text to be translated. By adding parallel data, you can
     * influence the style, tone, and word choice in your translation output.
     * </p>
     *
     * @param createParallelDataRequest
     * @return Result of the CreateParallelData operation returned by the service.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws InvalidRequestException
     *         The request that you made is not valid. Check your request to determine why it's not valid and then retry
     *         the request.
     * @throws LimitExceededException
     *         The specified limit has been exceeded. Review your request and retry it with a quantity below the stated
     *         limit.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws TooManyTagsException
     *         You have added too many tags to this resource. The maximum is 50 tags.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws ConcurrentModificationException
     *         Another modification is being made. That modification must complete before you can make your change.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.CreateParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/CreateParallelData" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateParallelDataResponse createParallelData(CreateParallelDataRequest createParallelDataRequest)
            throws InvalidParameterValueException, InvalidRequestException, LimitExceededException, TooManyRequestsException,
            TooManyTagsException, ConflictException, ConcurrentModificationException, InternalServerException,
            AwsServiceException, SdkClientException, TranslateException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a parallel data resource in Amazon Translate by importing an input file from Amazon S3. Parallel data
     * files contain examples that show how you want segments of text to be translated. By adding parallel data, you can
     * influence the style, tone, and word choice in your translation output.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateParallelDataRequest.Builder} avoiding the
     * need to create one manually via {@link CreateParallelDataRequest#builder()}
     * </p>
     *
     * @param createParallelDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.CreateParallelDataRequest.Builder} to create a
     *        request.
     * @return Result of the CreateParallelData operation returned by the service.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws InvalidRequestException
     *         The request that you made is not valid. Check your request to determine why it's not valid and then retry
     *         the request.
     * @throws LimitExceededException
     *         The specified limit has been exceeded. Review your request and retry it with a quantity below the stated
     *         limit.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws TooManyTagsException
     *         You have added too many tags to this resource. The maximum is 50 tags.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws ConcurrentModificationException
     *         Another modification is being made. That modification must complete before you can make your change.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.CreateParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/CreateParallelData" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateParallelDataResponse createParallelData(Consumer<CreateParallelDataRequest.Builder> createParallelDataRequest)
            throws InvalidParameterValueException, InvalidRequestException, LimitExceededException, TooManyRequestsException,
            TooManyTagsException, ConflictException, ConcurrentModificationException, InternalServerException,
            AwsServiceException, SdkClientException, TranslateException {
        return createParallelData(CreateParallelDataRequest.builder().applyMutation(createParallelDataRequest).build());
    }

    /**
     * <p>
     * Deletes a parallel data resource in Amazon Translate.
     * </p>
     *
     * @param deleteParallelDataRequest
     * @return Result of the DeleteParallelData operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is being made. That modification must complete before you can make your change.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.DeleteParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DeleteParallelData" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteParallelDataResponse deleteParallelData(DeleteParallelDataRequest deleteParallelDataRequest)
            throws ConcurrentModificationException, ResourceNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, TranslateException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a parallel data resource in Amazon Translate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteParallelDataRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteParallelDataRequest#builder()}
     * </p>
     *
     * @param deleteParallelDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.DeleteParallelDataRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteParallelData operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is being made. That modification must complete before you can make your change.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.DeleteParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DeleteParallelData" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteParallelDataResponse deleteParallelData(Consumer<DeleteParallelDataRequest.Builder> deleteParallelDataRequest)
            throws ConcurrentModificationException, ResourceNotFoundException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, TranslateException {
        return deleteParallelData(DeleteParallelDataRequest.builder().applyMutation(deleteParallelDataRequest).build());
    }

    /**
     * <p>
     * A synchronous action that deletes a custom terminology.
     * </p>
     *
     * @param deleteTerminologyRequest
     * @return Result of the DeleteTerminology operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.DeleteTerminology
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DeleteTerminology" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTerminologyResponse deleteTerminology(DeleteTerminologyRequest deleteTerminologyRequest)
            throws ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, InternalServerException,
            AwsServiceException, SdkClientException, TranslateException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A synchronous action that deletes a custom terminology.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTerminologyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTerminologyRequest#builder()}
     * </p>
     *
     * @param deleteTerminologyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.DeleteTerminologyRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTerminology operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.DeleteTerminology
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DeleteTerminology" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteTerminologyResponse deleteTerminology(Consumer<DeleteTerminologyRequest.Builder> deleteTerminologyRequest)
            throws ResourceNotFoundException, TooManyRequestsException, InvalidParameterValueException, InternalServerException,
            AwsServiceException, SdkClientException, TranslateException {
        return deleteTerminology(DeleteTerminologyRequest.builder().applyMutation(deleteTerminologyRequest).build());
    }

    /**
     * <p>
     * Gets the properties associated with an asynchronous batch translation job including name, ID, status, source and
     * target languages, input/output S3 buckets, and so on.
     * </p>
     *
     * @param describeTextTranslationJobRequest
     * @return Result of the DescribeTextTranslationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.DescribeTextTranslationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DescribeTextTranslationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTextTranslationJobResponse describeTextTranslationJob(
            DescribeTextTranslationJobRequest describeTextTranslationJobRequest) throws ResourceNotFoundException,
            TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, TranslateException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the properties associated with an asynchronous batch translation job including name, ID, status, source and
     * target languages, input/output S3 buckets, and so on.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeTextTranslationJobRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeTextTranslationJobRequest#builder()}
     * </p>
     *
     * @param describeTextTranslationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.DescribeTextTranslationJobRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeTextTranslationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.DescribeTextTranslationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/DescribeTextTranslationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeTextTranslationJobResponse describeTextTranslationJob(
            Consumer<DescribeTextTranslationJobRequest.Builder> describeTextTranslationJobRequest)
            throws ResourceNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, TranslateException {
        return describeTextTranslationJob(DescribeTextTranslationJobRequest.builder()
                .applyMutation(describeTextTranslationJobRequest).build());
    }

    /**
     * <p>
     * Provides information about a parallel data resource.
     * </p>
     *
     * @param getParallelDataRequest
     * @return Result of the GetParallelData operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.GetParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/GetParallelData" target="_top">AWS API
     *      Documentation</a>
     */
    default GetParallelDataResponse getParallelData(GetParallelDataRequest getParallelDataRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, TranslateException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a parallel data resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetParallelDataRequest.Builder} avoiding the need
     * to create one manually via {@link GetParallelDataRequest#builder()}
     * </p>
     *
     * @param getParallelDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.GetParallelDataRequest.Builder} to create a
     *        request.
     * @return Result of the GetParallelData operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.GetParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/GetParallelData" target="_top">AWS API
     *      Documentation</a>
     */
    default GetParallelDataResponse getParallelData(Consumer<GetParallelDataRequest.Builder> getParallelDataRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, TranslateException {
        return getParallelData(GetParallelDataRequest.builder().applyMutation(getParallelDataRequest).build());
    }

    /**
     * <p>
     * Retrieves a custom terminology.
     * </p>
     *
     * @param getTerminologyRequest
     * @return Result of the GetTerminology operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.GetTerminology
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/GetTerminology" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTerminologyResponse getTerminology(GetTerminologyRequest getTerminologyRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, TranslateException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a custom terminology.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTerminologyRequest.Builder} avoiding the need to
     * create one manually via {@link GetTerminologyRequest#builder()}
     * </p>
     *
     * @param getTerminologyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.GetTerminologyRequest.Builder} to create a request.
     * @return Result of the GetTerminology operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.GetTerminology
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/GetTerminology" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTerminologyResponse getTerminology(Consumer<GetTerminologyRequest.Builder> getTerminologyRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, TooManyRequestsException, InternalServerException,
            AwsServiceException, SdkClientException, TranslateException {
        return getTerminology(GetTerminologyRequest.builder().applyMutation(getTerminologyRequest).build());
    }

    /**
     * <p>
     * Creates or updates a custom terminology, depending on whether one already exists for the given terminology name.
     * Importing a terminology with the same name as an existing one will merge the terminologies based on the chosen
     * merge strategy. The only supported merge strategy is OVERWRITE, where the imported terminology overwrites the
     * existing terminology of the same name.
     * </p>
     * <p>
     * If you import a terminology that overwrites an existing one, the new terminology takes up to 10 minutes to fully
     * propagate. After that, translations have access to the new terminology.
     * </p>
     *
     * @param importTerminologyRequest
     * @return Result of the ImportTerminology operation returned by the service.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws LimitExceededException
     *         The specified limit has been exceeded. Review your request and retry it with a quantity below the stated
     *         limit.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws TooManyTagsException
     *         You have added too many tags to this resource. The maximum is 50 tags.
     * @throws ConcurrentModificationException
     *         Another modification is being made. That modification must complete before you can make your change.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ImportTerminology
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ImportTerminology" target="_top">AWS
     *      API Documentation</a>
     */
    default ImportTerminologyResponse importTerminology(ImportTerminologyRequest importTerminologyRequest)
            throws InvalidParameterValueException, LimitExceededException, TooManyRequestsException, TooManyTagsException,
            ConcurrentModificationException, InternalServerException, AwsServiceException, SdkClientException, TranslateException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or updates a custom terminology, depending on whether one already exists for the given terminology name.
     * Importing a terminology with the same name as an existing one will merge the terminologies based on the chosen
     * merge strategy. The only supported merge strategy is OVERWRITE, where the imported terminology overwrites the
     * existing terminology of the same name.
     * </p>
     * <p>
     * If you import a terminology that overwrites an existing one, the new terminology takes up to 10 minutes to fully
     * propagate. After that, translations have access to the new terminology.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportTerminologyRequest.Builder} avoiding the need
     * to create one manually via {@link ImportTerminologyRequest#builder()}
     * </p>
     *
     * @param importTerminologyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.ImportTerminologyRequest.Builder} to create a
     *        request.
     * @return Result of the ImportTerminology operation returned by the service.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws LimitExceededException
     *         The specified limit has been exceeded. Review your request and retry it with a quantity below the stated
     *         limit.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws TooManyTagsException
     *         You have added too many tags to this resource. The maximum is 50 tags.
     * @throws ConcurrentModificationException
     *         Another modification is being made. That modification must complete before you can make your change.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ImportTerminology
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ImportTerminology" target="_top">AWS
     *      API Documentation</a>
     */
    default ImportTerminologyResponse importTerminology(Consumer<ImportTerminologyRequest.Builder> importTerminologyRequest)
            throws InvalidParameterValueException, LimitExceededException, TooManyRequestsException, TooManyTagsException,
            ConcurrentModificationException, InternalServerException, AwsServiceException, SdkClientException, TranslateException {
        return importTerminology(ImportTerminologyRequest.builder().applyMutation(importTerminologyRequest).build());
    }

    /**
     * <p>
     * Provides a list of languages (RFC-5646 codes and names) that Amazon Translate supports.
     * </p>
     *
     * @param listLanguagesRequest
     * @return Result of the ListLanguages operation returned by the service.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws UnsupportedDisplayLanguageCodeException
     *         Requested display language code is not supported.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ListLanguages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListLanguages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLanguagesResponse listLanguages(ListLanguagesRequest listLanguagesRequest) throws InvalidParameterValueException,
            TooManyRequestsException, UnsupportedDisplayLanguageCodeException, InternalServerException, AwsServiceException,
            SdkClientException, TranslateException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of languages (RFC-5646 codes and names) that Amazon Translate supports.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLanguagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListLanguagesRequest#builder()}
     * </p>
     *
     * @param listLanguagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.ListLanguagesRequest.Builder} to create a request.
     * @return Result of the ListLanguages operation returned by the service.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws UnsupportedDisplayLanguageCodeException
     *         Requested display language code is not supported.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ListLanguages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListLanguages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLanguagesResponse listLanguages(Consumer<ListLanguagesRequest.Builder> listLanguagesRequest)
            throws InvalidParameterValueException, TooManyRequestsException, UnsupportedDisplayLanguageCodeException,
            InternalServerException, AwsServiceException, SdkClientException, TranslateException {
        return listLanguages(ListLanguagesRequest.builder().applyMutation(listLanguagesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listLanguages(software.amazon.awssdk.services.translate.model.ListLanguagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListLanguagesIterable responses = client.listLanguagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.translate.paginators.ListLanguagesIterable responses = client.listLanguagesPaginator(request);
     *     for (software.amazon.awssdk.services.translate.model.ListLanguagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListLanguagesIterable responses = client.listLanguagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLanguages(software.amazon.awssdk.services.translate.model.ListLanguagesRequest)} operation.</b>
     * </p>
     *
     * @param listLanguagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws UnsupportedDisplayLanguageCodeException
     *         Requested display language code is not supported.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ListLanguages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListLanguages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLanguagesIterable listLanguagesPaginator(ListLanguagesRequest listLanguagesRequest)
            throws InvalidParameterValueException, TooManyRequestsException, UnsupportedDisplayLanguageCodeException,
            InternalServerException, AwsServiceException, SdkClientException, TranslateException {
        return new ListLanguagesIterable(this, listLanguagesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listLanguages(software.amazon.awssdk.services.translate.model.ListLanguagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListLanguagesIterable responses = client.listLanguagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.translate.paginators.ListLanguagesIterable responses = client.listLanguagesPaginator(request);
     *     for (software.amazon.awssdk.services.translate.model.ListLanguagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListLanguagesIterable responses = client.listLanguagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLanguages(software.amazon.awssdk.services.translate.model.ListLanguagesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLanguagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListLanguagesRequest#builder()}
     * </p>
     *
     * @param listLanguagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.ListLanguagesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws UnsupportedDisplayLanguageCodeException
     *         Requested display language code is not supported.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ListLanguages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListLanguages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLanguagesIterable listLanguagesPaginator(Consumer<ListLanguagesRequest.Builder> listLanguagesRequest)
            throws InvalidParameterValueException, TooManyRequestsException, UnsupportedDisplayLanguageCodeException,
            InternalServerException, AwsServiceException, SdkClientException, TranslateException {
        return listLanguagesPaginator(ListLanguagesRequest.builder().applyMutation(listLanguagesRequest).build());
    }

    /**
     * <p>
     * Provides a list of your parallel data resources in Amazon Translate.
     * </p>
     *
     * @param listParallelDataRequest
     * @return Result of the ListParallelData operation returned by the service.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ListParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListParallelData" target="_top">AWS
     *      API Documentation</a>
     */
    default ListParallelDataResponse listParallelData(ListParallelDataRequest listParallelDataRequest)
            throws InvalidParameterValueException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, TranslateException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of your parallel data resources in Amazon Translate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListParallelDataRequest.Builder} avoiding the need
     * to create one manually via {@link ListParallelDataRequest#builder()}
     * </p>
     *
     * @param listParallelDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.ListParallelDataRequest.Builder} to create a
     *        request.
     * @return Result of the ListParallelData operation returned by the service.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ListParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListParallelData" target="_top">AWS
     *      API Documentation</a>
     */
    default ListParallelDataResponse listParallelData(Consumer<ListParallelDataRequest.Builder> listParallelDataRequest)
            throws InvalidParameterValueException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, TranslateException {
        return listParallelData(ListParallelDataRequest.builder().applyMutation(listParallelDataRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listParallelData(software.amazon.awssdk.services.translate.model.ListParallelDataRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListParallelDataIterable responses = client.listParallelDataPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.translate.paginators.ListParallelDataIterable responses = client
     *             .listParallelDataPaginator(request);
     *     for (software.amazon.awssdk.services.translate.model.ListParallelDataResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListParallelDataIterable responses = client.listParallelDataPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listParallelData(software.amazon.awssdk.services.translate.model.ListParallelDataRequest)} operation.</b>
     * </p>
     *
     * @param listParallelDataRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ListParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListParallelData" target="_top">AWS
     *      API Documentation</a>
     */
    default ListParallelDataIterable listParallelDataPaginator(ListParallelDataRequest listParallelDataRequest)
            throws InvalidParameterValueException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, TranslateException {
        return new ListParallelDataIterable(this, listParallelDataRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listParallelData(software.amazon.awssdk.services.translate.model.ListParallelDataRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListParallelDataIterable responses = client.listParallelDataPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.translate.paginators.ListParallelDataIterable responses = client
     *             .listParallelDataPaginator(request);
     *     for (software.amazon.awssdk.services.translate.model.ListParallelDataResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListParallelDataIterable responses = client.listParallelDataPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listParallelData(software.amazon.awssdk.services.translate.model.ListParallelDataRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListParallelDataRequest.Builder} avoiding the need
     * to create one manually via {@link ListParallelDataRequest#builder()}
     * </p>
     *
     * @param listParallelDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.ListParallelDataRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ListParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListParallelData" target="_top">AWS
     *      API Documentation</a>
     */
    default ListParallelDataIterable listParallelDataPaginator(Consumer<ListParallelDataRequest.Builder> listParallelDataRequest)
            throws InvalidParameterValueException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, TranslateException {
        return listParallelDataPaginator(ListParallelDataRequest.builder().applyMutation(listParallelDataRequest).build());
    }

    /**
     * <p>
     * Lists all tags associated with a given Amazon Translate resource. For more information, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, TranslateException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags associated with a given Amazon Translate resource. For more information, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, TranslateException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Provides a list of custom terminologies associated with your account.
     * </p>
     *
     * @param listTerminologiesRequest
     * @return Result of the ListTerminologies operation returned by the service.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ListTerminologies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTerminologies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTerminologiesResponse listTerminologies(ListTerminologiesRequest listTerminologiesRequest)
            throws InvalidParameterValueException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, TranslateException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides a list of custom terminologies associated with your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTerminologiesRequest.Builder} avoiding the need
     * to create one manually via {@link ListTerminologiesRequest#builder()}
     * </p>
     *
     * @param listTerminologiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.ListTerminologiesRequest.Builder} to create a
     *        request.
     * @return Result of the ListTerminologies operation returned by the service.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ListTerminologies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTerminologies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTerminologiesResponse listTerminologies(Consumer<ListTerminologiesRequest.Builder> listTerminologiesRequest)
            throws InvalidParameterValueException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, TranslateException {
        return listTerminologies(ListTerminologiesRequest.builder().applyMutation(listTerminologiesRequest).build());
    }

    /**
     * <p>
     * Provides a list of custom terminologies associated with your account.
     * </p>
     *
     * @return Result of the ListTerminologies operation returned by the service.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ListTerminologies
     * @see #listTerminologies(ListTerminologiesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTerminologies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTerminologiesResponse listTerminologies() throws InvalidParameterValueException, TooManyRequestsException,
            InternalServerException, AwsServiceException, SdkClientException, TranslateException {
        return listTerminologies(ListTerminologiesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTerminologies(software.amazon.awssdk.services.translate.model.ListTerminologiesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListTerminologiesIterable responses = client.listTerminologiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.translate.paginators.ListTerminologiesIterable responses = client
     *             .listTerminologiesPaginator(request);
     *     for (software.amazon.awssdk.services.translate.model.ListTerminologiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListTerminologiesIterable responses = client.listTerminologiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTerminologies(software.amazon.awssdk.services.translate.model.ListTerminologiesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ListTerminologies
     * @see #listTerminologiesPaginator(ListTerminologiesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTerminologies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTerminologiesIterable listTerminologiesPaginator() throws InvalidParameterValueException,
            TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, TranslateException {
        return listTerminologiesPaginator(ListTerminologiesRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTerminologies(software.amazon.awssdk.services.translate.model.ListTerminologiesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListTerminologiesIterable responses = client.listTerminologiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.translate.paginators.ListTerminologiesIterable responses = client
     *             .listTerminologiesPaginator(request);
     *     for (software.amazon.awssdk.services.translate.model.ListTerminologiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListTerminologiesIterable responses = client.listTerminologiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTerminologies(software.amazon.awssdk.services.translate.model.ListTerminologiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTerminologiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ListTerminologies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTerminologies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTerminologiesIterable listTerminologiesPaginator(ListTerminologiesRequest listTerminologiesRequest)
            throws InvalidParameterValueException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, TranslateException {
        return new ListTerminologiesIterable(this, listTerminologiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTerminologies(software.amazon.awssdk.services.translate.model.ListTerminologiesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListTerminologiesIterable responses = client.listTerminologiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.translate.paginators.ListTerminologiesIterable responses = client
     *             .listTerminologiesPaginator(request);
     *     for (software.amazon.awssdk.services.translate.model.ListTerminologiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListTerminologiesIterable responses = client.listTerminologiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTerminologies(software.amazon.awssdk.services.translate.model.ListTerminologiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTerminologiesRequest.Builder} avoiding the need
     * to create one manually via {@link ListTerminologiesRequest#builder()}
     * </p>
     *
     * @param listTerminologiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.ListTerminologiesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ListTerminologies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTerminologies" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTerminologiesIterable listTerminologiesPaginator(
            Consumer<ListTerminologiesRequest.Builder> listTerminologiesRequest) throws InvalidParameterValueException,
            TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, TranslateException {
        return listTerminologiesPaginator(ListTerminologiesRequest.builder().applyMutation(listTerminologiesRequest).build());
    }

    /**
     * <p>
     * Gets a list of the batch translation jobs that you have submitted.
     * </p>
     *
     * @param listTextTranslationJobsRequest
     * @return Result of the ListTextTranslationJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is not valid. Check your request to determine why it's not valid and then retry
     *         the request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InvalidFilterException
     *         The filter specified for the operation is not valid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ListTextTranslationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTextTranslationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTextTranslationJobsResponse listTextTranslationJobs(ListTextTranslationJobsRequest listTextTranslationJobsRequest)
            throws InvalidRequestException, TooManyRequestsException, InvalidFilterException, InternalServerException,
            AwsServiceException, SdkClientException, TranslateException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the batch translation jobs that you have submitted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTextTranslationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTextTranslationJobsRequest#builder()}
     * </p>
     *
     * @param listTextTranslationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListTextTranslationJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is not valid. Check your request to determine why it's not valid and then retry
     *         the request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InvalidFilterException
     *         The filter specified for the operation is not valid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ListTextTranslationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTextTranslationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTextTranslationJobsResponse listTextTranslationJobs(
            Consumer<ListTextTranslationJobsRequest.Builder> listTextTranslationJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            TranslateException {
        return listTextTranslationJobs(ListTextTranslationJobsRequest.builder().applyMutation(listTextTranslationJobsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTextTranslationJobs(software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListTextTranslationJobsIterable responses = client.listTextTranslationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.translate.paginators.ListTextTranslationJobsIterable responses = client
     *             .listTextTranslationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.translate.model.ListTextTranslationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListTextTranslationJobsIterable responses = client.listTextTranslationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTextTranslationJobs(software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTextTranslationJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request that you made is not valid. Check your request to determine why it's not valid and then retry
     *         the request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InvalidFilterException
     *         The filter specified for the operation is not valid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ListTextTranslationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTextTranslationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTextTranslationJobsIterable listTextTranslationJobsPaginator(
            ListTextTranslationJobsRequest listTextTranslationJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            TranslateException {
        return new ListTextTranslationJobsIterable(this, listTextTranslationJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTextTranslationJobs(software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListTextTranslationJobsIterable responses = client.listTextTranslationJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.translate.paginators.ListTextTranslationJobsIterable responses = client
     *             .listTextTranslationJobsPaginator(request);
     *     for (software.amazon.awssdk.services.translate.model.ListTextTranslationJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.translate.paginators.ListTextTranslationJobsIterable responses = client.listTextTranslationJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTextTranslationJobs(software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTextTranslationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListTextTranslationJobsRequest#builder()}
     * </p>
     *
     * @param listTextTranslationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request that you made is not valid. Check your request to determine why it's not valid and then retry
     *         the request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InvalidFilterException
     *         The filter specified for the operation is not valid. Specify a different filter.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.ListTextTranslationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/ListTextTranslationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTextTranslationJobsIterable listTextTranslationJobsPaginator(
            Consumer<ListTextTranslationJobsRequest.Builder> listTextTranslationJobsRequest) throws InvalidRequestException,
            TooManyRequestsException, InvalidFilterException, InternalServerException, AwsServiceException, SdkClientException,
            TranslateException {
        return listTextTranslationJobsPaginator(ListTextTranslationJobsRequest.builder()
                .applyMutation(listTextTranslationJobsRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous batch translation job. Use batch translation jobs to translate large volumes of text
     * across multiple documents at once. For batch translation, you can input documents with different source languages
     * (specify <code>auto</code> as the source language). You can specify one or more target languages. Batch
     * translation translates each input document into each of the target languages. For more information, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/async.html">Asynchronous batch processing</a>.
     * </p>
     * <p>
     * Batch translation jobs can be described with the <a>DescribeTextTranslationJob</a> operation, listed with the
     * <a>ListTextTranslationJobs</a> operation, and stopped with the <a>StopTextTranslationJob</a> operation.
     * </p>
     *
     * @param startTextTranslationJobRequest
     * @return Result of the StartTextTranslationJob operation returned by the service.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws UnsupportedLanguagePairException
     *         Amazon Translate does not support translation from the language of the source text into the requested
     *         target language. For more information, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.
     * @throws InvalidRequestException
     *         The request that you made is not valid. Check your request to determine why it's not valid and then retry
     *         the request.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.StartTextTranslationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/StartTextTranslationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTextTranslationJobResponse startTextTranslationJob(StartTextTranslationJobRequest startTextTranslationJobRequest)
            throws TooManyRequestsException, UnsupportedLanguagePairException, InvalidRequestException,
            ResourceNotFoundException, InvalidParameterValueException, InternalServerException, AwsServiceException,
            SdkClientException, TranslateException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous batch translation job. Use batch translation jobs to translate large volumes of text
     * across multiple documents at once. For batch translation, you can input documents with different source languages
     * (specify <code>auto</code> as the source language). You can specify one or more target languages. Batch
     * translation translates each input document into each of the target languages. For more information, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/async.html">Asynchronous batch processing</a>.
     * </p>
     * <p>
     * Batch translation jobs can be described with the <a>DescribeTextTranslationJob</a> operation, listed with the
     * <a>ListTextTranslationJobs</a> operation, and stopped with the <a>StopTextTranslationJob</a> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTextTranslationJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartTextTranslationJobRequest#builder()}
     * </p>
     *
     * @param startTextTranslationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.StartTextTranslationJobRequest.Builder} to create a
     *        request.
     * @return Result of the StartTextTranslationJob operation returned by the service.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws UnsupportedLanguagePairException
     *         Amazon Translate does not support translation from the language of the source text into the requested
     *         target language. For more information, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.
     * @throws InvalidRequestException
     *         The request that you made is not valid. Check your request to determine why it's not valid and then retry
     *         the request.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.StartTextTranslationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/StartTextTranslationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartTextTranslationJobResponse startTextTranslationJob(
            Consumer<StartTextTranslationJobRequest.Builder> startTextTranslationJobRequest) throws TooManyRequestsException,
            UnsupportedLanguagePairException, InvalidRequestException, ResourceNotFoundException, InvalidParameterValueException,
            InternalServerException, AwsServiceException, SdkClientException, TranslateException {
        return startTextTranslationJob(StartTextTranslationJobRequest.builder().applyMutation(startTextTranslationJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops an asynchronous batch translation job that is in progress.
     * </p>
     * <p>
     * If the job's state is <code>IN_PROGRESS</code>, the job will be marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state. Otherwise, the job is put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * Asynchronous batch translation jobs are started with the <a>StartTextTranslationJob</a> operation. You can use
     * the <a>DescribeTextTranslationJob</a> or <a>ListTextTranslationJobs</a> operations to get a batch translation
     * job's <code>JobId</code>.
     * </p>
     *
     * @param stopTextTranslationJobRequest
     * @return Result of the StopTextTranslationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.StopTextTranslationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/StopTextTranslationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopTextTranslationJobResponse stopTextTranslationJob(StopTextTranslationJobRequest stopTextTranslationJobRequest)
            throws ResourceNotFoundException, TooManyRequestsException, InternalServerException, AwsServiceException,
            SdkClientException, TranslateException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an asynchronous batch translation job that is in progress.
     * </p>
     * <p>
     * If the job's state is <code>IN_PROGRESS</code>, the job will be marked for termination and put into the
     * <code>STOP_REQUESTED</code> state. If the job completes before it can be stopped, it is put into the
     * <code>COMPLETED</code> state. Otherwise, the job is put into the <code>STOPPED</code> state.
     * </p>
     * <p>
     * Asynchronous batch translation jobs are started with the <a>StartTextTranslationJob</a> operation. You can use
     * the <a>DescribeTextTranslationJob</a> or <a>ListTextTranslationJobs</a> operations to get a batch translation
     * job's <code>JobId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopTextTranslationJobRequest.Builder} avoiding the
     * need to create one manually via {@link StopTextTranslationJobRequest#builder()}
     * </p>
     *
     * @param stopTextTranslationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.StopTextTranslationJobRequest.Builder} to create a
     *        request.
     * @return Result of the StopTextTranslationJob operation returned by the service.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.StopTextTranslationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/StopTextTranslationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopTextTranslationJobResponse stopTextTranslationJob(
            Consumer<StopTextTranslationJobRequest.Builder> stopTextTranslationJobRequest) throws ResourceNotFoundException,
            TooManyRequestsException, InternalServerException, AwsServiceException, SdkClientException, TranslateException {
        return stopTextTranslationJob(StopTextTranslationJobRequest.builder().applyMutation(stopTextTranslationJobRequest)
                .build());
    }

    /**
     * <p>
     * Associates a specific tag with a resource. A tag is a key-value pair that adds as a metadata to a resource. For
     * more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your
     * resources</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws ConcurrentModificationException
     *         Another modification is being made. That modification must complete before you can make your change.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws TooManyTagsException
     *         You have added too many tags to this resource. The maximum is 50 tags.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidParameterValueException,
            ConcurrentModificationException, ResourceNotFoundException, TooManyTagsException, InternalServerException,
            AwsServiceException, SdkClientException, TranslateException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a specific tag with a resource. A tag is a key-value pair that adds as a metadata to a resource. For
     * more information, see <a href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your
     * resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws ConcurrentModificationException
     *         Another modification is being made. That modification must complete before you can make your change.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws TooManyTagsException
     *         You have added too many tags to this resource. The maximum is 50 tags.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InvalidParameterValueException, ConcurrentModificationException, ResourceNotFoundException,
            TooManyTagsException, InternalServerException, AwsServiceException, SdkClientException, TranslateException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Translates the input document from the source language to the target language. This synchronous operation
     * supports text, HTML, or Word documents as the input document. <code>TranslateDocument</code> supports
     * translations from English to any supported language, and from any supported language to English. Therefore,
     * specify either the source language code or the target language code as “en” (English).
     * </p>
     * <p>
     * If you set the <code>Formality</code> parameter, the request will fail if the target language does not support
     * formality. For a list of target languages that support formality, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-formality.html">Setting
     * formality</a>.
     * </p>
     *
     * @param translateDocumentRequest
     * @return Result of the TranslateDocument operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is not valid. Check your request to determine why it's not valid and then retry
     *         the request.
     * @throws LimitExceededException
     *         The specified limit has been exceeded. Review your request and retry it with a quantity below the stated
     *         limit.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws UnsupportedLanguagePairException
     *         Amazon Translate does not support translation from the language of the source text into the requested
     *         target language. For more information, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Translate service is temporarily unavailable. Wait a bit and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.TranslateDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/TranslateDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default TranslateDocumentResponse translateDocument(TranslateDocumentRequest translateDocumentRequest)
            throws InvalidRequestException, LimitExceededException, TooManyRequestsException, ResourceNotFoundException,
            UnsupportedLanguagePairException, InternalServerException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, TranslateException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Translates the input document from the source language to the target language. This synchronous operation
     * supports text, HTML, or Word documents as the input document. <code>TranslateDocument</code> supports
     * translations from English to any supported language, and from any supported language to English. Therefore,
     * specify either the source language code or the target language code as “en” (English).
     * </p>
     * <p>
     * If you set the <code>Formality</code> parameter, the request will fail if the target language does not support
     * formality. For a list of target languages that support formality, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-formality.html">Setting
     * formality</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TranslateDocumentRequest.Builder} avoiding the need
     * to create one manually via {@link TranslateDocumentRequest#builder()}
     * </p>
     *
     * @param translateDocumentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.TranslateDocumentRequest.Builder} to create a
     *        request.
     * @return Result of the TranslateDocument operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is not valid. Check your request to determine why it's not valid and then retry
     *         the request.
     * @throws LimitExceededException
     *         The specified limit has been exceeded. Review your request and retry it with a quantity below the stated
     *         limit.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws UnsupportedLanguagePairException
     *         Amazon Translate does not support translation from the language of the source text into the requested
     *         target language. For more information, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Translate service is temporarily unavailable. Wait a bit and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.TranslateDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/TranslateDocument" target="_top">AWS
     *      API Documentation</a>
     */
    default TranslateDocumentResponse translateDocument(Consumer<TranslateDocumentRequest.Builder> translateDocumentRequest)
            throws InvalidRequestException, LimitExceededException, TooManyRequestsException, ResourceNotFoundException,
            UnsupportedLanguagePairException, InternalServerException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, TranslateException {
        return translateDocument(TranslateDocumentRequest.builder().applyMutation(translateDocumentRequest).build());
    }

    /**
     * <p>
     * Translates input text from the source language to the target language. For a list of available languages and
     * language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported
     * languages</a>.
     * </p>
     *
     * @param translateTextRequest
     * @return Result of the TranslateText operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is not valid. Check your request to determine why it's not valid and then retry
     *         the request.
     * @throws TextSizeLimitExceededException
     *         The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller
     *         document and then retry your request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws UnsupportedLanguagePairException
     *         Amazon Translate does not support translation from the language of the source text into the requested
     *         target language. For more information, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.
     * @throws DetectedLanguageLowConfidenceException
     *         The confidence that Amazon Comprehend accurately detected the source language is low. If a low confidence
     *         level is acceptable for your application, you can use the language in the exception to call Amazon
     *         Translate again. For more information, see the <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectDominantLanguage.html"
     *         >DetectDominantLanguage</a> operation in the <i>Amazon Comprehend Developer Guide</i>.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Translate service is temporarily unavailable. Wait a bit and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.TranslateText
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/TranslateText" target="_top">AWS API
     *      Documentation</a>
     */
    default TranslateTextResponse translateText(TranslateTextRequest translateTextRequest) throws InvalidRequestException,
            TextSizeLimitExceededException, TooManyRequestsException, UnsupportedLanguagePairException,
            DetectedLanguageLowConfidenceException, ResourceNotFoundException, InternalServerException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, TranslateException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Translates input text from the source language to the target language. For a list of available languages and
     * language codes, see <a href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported
     * languages</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TranslateTextRequest.Builder} avoiding the need to
     * create one manually via {@link TranslateTextRequest#builder()}
     * </p>
     *
     * @param translateTextRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.TranslateTextRequest.Builder} to create a request.
     * @return Result of the TranslateText operation returned by the service.
     * @throws InvalidRequestException
     *         The request that you made is not valid. Check your request to determine why it's not valid and then retry
     *         the request.
     * @throws TextSizeLimitExceededException
     *         The size of the text you submitted exceeds the size limit. Reduce the size of the text or use a smaller
     *         document and then retry your request.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws UnsupportedLanguagePairException
     *         Amazon Translate does not support translation from the language of the source text into the requested
     *         target language. For more information, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.
     * @throws DetectedLanguageLowConfidenceException
     *         The confidence that Amazon Comprehend accurately detected the source language is low. If a low confidence
     *         level is acceptable for your application, you can use the language in the exception to call Amazon
     *         Translate again. For more information, see the <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectDominantLanguage.html"
     *         >DetectDominantLanguage</a> operation in the <i>Amazon Comprehend Developer Guide</i>.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws ServiceUnavailableException
     *         The Amazon Translate service is temporarily unavailable. Wait a bit and then retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.TranslateText
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/TranslateText" target="_top">AWS API
     *      Documentation</a>
     */
    default TranslateTextResponse translateText(Consumer<TranslateTextRequest.Builder> translateTextRequest)
            throws InvalidRequestException, TextSizeLimitExceededException, TooManyRequestsException,
            UnsupportedLanguagePairException, DetectedLanguageLowConfidenceException, ResourceNotFoundException,
            InternalServerException, ServiceUnavailableException, AwsServiceException, SdkClientException, TranslateException {
        return translateText(TranslateTextRequest.builder().applyMutation(translateTextRequest).build());
    }

    /**
     * <p>
     * Removes a specific tag associated with an Amazon Translate resource. For more information, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws ConcurrentModificationException
     *         Another modification is being made. That modification must complete before you can make your change.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidParameterValueException,
            ConcurrentModificationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, TranslateException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a specific tag associated with an Amazon Translate resource. For more information, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/tagging.html"> Tagging your resources</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws ConcurrentModificationException
     *         Another modification is being made. That modification must complete before you can make your change.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InvalidParameterValueException, ConcurrentModificationException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, TranslateException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a previously created parallel data resource by importing a new input file from Amazon S3.
     * </p>
     *
     * @param updateParallelDataRequest
     * @return Result of the UpdateParallelData operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is being made. That modification must complete before you can make your change.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws InvalidRequestException
     *         The request that you made is not valid. Check your request to determine why it's not valid and then retry
     *         the request.
     * @throws LimitExceededException
     *         The specified limit has been exceeded. Review your request and retry it with a quantity below the stated
     *         limit.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.UpdateParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/UpdateParallelData" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateParallelDataResponse updateParallelData(UpdateParallelDataRequest updateParallelDataRequest)
            throws ConcurrentModificationException, InvalidParameterValueException, InvalidRequestException,
            LimitExceededException, TooManyRequestsException, ConflictException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, TranslateException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a previously created parallel data resource by importing a new input file from Amazon S3.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateParallelDataRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateParallelDataRequest#builder()}
     * </p>
     *
     * @param updateParallelDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.translate.model.UpdateParallelDataRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateParallelData operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is being made. That modification must complete before you can make your change.
     * @throws InvalidParameterValueException
     *         The value of the parameter is not valid. Review the value of the parameter you are using to correct it,
     *         and then retry your operation.
     * @throws InvalidRequestException
     *         The request that you made is not valid. Check your request to determine why it's not valid and then retry
     *         the request.
     * @throws LimitExceededException
     *         The specified limit has been exceeded. Review your request and retry it with a quantity below the stated
     *         limit.
     * @throws TooManyRequestsException
     *         You have made too many requests within a short period of time. Wait for a short time and then try your
     *         request again.
     * @throws ConflictException
     *         There was a conflict processing the request. Try your request again.
     * @throws ResourceNotFoundException
     *         The resource you are looking for has not been found. Review the resource you're looking for and see if a
     *         different resource will accomplish your needs before retrying the revised request.
     * @throws InternalServerException
     *         An internal server error occurred. Retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TranslateException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TranslateClient.UpdateParallelData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/translate-2017-07-01/UpdateParallelData" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateParallelDataResponse updateParallelData(Consumer<UpdateParallelDataRequest.Builder> updateParallelDataRequest)
            throws ConcurrentModificationException, InvalidParameterValueException, InvalidRequestException,
            LimitExceededException, TooManyRequestsException, ConflictException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, TranslateException {
        return updateParallelData(UpdateParallelDataRequest.builder().applyMutation(updateParallelDataRequest).build());
    }

    /**
     * Create a {@link TranslateClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static TranslateClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link TranslateClient}.
     */
    static TranslateClientBuilder builder() {
        return new DefaultTranslateClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default TranslateServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
