/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of documents successfully and unsuccessfully processed during a translation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobDetails implements SdkPojo, Serializable, ToCopyableBuilder<JobDetails.Builder, JobDetails> {
    private static final SdkField<Integer> TRANSLATED_DOCUMENTS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TranslatedDocumentsCount").getter(getter(JobDetails::translatedDocumentsCount))
            .setter(setter(Builder::translatedDocumentsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranslatedDocumentsCount").build())
            .build();

    private static final SdkField<Integer> DOCUMENTS_WITH_ERRORS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("DocumentsWithErrorsCount")
            .getter(getter(JobDetails::documentsWithErrorsCount)).setter(setter(Builder::documentsWithErrorsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentsWithErrorsCount").build())
            .build();

    private static final SdkField<Integer> INPUT_DOCUMENTS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InputDocumentsCount").getter(getter(JobDetails::inputDocumentsCount))
            .setter(setter(Builder::inputDocumentsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDocumentsCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TRANSLATED_DOCUMENTS_COUNT_FIELD, DOCUMENTS_WITH_ERRORS_COUNT_FIELD, INPUT_DOCUMENTS_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer translatedDocumentsCount;

    private final Integer documentsWithErrorsCount;

    private final Integer inputDocumentsCount;

    private JobDetails(BuilderImpl builder) {
        this.translatedDocumentsCount = builder.translatedDocumentsCount;
        this.documentsWithErrorsCount = builder.documentsWithErrorsCount;
        this.inputDocumentsCount = builder.inputDocumentsCount;
    }

    /**
     * <p>
     * The number of documents successfully processed during a translation job.
     * </p>
     * 
     * @return The number of documents successfully processed during a translation job.
     */
    public final Integer translatedDocumentsCount() {
        return translatedDocumentsCount;
    }

    /**
     * <p>
     * The number of documents that could not be processed during a translation job.
     * </p>
     * 
     * @return The number of documents that could not be processed during a translation job.
     */
    public final Integer documentsWithErrorsCount() {
        return documentsWithErrorsCount;
    }

    /**
     * <p>
     * The number of documents used as input in a translation job.
     * </p>
     * 
     * @return The number of documents used as input in a translation job.
     */
    public final Integer inputDocumentsCount() {
        return inputDocumentsCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(translatedDocumentsCount());
        hashCode = 31 * hashCode + Objects.hashCode(documentsWithErrorsCount());
        hashCode = 31 * hashCode + Objects.hashCode(inputDocumentsCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDetails)) {
            return false;
        }
        JobDetails other = (JobDetails) obj;
        return Objects.equals(translatedDocumentsCount(), other.translatedDocumentsCount())
                && Objects.equals(documentsWithErrorsCount(), other.documentsWithErrorsCount())
                && Objects.equals(inputDocumentsCount(), other.inputDocumentsCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobDetails").add("TranslatedDocumentsCount", translatedDocumentsCount())
                .add("DocumentsWithErrorsCount", documentsWithErrorsCount()).add("InputDocumentsCount", inputDocumentsCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TranslatedDocumentsCount":
            return Optional.ofNullable(clazz.cast(translatedDocumentsCount()));
        case "DocumentsWithErrorsCount":
            return Optional.ofNullable(clazz.cast(documentsWithErrorsCount()));
        case "InputDocumentsCount":
            return Optional.ofNullable(clazz.cast(inputDocumentsCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TranslatedDocumentsCount", TRANSLATED_DOCUMENTS_COUNT_FIELD);
        map.put("DocumentsWithErrorsCount", DOCUMENTS_WITH_ERRORS_COUNT_FIELD);
        map.put("InputDocumentsCount", INPUT_DOCUMENTS_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobDetails, T> g) {
        return obj -> g.apply((JobDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobDetails> {
        /**
         * <p>
         * The number of documents successfully processed during a translation job.
         * </p>
         * 
         * @param translatedDocumentsCount
         *        The number of documents successfully processed during a translation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder translatedDocumentsCount(Integer translatedDocumentsCount);

        /**
         * <p>
         * The number of documents that could not be processed during a translation job.
         * </p>
         * 
         * @param documentsWithErrorsCount
         *        The number of documents that could not be processed during a translation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentsWithErrorsCount(Integer documentsWithErrorsCount);

        /**
         * <p>
         * The number of documents used as input in a translation job.
         * </p>
         * 
         * @param inputDocumentsCount
         *        The number of documents used as input in a translation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDocumentsCount(Integer inputDocumentsCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer translatedDocumentsCount;

        private Integer documentsWithErrorsCount;

        private Integer inputDocumentsCount;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDetails model) {
            translatedDocumentsCount(model.translatedDocumentsCount);
            documentsWithErrorsCount(model.documentsWithErrorsCount);
            inputDocumentsCount(model.inputDocumentsCount);
        }

        public final Integer getTranslatedDocumentsCount() {
            return translatedDocumentsCount;
        }

        public final void setTranslatedDocumentsCount(Integer translatedDocumentsCount) {
            this.translatedDocumentsCount = translatedDocumentsCount;
        }

        @Override
        public final Builder translatedDocumentsCount(Integer translatedDocumentsCount) {
            this.translatedDocumentsCount = translatedDocumentsCount;
            return this;
        }

        public final Integer getDocumentsWithErrorsCount() {
            return documentsWithErrorsCount;
        }

        public final void setDocumentsWithErrorsCount(Integer documentsWithErrorsCount) {
            this.documentsWithErrorsCount = documentsWithErrorsCount;
        }

        @Override
        public final Builder documentsWithErrorsCount(Integer documentsWithErrorsCount) {
            this.documentsWithErrorsCount = documentsWithErrorsCount;
            return this;
        }

        public final Integer getInputDocumentsCount() {
            return inputDocumentsCount;
        }

        public final void setInputDocumentsCount(Integer inputDocumentsCount) {
            this.inputDocumentsCount = inputDocumentsCount;
        }

        @Override
        public final Builder inputDocumentsCount(Integer inputDocumentsCount) {
            this.inputDocumentsCount = inputDocumentsCount;
            return this;
        }

        @Override
        public JobDetails build() {
            return new JobDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
