/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTextTranslationJobRequest extends TranslateRequest implements
        ToCopyableBuilder<StartTextTranslationJobRequest.Builder, StartTextTranslationJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobName").getter(getter(StartTextTranslationJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField
            .<InputDataConfig> builder(MarshallingType.SDK_POJO).memberName("InputDataConfig")
            .getter(getter(StartTextTranslationJobRequest::inputDataConfig)).setter(setter(Builder::inputDataConfig))
            .constructor(InputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()).build();

    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<OutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("OutputDataConfig")
            .getter(getter(StartTextTranslationJobRequest::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(OutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessRoleArn").getter(getter(StartTextTranslationJobRequest::dataAccessRoleArn))
            .setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<String> SOURCE_LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLanguageCode").getter(getter(StartTextTranslationJobRequest::sourceLanguageCode))
            .setter(setter(Builder::sourceLanguageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLanguageCode").build())
            .build();

    private static final SdkField<List<String>> TARGET_LANGUAGE_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetLanguageCodes")
            .getter(getter(StartTextTranslationJobRequest::targetLanguageCodes))
            .setter(setter(Builder::targetLanguageCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLanguageCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TERMINOLOGY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TerminologyNames")
            .getter(getter(StartTextTranslationJobRequest::terminologyNames))
            .setter(setter(Builder::terminologyNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminologyNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PARALLEL_DATA_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ParallelDataNames")
            .getter(getter(StartTextTranslationJobRequest::parallelDataNames))
            .setter(setter(Builder::parallelDataNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelDataNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartTextTranslationJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<TranslationSettings> SETTINGS_FIELD = SdkField
            .<TranslationSettings> builder(MarshallingType.SDK_POJO).memberName("Settings")
            .getter(getter(StartTextTranslationJobRequest::settings)).setter(setter(Builder::settings))
            .constructor(TranslationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Settings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, SOURCE_LANGUAGE_CODE_FIELD,
            TARGET_LANGUAGE_CODES_FIELD, TERMINOLOGY_NAMES_FIELD, PARALLEL_DATA_NAMES_FIELD, CLIENT_TOKEN_FIELD, SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String jobName;

    private final InputDataConfig inputDataConfig;

    private final OutputDataConfig outputDataConfig;

    private final String dataAccessRoleArn;

    private final String sourceLanguageCode;

    private final List<String> targetLanguageCodes;

    private final List<String> terminologyNames;

    private final List<String> parallelDataNames;

    private final String clientToken;

    private final TranslationSettings settings;

    private StartTextTranslationJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.sourceLanguageCode = builder.sourceLanguageCode;
        this.targetLanguageCodes = builder.targetLanguageCodes;
        this.terminologyNames = builder.terminologyNames;
        this.parallelDataNames = builder.parallelDataNames;
        this.clientToken = builder.clientToken;
        this.settings = builder.settings;
    }

    /**
     * <p>
     * The name of the batch translation job to be performed.
     * </p>
     * 
     * @return The name of the batch translation job to be performed.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * Specifies the format and location of the input documents for the translation job.
     * </p>
     * 
     * @return Specifies the format and location of the input documents for the translation job.
     */
    public final InputDataConfig inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * Specifies the S3 folder to which your job output will be saved.
     * </p>
     * 
     * @return Specifies the S3 folder to which your job output will be saved.
     */
    public final OutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon Translate
     * read access to your input data. For more information, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/identity-and-access-management.html">Identity and access
     * management </a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon
     *         Translate read access to your input data. For more information, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/identity-and-access-management.html">Identity and
     *         access management </a>.
     */
    public final String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * <p>
     * The language code of the input language. Specify the language if all input documents share the same language. If
     * you don't know the language of the source files, or your input documents contains different source languages,
     * select <code>auto</code>. Amazon Translate auto detects the source language for each input document. For a list
     * of supported language codes, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.
     * </p>
     * 
     * @return The language code of the input language. Specify the language if all input documents share the same
     *         language. If you don't know the language of the source files, or your input documents contains different
     *         source languages, select <code>auto</code>. Amazon Translate auto detects the source language for each
     *         input document. For a list of supported language codes, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.
     */
    public final String sourceLanguageCode() {
        return sourceLanguageCode;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetLanguageCodes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetLanguageCodes() {
        return targetLanguageCodes != null && !(targetLanguageCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The target languages of the translation job. Enter up to 10 language codes. Each input file is translated into
     * each target language.
     * </p>
     * <p>
     * Each language code is 2 or 5 characters long. For a list of language codes, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetLanguageCodes} method.
     * </p>
     * 
     * @return The target languages of the translation job. Enter up to 10 language codes. Each input file is translated
     *         into each target language.</p>
     *         <p>
     *         Each language code is 2 or 5 characters long. For a list of language codes, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.
     */
    public final List<String> targetLanguageCodes() {
        return targetLanguageCodes;
    }

    /**
     * For responses, this returns true if the service returned a value for the TerminologyNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTerminologyNames() {
        return terminologyNames != null && !(terminologyNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of a custom terminology resource to add to the translation job. This resource lists examples source
     * terms and the desired translation for each term.
     * </p>
     * <p>
     * This parameter accepts only one custom terminology resource.
     * </p>
     * <p>
     * If you specify multiple target languages for the job, translate uses the designated terminology for each
     * requested target language that has an entry for the source term in the terminology file.
     * </p>
     * <p>
     * For a list of available custom terminology resources, use the <a>ListTerminologies</a> operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom terminology</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTerminologyNames} method.
     * </p>
     * 
     * @return The name of a custom terminology resource to add to the translation job. This resource lists examples
     *         source terms and the desired translation for each term.</p>
     *         <p>
     *         This parameter accepts only one custom terminology resource.
     *         </p>
     *         <p>
     *         If you specify multiple target languages for the job, translate uses the designated terminology for each
     *         requested target language that has an entry for the source term in the terminology file.
     *         </p>
     *         <p>
     *         For a list of available custom terminology resources, use the <a>ListTerminologies</a> operation.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom
     *         terminology</a>.
     */
    public final List<String> terminologyNames() {
        return terminologyNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParallelDataNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParallelDataNames() {
        return parallelDataNames != null && !(parallelDataNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of a parallel data resource to add to the translation job. This resource consists of examples that show
     * how you want segments of text to be translated. If you specify multiple target languages for the job, the
     * parallel data file must include translations for all the target languages.
     * </p>
     * <p>
     * When you add parallel data to a translation job, you create an <i>Active Custom Translation</i> job.
     * </p>
     * <p>
     * This parameter accepts only one parallel data resource.
     * </p>
     * <note>
     * <p>
     * Active Custom Translation jobs are priced at a higher rate than other jobs that don't use parallel data. For more
     * information, see <a href="http://aws.amazon.com/translate/pricing/">Amazon Translate pricing</a>.
     * </p>
     * </note>
     * <p>
     * For a list of available parallel data resources, use the <a>ListParallelData</a> operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-parallel-data.html"> Customizing
     * your translations with parallel data</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParallelDataNames} method.
     * </p>
     * 
     * @return The name of a parallel data resource to add to the translation job. This resource consists of examples
     *         that show how you want segments of text to be translated. If you specify multiple target languages for
     *         the job, the parallel data file must include translations for all the target languages.</p>
     *         <p>
     *         When you add parallel data to a translation job, you create an <i>Active Custom Translation</i> job.
     *         </p>
     *         <p>
     *         This parameter accepts only one parallel data resource.
     *         </p>
     *         <note>
     *         <p>
     *         Active Custom Translation jobs are priced at a higher rate than other jobs that don't use parallel data.
     *         For more information, see <a href="http://aws.amazon.com/translate/pricing/">Amazon Translate
     *         pricing</a>.
     *         </p>
     *         </note>
     *         <p>
     *         For a list of available parallel data resources, use the <a>ListParallelData</a> operation.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-parallel-data.html">
     *         Customizing your translations with parallel data</a>.
     */
    public final List<String> parallelDataNames() {
        return parallelDataNames;
    }

    /**
     * <p>
     * A unique identifier for the request. This token is generated for you when using the Amazon Translate SDK.
     * </p>
     * 
     * @return A unique identifier for the request. This token is generated for you when using the Amazon Translate SDK.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Settings to configure your translation output. You can configure the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Brevity: not supported.
     * </p>
     * </li>
     * <li>
     * <p>
     * Formality: sets the formality level of the output text.
     * </p>
     * </li>
     * <li>
     * <p>
     * Profanity: masks profane words and phrases in your translation output.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Settings to configure your translation output. You can configure the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Brevity: not supported.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Formality: sets the formality level of the output text.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Profanity: masks profane words and phrases in your translation output.
     *         </p>
     *         </li>
     */
    public final TranslationSettings settings() {
        return settings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetLanguageCodes() ? targetLanguageCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTerminologyNames() ? terminologyNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParallelDataNames() ? parallelDataNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(settings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTextTranslationJobRequest)) {
            return false;
        }
        StartTextTranslationJobRequest other = (StartTextTranslationJobRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn())
                && Objects.equals(sourceLanguageCode(), other.sourceLanguageCode())
                && hasTargetLanguageCodes() == other.hasTargetLanguageCodes()
                && Objects.equals(targetLanguageCodes(), other.targetLanguageCodes())
                && hasTerminologyNames() == other.hasTerminologyNames()
                && Objects.equals(terminologyNames(), other.terminologyNames())
                && hasParallelDataNames() == other.hasParallelDataNames()
                && Objects.equals(parallelDataNames(), other.parallelDataNames())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(settings(), other.settings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartTextTranslationJobRequest").add("JobName", jobName())
                .add("InputDataConfig", inputDataConfig()).add("OutputDataConfig", outputDataConfig())
                .add("DataAccessRoleArn", dataAccessRoleArn()).add("SourceLanguageCode", sourceLanguageCode())
                .add("TargetLanguageCodes", hasTargetLanguageCodes() ? targetLanguageCodes() : null)
                .add("TerminologyNames", hasTerminologyNames() ? terminologyNames() : null)
                .add("ParallelDataNames", hasParallelDataNames() ? parallelDataNames() : null).add("ClientToken", clientToken())
                .add("Settings", settings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "OutputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "SourceLanguageCode":
            return Optional.ofNullable(clazz.cast(sourceLanguageCode()));
        case "TargetLanguageCodes":
            return Optional.ofNullable(clazz.cast(targetLanguageCodes()));
        case "TerminologyNames":
            return Optional.ofNullable(clazz.cast(terminologyNames()));
        case "ParallelDataNames":
            return Optional.ofNullable(clazz.cast(parallelDataNames()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Settings":
            return Optional.ofNullable(clazz.cast(settings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobName", JOB_NAME_FIELD);
        map.put("InputDataConfig", INPUT_DATA_CONFIG_FIELD);
        map.put("OutputDataConfig", OUTPUT_DATA_CONFIG_FIELD);
        map.put("DataAccessRoleArn", DATA_ACCESS_ROLE_ARN_FIELD);
        map.put("SourceLanguageCode", SOURCE_LANGUAGE_CODE_FIELD);
        map.put("TargetLanguageCodes", TARGET_LANGUAGE_CODES_FIELD);
        map.put("TerminologyNames", TERMINOLOGY_NAMES_FIELD);
        map.put("ParallelDataNames", PARALLEL_DATA_NAMES_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Settings", SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartTextTranslationJobRequest, T> g) {
        return obj -> g.apply((StartTextTranslationJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TranslateRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartTextTranslationJobRequest> {
        /**
         * <p>
         * The name of the batch translation job to be performed.
         * </p>
         * 
         * @param jobName
         *        The name of the batch translation job to be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * Specifies the format and location of the input documents for the translation job.
         * </p>
         * 
         * @param inputDataConfig
         *        Specifies the format and location of the input documents for the translation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(InputDataConfig inputDataConfig);

        /**
         * <p>
         * Specifies the format and location of the input documents for the translation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputDataConfig.Builder} avoiding the
         * need to create one manually via {@link InputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #inputDataConfig(InputDataConfig)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link InputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(InputDataConfig)
         */
        default Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return inputDataConfig(InputDataConfig.builder().applyMutation(inputDataConfig).build());
        }

        /**
         * <p>
         * Specifies the S3 folder to which your job output will be saved.
         * </p>
         * 
         * @param outputDataConfig
         *        Specifies the S3 folder to which your job output will be saved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(OutputDataConfig outputDataConfig);

        /**
         * <p>
         * Specifies the S3 folder to which your job output will be saved.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputDataConfig.Builder} avoiding the
         * need to create one manually via {@link OutputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputDataConfig(OutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link OutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(OutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(OutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon
         * Translate read access to your input data. For more information, see <a
         * href="https://docs.aws.amazon.com/translate/latest/dg/identity-and-access-management.html">Identity and
         * access management </a>.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon
         *        Translate read access to your input data. For more information, see <a
         *        href="https://docs.aws.amazon.com/translate/latest/dg/identity-and-access-management.html">Identity
         *        and access management </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * The language code of the input language. Specify the language if all input documents share the same language.
         * If you don't know the language of the source files, or your input documents contains different source
         * languages, select <code>auto</code>. Amazon Translate auto detects the source language for each input
         * document. For a list of supported language codes, see <a
         * href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.
         * </p>
         * 
         * @param sourceLanguageCode
         *        The language code of the input language. Specify the language if all input documents share the same
         *        language. If you don't know the language of the source files, or your input documents contains
         *        different source languages, select <code>auto</code>. Amazon Translate auto detects the source
         *        language for each input document. For a list of supported language codes, see <a
         *        href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLanguageCode(String sourceLanguageCode);

        /**
         * <p>
         * The target languages of the translation job. Enter up to 10 language codes. Each input file is translated
         * into each target language.
         * </p>
         * <p>
         * Each language code is 2 or 5 characters long. For a list of language codes, see <a
         * href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.
         * </p>
         * 
         * @param targetLanguageCodes
         *        The target languages of the translation job. Enter up to 10 language codes. Each input file is
         *        translated into each target language.</p>
         *        <p>
         *        Each language code is 2 or 5 characters long. For a list of language codes, see <a
         *        href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLanguageCodes(Collection<String> targetLanguageCodes);

        /**
         * <p>
         * The target languages of the translation job. Enter up to 10 language codes. Each input file is translated
         * into each target language.
         * </p>
         * <p>
         * Each language code is 2 or 5 characters long. For a list of language codes, see <a
         * href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.
         * </p>
         * 
         * @param targetLanguageCodes
         *        The target languages of the translation job. Enter up to 10 language codes. Each input file is
         *        translated into each target language.</p>
         *        <p>
         *        Each language code is 2 or 5 characters long. For a list of language codes, see <a
         *        href="https://docs.aws.amazon.com/translate/latest/dg/what-is-languages.html">Supported languages</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLanguageCodes(String... targetLanguageCodes);

        /**
         * <p>
         * The name of a custom terminology resource to add to the translation job. This resource lists examples source
         * terms and the desired translation for each term.
         * </p>
         * <p>
         * This parameter accepts only one custom terminology resource.
         * </p>
         * <p>
         * If you specify multiple target languages for the job, translate uses the designated terminology for each
         * requested target language that has an entry for the source term in the terminology file.
         * </p>
         * <p>
         * For a list of available custom terminology resources, use the <a>ListTerminologies</a> operation.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom terminology</a>.
         * </p>
         * 
         * @param terminologyNames
         *        The name of a custom terminology resource to add to the translation job. This resource lists examples
         *        source terms and the desired translation for each term.</p>
         *        <p>
         *        This parameter accepts only one custom terminology resource.
         *        </p>
         *        <p>
         *        If you specify multiple target languages for the job, translate uses the designated terminology for
         *        each requested target language that has an entry for the source term in the terminology file.
         *        </p>
         *        <p>
         *        For a list of available custom terminology resources, use the <a>ListTerminologies</a> operation.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom
         *        terminology</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminologyNames(Collection<String> terminologyNames);

        /**
         * <p>
         * The name of a custom terminology resource to add to the translation job. This resource lists examples source
         * terms and the desired translation for each term.
         * </p>
         * <p>
         * This parameter accepts only one custom terminology resource.
         * </p>
         * <p>
         * If you specify multiple target languages for the job, translate uses the designated terminology for each
         * requested target language that has an entry for the source term in the terminology file.
         * </p>
         * <p>
         * For a list of available custom terminology resources, use the <a>ListTerminologies</a> operation.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom terminology</a>.
         * </p>
         * 
         * @param terminologyNames
         *        The name of a custom terminology resource to add to the translation job. This resource lists examples
         *        source terms and the desired translation for each term.</p>
         *        <p>
         *        This parameter accepts only one custom terminology resource.
         *        </p>
         *        <p>
         *        If you specify multiple target languages for the job, translate uses the designated terminology for
         *        each requested target language that has an entry for the source term in the terminology file.
         *        </p>
         *        <p>
         *        For a list of available custom terminology resources, use the <a>ListTerminologies</a> operation.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/translate/latest/dg/how-custom-terminology.html">Custom
         *        terminology</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminologyNames(String... terminologyNames);

        /**
         * <p>
         * The name of a parallel data resource to add to the translation job. This resource consists of examples that
         * show how you want segments of text to be translated. If you specify multiple target languages for the job,
         * the parallel data file must include translations for all the target languages.
         * </p>
         * <p>
         * When you add parallel data to a translation job, you create an <i>Active Custom Translation</i> job.
         * </p>
         * <p>
         * This parameter accepts only one parallel data resource.
         * </p>
         * <note>
         * <p>
         * Active Custom Translation jobs are priced at a higher rate than other jobs that don't use parallel data. For
         * more information, see <a href="http://aws.amazon.com/translate/pricing/">Amazon Translate pricing</a>.
         * </p>
         * </note>
         * <p>
         * For a list of available parallel data resources, use the <a>ListParallelData</a> operation.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-parallel-data.html">
         * Customizing your translations with parallel data</a>.
         * </p>
         * 
         * @param parallelDataNames
         *        The name of a parallel data resource to add to the translation job. This resource consists of examples
         *        that show how you want segments of text to be translated. If you specify multiple target languages for
         *        the job, the parallel data file must include translations for all the target languages.</p>
         *        <p>
         *        When you add parallel data to a translation job, you create an <i>Active Custom Translation</i> job.
         *        </p>
         *        <p>
         *        This parameter accepts only one parallel data resource.
         *        </p>
         *        <note>
         *        <p>
         *        Active Custom Translation jobs are priced at a higher rate than other jobs that don't use parallel
         *        data. For more information, see <a href="http://aws.amazon.com/translate/pricing/">Amazon Translate
         *        pricing</a>.
         *        </p>
         *        </note>
         *        <p>
         *        For a list of available parallel data resources, use the <a>ListParallelData</a> operation.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-parallel-data.html">
         *        Customizing your translations with parallel data</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelDataNames(Collection<String> parallelDataNames);

        /**
         * <p>
         * The name of a parallel data resource to add to the translation job. This resource consists of examples that
         * show how you want segments of text to be translated. If you specify multiple target languages for the job,
         * the parallel data file must include translations for all the target languages.
         * </p>
         * <p>
         * When you add parallel data to a translation job, you create an <i>Active Custom Translation</i> job.
         * </p>
         * <p>
         * This parameter accepts only one parallel data resource.
         * </p>
         * <note>
         * <p>
         * Active Custom Translation jobs are priced at a higher rate than other jobs that don't use parallel data. For
         * more information, see <a href="http://aws.amazon.com/translate/pricing/">Amazon Translate pricing</a>.
         * </p>
         * </note>
         * <p>
         * For a list of available parallel data resources, use the <a>ListParallelData</a> operation.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-parallel-data.html">
         * Customizing your translations with parallel data</a>.
         * </p>
         * 
         * @param parallelDataNames
         *        The name of a parallel data resource to add to the translation job. This resource consists of examples
         *        that show how you want segments of text to be translated. If you specify multiple target languages for
         *        the job, the parallel data file must include translations for all the target languages.</p>
         *        <p>
         *        When you add parallel data to a translation job, you create an <i>Active Custom Translation</i> job.
         *        </p>
         *        <p>
         *        This parameter accepts only one parallel data resource.
         *        </p>
         *        <note>
         *        <p>
         *        Active Custom Translation jobs are priced at a higher rate than other jobs that don't use parallel
         *        data. For more information, see <a href="http://aws.amazon.com/translate/pricing/">Amazon Translate
         *        pricing</a>.
         *        </p>
         *        </note>
         *        <p>
         *        For a list of available parallel data resources, use the <a>ListParallelData</a> operation.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/translate/latest/dg/customizing-translations-parallel-data.html">
         *        Customizing your translations with parallel data</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelDataNames(String... parallelDataNames);

        /**
         * <p>
         * A unique identifier for the request. This token is generated for you when using the Amazon Translate SDK.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier for the request. This token is generated for you when using the Amazon Translate
         *        SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Settings to configure your translation output. You can configure the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Brevity: not supported.
         * </p>
         * </li>
         * <li>
         * <p>
         * Formality: sets the formality level of the output text.
         * </p>
         * </li>
         * <li>
         * <p>
         * Profanity: masks profane words and phrases in your translation output.
         * </p>
         * </li>
         * </ul>
         * 
         * @param settings
         *        Settings to configure your translation output. You can configure the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Brevity: not supported.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Formality: sets the formality level of the output text.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Profanity: masks profane words and phrases in your translation output.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settings(TranslationSettings settings);

        /**
         * <p>
         * Settings to configure your translation output. You can configure the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Brevity: not supported.
         * </p>
         * </li>
         * <li>
         * <p>
         * Formality: sets the formality level of the output text.
         * </p>
         * </li>
         * <li>
         * <p>
         * Profanity: masks profane words and phrases in your translation output.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link TranslationSettings.Builder} avoiding the
         * need to create one manually via {@link TranslationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TranslationSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #settings(TranslationSettings)}.
         * 
         * @param settings
         *        a consumer that will call methods on {@link TranslationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settings(TranslationSettings)
         */
        default Builder settings(Consumer<TranslationSettings.Builder> settings) {
            return settings(TranslationSettings.builder().applyMutation(settings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranslateRequest.BuilderImpl implements Builder {
        private String jobName;

        private InputDataConfig inputDataConfig;

        private OutputDataConfig outputDataConfig;

        private String dataAccessRoleArn;

        private String sourceLanguageCode;

        private List<String> targetLanguageCodes = DefaultSdkAutoConstructList.getInstance();

        private List<String> terminologyNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> parallelDataNames = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private TranslationSettings settings;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTextTranslationJobRequest model) {
            super(model);
            jobName(model.jobName);
            inputDataConfig(model.inputDataConfig);
            outputDataConfig(model.outputDataConfig);
            dataAccessRoleArn(model.dataAccessRoleArn);
            sourceLanguageCode(model.sourceLanguageCode);
            targetLanguageCodes(model.targetLanguageCodes);
            terminologyNames(model.terminologyNames);
            parallelDataNames(model.parallelDataNames);
            clientToken(model.clientToken);
            settings(model.settings);
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return inputDataConfig != null ? inputDataConfig.toBuilder() : null;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final String getSourceLanguageCode() {
            return sourceLanguageCode;
        }

        public final void setSourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
        }

        @Override
        public final Builder sourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
            return this;
        }

        public final Collection<String> getTargetLanguageCodes() {
            if (targetLanguageCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return targetLanguageCodes;
        }

        public final void setTargetLanguageCodes(Collection<String> targetLanguageCodes) {
            this.targetLanguageCodes = TargetLanguageCodeStringListCopier.copy(targetLanguageCodes);
        }

        @Override
        public final Builder targetLanguageCodes(Collection<String> targetLanguageCodes) {
            this.targetLanguageCodes = TargetLanguageCodeStringListCopier.copy(targetLanguageCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLanguageCodes(String... targetLanguageCodes) {
            targetLanguageCodes(Arrays.asList(targetLanguageCodes));
            return this;
        }

        public final Collection<String> getTerminologyNames() {
            if (terminologyNames instanceof SdkAutoConstructList) {
                return null;
            }
            return terminologyNames;
        }

        public final void setTerminologyNames(Collection<String> terminologyNames) {
            this.terminologyNames = ResourceNameListCopier.copy(terminologyNames);
        }

        @Override
        public final Builder terminologyNames(Collection<String> terminologyNames) {
            this.terminologyNames = ResourceNameListCopier.copy(terminologyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminologyNames(String... terminologyNames) {
            terminologyNames(Arrays.asList(terminologyNames));
            return this;
        }

        public final Collection<String> getParallelDataNames() {
            if (parallelDataNames instanceof SdkAutoConstructList) {
                return null;
            }
            return parallelDataNames;
        }

        public final void setParallelDataNames(Collection<String> parallelDataNames) {
            this.parallelDataNames = ResourceNameListCopier.copy(parallelDataNames);
        }

        @Override
        public final Builder parallelDataNames(Collection<String> parallelDataNames) {
            this.parallelDataNames = ResourceNameListCopier.copy(parallelDataNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parallelDataNames(String... parallelDataNames) {
            parallelDataNames(Arrays.asList(parallelDataNames));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final TranslationSettings.Builder getSettings() {
            return settings != null ? settings.toBuilder() : null;
        }

        public final void setSettings(TranslationSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        @Override
        @Transient
        public final Builder settings(TranslationSettings settings) {
            this.settings = settings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTextTranslationJobRequest build() {
            return new StartTextTranslationJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
