/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Term
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Term> {
    private static final SdkField<String> SOURCE_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Term.getter(Term::sourceText)).setter(Term.setter(Builder::sourceText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceText").build()}).build();
    private static final SdkField<String> TARGET_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Term.getter(Term::targetText)).setter(Term.setter(Builder::targetText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetText").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_TEXT_FIELD, TARGET_TEXT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceText;
    private final String targetText;

    private Term(BuilderImpl builder) {
        this.sourceText = builder.sourceText;
        this.targetText = builder.targetText;
    }

    public String sourceText() {
        return this.sourceText;
    }

    public String targetText() {
        return this.targetText;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceText());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetText());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Term)) {
            return false;
        }
        Term other = (Term)obj;
        return Objects.equals(this.sourceText(), other.sourceText()) && Objects.equals(this.targetText(), other.targetText());
    }

    public String toString() {
        return ToString.builder((String)"Term").add("SourceText", (Object)this.sourceText()).add("TargetText", (Object)this.targetText()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceText": {
                return Optional.ofNullable(clazz.cast(this.sourceText()));
            }
            case "TargetText": {
                return Optional.ofNullable(clazz.cast(this.targetText()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Term, T> g) {
        return obj -> g.apply((Term)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceText;
        private String targetText;

        private BuilderImpl() {
        }

        private BuilderImpl(Term model) {
            this.sourceText(model.sourceText);
            this.targetText(model.targetText);
        }

        public final String getSourceText() {
            return this.sourceText;
        }

        @Override
        public final Builder sourceText(String sourceText) {
            this.sourceText = sourceText;
            return this;
        }

        public final void setSourceText(String sourceText) {
            this.sourceText = sourceText;
        }

        public final String getTargetText() {
            return this.targetText;
        }

        @Override
        public final Builder targetText(String targetText) {
            this.targetText = targetText;
            return this;
        }

        public final void setTargetText(String targetText) {
            this.targetText = targetText;
        }

        public Term build() {
            return new Term(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Term> {
        public Builder sourceText(String var1);

        public Builder targetText(String var1);
    }
}

