/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportTerminologyRequest extends TranslateRequest implements
        ToCopyableBuilder<ImportTerminologyRequest.Builder, ImportTerminologyRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImportTerminologyRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> MERGE_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImportTerminologyRequest::mergeStrategyAsString)).setter(setter(Builder::mergeStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MergeStrategy").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImportTerminologyRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<TerminologyData> TERMINOLOGY_DATA_FIELD = SdkField
            .<TerminologyData> builder(MarshallingType.SDK_POJO).getter(getter(ImportTerminologyRequest::terminologyData))
            .setter(setter(Builder::terminologyData)).constructor(TerminologyData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminologyData").build()).build();

    private static final SdkField<EncryptionKey> ENCRYPTION_KEY_FIELD = SdkField
            .<EncryptionKey> builder(MarshallingType.SDK_POJO).getter(getter(ImportTerminologyRequest::encryptionKey))
            .setter(setter(Builder::encryptionKey)).constructor(EncryptionKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            MERGE_STRATEGY_FIELD, DESCRIPTION_FIELD, TERMINOLOGY_DATA_FIELD, ENCRYPTION_KEY_FIELD));

    private final String name;

    private final String mergeStrategy;

    private final String description;

    private final TerminologyData terminologyData;

    private final EncryptionKey encryptionKey;

    private ImportTerminologyRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.mergeStrategy = builder.mergeStrategy;
        this.description = builder.description;
        this.terminologyData = builder.terminologyData;
        this.encryptionKey = builder.encryptionKey;
    }

    /**
     * <p>
     * The name of the custom terminology being imported.
     * </p>
     * 
     * @return The name of the custom terminology being imported.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy is
     * supported. In this case, the imported terminology will overwrite an existing terminology of the same name.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeStrategy}
     * will return {@link MergeStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeStrategyAsString}.
     * </p>
     * 
     * @return The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy
     *         is supported. In this case, the imported terminology will overwrite an existing terminology of the same
     *         name.
     * @see MergeStrategy
     */
    public MergeStrategy mergeStrategy() {
        return MergeStrategy.fromValue(mergeStrategy);
    }

    /**
     * <p>
     * The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy is
     * supported. In this case, the imported terminology will overwrite an existing terminology of the same name.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mergeStrategy}
     * will return {@link MergeStrategy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mergeStrategyAsString}.
     * </p>
     * 
     * @return The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy
     *         is supported. In this case, the imported terminology will overwrite an existing terminology of the same
     *         name.
     * @see MergeStrategy
     */
    public String mergeStrategyAsString() {
        return mergeStrategy;
    }

    /**
     * <p>
     * The description of the custom terminology being imported.
     * </p>
     * 
     * @return The description of the custom terminology being imported.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The terminology data for the custom terminology being imported.
     * </p>
     * 
     * @return The terminology data for the custom terminology being imported.
     */
    public TerminologyData terminologyData() {
        return terminologyData;
    }

    /**
     * <p>
     * The encryption key for the custom terminology being imported.
     * </p>
     * 
     * @return The encryption key for the custom terminology being imported.
     */
    public EncryptionKey encryptionKey() {
        return encryptionKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(mergeStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(terminologyData());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportTerminologyRequest)) {
            return false;
        }
        ImportTerminologyRequest other = (ImportTerminologyRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(mergeStrategyAsString(), other.mergeStrategyAsString())
                && Objects.equals(description(), other.description())
                && Objects.equals(terminologyData(), other.terminologyData())
                && Objects.equals(encryptionKey(), other.encryptionKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ImportTerminologyRequest").add("Name", name()).add("MergeStrategy", mergeStrategyAsString())
                .add("Description", description()).add("TerminologyData", terminologyData())
                .add("EncryptionKey", encryptionKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "MergeStrategy":
            return Optional.ofNullable(clazz.cast(mergeStrategyAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "TerminologyData":
            return Optional.ofNullable(clazz.cast(terminologyData()));
        case "EncryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportTerminologyRequest, T> g) {
        return obj -> g.apply((ImportTerminologyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranslateRequest.Builder, SdkPojo, CopyableBuilder<Builder, ImportTerminologyRequest> {
        /**
         * <p>
         * The name of the custom terminology being imported.
         * </p>
         * 
         * @param name
         *        The name of the custom terminology being imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy is
         * supported. In this case, the imported terminology will overwrite an existing terminology of the same name.
         * </p>
         * 
         * @param mergeStrategy
         *        The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge
         *        strategy is supported. In this case, the imported terminology will overwrite an existing terminology
         *        of the same name.
         * @see MergeStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeStrategy
         */
        Builder mergeStrategy(String mergeStrategy);

        /**
         * <p>
         * The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge strategy is
         * supported. In this case, the imported terminology will overwrite an existing terminology of the same name.
         * </p>
         * 
         * @param mergeStrategy
         *        The merge strategy of the custom terminology being imported. Currently, only the OVERWRITE merge
         *        strategy is supported. In this case, the imported terminology will overwrite an existing terminology
         *        of the same name.
         * @see MergeStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MergeStrategy
         */
        Builder mergeStrategy(MergeStrategy mergeStrategy);

        /**
         * <p>
         * The description of the custom terminology being imported.
         * </p>
         * 
         * @param description
         *        The description of the custom terminology being imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The terminology data for the custom terminology being imported.
         * </p>
         * 
         * @param terminologyData
         *        The terminology data for the custom terminology being imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminologyData(TerminologyData terminologyData);

        /**
         * <p>
         * The terminology data for the custom terminology being imported.
         * </p>
         * This is a convenience that creates an instance of the {@link TerminologyData.Builder} avoiding the need to
         * create one manually via {@link TerminologyData#builder()}.
         *
         * When the {@link Consumer} completes, {@link TerminologyData.Builder#build()} is called immediately and its
         * result is passed to {@link #terminologyData(TerminologyData)}.
         * 
         * @param terminologyData
         *        a consumer that will call methods on {@link TerminologyData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #terminologyData(TerminologyData)
         */
        default Builder terminologyData(Consumer<TerminologyData.Builder> terminologyData) {
            return terminologyData(TerminologyData.builder().applyMutation(terminologyData).build());
        }

        /**
         * <p>
         * The encryption key for the custom terminology being imported.
         * </p>
         * 
         * @param encryptionKey
         *        The encryption key for the custom terminology being imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(EncryptionKey encryptionKey);

        /**
         * <p>
         * The encryption key for the custom terminology being imported.
         * </p>
         * This is a convenience that creates an instance of the {@link EncryptionKey.Builder} avoiding the need to
         * create one manually via {@link EncryptionKey#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncryptionKey.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionKey(EncryptionKey)}.
         * 
         * @param encryptionKey
         *        a consumer that will call methods on {@link EncryptionKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionKey(EncryptionKey)
         */
        default Builder encryptionKey(Consumer<EncryptionKey.Builder> encryptionKey) {
            return encryptionKey(EncryptionKey.builder().applyMutation(encryptionKey).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranslateRequest.BuilderImpl implements Builder {
        private String name;

        private String mergeStrategy;

        private String description;

        private TerminologyData terminologyData;

        private EncryptionKey encryptionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportTerminologyRequest model) {
            super(model);
            name(model.name);
            mergeStrategy(model.mergeStrategy);
            description(model.description);
            terminologyData(model.terminologyData);
            encryptionKey(model.encryptionKey);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMergeStrategyAsString() {
            return mergeStrategy;
        }

        @Override
        public final Builder mergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
            return this;
        }

        @Override
        public final Builder mergeStrategy(MergeStrategy mergeStrategy) {
            this.mergeStrategy(mergeStrategy.toString());
            return this;
        }

        public final void setMergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final TerminologyData.Builder getTerminologyData() {
            return terminologyData != null ? terminologyData.toBuilder() : null;
        }

        @Override
        public final Builder terminologyData(TerminologyData terminologyData) {
            this.terminologyData = terminologyData;
            return this;
        }

        public final void setTerminologyData(TerminologyData.BuilderImpl terminologyData) {
            this.terminologyData = terminologyData != null ? terminologyData.build() : null;
        }

        public final EncryptionKey.Builder getEncryptionKey() {
            return encryptionKey != null ? encryptionKey.toBuilder() : null;
        }

        @Override
        public final Builder encryptionKey(EncryptionKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final void setEncryptionKey(EncryptionKey.BuilderImpl encryptionKey) {
            this.encryptionKey = encryptionKey != null ? encryptionKey.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportTerminologyRequest build() {
            return new ImportTerminologyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
