/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTerminologyResponse extends TranslateResponse implements
        ToCopyableBuilder<GetTerminologyResponse.Builder, GetTerminologyResponse> {
    private static final SdkField<TerminologyProperties> TERMINOLOGY_PROPERTIES_FIELD = SdkField
            .<TerminologyProperties> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetTerminologyResponse::terminologyProperties)).setter(setter(Builder::terminologyProperties))
            .constructor(TerminologyProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminologyProperties").build())
            .build();

    private static final SdkField<TerminologyDataLocation> TERMINOLOGY_DATA_LOCATION_FIELD = SdkField
            .<TerminologyDataLocation> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetTerminologyResponse::terminologyDataLocation)).setter(setter(Builder::terminologyDataLocation))
            .constructor(TerminologyDataLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminologyDataLocation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMINOLOGY_PROPERTIES_FIELD,
            TERMINOLOGY_DATA_LOCATION_FIELD));

    private final TerminologyProperties terminologyProperties;

    private final TerminologyDataLocation terminologyDataLocation;

    private GetTerminologyResponse(BuilderImpl builder) {
        super(builder);
        this.terminologyProperties = builder.terminologyProperties;
        this.terminologyDataLocation = builder.terminologyDataLocation;
    }

    /**
     * <p>
     * The properties of the custom terminology being retrieved.
     * </p>
     * 
     * @return The properties of the custom terminology being retrieved.
     */
    public TerminologyProperties terminologyProperties() {
        return terminologyProperties;
    }

    /**
     * <p>
     * The data location of the custom terminology being retrieved. The custom terminology file is returned in a
     * presigned url that has a 30 minute expiration.
     * </p>
     * 
     * @return The data location of the custom terminology being retrieved. The custom terminology file is returned in a
     *         presigned url that has a 30 minute expiration.
     */
    public TerminologyDataLocation terminologyDataLocation() {
        return terminologyDataLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(terminologyProperties());
        hashCode = 31 * hashCode + Objects.hashCode(terminologyDataLocation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTerminologyResponse)) {
            return false;
        }
        GetTerminologyResponse other = (GetTerminologyResponse) obj;
        return Objects.equals(terminologyProperties(), other.terminologyProperties())
                && Objects.equals(terminologyDataLocation(), other.terminologyDataLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetTerminologyResponse").add("TerminologyProperties", terminologyProperties())
                .add("TerminologyDataLocation", terminologyDataLocation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TerminologyProperties":
            return Optional.ofNullable(clazz.cast(terminologyProperties()));
        case "TerminologyDataLocation":
            return Optional.ofNullable(clazz.cast(terminologyDataLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTerminologyResponse, T> g) {
        return obj -> g.apply((GetTerminologyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranslateResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTerminologyResponse> {
        /**
         * <p>
         * The properties of the custom terminology being retrieved.
         * </p>
         * 
         * @param terminologyProperties
         *        The properties of the custom terminology being retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminologyProperties(TerminologyProperties terminologyProperties);

        /**
         * <p>
         * The properties of the custom terminology being retrieved.
         * </p>
         * This is a convenience that creates an instance of the {@link TerminologyProperties.Builder} avoiding the need
         * to create one manually via {@link TerminologyProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link TerminologyProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #terminologyProperties(TerminologyProperties)}.
         * 
         * @param terminologyProperties
         *        a consumer that will call methods on {@link TerminologyProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #terminologyProperties(TerminologyProperties)
         */
        default Builder terminologyProperties(Consumer<TerminologyProperties.Builder> terminologyProperties) {
            return terminologyProperties(TerminologyProperties.builder().applyMutation(terminologyProperties).build());
        }

        /**
         * <p>
         * The data location of the custom terminology being retrieved. The custom terminology file is returned in a
         * presigned url that has a 30 minute expiration.
         * </p>
         * 
         * @param terminologyDataLocation
         *        The data location of the custom terminology being retrieved. The custom terminology file is returned
         *        in a presigned url that has a 30 minute expiration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminologyDataLocation(TerminologyDataLocation terminologyDataLocation);

        /**
         * <p>
         * The data location of the custom terminology being retrieved. The custom terminology file is returned in a
         * presigned url that has a 30 minute expiration.
         * </p>
         * This is a convenience that creates an instance of the {@link TerminologyDataLocation.Builder} avoiding the
         * need to create one manually via {@link TerminologyDataLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link TerminologyDataLocation.Builder#build()} is called immediately
         * and its result is passed to {@link #terminologyDataLocation(TerminologyDataLocation)}.
         * 
         * @param terminologyDataLocation
         *        a consumer that will call methods on {@link TerminologyDataLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #terminologyDataLocation(TerminologyDataLocation)
         */
        default Builder terminologyDataLocation(Consumer<TerminologyDataLocation.Builder> terminologyDataLocation) {
            return terminologyDataLocation(TerminologyDataLocation.builder().applyMutation(terminologyDataLocation).build());
        }
    }

    static final class BuilderImpl extends TranslateResponse.BuilderImpl implements Builder {
        private TerminologyProperties terminologyProperties;

        private TerminologyDataLocation terminologyDataLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTerminologyResponse model) {
            super(model);
            terminologyProperties(model.terminologyProperties);
            terminologyDataLocation(model.terminologyDataLocation);
        }

        public final TerminologyProperties.Builder getTerminologyProperties() {
            return terminologyProperties != null ? terminologyProperties.toBuilder() : null;
        }

        @Override
        public final Builder terminologyProperties(TerminologyProperties terminologyProperties) {
            this.terminologyProperties = terminologyProperties;
            return this;
        }

        public final void setTerminologyProperties(TerminologyProperties.BuilderImpl terminologyProperties) {
            this.terminologyProperties = terminologyProperties != null ? terminologyProperties.build() : null;
        }

        public final TerminologyDataLocation.Builder getTerminologyDataLocation() {
            return terminologyDataLocation != null ? terminologyDataLocation.toBuilder() : null;
        }

        @Override
        public final Builder terminologyDataLocation(TerminologyDataLocation terminologyDataLocation) {
            this.terminologyDataLocation = terminologyDataLocation;
            return this;
        }

        public final void setTerminologyDataLocation(TerminologyDataLocation.BuilderImpl terminologyDataLocation) {
            this.terminologyDataLocation = terminologyDataLocation != null ? terminologyDataLocation.build() : null;
        }

        @Override
        public GetTerminologyResponse build() {
            return new GetTerminologyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
