/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TranslateTextResponse extends TranslateResponse implements
        ToCopyableBuilder<TranslateTextResponse.Builder, TranslateTextResponse> {
    private static final SdkField<String> TRANSLATED_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TranslateTextResponse::translatedText)).setter(setter(Builder::translatedText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranslatedText").build()).build();

    private static final SdkField<String> SOURCE_LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TranslateTextResponse::sourceLanguageCode)).setter(setter(Builder::sourceLanguageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLanguageCode").build())
            .build();

    private static final SdkField<String> TARGET_LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TranslateTextResponse::targetLanguageCode)).setter(setter(Builder::targetLanguageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLanguageCode").build())
            .build();

    private static final SdkField<List<AppliedTerminology>> APPLIED_TERMINOLOGIES_FIELD = SdkField
            .<List<AppliedTerminology>> builder(MarshallingType.LIST)
            .getter(getter(TranslateTextResponse::appliedTerminologies))
            .setter(setter(Builder::appliedTerminologies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppliedTerminologies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppliedTerminology> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppliedTerminology::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSLATED_TEXT_FIELD,
            SOURCE_LANGUAGE_CODE_FIELD, TARGET_LANGUAGE_CODE_FIELD, APPLIED_TERMINOLOGIES_FIELD));

    private final String translatedText;

    private final String sourceLanguageCode;

    private final String targetLanguageCode;

    private final List<AppliedTerminology> appliedTerminologies;

    private TranslateTextResponse(BuilderImpl builder) {
        super(builder);
        this.translatedText = builder.translatedText;
        this.sourceLanguageCode = builder.sourceLanguageCode;
        this.targetLanguageCode = builder.targetLanguageCode;
        this.appliedTerminologies = builder.appliedTerminologies;
    }

    /**
     * <p>
     * The the translated text. The maximum length of this text is 5kb.
     * </p>
     * 
     * @return The the translated text. The maximum length of this text is 5kb.
     */
    public String translatedText() {
        return translatedText;
    }

    /**
     * <p>
     * The language code for the language of the source text.
     * </p>
     * 
     * @return The language code for the language of the source text.
     */
    public String sourceLanguageCode() {
        return sourceLanguageCode;
    }

    /**
     * <p>
     * The language code for the language of the target text.
     * </p>
     * 
     * @return The language code for the language of the target text.
     */
    public String targetLanguageCode() {
        return targetLanguageCode;
    }

    /**
     * <p>
     * The names of the custom terminologies applied to the input text by Amazon Translate for the translated text
     * response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of the custom terminologies applied to the input text by Amazon Translate for the translated
     *         text response.
     */
    public List<AppliedTerminology> appliedTerminologies() {
        return appliedTerminologies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(translatedText());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(targetLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(appliedTerminologies());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranslateTextResponse)) {
            return false;
        }
        TranslateTextResponse other = (TranslateTextResponse) obj;
        return Objects.equals(translatedText(), other.translatedText())
                && Objects.equals(sourceLanguageCode(), other.sourceLanguageCode())
                && Objects.equals(targetLanguageCode(), other.targetLanguageCode())
                && Objects.equals(appliedTerminologies(), other.appliedTerminologies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TranslateTextResponse").add("TranslatedText", translatedText())
                .add("SourceLanguageCode", sourceLanguageCode()).add("TargetLanguageCode", targetLanguageCode())
                .add("AppliedTerminologies", appliedTerminologies()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TranslatedText":
            return Optional.ofNullable(clazz.cast(translatedText()));
        case "SourceLanguageCode":
            return Optional.ofNullable(clazz.cast(sourceLanguageCode()));
        case "TargetLanguageCode":
            return Optional.ofNullable(clazz.cast(targetLanguageCode()));
        case "AppliedTerminologies":
            return Optional.ofNullable(clazz.cast(appliedTerminologies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TranslateTextResponse, T> g) {
        return obj -> g.apply((TranslateTextResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranslateResponse.Builder, SdkPojo, CopyableBuilder<Builder, TranslateTextResponse> {
        /**
         * <p>
         * The the translated text. The maximum length of this text is 5kb.
         * </p>
         * 
         * @param translatedText
         *        The the translated text. The maximum length of this text is 5kb.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder translatedText(String translatedText);

        /**
         * <p>
         * The language code for the language of the source text.
         * </p>
         * 
         * @param sourceLanguageCode
         *        The language code for the language of the source text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLanguageCode(String sourceLanguageCode);

        /**
         * <p>
         * The language code for the language of the target text.
         * </p>
         * 
         * @param targetLanguageCode
         *        The language code for the language of the target text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLanguageCode(String targetLanguageCode);

        /**
         * <p>
         * The names of the custom terminologies applied to the input text by Amazon Translate for the translated text
         * response.
         * </p>
         * 
         * @param appliedTerminologies
         *        The names of the custom terminologies applied to the input text by Amazon Translate for the translated
         *        text response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedTerminologies(Collection<AppliedTerminology> appliedTerminologies);

        /**
         * <p>
         * The names of the custom terminologies applied to the input text by Amazon Translate for the translated text
         * response.
         * </p>
         * 
         * @param appliedTerminologies
         *        The names of the custom terminologies applied to the input text by Amazon Translate for the translated
         *        text response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appliedTerminologies(AppliedTerminology... appliedTerminologies);

        /**
         * <p>
         * The names of the custom terminologies applied to the input text by Amazon Translate for the translated text
         * response.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AppliedTerminology>.Builder} avoiding the
         * need to create one manually via {@link List<AppliedTerminology>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AppliedTerminology>.Builder#build()} is called immediately
         * and its result is passed to {@link #appliedTerminologies(List<AppliedTerminology>)}.
         * 
         * @param appliedTerminologies
         *        a consumer that will call methods on {@link List<AppliedTerminology>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appliedTerminologies(List<AppliedTerminology>)
         */
        Builder appliedTerminologies(Consumer<AppliedTerminology.Builder>... appliedTerminologies);
    }

    static final class BuilderImpl extends TranslateResponse.BuilderImpl implements Builder {
        private String translatedText;

        private String sourceLanguageCode;

        private String targetLanguageCode;

        private List<AppliedTerminology> appliedTerminologies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TranslateTextResponse model) {
            super(model);
            translatedText(model.translatedText);
            sourceLanguageCode(model.sourceLanguageCode);
            targetLanguageCode(model.targetLanguageCode);
            appliedTerminologies(model.appliedTerminologies);
        }

        public final String getTranslatedText() {
            return translatedText;
        }

        @Override
        public final Builder translatedText(String translatedText) {
            this.translatedText = translatedText;
            return this;
        }

        public final void setTranslatedText(String translatedText) {
            this.translatedText = translatedText;
        }

        public final String getSourceLanguageCode() {
            return sourceLanguageCode;
        }

        @Override
        public final Builder sourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
            return this;
        }

        public final void setSourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
        }

        public final String getTargetLanguageCode() {
            return targetLanguageCode;
        }

        @Override
        public final Builder targetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
            return this;
        }

        public final void setTargetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
        }

        public final Collection<AppliedTerminology.Builder> getAppliedTerminologies() {
            return appliedTerminologies != null ? appliedTerminologies.stream().map(AppliedTerminology::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder appliedTerminologies(Collection<AppliedTerminology> appliedTerminologies) {
            this.appliedTerminologies = AppliedTerminologyListCopier.copy(appliedTerminologies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appliedTerminologies(AppliedTerminology... appliedTerminologies) {
            appliedTerminologies(Arrays.asList(appliedTerminologies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appliedTerminologies(Consumer<AppliedTerminology.Builder>... appliedTerminologies) {
            appliedTerminologies(Stream.of(appliedTerminologies).map(c -> AppliedTerminology.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAppliedTerminologies(Collection<AppliedTerminology.BuilderImpl> appliedTerminologies) {
            this.appliedTerminologies = AppliedTerminologyListCopier.copyFromBuilder(appliedTerminologies);
        }

        @Override
        public TranslateTextResponse build() {
            return new TranslateTextResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
