/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.trustedadvisor.model.ResourceStatus;
import software.amazon.awssdk.services.trustedadvisor.model.TrustedAdvisorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOrganizationRecommendationResourcesRequest
extends TrustedAdvisorRequest
implements ToCopyableBuilder<Builder, ListOrganizationRecommendationResourcesRequest> {
    private static final SdkField<String> AFFECTED_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("affectedAccountId").getter(ListOrganizationRecommendationResourcesRequest.getter(ListOrganizationRecommendationResourcesRequest::affectedAccountId)).setter(ListOrganizationRecommendationResourcesRequest.setter(Builder::affectedAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("affectedAccountId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListOrganizationRecommendationResourcesRequest.getter(ListOrganizationRecommendationResourcesRequest::maxResults)).setter(ListOrganizationRecommendationResourcesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListOrganizationRecommendationResourcesRequest.getter(ListOrganizationRecommendationResourcesRequest::nextToken)).setter(ListOrganizationRecommendationResourcesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> ORGANIZATION_RECOMMENDATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("organizationRecommendationIdentifier").getter(ListOrganizationRecommendationResourcesRequest.getter(ListOrganizationRecommendationResourcesRequest::organizationRecommendationIdentifier)).setter(ListOrganizationRecommendationResourcesRequest.setter(Builder::organizationRecommendationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("organizationRecommendationIdentifier").build()}).build();
    private static final SdkField<String> REGION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("regionCode").getter(ListOrganizationRecommendationResourcesRequest.getter(ListOrganizationRecommendationResourcesRequest::regionCode)).setter(ListOrganizationRecommendationResourcesRequest.setter(Builder::regionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("regionCode").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ListOrganizationRecommendationResourcesRequest.getter(ListOrganizationRecommendationResourcesRequest::statusAsString)).setter(ListOrganizationRecommendationResourcesRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFFECTED_ACCOUNT_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, ORGANIZATION_RECOMMENDATION_IDENTIFIER_FIELD, REGION_CODE_FIELD, STATUS_FIELD));
    private final String affectedAccountId;
    private final Integer maxResults;
    private final String nextToken;
    private final String organizationRecommendationIdentifier;
    private final String regionCode;
    private final String status;

    private ListOrganizationRecommendationResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.affectedAccountId = builder.affectedAccountId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.organizationRecommendationIdentifier = builder.organizationRecommendationIdentifier;
        this.regionCode = builder.regionCode;
        this.status = builder.status;
    }

    public final String affectedAccountId() {
        return this.affectedAccountId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String organizationRecommendationIdentifier() {
        return this.organizationRecommendationIdentifier;
    }

    public final String regionCode() {
        return this.regionCode;
    }

    public final ResourceStatus status() {
        return ResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.affectedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationRecommendationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOrganizationRecommendationResourcesRequest)) {
            return false;
        }
        ListOrganizationRecommendationResourcesRequest other = (ListOrganizationRecommendationResourcesRequest)((Object)obj);
        return Objects.equals(this.affectedAccountId(), other.affectedAccountId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.organizationRecommendationIdentifier(), other.organizationRecommendationIdentifier()) && Objects.equals(this.regionCode(), other.regionCode()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListOrganizationRecommendationResourcesRequest").add("AffectedAccountId", (Object)this.affectedAccountId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("OrganizationRecommendationIdentifier", (Object)this.organizationRecommendationIdentifier()).add("RegionCode", (Object)this.regionCode()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "affectedAccountId": {
                return Optional.ofNullable(clazz.cast(this.affectedAccountId()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "organizationRecommendationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.organizationRecommendationIdentifier()));
            }
            case "regionCode": {
                return Optional.ofNullable(clazz.cast(this.regionCode()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOrganizationRecommendationResourcesRequest, T> g) {
        return obj -> g.apply((ListOrganizationRecommendationResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TrustedAdvisorRequest.BuilderImpl
    implements Builder {
        private String affectedAccountId;
        private Integer maxResults;
        private String nextToken;
        private String organizationRecommendationIdentifier;
        private String regionCode;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOrganizationRecommendationResourcesRequest model) {
            super(model);
            this.affectedAccountId(model.affectedAccountId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.organizationRecommendationIdentifier(model.organizationRecommendationIdentifier);
            this.regionCode(model.regionCode);
            this.status(model.status);
        }

        public final String getAffectedAccountId() {
            return this.affectedAccountId;
        }

        public final void setAffectedAccountId(String affectedAccountId) {
            this.affectedAccountId = affectedAccountId;
        }

        @Override
        public final Builder affectedAccountId(String affectedAccountId) {
            this.affectedAccountId = affectedAccountId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOrganizationRecommendationIdentifier() {
            return this.organizationRecommendationIdentifier;
        }

        public final void setOrganizationRecommendationIdentifier(String organizationRecommendationIdentifier) {
            this.organizationRecommendationIdentifier = organizationRecommendationIdentifier;
        }

        @Override
        public final Builder organizationRecommendationIdentifier(String organizationRecommendationIdentifier) {
            this.organizationRecommendationIdentifier = organizationRecommendationIdentifier;
            return this;
        }

        public final String getRegionCode() {
            return this.regionCode;
        }

        public final void setRegionCode(String regionCode) {
            this.regionCode = regionCode;
        }

        @Override
        public final Builder regionCode(String regionCode) {
            this.regionCode = regionCode;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListOrganizationRecommendationResourcesRequest build() {
            return new ListOrganizationRecommendationResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TrustedAdvisorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOrganizationRecommendationResourcesRequest> {
        public Builder affectedAccountId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder organizationRecommendationIdentifier(String var1);

        public Builder regionCode(String var1);

        public Builder status(String var1);

        public Builder status(ResourceStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

