/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.trustedadvisor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRecommendationsRequest extends TrustedAdvisorRequest implements
        ToCopyableBuilder<ListRecommendationsRequest.Builder, ListRecommendationsRequest> {
    private static final SdkField<Instant> AFTER_LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("afterLastUpdatedAt").getter(getter(ListRecommendationsRequest::afterLastUpdatedAt))
            .setter(setter(Builder::afterLastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("afterLastUpdatedAt").build())
            .build();

    private static final SdkField<String> AWS_SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsService").getter(getter(ListRecommendationsRequest::awsService)).setter(setter(Builder::awsService))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("awsService").build()).build();

    private static final SdkField<Instant> BEFORE_LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("beforeLastUpdatedAt").getter(getter(ListRecommendationsRequest::beforeLastUpdatedAt))
            .setter(setter(Builder::beforeLastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("beforeLastUpdatedAt").build())
            .build();

    private static final SdkField<String> CHECK_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checkIdentifier").getter(getter(ListRecommendationsRequest::checkIdentifier))
            .setter(setter(Builder::checkIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("checkIdentifier").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListRecommendationsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRecommendationsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> PILLAR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("pillar")
            .getter(getter(ListRecommendationsRequest::pillarAsString)).setter(setter(Builder::pillar))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("pillar").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(ListRecommendationsRequest::sourceAsString)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("source").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListRecommendationsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ListRecommendationsRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFTER_LAST_UPDATED_AT_FIELD,
            AWS_SERVICE_FIELD, BEFORE_LAST_UPDATED_AT_FIELD, CHECK_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD,
            PILLAR_FIELD, SOURCE_FIELD, STATUS_FIELD, TYPE_FIELD));

    private final Instant afterLastUpdatedAt;

    private final String awsService;

    private final Instant beforeLastUpdatedAt;

    private final String checkIdentifier;

    private final Integer maxResults;

    private final String nextToken;

    private final String pillar;

    private final String source;

    private final String status;

    private final String type;

    private ListRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.afterLastUpdatedAt = builder.afterLastUpdatedAt;
        this.awsService = builder.awsService;
        this.beforeLastUpdatedAt = builder.beforeLastUpdatedAt;
        this.checkIdentifier = builder.checkIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.pillar = builder.pillar;
        this.source = builder.source;
        this.status = builder.status;
        this.type = builder.type;
    }

    /**
     * <p>
     * After the last update of the Recommendation
     * </p>
     * 
     * @return After the last update of the Recommendation
     */
    public final Instant afterLastUpdatedAt() {
        return afterLastUpdatedAt;
    }

    /**
     * <p>
     * The aws service associated with the Recommendation
     * </p>
     * 
     * @return The aws service associated with the Recommendation
     */
    public final String awsService() {
        return awsService;
    }

    /**
     * <p>
     * Before the last update of the Recommendation
     * </p>
     * 
     * @return Before the last update of the Recommendation
     */
    public final Instant beforeLastUpdatedAt() {
        return beforeLastUpdatedAt;
    }

    /**
     * <p>
     * The check identifier of the Recommendation
     * </p>
     * 
     * @return The check identifier of the Recommendation
     */
    public final String checkIdentifier() {
        return checkIdentifier;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The pillar of the Recommendation
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pillar} will
     * return {@link RecommendationPillar#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #pillarAsString}.
     * </p>
     * 
     * @return The pillar of the Recommendation
     * @see RecommendationPillar
     */
    public final RecommendationPillar pillar() {
        return RecommendationPillar.fromValue(pillar);
    }

    /**
     * <p>
     * The pillar of the Recommendation
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pillar} will
     * return {@link RecommendationPillar#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #pillarAsString}.
     * </p>
     * 
     * @return The pillar of the Recommendation
     * @see RecommendationPillar
     */
    public final String pillarAsString() {
        return pillar;
    }

    /**
     * <p>
     * The source of the Recommendation
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link RecommendationSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceAsString}.
     * </p>
     * 
     * @return The source of the Recommendation
     * @see RecommendationSource
     */
    public final RecommendationSource source() {
        return RecommendationSource.fromValue(source);
    }

    /**
     * <p>
     * The source of the Recommendation
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link RecommendationSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceAsString}.
     * </p>
     * 
     * @return The source of the Recommendation
     * @see RecommendationSource
     */
    public final String sourceAsString() {
        return source;
    }

    /**
     * <p>
     * The status of the Recommendation
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecommendationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Recommendation
     * @see RecommendationStatus
     */
    public final RecommendationStatus status() {
        return RecommendationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Recommendation
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecommendationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Recommendation
     * @see RecommendationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The type of the Recommendation
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RecommendationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the Recommendation
     * @see RecommendationType
     */
    public final RecommendationType type() {
        return RecommendationType.fromValue(type);
    }

    /**
     * <p>
     * The type of the Recommendation
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RecommendationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the Recommendation
     * @see RecommendationType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(afterLastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(awsService());
        hashCode = 31 * hashCode + Objects.hashCode(beforeLastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(checkIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(pillarAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationsRequest)) {
            return false;
        }
        ListRecommendationsRequest other = (ListRecommendationsRequest) obj;
        return Objects.equals(afterLastUpdatedAt(), other.afterLastUpdatedAt())
                && Objects.equals(awsService(), other.awsService())
                && Objects.equals(beforeLastUpdatedAt(), other.beforeLastUpdatedAt())
                && Objects.equals(checkIdentifier(), other.checkIdentifier()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(pillarAsString(), other.pillarAsString())
                && Objects.equals(sourceAsString(), other.sourceAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRecommendationsRequest").add("AfterLastUpdatedAt", afterLastUpdatedAt())
                .add("AwsService", awsService()).add("BeforeLastUpdatedAt", beforeLastUpdatedAt())
                .add("CheckIdentifier", checkIdentifier()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("Pillar", pillarAsString()).add("Source", sourceAsString()).add("Status", statusAsString())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "afterLastUpdatedAt":
            return Optional.ofNullable(clazz.cast(afterLastUpdatedAt()));
        case "awsService":
            return Optional.ofNullable(clazz.cast(awsService()));
        case "beforeLastUpdatedAt":
            return Optional.ofNullable(clazz.cast(beforeLastUpdatedAt()));
        case "checkIdentifier":
            return Optional.ofNullable(clazz.cast(checkIdentifier()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "pillar":
            return Optional.ofNullable(clazz.cast(pillarAsString()));
        case "source":
            return Optional.ofNullable(clazz.cast(sourceAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendationsRequest, T> g) {
        return obj -> g.apply((ListRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TrustedAdvisorRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListRecommendationsRequest> {
        /**
         * <p>
         * After the last update of the Recommendation
         * </p>
         * 
         * @param afterLastUpdatedAt
         *        After the last update of the Recommendation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterLastUpdatedAt(Instant afterLastUpdatedAt);

        /**
         * <p>
         * The aws service associated with the Recommendation
         * </p>
         * 
         * @param awsService
         *        The aws service associated with the Recommendation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsService(String awsService);

        /**
         * <p>
         * Before the last update of the Recommendation
         * </p>
         * 
         * @param beforeLastUpdatedAt
         *        Before the last update of the Recommendation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeLastUpdatedAt(Instant beforeLastUpdatedAt);

        /**
         * <p>
         * The check identifier of the Recommendation
         * </p>
         * 
         * @param checkIdentifier
         *        The check identifier of the Recommendation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkIdentifier(String checkIdentifier);

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The pillar of the Recommendation
         * </p>
         * 
         * @param pillar
         *        The pillar of the Recommendation
         * @see RecommendationPillar
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationPillar
         */
        Builder pillar(String pillar);

        /**
         * <p>
         * The pillar of the Recommendation
         * </p>
         * 
         * @param pillar
         *        The pillar of the Recommendation
         * @see RecommendationPillar
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationPillar
         */
        Builder pillar(RecommendationPillar pillar);

        /**
         * <p>
         * The source of the Recommendation
         * </p>
         * 
         * @param source
         *        The source of the Recommendation
         * @see RecommendationSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationSource
         */
        Builder source(String source);

        /**
         * <p>
         * The source of the Recommendation
         * </p>
         * 
         * @param source
         *        The source of the Recommendation
         * @see RecommendationSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationSource
         */
        Builder source(RecommendationSource source);

        /**
         * <p>
         * The status of the Recommendation
         * </p>
         * 
         * @param status
         *        The status of the Recommendation
         * @see RecommendationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Recommendation
         * </p>
         * 
         * @param status
         *        The status of the Recommendation
         * @see RecommendationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationStatus
         */
        Builder status(RecommendationStatus status);

        /**
         * <p>
         * The type of the Recommendation
         * </p>
         * 
         * @param type
         *        The type of the Recommendation
         * @see RecommendationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the Recommendation
         * </p>
         * 
         * @param type
         *        The type of the Recommendation
         * @see RecommendationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationType
         */
        Builder type(RecommendationType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TrustedAdvisorRequest.BuilderImpl implements Builder {
        private Instant afterLastUpdatedAt;

        private String awsService;

        private Instant beforeLastUpdatedAt;

        private String checkIdentifier;

        private Integer maxResults;

        private String nextToken;

        private String pillar;

        private String source;

        private String status;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendationsRequest model) {
            super(model);
            afterLastUpdatedAt(model.afterLastUpdatedAt);
            awsService(model.awsService);
            beforeLastUpdatedAt(model.beforeLastUpdatedAt);
            checkIdentifier(model.checkIdentifier);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            pillar(model.pillar);
            source(model.source);
            status(model.status);
            type(model.type);
        }

        public final Instant getAfterLastUpdatedAt() {
            return afterLastUpdatedAt;
        }

        public final void setAfterLastUpdatedAt(Instant afterLastUpdatedAt) {
            this.afterLastUpdatedAt = afterLastUpdatedAt;
        }

        @Override
        public final Builder afterLastUpdatedAt(Instant afterLastUpdatedAt) {
            this.afterLastUpdatedAt = afterLastUpdatedAt;
            return this;
        }

        public final String getAwsService() {
            return awsService;
        }

        public final void setAwsService(String awsService) {
            this.awsService = awsService;
        }

        @Override
        public final Builder awsService(String awsService) {
            this.awsService = awsService;
            return this;
        }

        public final Instant getBeforeLastUpdatedAt() {
            return beforeLastUpdatedAt;
        }

        public final void setBeforeLastUpdatedAt(Instant beforeLastUpdatedAt) {
            this.beforeLastUpdatedAt = beforeLastUpdatedAt;
        }

        @Override
        public final Builder beforeLastUpdatedAt(Instant beforeLastUpdatedAt) {
            this.beforeLastUpdatedAt = beforeLastUpdatedAt;
            return this;
        }

        public final String getCheckIdentifier() {
            return checkIdentifier;
        }

        public final void setCheckIdentifier(String checkIdentifier) {
            this.checkIdentifier = checkIdentifier;
        }

        @Override
        public final Builder checkIdentifier(String checkIdentifier) {
            this.checkIdentifier = checkIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getPillar() {
            return pillar;
        }

        public final void setPillar(String pillar) {
            this.pillar = pillar;
        }

        @Override
        public final Builder pillar(String pillar) {
            this.pillar = pillar;
            return this;
        }

        @Override
        public final Builder pillar(RecommendationPillar pillar) {
            this.pillar(pillar == null ? null : pillar.toString());
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(RecommendationSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecommendationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RecommendationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRecommendationsRequest build() {
            return new ListRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
