/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.trustedadvisor;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.trustedadvisor.model.AccessDeniedException;
import software.amazon.awssdk.services.trustedadvisor.model.ConflictException;
import software.amazon.awssdk.services.trustedadvisor.model.GetOrganizationRecommendationRequest;
import software.amazon.awssdk.services.trustedadvisor.model.GetOrganizationRecommendationResponse;
import software.amazon.awssdk.services.trustedadvisor.model.GetRecommendationRequest;
import software.amazon.awssdk.services.trustedadvisor.model.GetRecommendationResponse;
import software.amazon.awssdk.services.trustedadvisor.model.InternalServerException;
import software.amazon.awssdk.services.trustedadvisor.model.ListChecksRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListChecksResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ResourceNotFoundException;
import software.amazon.awssdk.services.trustedadvisor.model.ThrottlingException;
import software.amazon.awssdk.services.trustedadvisor.model.TrustedAdvisorException;
import software.amazon.awssdk.services.trustedadvisor.model.UpdateOrganizationRecommendationLifecycleRequest;
import software.amazon.awssdk.services.trustedadvisor.model.UpdateOrganizationRecommendationLifecycleResponse;
import software.amazon.awssdk.services.trustedadvisor.model.UpdateRecommendationLifecycleRequest;
import software.amazon.awssdk.services.trustedadvisor.model.UpdateRecommendationLifecycleResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ValidationException;
import software.amazon.awssdk.services.trustedadvisor.paginators.ListChecksIterable;
import software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationAccountsIterable;
import software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationResourcesIterable;
import software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationsIterable;
import software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationResourcesIterable;
import software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationsIterable;

/**
 * Service client for accessing TrustedAdvisor Public API. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * TrustedAdvisor Public API
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface TrustedAdvisorClient extends AwsClient {
    String SERVICE_NAME = "trustedadvisor";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "trustedadvisor";

    /**
     * <p>
     * Get a specific recommendation within an AWS Organizations organization. This API supports only prioritized
     * recommendations.
     * </p>
     *
     * @param getOrganizationRecommendationRequest
     * @return Result of the GetOrganizationRecommendation operation returned by the service.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ResourceNotFoundException
     *         Exception that the requested resource has not been found
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.GetOrganizationRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/GetOrganizationRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOrganizationRecommendationResponse getOrganizationRecommendation(
            GetOrganizationRecommendationRequest getOrganizationRecommendationRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, TrustedAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a specific recommendation within an AWS Organizations organization. This API supports only prioritized
     * recommendations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOrganizationRecommendationRequest.Builder}
     * avoiding the need to create one manually via {@link GetOrganizationRecommendationRequest#builder()}
     * </p>
     *
     * @param getOrganizationRecommendationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.GetOrganizationRecommendationRequest.Builder}
     *        to create a request.
     * @return Result of the GetOrganizationRecommendation operation returned by the service.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ResourceNotFoundException
     *         Exception that the requested resource has not been found
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.GetOrganizationRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/GetOrganizationRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOrganizationRecommendationResponse getOrganizationRecommendation(
            Consumer<GetOrganizationRecommendationRequest.Builder> getOrganizationRecommendationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        return getOrganizationRecommendation(GetOrganizationRecommendationRequest.builder()
                .applyMutation(getOrganizationRecommendationRequest).build());
    }

    /**
     * <p>
     * Get a specific Recommendation
     * </p>
     *
     * @param getRecommendationRequest
     * @return Result of the GetRecommendation operation returned by the service.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ResourceNotFoundException
     *         Exception that the requested resource has not been found
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.GetRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/GetRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRecommendationResponse getRecommendation(GetRecommendationRequest getRecommendationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a specific Recommendation
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecommendationRequest.Builder} avoiding the need
     * to create one manually via {@link GetRecommendationRequest#builder()}
     * </p>
     *
     * @param getRecommendationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.GetRecommendationRequest.Builder} to create a
     *        request.
     * @return Result of the GetRecommendation operation returned by the service.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ResourceNotFoundException
     *         Exception that the requested resource has not been found
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.GetRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/GetRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRecommendationResponse getRecommendation(Consumer<GetRecommendationRequest.Builder> getRecommendationRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        return getRecommendation(GetRecommendationRequest.builder().applyMutation(getRecommendationRequest).build());
    }

    /**
     * <p>
     * List a filterable set of Checks
     * </p>
     *
     * @param listChecksRequest
     * @return Result of the ListChecks operation returned by the service.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListChecks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChecksResponse listChecks(ListChecksRequest listChecksRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            TrustedAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List a filterable set of Checks
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChecksRequest.Builder} avoiding the need to
     * create one manually via {@link ListChecksRequest#builder()}
     * </p>
     *
     * @param listChecksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListChecksRequest.Builder} to create a
     *        request.
     * @return Result of the ListChecks operation returned by the service.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListChecks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChecksResponse listChecks(Consumer<ListChecksRequest.Builder> listChecksRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            TrustedAdvisorException {
        return listChecks(ListChecksRequest.builder().applyMutation(listChecksRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listChecks(software.amazon.awssdk.services.trustedadvisor.model.ListChecksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListChecksIterable responses = client.listChecksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.trustedadvisor.paginators.ListChecksIterable responses = client.listChecksPaginator(request);
     *     for (software.amazon.awssdk.services.trustedadvisor.model.ListChecksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListChecksIterable responses = client.listChecksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChecks(software.amazon.awssdk.services.trustedadvisor.model.ListChecksRequest)} operation.</b>
     * </p>
     *
     * @param listChecksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListChecks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChecksIterable listChecksPaginator(ListChecksRequest listChecksRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            TrustedAdvisorException {
        return new ListChecksIterable(this, listChecksRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listChecks(software.amazon.awssdk.services.trustedadvisor.model.ListChecksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListChecksIterable responses = client.listChecksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.trustedadvisor.paginators.ListChecksIterable responses = client.listChecksPaginator(request);
     *     for (software.amazon.awssdk.services.trustedadvisor.model.ListChecksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListChecksIterable responses = client.listChecksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChecks(software.amazon.awssdk.services.trustedadvisor.model.ListChecksRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChecksRequest.Builder} avoiding the need to
     * create one manually via {@link ListChecksRequest#builder()}
     * </p>
     *
     * @param listChecksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListChecksRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListChecks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChecksIterable listChecksPaginator(Consumer<ListChecksRequest.Builder> listChecksRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, TrustedAdvisorException {
        return listChecksPaginator(ListChecksRequest.builder().applyMutation(listChecksRequest).build());
    }

    /**
     * <p>
     * Lists the accounts that own the resources for an organization aggregate recommendation. This API only supports
     * prioritized recommendations.
     * </p>
     *
     * @param listOrganizationRecommendationAccountsRequest
     * @return Result of the ListOrganizationRecommendationAccounts operation returned by the service.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ResourceNotFoundException
     *         Exception that the requested resource has not been found
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListOrganizationRecommendationAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendationAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationRecommendationAccountsResponse listOrganizationRecommendationAccounts(
            ListOrganizationRecommendationAccountsRequest listOrganizationRecommendationAccountsRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the accounts that own the resources for an organization aggregate recommendation. This API only supports
     * prioritized recommendations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListOrganizationRecommendationAccountsRequest.Builder} avoiding the need to create one manually via
     * {@link ListOrganizationRecommendationAccountsRequest#builder()}
     * </p>
     *
     * @param listOrganizationRecommendationAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsRequest.Builder}
     *        to create a request.
     * @return Result of the ListOrganizationRecommendationAccounts operation returned by the service.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ResourceNotFoundException
     *         Exception that the requested resource has not been found
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListOrganizationRecommendationAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendationAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationRecommendationAccountsResponse listOrganizationRecommendationAccounts(
            Consumer<ListOrganizationRecommendationAccountsRequest.Builder> listOrganizationRecommendationAccountsRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        return listOrganizationRecommendationAccounts(ListOrganizationRecommendationAccountsRequest.builder()
                .applyMutation(listOrganizationRecommendationAccountsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationRecommendationAccounts(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationAccountsIterable responses = client.listOrganizationRecommendationAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationAccountsIterable responses = client
     *             .listOrganizationRecommendationAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationAccountsIterable responses = client.listOrganizationRecommendationAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationRecommendationAccounts(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationRecommendationAccountsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ResourceNotFoundException
     *         Exception that the requested resource has not been found
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListOrganizationRecommendationAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendationAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationRecommendationAccountsIterable listOrganizationRecommendationAccountsPaginator(
            ListOrganizationRecommendationAccountsRequest listOrganizationRecommendationAccountsRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        return new ListOrganizationRecommendationAccountsIterable(this, listOrganizationRecommendationAccountsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationRecommendationAccounts(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationAccountsIterable responses = client.listOrganizationRecommendationAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationAccountsIterable responses = client
     *             .listOrganizationRecommendationAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationAccountsIterable responses = client.listOrganizationRecommendationAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationRecommendationAccounts(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListOrganizationRecommendationAccountsRequest.Builder} avoiding the need to create one manually via
     * {@link ListOrganizationRecommendationAccountsRequest#builder()}
     * </p>
     *
     * @param listOrganizationRecommendationAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ResourceNotFoundException
     *         Exception that the requested resource has not been found
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListOrganizationRecommendationAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendationAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationRecommendationAccountsIterable listOrganizationRecommendationAccountsPaginator(
            Consumer<ListOrganizationRecommendationAccountsRequest.Builder> listOrganizationRecommendationAccountsRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        return listOrganizationRecommendationAccountsPaginator(ListOrganizationRecommendationAccountsRequest.builder()
                .applyMutation(listOrganizationRecommendationAccountsRequest).build());
    }

    /**
     * <p>
     * List Resources of a Recommendation within an Organization. This API only supports prioritized recommendations.
     * </p>
     *
     * @param listOrganizationRecommendationResourcesRequest
     * @return Result of the ListOrganizationRecommendationResources operation returned by the service.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ResourceNotFoundException
     *         Exception that the requested resource has not been found
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListOrganizationRecommendationResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationRecommendationResourcesResponse listOrganizationRecommendationResources(
            ListOrganizationRecommendationResourcesRequest listOrganizationRecommendationResourcesRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List Resources of a Recommendation within an Organization. This API only supports prioritized recommendations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListOrganizationRecommendationResourcesRequest.Builder} avoiding the need to create one manually via
     * {@link ListOrganizationRecommendationResourcesRequest#builder()}
     * </p>
     *
     * @param listOrganizationRecommendationResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesRequest.Builder}
     *        to create a request.
     * @return Result of the ListOrganizationRecommendationResources operation returned by the service.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ResourceNotFoundException
     *         Exception that the requested resource has not been found
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListOrganizationRecommendationResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationRecommendationResourcesResponse listOrganizationRecommendationResources(
            Consumer<ListOrganizationRecommendationResourcesRequest.Builder> listOrganizationRecommendationResourcesRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        return listOrganizationRecommendationResources(ListOrganizationRecommendationResourcesRequest.builder()
                .applyMutation(listOrganizationRecommendationResourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationRecommendationResources(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationResourcesIterable responses = client.listOrganizationRecommendationResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationResourcesIterable responses = client
     *             .listOrganizationRecommendationResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationResourcesIterable responses = client.listOrganizationRecommendationResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationRecommendationResources(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationRecommendationResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ResourceNotFoundException
     *         Exception that the requested resource has not been found
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListOrganizationRecommendationResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationRecommendationResourcesIterable listOrganizationRecommendationResourcesPaginator(
            ListOrganizationRecommendationResourcesRequest listOrganizationRecommendationResourcesRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        return new ListOrganizationRecommendationResourcesIterable(this, listOrganizationRecommendationResourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationRecommendationResources(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationResourcesIterable responses = client.listOrganizationRecommendationResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationResourcesIterable responses = client
     *             .listOrganizationRecommendationResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationResourcesIterable responses = client.listOrganizationRecommendationResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationRecommendationResources(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListOrganizationRecommendationResourcesRequest.Builder} avoiding the need to create one manually via
     * {@link ListOrganizationRecommendationResourcesRequest#builder()}
     * </p>
     *
     * @param listOrganizationRecommendationResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ResourceNotFoundException
     *         Exception that the requested resource has not been found
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListOrganizationRecommendationResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationRecommendationResourcesIterable listOrganizationRecommendationResourcesPaginator(
            Consumer<ListOrganizationRecommendationResourcesRequest.Builder> listOrganizationRecommendationResourcesRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        return listOrganizationRecommendationResourcesPaginator(ListOrganizationRecommendationResourcesRequest.builder()
                .applyMutation(listOrganizationRecommendationResourcesRequest).build());
    }

    /**
     * <p>
     * List a filterable set of Recommendations within an Organization. This API only supports prioritized
     * recommendations.
     * </p>
     *
     * @param listOrganizationRecommendationsRequest
     * @return Result of the ListOrganizationRecommendations operation returned by the service.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListOrganizationRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationRecommendationsResponse listOrganizationRecommendations(
            ListOrganizationRecommendationsRequest listOrganizationRecommendationsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            TrustedAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List a filterable set of Recommendations within an Organization. This API only supports prioritized
     * recommendations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationRecommendationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationRecommendationsRequest#builder()}
     * </p>
     *
     * @param listOrganizationRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListOrganizationRecommendations operation returned by the service.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListOrganizationRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationRecommendationsResponse listOrganizationRecommendations(
            Consumer<ListOrganizationRecommendationsRequest.Builder> listOrganizationRecommendationsRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, TrustedAdvisorException {
        return listOrganizationRecommendations(ListOrganizationRecommendationsRequest.builder()
                .applyMutation(listOrganizationRecommendationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationRecommendations(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationsIterable responses = client.listOrganizationRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationsIterable responses = client
     *             .listOrganizationRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationsIterable responses = client.listOrganizationRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationRecommendations(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationRecommendationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListOrganizationRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationRecommendationsIterable listOrganizationRecommendationsPaginator(
            ListOrganizationRecommendationsRequest listOrganizationRecommendationsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            TrustedAdvisorException {
        return new ListOrganizationRecommendationsIterable(this, listOrganizationRecommendationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationRecommendations(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationsIterable responses = client.listOrganizationRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationsIterable responses = client
     *             .listOrganizationRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationsIterable responses = client.listOrganizationRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationRecommendations(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationRecommendationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationRecommendationsRequest#builder()}
     * </p>
     *
     * @param listOrganizationRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListOrganizationRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationRecommendationsIterable listOrganizationRecommendationsPaginator(
            Consumer<ListOrganizationRecommendationsRequest.Builder> listOrganizationRecommendationsRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, TrustedAdvisorException {
        return listOrganizationRecommendationsPaginator(ListOrganizationRecommendationsRequest.builder()
                .applyMutation(listOrganizationRecommendationsRequest).build());
    }

    /**
     * <p>
     * List Resources of a Recommendation
     * </p>
     *
     * @param listRecommendationResourcesRequest
     * @return Result of the ListRecommendationResources operation returned by the service.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ResourceNotFoundException
     *         Exception that the requested resource has not been found
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListRecommendationResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListRecommendationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationResourcesResponse listRecommendationResources(
            ListRecommendationResourcesRequest listRecommendationResourcesRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, TrustedAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List Resources of a Recommendation
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecommendationResourcesRequest#builder()}
     * </p>
     *
     * @param listRecommendationResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesRequest.Builder} to
     *        create a request.
     * @return Result of the ListRecommendationResources operation returned by the service.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ResourceNotFoundException
     *         Exception that the requested resource has not been found
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListRecommendationResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListRecommendationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationResourcesResponse listRecommendationResources(
            Consumer<ListRecommendationResourcesRequest.Builder> listRecommendationResourcesRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        return listRecommendationResources(ListRecommendationResourcesRequest.builder()
                .applyMutation(listRecommendationResourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecommendationResources(software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationResourcesIterable responses = client.listRecommendationResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationResourcesIterable responses = client
     *             .listRecommendationResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationResourcesIterable responses = client.listRecommendationResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendationResources(software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecommendationResourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ResourceNotFoundException
     *         Exception that the requested resource has not been found
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListRecommendationResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListRecommendationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationResourcesIterable listRecommendationResourcesPaginator(
            ListRecommendationResourcesRequest listRecommendationResourcesRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException,
            SdkClientException, TrustedAdvisorException {
        return new ListRecommendationResourcesIterable(this, listRecommendationResourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecommendationResources(software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationResourcesIterable responses = client.listRecommendationResourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationResourcesIterable responses = client
     *             .listRecommendationResourcesPaginator(request);
     *     for (software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationResourcesIterable responses = client.listRecommendationResourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendationResources(software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecommendationResourcesRequest#builder()}
     * </p>
     *
     * @param listRecommendationResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ResourceNotFoundException
     *         Exception that the requested resource has not been found
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListRecommendationResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListRecommendationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationResourcesIterable listRecommendationResourcesPaginator(
            Consumer<ListRecommendationResourcesRequest.Builder> listRecommendationResourcesRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        return listRecommendationResourcesPaginator(ListRecommendationResourcesRequest.builder()
                .applyMutation(listRecommendationResourcesRequest).build());
    }

    /**
     * <p>
     * List a filterable set of Recommendations
     * </p>
     *
     * @param listRecommendationsRequest
     * @return Result of the ListRecommendations operation returned by the service.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationsResponse listRecommendations(ListRecommendationsRequest listRecommendationsRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, TrustedAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List a filterable set of Recommendations
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendationsRequest#builder()}
     * </p>
     *
     * @param listRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsRequest.Builder} to create
     *        a request.
     * @return Result of the ListRecommendations operation returned by the service.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationsResponse listRecommendations(
            Consumer<ListRecommendationsRequest.Builder> listRecommendationsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            TrustedAdvisorException {
        return listRecommendations(ListRecommendationsRequest.builder().applyMutation(listRecommendationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecommendations(software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationsIterable responses = client.listRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationsIterable responses = client
     *             .listRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationsIterable responses = client.listRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendations(software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecommendationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationsIterable listRecommendationsPaginator(ListRecommendationsRequest listRecommendationsRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, TrustedAdvisorException {
        return new ListRecommendationsIterable(this, listRecommendationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecommendations(software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationsIterable responses = client.listRecommendationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationsIterable responses = client
     *             .listRecommendationsPaginator(request);
     *     for (software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationsIterable responses = client.listRecommendationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendations(software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendationsRequest#builder()}
     * </p>
     *
     * @param listRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationsIterable listRecommendationsPaginator(
            Consumer<ListRecommendationsRequest.Builder> listRecommendationsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            TrustedAdvisorException {
        return listRecommendationsPaginator(ListRecommendationsRequest.builder().applyMutation(listRecommendationsRequest)
                .build());
    }

    /**
     * <p>
     * Update the lifecyle of a Recommendation within an Organization. This API only supports prioritized
     * recommendations.
     * </p>
     *
     * @param updateOrganizationRecommendationLifecycleRequest
     * @return Result of the UpdateOrganizationRecommendationLifecycle operation returned by the service.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws ConflictException
     *         Exception that the request was denied due to conflictions in state
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ResourceNotFoundException
     *         Exception that the requested resource has not been found
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.UpdateOrganizationRecommendationLifecycle
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/UpdateOrganizationRecommendationLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOrganizationRecommendationLifecycleResponse updateOrganizationRecommendationLifecycle(
            UpdateOrganizationRecommendationLifecycleRequest updateOrganizationRecommendationLifecycleRequest)
            throws AccessDeniedException, ConflictException, InternalServerException, ValidationException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the lifecyle of a Recommendation within an Organization. This API only supports prioritized
     * recommendations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateOrganizationRecommendationLifecycleRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateOrganizationRecommendationLifecycleRequest#builder()}
     * </p>
     *
     * @param updateOrganizationRecommendationLifecycleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.UpdateOrganizationRecommendationLifecycleRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateOrganizationRecommendationLifecycle operation returned by the service.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws ConflictException
     *         Exception that the request was denied due to conflictions in state
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ResourceNotFoundException
     *         Exception that the requested resource has not been found
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.UpdateOrganizationRecommendationLifecycle
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/UpdateOrganizationRecommendationLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOrganizationRecommendationLifecycleResponse updateOrganizationRecommendationLifecycle(
            Consumer<UpdateOrganizationRecommendationLifecycleRequest.Builder> updateOrganizationRecommendationLifecycleRequest)
            throws AccessDeniedException, ConflictException, InternalServerException, ValidationException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        return updateOrganizationRecommendationLifecycle(UpdateOrganizationRecommendationLifecycleRequest.builder()
                .applyMutation(updateOrganizationRecommendationLifecycleRequest).build());
    }

    /**
     * <p>
     * Update the lifecyle of a Recommendation. This API only supports prioritized recommendations.
     * </p>
     *
     * @param updateRecommendationLifecycleRequest
     * @return Result of the UpdateRecommendationLifecycle operation returned by the service.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws ConflictException
     *         Exception that the request was denied due to conflictions in state
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ResourceNotFoundException
     *         Exception that the requested resource has not been found
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.UpdateRecommendationLifecycle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/UpdateRecommendationLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRecommendationLifecycleResponse updateRecommendationLifecycle(
            UpdateRecommendationLifecycleRequest updateRecommendationLifecycleRequest) throws AccessDeniedException,
            ConflictException, InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, TrustedAdvisorException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the lifecyle of a Recommendation. This API only supports prioritized recommendations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRecommendationLifecycleRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateRecommendationLifecycleRequest#builder()}
     * </p>
     *
     * @param updateRecommendationLifecycleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.UpdateRecommendationLifecycleRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateRecommendationLifecycle operation returned by the service.
     * @throws AccessDeniedException
     *         Exception that access has been denied due to insufficient access
     * @throws ConflictException
     *         Exception that the request was denied due to conflictions in state
     * @throws InternalServerException
     *         Exception to notify that an unexpected internal error occurred during processing of the request
     * @throws ValidationException
     *         Exception that the request failed to satisfy service constraints
     * @throws ResourceNotFoundException
     *         Exception that the requested resource has not been found
     * @throws ThrottlingException
     *         Exception to notify that requests are being throttled
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws TrustedAdvisorException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample TrustedAdvisorClient.UpdateRecommendationLifecycle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/UpdateRecommendationLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateRecommendationLifecycleResponse updateRecommendationLifecycle(
            Consumer<UpdateRecommendationLifecycleRequest.Builder> updateRecommendationLifecycleRequest)
            throws AccessDeniedException, ConflictException, InternalServerException, ValidationException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        return updateRecommendationLifecycle(UpdateRecommendationLifecycleRequest.builder()
                .applyMutation(updateRecommendationLifecycleRequest).build());
    }

    /**
     * Create a {@link TrustedAdvisorClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static TrustedAdvisorClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link TrustedAdvisorClient}.
     */
    static TrustedAdvisorClientBuilder builder() {
        return new DefaultTrustedAdvisorClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default TrustedAdvisorServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
