/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.trustedadvisor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListChecksRequest extends TrustedAdvisorRequest implements
        ToCopyableBuilder<ListChecksRequest.Builder, ListChecksRequest> {
    private static final SdkField<String> AWS_SERVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsService").getter(getter(ListChecksRequest::awsService)).setter(setter(Builder::awsService))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("awsService").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("language").getter(getter(ListChecksRequest::languageAsString)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("language").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListChecksRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListChecksRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> PILLAR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("pillar")
            .getter(getter(ListChecksRequest::pillarAsString)).setter(setter(Builder::pillar))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("pillar").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(ListChecksRequest::sourceAsString)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_SERVICE_FIELD,
            LANGUAGE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PILLAR_FIELD, SOURCE_FIELD));

    private final String awsService;

    private final String language;

    private final Integer maxResults;

    private final String nextToken;

    private final String pillar;

    private final String source;

    private ListChecksRequest(BuilderImpl builder) {
        super(builder);
        this.awsService = builder.awsService;
        this.language = builder.language;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.pillar = builder.pillar;
        this.source = builder.source;
    }

    /**
     * <p>
     * The aws service associated with the check
     * </p>
     * 
     * @return The aws service associated with the check
     */
    public final String awsService() {
        return awsService;
    }

    /**
     * <p>
     * The ISO 639-1 code for the language that you want your checks to appear in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #language} will
     * return {@link RecommendationLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #languageAsString}.
     * </p>
     * 
     * @return The ISO 639-1 code for the language that you want your checks to appear in.
     * @see RecommendationLanguage
     */
    public final RecommendationLanguage language() {
        return RecommendationLanguage.fromValue(language);
    }

    /**
     * <p>
     * The ISO 639-1 code for the language that you want your checks to appear in.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #language} will
     * return {@link RecommendationLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #languageAsString}.
     * </p>
     * 
     * @return The ISO 639-1 code for the language that you want your checks to appear in.
     * @see RecommendationLanguage
     */
    public final String languageAsString() {
        return language;
    }

    /**
     * <p>
     * The maximum number of results to return per page.
     * </p>
     * 
     * @return The maximum number of results to return per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results. Use the value returned in the previous response in the next request to
     * retrieve the next set of results.
     * </p>
     * 
     * @return The token for the next set of results. Use the value returned in the previous response in the next
     *         request to retrieve the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The pillar of the check
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pillar} will
     * return {@link RecommendationPillar#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #pillarAsString}.
     * </p>
     * 
     * @return The pillar of the check
     * @see RecommendationPillar
     */
    public final RecommendationPillar pillar() {
        return RecommendationPillar.fromValue(pillar);
    }

    /**
     * <p>
     * The pillar of the check
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pillar} will
     * return {@link RecommendationPillar#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #pillarAsString}.
     * </p>
     * 
     * @return The pillar of the check
     * @see RecommendationPillar
     */
    public final String pillarAsString() {
        return pillar;
    }

    /**
     * <p>
     * The source of the check
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link RecommendationSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceAsString}.
     * </p>
     * 
     * @return The source of the check
     * @see RecommendationSource
     */
    public final RecommendationSource source() {
        return RecommendationSource.fromValue(source);
    }

    /**
     * <p>
     * The source of the check
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link RecommendationSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceAsString}.
     * </p>
     * 
     * @return The source of the check
     * @see RecommendationSource
     */
    public final String sourceAsString() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsService());
        hashCode = 31 * hashCode + Objects.hashCode(languageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(pillarAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChecksRequest)) {
            return false;
        }
        ListChecksRequest other = (ListChecksRequest) obj;
        return Objects.equals(awsService(), other.awsService()) && Objects.equals(languageAsString(), other.languageAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(pillarAsString(), other.pillarAsString())
                && Objects.equals(sourceAsString(), other.sourceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListChecksRequest").add("AwsService", awsService()).add("Language", languageAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("Pillar", pillarAsString())
                .add("Source", sourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "awsService":
            return Optional.ofNullable(clazz.cast(awsService()));
        case "language":
            return Optional.ofNullable(clazz.cast(languageAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "pillar":
            return Optional.ofNullable(clazz.cast(pillarAsString()));
        case "source":
            return Optional.ofNullable(clazz.cast(sourceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChecksRequest, T> g) {
        return obj -> g.apply((ListChecksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TrustedAdvisorRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListChecksRequest> {
        /**
         * <p>
         * The aws service associated with the check
         * </p>
         * 
         * @param awsService
         *        The aws service associated with the check
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsService(String awsService);

        /**
         * <p>
         * The ISO 639-1 code for the language that you want your checks to appear in.
         * </p>
         * 
         * @param language
         *        The ISO 639-1 code for the language that you want your checks to appear in.
         * @see RecommendationLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationLanguage
         */
        Builder language(String language);

        /**
         * <p>
         * The ISO 639-1 code for the language that you want your checks to appear in.
         * </p>
         * 
         * @param language
         *        The ISO 639-1 code for the language that you want your checks to appear in.
         * @see RecommendationLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationLanguage
         */
        Builder language(RecommendationLanguage language);

        /**
         * <p>
         * The maximum number of results to return per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results. Use the value returned in the previous response in the next request to
         * retrieve the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. Use the value returned in the previous response in the next
         *        request to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The pillar of the check
         * </p>
         * 
         * @param pillar
         *        The pillar of the check
         * @see RecommendationPillar
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationPillar
         */
        Builder pillar(String pillar);

        /**
         * <p>
         * The pillar of the check
         * </p>
         * 
         * @param pillar
         *        The pillar of the check
         * @see RecommendationPillar
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationPillar
         */
        Builder pillar(RecommendationPillar pillar);

        /**
         * <p>
         * The source of the check
         * </p>
         * 
         * @param source
         *        The source of the check
         * @see RecommendationSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationSource
         */
        Builder source(String source);

        /**
         * <p>
         * The source of the check
         * </p>
         * 
         * @param source
         *        The source of the check
         * @see RecommendationSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationSource
         */
        Builder source(RecommendationSource source);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TrustedAdvisorRequest.BuilderImpl implements Builder {
        private String awsService;

        private String language;

        private Integer maxResults;

        private String nextToken;

        private String pillar;

        private String source;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChecksRequest model) {
            super(model);
            awsService(model.awsService);
            language(model.language);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            pillar(model.pillar);
            source(model.source);
        }

        public final String getAwsService() {
            return awsService;
        }

        public final void setAwsService(String awsService) {
            this.awsService = awsService;
        }

        @Override
        public final Builder awsService(String awsService) {
            this.awsService = awsService;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(RecommendationLanguage language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getPillar() {
            return pillar;
        }

        public final void setPillar(String pillar) {
            this.pillar = pillar;
        }

        @Override
        public final Builder pillar(String pillar) {
            this.pillar = pillar;
            return this;
        }

        @Override
        public final Builder pillar(RecommendationPillar pillar) {
            this.pillar(pillar == null ? null : pillar.toString());
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(RecommendationSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListChecksRequest build() {
            return new ListChecksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
