/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.trustedadvisor.TrustedAdvisorClient;
import software.amazon.awssdk.services.trustedadvisor.internal.UserAgentUtils;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesResponse;
import software.amazon.awssdk.services.trustedadvisor.model.OrganizationRecommendationResourceSummary;

public class ListOrganizationRecommendationResourcesIterable
implements SdkIterable<ListOrganizationRecommendationResourcesResponse> {
    private final TrustedAdvisorClient client;
    private final ListOrganizationRecommendationResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOrganizationRecommendationResourcesIterable(TrustedAdvisorClient client, ListOrganizationRecommendationResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOrganizationRecommendationResourcesResponseFetcher();
    }

    public Iterator<ListOrganizationRecommendationResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OrganizationRecommendationResourceSummary> organizationRecommendationResourceSummaries() {
        Function<ListOrganizationRecommendationResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.organizationRecommendationResourceSummaries() != null) {
                return response.organizationRecommendationResourceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOrganizationRecommendationResourcesResponseFetcher
    implements SyncPageFetcher<ListOrganizationRecommendationResourcesResponse> {
        private ListOrganizationRecommendationResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListOrganizationRecommendationResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOrganizationRecommendationResourcesResponse nextPage(ListOrganizationRecommendationResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListOrganizationRecommendationResourcesIterable.this.client.listOrganizationRecommendationResources(ListOrganizationRecommendationResourcesIterable.this.firstRequest);
            }
            return ListOrganizationRecommendationResourcesIterable.this.client.listOrganizationRecommendationResources((ListOrganizationRecommendationResourcesRequest)((Object)ListOrganizationRecommendationResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

