/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.trustedadvisor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of an AWS Trusted Advisor Check
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CheckSummary implements SdkPojo, Serializable, ToCopyableBuilder<CheckSummary.Builder, CheckSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CheckSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<List<String>> AWS_SERVICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("awsServices")
            .getter(getter(CheckSummary::awsServices))
            .setter(setter(Builder::awsServices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsServices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CheckSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CheckSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("metadata")
            .getter(getter(CheckSummary::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CheckSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> PILLARS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("pillars")
            .getter(getter(CheckSummary::pillarsAsStrings))
            .setter(setter(Builder::pillarsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pillars").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(CheckSummary::sourceAsString)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AWS_SERVICES_FIELD,
            DESCRIPTION_FIELD, ID_FIELD, METADATA_FIELD, NAME_FIELD, PILLARS_FIELD, SOURCE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final List<String> awsServices;

    private final String description;

    private final String id;

    private final Map<String, String> metadata;

    private final String name;

    private final List<String> pillars;

    private final String source;

    private CheckSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.awsServices = builder.awsServices;
        this.description = builder.description;
        this.id = builder.id;
        this.metadata = builder.metadata;
        this.name = builder.name;
        this.pillars = builder.pillars;
        this.source = builder.source;
    }

    /**
     * <p>
     * The ARN of the AWS Trusted Advisor Check
     * </p>
     * 
     * @return The ARN of the AWS Trusted Advisor Check
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AwsServices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAwsServices() {
        return awsServices != null && !(awsServices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS Services that the Check applies to
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAwsServices} method.
     * </p>
     * 
     * @return The AWS Services that the Check applies to
     */
    public final List<String> awsServices() {
        return awsServices;
    }

    /**
     * <p>
     * A description of what the AWS Trusted Advisor Check is monitoring
     * </p>
     * 
     * @return A description of what the AWS Trusted Advisor Check is monitoring
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the AWS Trusted Advisor Check
     * </p>
     * 
     * @return The unique identifier of the AWS Trusted Advisor Check
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metadata property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetadata() {
        return metadata != null && !(metadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The column headings for the metadata returned in the resource
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadata} method.
     * </p>
     * 
     * @return The column headings for the metadata returned in the resource
     */
    public final Map<String, String> metadata() {
        return metadata;
    }

    /**
     * <p>
     * The name of the AWS Trusted Advisor Check
     * </p>
     * 
     * @return The name of the AWS Trusted Advisor Check
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Recommendation pillars that the AWS Trusted Advisor Check falls under
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPillars} method.
     * </p>
     * 
     * @return The Recommendation pillars that the AWS Trusted Advisor Check falls under
     */
    public final List<RecommendationPillar> pillars() {
        return RecommendationPillarListCopier.copyStringToEnum(pillars);
    }

    /**
     * For responses, this returns true if the service returned a value for the Pillars property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPillars() {
        return pillars != null && !(pillars instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Recommendation pillars that the AWS Trusted Advisor Check falls under
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPillars} method.
     * </p>
     * 
     * @return The Recommendation pillars that the AWS Trusted Advisor Check falls under
     */
    public final List<String> pillarsAsStrings() {
        return pillars;
    }

    /**
     * <p>
     * The source of the Recommendation
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link RecommendationSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceAsString}.
     * </p>
     * 
     * @return The source of the Recommendation
     * @see RecommendationSource
     */
    public final RecommendationSource source() {
        return RecommendationSource.fromValue(source);
    }

    /**
     * <p>
     * The source of the Recommendation
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link RecommendationSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceAsString}.
     * </p>
     * 
     * @return The source of the Recommendation
     * @see RecommendationSource
     */
    public final String sourceAsString() {
        return source;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAwsServices() ? awsServices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadata() ? metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasPillars() ? pillarsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckSummary)) {
            return false;
        }
        CheckSummary other = (CheckSummary) obj;
        return Objects.equals(arn(), other.arn()) && hasAwsServices() == other.hasAwsServices()
                && Objects.equals(awsServices(), other.awsServices()) && Objects.equals(description(), other.description())
                && Objects.equals(id(), other.id()) && hasMetadata() == other.hasMetadata()
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(name(), other.name())
                && hasPillars() == other.hasPillars() && Objects.equals(pillarsAsStrings(), other.pillarsAsStrings())
                && Objects.equals(sourceAsString(), other.sourceAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CheckSummary").add("Arn", arn()).add("AwsServices", hasAwsServices() ? awsServices() : null)
                .add("Description", description()).add("Id", id()).add("Metadata", hasMetadata() ? metadata() : null)
                .add("Name", name()).add("Pillars", hasPillars() ? pillarsAsStrings() : null).add("Source", sourceAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "awsServices":
            return Optional.ofNullable(clazz.cast(awsServices()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "pillars":
            return Optional.ofNullable(clazz.cast(pillarsAsStrings()));
        case "source":
            return Optional.ofNullable(clazz.cast(sourceAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CheckSummary, T> g) {
        return obj -> g.apply((CheckSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CheckSummary> {
        /**
         * <p>
         * The ARN of the AWS Trusted Advisor Check
         * </p>
         * 
         * @param arn
         *        The ARN of the AWS Trusted Advisor Check
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The AWS Services that the Check applies to
         * </p>
         * 
         * @param awsServices
         *        The AWS Services that the Check applies to
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsServices(Collection<String> awsServices);

        /**
         * <p>
         * The AWS Services that the Check applies to
         * </p>
         * 
         * @param awsServices
         *        The AWS Services that the Check applies to
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsServices(String... awsServices);

        /**
         * <p>
         * A description of what the AWS Trusted Advisor Check is monitoring
         * </p>
         * 
         * @param description
         *        A description of what the AWS Trusted Advisor Check is monitoring
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the AWS Trusted Advisor Check
         * </p>
         * 
         * @param id
         *        The unique identifier of the AWS Trusted Advisor Check
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The column headings for the metadata returned in the resource
         * </p>
         * 
         * @param metadata
         *        The column headings for the metadata returned in the resource
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Map<String, String> metadata);

        /**
         * <p>
         * The name of the AWS Trusted Advisor Check
         * </p>
         * 
         * @param name
         *        The name of the AWS Trusted Advisor Check
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Recommendation pillars that the AWS Trusted Advisor Check falls under
         * </p>
         * 
         * @param pillars
         *        The Recommendation pillars that the AWS Trusted Advisor Check falls under
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarsWithStrings(Collection<String> pillars);

        /**
         * <p>
         * The Recommendation pillars that the AWS Trusted Advisor Check falls under
         * </p>
         * 
         * @param pillars
         *        The Recommendation pillars that the AWS Trusted Advisor Check falls under
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarsWithStrings(String... pillars);

        /**
         * <p>
         * The Recommendation pillars that the AWS Trusted Advisor Check falls under
         * </p>
         * 
         * @param pillars
         *        The Recommendation pillars that the AWS Trusted Advisor Check falls under
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillars(Collection<RecommendationPillar> pillars);

        /**
         * <p>
         * The Recommendation pillars that the AWS Trusted Advisor Check falls under
         * </p>
         * 
         * @param pillars
         *        The Recommendation pillars that the AWS Trusted Advisor Check falls under
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillars(RecommendationPillar... pillars);

        /**
         * <p>
         * The source of the Recommendation
         * </p>
         * 
         * @param source
         *        The source of the Recommendation
         * @see RecommendationSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationSource
         */
        Builder source(String source);

        /**
         * <p>
         * The source of the Recommendation
         * </p>
         * 
         * @param source
         *        The source of the Recommendation
         * @see RecommendationSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationSource
         */
        Builder source(RecommendationSource source);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private List<String> awsServices = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private String id;

        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();

        private String name;

        private List<String> pillars = DefaultSdkAutoConstructList.getInstance();

        private String source;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckSummary model) {
            arn(model.arn);
            awsServices(model.awsServices);
            description(model.description);
            id(model.id);
            metadata(model.metadata);
            name(model.name);
            pillarsWithStrings(model.pillars);
            source(model.source);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getAwsServices() {
            if (awsServices instanceof SdkAutoConstructList) {
                return null;
            }
            return awsServices;
        }

        public final void setAwsServices(Collection<String> awsServices) {
            this.awsServices = RecommendationAwsServiceListCopier.copy(awsServices);
        }

        @Override
        public final Builder awsServices(Collection<String> awsServices) {
            this.awsServices = RecommendationAwsServiceListCopier.copy(awsServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsServices(String... awsServices) {
            awsServices(Arrays.asList(awsServices));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = StringMapCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = StringMapCopier.copy(metadata);
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getPillars() {
            if (pillars instanceof SdkAutoConstructList) {
                return null;
            }
            return pillars;
        }

        public final void setPillars(Collection<String> pillars) {
            this.pillars = RecommendationPillarListCopier.copy(pillars);
        }

        @Override
        public final Builder pillarsWithStrings(Collection<String> pillars) {
            this.pillars = RecommendationPillarListCopier.copy(pillars);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillarsWithStrings(String... pillars) {
            pillarsWithStrings(Arrays.asList(pillars));
            return this;
        }

        @Override
        public final Builder pillars(Collection<RecommendationPillar> pillars) {
            this.pillars = RecommendationPillarListCopier.copyEnumToString(pillars);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillars(RecommendationPillar... pillars) {
            pillars(Arrays.asList(pillars));
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(RecommendationSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        @Override
        public CheckSummary build() {
            return new CheckSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
