/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.trustedadvisor;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.trustedadvisor.model.BatchUpdateRecommendationResourceExclusionRequest;
import software.amazon.awssdk.services.trustedadvisor.model.BatchUpdateRecommendationResourceExclusionResponse;
import software.amazon.awssdk.services.trustedadvisor.model.GetOrganizationRecommendationRequest;
import software.amazon.awssdk.services.trustedadvisor.model.GetOrganizationRecommendationResponse;
import software.amazon.awssdk.services.trustedadvisor.model.GetRecommendationRequest;
import software.amazon.awssdk.services.trustedadvisor.model.GetRecommendationResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ListChecksRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListChecksResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsResponse;
import software.amazon.awssdk.services.trustedadvisor.model.UpdateOrganizationRecommendationLifecycleRequest;
import software.amazon.awssdk.services.trustedadvisor.model.UpdateOrganizationRecommendationLifecycleResponse;
import software.amazon.awssdk.services.trustedadvisor.model.UpdateRecommendationLifecycleRequest;
import software.amazon.awssdk.services.trustedadvisor.model.UpdateRecommendationLifecycleResponse;
import software.amazon.awssdk.services.trustedadvisor.paginators.ListChecksPublisher;
import software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationAccountsPublisher;
import software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationResourcesPublisher;
import software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationsPublisher;
import software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationResourcesPublisher;
import software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationsPublisher;

/**
 * Service client for accessing TrustedAdvisor Public API asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * TrustedAdvisor Public API
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface TrustedAdvisorAsyncClient extends AwsClient {
    String SERVICE_NAME = "trustedadvisor";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "trustedadvisor";

    /**
     * <p>
     * Update one or more exclusion status for a list of recommendation resources
     * </p>
     *
     * @param batchUpdateRecommendationResourceExclusionRequest
     * @return A Java Future containing the result of the BatchUpdateRecommendationResourceExclusion operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>ConflictException Exception that the request was denied due to conflictions in state</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.BatchUpdateRecommendationResourceExclusion
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/BatchUpdateRecommendationResourceExclusion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateRecommendationResourceExclusionResponse> batchUpdateRecommendationResourceExclusion(
            BatchUpdateRecommendationResourceExclusionRequest batchUpdateRecommendationResourceExclusionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update one or more exclusion status for a list of recommendation resources
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchUpdateRecommendationResourceExclusionRequest.Builder} avoiding the need to create one manually via
     * {@link BatchUpdateRecommendationResourceExclusionRequest#builder()}
     * </p>
     *
     * @param batchUpdateRecommendationResourceExclusionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.BatchUpdateRecommendationResourceExclusionRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchUpdateRecommendationResourceExclusion operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>ConflictException Exception that the request was denied due to conflictions in state</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.BatchUpdateRecommendationResourceExclusion
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/BatchUpdateRecommendationResourceExclusion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchUpdateRecommendationResourceExclusionResponse> batchUpdateRecommendationResourceExclusion(
            Consumer<BatchUpdateRecommendationResourceExclusionRequest.Builder> batchUpdateRecommendationResourceExclusionRequest) {
        return batchUpdateRecommendationResourceExclusion(BatchUpdateRecommendationResourceExclusionRequest.builder()
                .applyMutation(batchUpdateRecommendationResourceExclusionRequest).build());
    }

    /**
     * <p>
     * Get a specific recommendation within an AWS Organizations organization. This API supports only prioritized
     * recommendations.
     * </p>
     *
     * @param getOrganizationRecommendationRequest
     * @return A Java Future containing the result of the GetOrganizationRecommendation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ResourceNotFoundException Exception that the requested resource has not been found</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.GetOrganizationRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/GetOrganizationRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOrganizationRecommendationResponse> getOrganizationRecommendation(
            GetOrganizationRecommendationRequest getOrganizationRecommendationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a specific recommendation within an AWS Organizations organization. This API supports only prioritized
     * recommendations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOrganizationRecommendationRequest.Builder}
     * avoiding the need to create one manually via {@link GetOrganizationRecommendationRequest#builder()}
     * </p>
     *
     * @param getOrganizationRecommendationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.GetOrganizationRecommendationRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetOrganizationRecommendation operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ResourceNotFoundException Exception that the requested resource has not been found</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.GetOrganizationRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/GetOrganizationRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetOrganizationRecommendationResponse> getOrganizationRecommendation(
            Consumer<GetOrganizationRecommendationRequest.Builder> getOrganizationRecommendationRequest) {
        return getOrganizationRecommendation(GetOrganizationRecommendationRequest.builder()
                .applyMutation(getOrganizationRecommendationRequest).build());
    }

    /**
     * <p>
     * Get a specific Recommendation
     * </p>
     *
     * @param getRecommendationRequest
     * @return A Java Future containing the result of the GetRecommendation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ResourceNotFoundException Exception that the requested resource has not been found</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.GetRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/GetRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecommendationResponse> getRecommendation(GetRecommendationRequest getRecommendationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a specific Recommendation
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRecommendationRequest.Builder} avoiding the need
     * to create one manually via {@link GetRecommendationRequest#builder()}
     * </p>
     *
     * @param getRecommendationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.GetRecommendationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetRecommendation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ResourceNotFoundException Exception that the requested resource has not been found</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.GetRecommendation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/GetRecommendation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRecommendationResponse> getRecommendation(
            Consumer<GetRecommendationRequest.Builder> getRecommendationRequest) {
        return getRecommendation(GetRecommendationRequest.builder().applyMutation(getRecommendationRequest).build());
    }

    /**
     * <p>
     * List a filterable set of Checks
     * </p>
     *
     * @param listChecksRequest
     * @return A Java Future containing the result of the ListChecks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListChecks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListChecksResponse> listChecks(ListChecksRequest listChecksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List a filterable set of Checks
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChecksRequest.Builder} avoiding the need to
     * create one manually via {@link ListChecksRequest#builder()}
     * </p>
     *
     * @param listChecksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListChecksRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListChecks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListChecks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListChecksResponse> listChecks(Consumer<ListChecksRequest.Builder> listChecksRequest) {
        return listChecks(ListChecksRequest.builder().applyMutation(listChecksRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listChecks(software.amazon.awssdk.services.trustedadvisor.model.ListChecksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListChecksPublisher publisher = client.listChecksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListChecksPublisher publisher = client.listChecksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.trustedadvisor.model.ListChecksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.trustedadvisor.model.ListChecksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChecks(software.amazon.awssdk.services.trustedadvisor.model.ListChecksRequest)} operation.</b>
     * </p>
     *
     * @param listChecksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListChecks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChecksPublisher listChecksPaginator(ListChecksRequest listChecksRequest) {
        return new ListChecksPublisher(this, listChecksRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listChecks(software.amazon.awssdk.services.trustedadvisor.model.ListChecksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListChecksPublisher publisher = client.listChecksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListChecksPublisher publisher = client.listChecksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.trustedadvisor.model.ListChecksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.trustedadvisor.model.ListChecksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listChecks(software.amazon.awssdk.services.trustedadvisor.model.ListChecksRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListChecksRequest.Builder} avoiding the need to
     * create one manually via {@link ListChecksRequest#builder()}
     * </p>
     *
     * @param listChecksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListChecksRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListChecks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListChecks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListChecksPublisher listChecksPaginator(Consumer<ListChecksRequest.Builder> listChecksRequest) {
        return listChecksPaginator(ListChecksRequest.builder().applyMutation(listChecksRequest).build());
    }

    /**
     * <p>
     * Lists the accounts that own the resources for an organization aggregate recommendation. This API only supports
     * prioritized recommendations.
     * </p>
     *
     * @param listOrganizationRecommendationAccountsRequest
     * @return A Java Future containing the result of the ListOrganizationRecommendationAccounts operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ResourceNotFoundException Exception that the requested resource has not been found</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListOrganizationRecommendationAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendationAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOrganizationRecommendationAccountsResponse> listOrganizationRecommendationAccounts(
            ListOrganizationRecommendationAccountsRequest listOrganizationRecommendationAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the accounts that own the resources for an organization aggregate recommendation. This API only supports
     * prioritized recommendations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListOrganizationRecommendationAccountsRequest.Builder} avoiding the need to create one manually via
     * {@link ListOrganizationRecommendationAccountsRequest#builder()}
     * </p>
     *
     * @param listOrganizationRecommendationAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListOrganizationRecommendationAccounts operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ResourceNotFoundException Exception that the requested resource has not been found</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListOrganizationRecommendationAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendationAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOrganizationRecommendationAccountsResponse> listOrganizationRecommendationAccounts(
            Consumer<ListOrganizationRecommendationAccountsRequest.Builder> listOrganizationRecommendationAccountsRequest) {
        return listOrganizationRecommendationAccounts(ListOrganizationRecommendationAccountsRequest.builder()
                .applyMutation(listOrganizationRecommendationAccountsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationRecommendationAccounts(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationAccountsPublisher publisher = client.listOrganizationRecommendationAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationAccountsPublisher publisher = client.listOrganizationRecommendationAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationRecommendationAccounts(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationRecommendationAccountsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ResourceNotFoundException Exception that the requested resource has not been found</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListOrganizationRecommendationAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendationAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationRecommendationAccountsPublisher listOrganizationRecommendationAccountsPaginator(
            ListOrganizationRecommendationAccountsRequest listOrganizationRecommendationAccountsRequest) {
        return new ListOrganizationRecommendationAccountsPublisher(this, listOrganizationRecommendationAccountsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationRecommendationAccounts(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationAccountsPublisher publisher = client.listOrganizationRecommendationAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationAccountsPublisher publisher = client.listOrganizationRecommendationAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationRecommendationAccounts(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListOrganizationRecommendationAccountsRequest.Builder} avoiding the need to create one manually via
     * {@link ListOrganizationRecommendationAccountsRequest#builder()}
     * </p>
     *
     * @param listOrganizationRecommendationAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ResourceNotFoundException Exception that the requested resource has not been found</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListOrganizationRecommendationAccounts
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendationAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationRecommendationAccountsPublisher listOrganizationRecommendationAccountsPaginator(
            Consumer<ListOrganizationRecommendationAccountsRequest.Builder> listOrganizationRecommendationAccountsRequest) {
        return listOrganizationRecommendationAccountsPaginator(ListOrganizationRecommendationAccountsRequest.builder()
                .applyMutation(listOrganizationRecommendationAccountsRequest).build());
    }

    /**
     * <p>
     * List Resources of a Recommendation within an Organization. This API only supports prioritized recommendations.
     * </p>
     *
     * @param listOrganizationRecommendationResourcesRequest
     * @return A Java Future containing the result of the ListOrganizationRecommendationResources operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ResourceNotFoundException Exception that the requested resource has not been found</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListOrganizationRecommendationResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOrganizationRecommendationResourcesResponse> listOrganizationRecommendationResources(
            ListOrganizationRecommendationResourcesRequest listOrganizationRecommendationResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List Resources of a Recommendation within an Organization. This API only supports prioritized recommendations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListOrganizationRecommendationResourcesRequest.Builder} avoiding the need to create one manually via
     * {@link ListOrganizationRecommendationResourcesRequest#builder()}
     * </p>
     *
     * @param listOrganizationRecommendationResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListOrganizationRecommendationResources operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ResourceNotFoundException Exception that the requested resource has not been found</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListOrganizationRecommendationResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOrganizationRecommendationResourcesResponse> listOrganizationRecommendationResources(
            Consumer<ListOrganizationRecommendationResourcesRequest.Builder> listOrganizationRecommendationResourcesRequest) {
        return listOrganizationRecommendationResources(ListOrganizationRecommendationResourcesRequest.builder()
                .applyMutation(listOrganizationRecommendationResourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationRecommendationResources(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationResourcesPublisher publisher = client.listOrganizationRecommendationResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationResourcesPublisher publisher = client.listOrganizationRecommendationResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationRecommendationResources(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationRecommendationResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ResourceNotFoundException Exception that the requested resource has not been found</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListOrganizationRecommendationResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationRecommendationResourcesPublisher listOrganizationRecommendationResourcesPaginator(
            ListOrganizationRecommendationResourcesRequest listOrganizationRecommendationResourcesRequest) {
        return new ListOrganizationRecommendationResourcesPublisher(this, listOrganizationRecommendationResourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationRecommendationResources(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationResourcesPublisher publisher = client.listOrganizationRecommendationResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationResourcesPublisher publisher = client.listOrganizationRecommendationResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationRecommendationResources(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListOrganizationRecommendationResourcesRequest.Builder} avoiding the need to create one manually via
     * {@link ListOrganizationRecommendationResourcesRequest#builder()}
     * </p>
     *
     * @param listOrganizationRecommendationResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ResourceNotFoundException Exception that the requested resource has not been found</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListOrganizationRecommendationResources
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationRecommendationResourcesPublisher listOrganizationRecommendationResourcesPaginator(
            Consumer<ListOrganizationRecommendationResourcesRequest.Builder> listOrganizationRecommendationResourcesRequest) {
        return listOrganizationRecommendationResourcesPaginator(ListOrganizationRecommendationResourcesRequest.builder()
                .applyMutation(listOrganizationRecommendationResourcesRequest).build());
    }

    /**
     * <p>
     * List a filterable set of Recommendations within an Organization. This API only supports prioritized
     * recommendations.
     * </p>
     *
     * @param listOrganizationRecommendationsRequest
     * @return A Java Future containing the result of the ListOrganizationRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListOrganizationRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOrganizationRecommendationsResponse> listOrganizationRecommendations(
            ListOrganizationRecommendationsRequest listOrganizationRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List a filterable set of Recommendations within an Organization. This API only supports prioritized
     * recommendations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationRecommendationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationRecommendationsRequest#builder()}
     * </p>
     *
     * @param listOrganizationRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListOrganizationRecommendations operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListOrganizationRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOrganizationRecommendationsResponse> listOrganizationRecommendations(
            Consumer<ListOrganizationRecommendationsRequest.Builder> listOrganizationRecommendationsRequest) {
        return listOrganizationRecommendations(ListOrganizationRecommendationsRequest.builder()
                .applyMutation(listOrganizationRecommendationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationRecommendations(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationsPublisher publisher = client.listOrganizationRecommendationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationsPublisher publisher = client.listOrganizationRecommendationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationRecommendations(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationRecommendationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListOrganizationRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationRecommendationsPublisher listOrganizationRecommendationsPaginator(
            ListOrganizationRecommendationsRequest listOrganizationRecommendationsRequest) {
        return new ListOrganizationRecommendationsPublisher(this, listOrganizationRecommendationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationRecommendations(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationsPublisher publisher = client.listOrganizationRecommendationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListOrganizationRecommendationsPublisher publisher = client.listOrganizationRecommendationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationRecommendations(software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationRecommendationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationRecommendationsRequest#builder()}
     * </p>
     *
     * @param listOrganizationRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListOrganizationRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListOrganizationRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationRecommendationsPublisher listOrganizationRecommendationsPaginator(
            Consumer<ListOrganizationRecommendationsRequest.Builder> listOrganizationRecommendationsRequest) {
        return listOrganizationRecommendationsPaginator(ListOrganizationRecommendationsRequest.builder()
                .applyMutation(listOrganizationRecommendationsRequest).build());
    }

    /**
     * <p>
     * List Resources of a Recommendation
     * </p>
     *
     * @param listRecommendationResourcesRequest
     * @return A Java Future containing the result of the ListRecommendationResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ResourceNotFoundException Exception that the requested resource has not been found</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListRecommendationResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListRecommendationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecommendationResourcesResponse> listRecommendationResources(
            ListRecommendationResourcesRequest listRecommendationResourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List Resources of a Recommendation
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecommendationResourcesRequest#builder()}
     * </p>
     *
     * @param listRecommendationResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListRecommendationResources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ResourceNotFoundException Exception that the requested resource has not been found</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListRecommendationResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListRecommendationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecommendationResourcesResponse> listRecommendationResources(
            Consumer<ListRecommendationResourcesRequest.Builder> listRecommendationResourcesRequest) {
        return listRecommendationResources(ListRecommendationResourcesRequest.builder()
                .applyMutation(listRecommendationResourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecommendationResources(software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationResourcesPublisher publisher = client.listRecommendationResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationResourcesPublisher publisher = client.listRecommendationResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendationResources(software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecommendationResourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ResourceNotFoundException Exception that the requested resource has not been found</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListRecommendationResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListRecommendationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationResourcesPublisher listRecommendationResourcesPaginator(
            ListRecommendationResourcesRequest listRecommendationResourcesRequest) {
        return new ListRecommendationResourcesPublisher(this, listRecommendationResourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecommendationResources(software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationResourcesPublisher publisher = client.listRecommendationResourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationResourcesPublisher publisher = client.listRecommendationResourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendationResources(software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationResourcesRequest.Builder}
     * avoiding the need to create one manually via {@link ListRecommendationResourcesRequest#builder()}
     * </p>
     *
     * @param listRecommendationResourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ResourceNotFoundException Exception that the requested resource has not been found</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListRecommendationResources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListRecommendationResources"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationResourcesPublisher listRecommendationResourcesPaginator(
            Consumer<ListRecommendationResourcesRequest.Builder> listRecommendationResourcesRequest) {
        return listRecommendationResourcesPaginator(ListRecommendationResourcesRequest.builder()
                .applyMutation(listRecommendationResourcesRequest).build());
    }

    /**
     * <p>
     * List a filterable set of Recommendations
     * </p>
     *
     * @param listRecommendationsRequest
     * @return A Java Future containing the result of the ListRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecommendationsResponse> listRecommendations(
            ListRecommendationsRequest listRecommendationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List a filterable set of Recommendations
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendationsRequest#builder()}
     * </p>
     *
     * @param listRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListRecommendations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRecommendationsResponse> listRecommendations(
            Consumer<ListRecommendationsRequest.Builder> listRecommendationsRequest) {
        return listRecommendations(ListRecommendationsRequest.builder().applyMutation(listRecommendationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecommendations(software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationsPublisher publisher = client.listRecommendationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationsPublisher publisher = client.listRecommendationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendations(software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecommendationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationsPublisher listRecommendationsPaginator(ListRecommendationsRequest listRecommendationsRequest) {
        return new ListRecommendationsPublisher(this, listRecommendationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecommendations(software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationsPublisher publisher = client.listRecommendationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.trustedadvisor.paginators.ListRecommendationsPublisher publisher = client.listRecommendationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendations(software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendationsRequest#builder()}
     * </p>
     *
     * @param listRecommendationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.ListRecommendations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/ListRecommendations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendationsPublisher listRecommendationsPaginator(
            Consumer<ListRecommendationsRequest.Builder> listRecommendationsRequest) {
        return listRecommendationsPaginator(ListRecommendationsRequest.builder().applyMutation(listRecommendationsRequest)
                .build());
    }

    /**
     * <p>
     * Update the lifecycle of a Recommendation within an Organization. This API only supports prioritized
     * recommendations.
     * </p>
     *
     * @param updateOrganizationRecommendationLifecycleRequest
     * @return A Java Future containing the result of the UpdateOrganizationRecommendationLifecycle operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>ConflictException Exception that the request was denied due to conflictions in state</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ResourceNotFoundException Exception that the requested resource has not been found</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.UpdateOrganizationRecommendationLifecycle
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/UpdateOrganizationRecommendationLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOrganizationRecommendationLifecycleResponse> updateOrganizationRecommendationLifecycle(
            UpdateOrganizationRecommendationLifecycleRequest updateOrganizationRecommendationLifecycleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the lifecycle of a Recommendation within an Organization. This API only supports prioritized
     * recommendations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateOrganizationRecommendationLifecycleRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateOrganizationRecommendationLifecycleRequest#builder()}
     * </p>
     *
     * @param updateOrganizationRecommendationLifecycleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.UpdateOrganizationRecommendationLifecycleRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateOrganizationRecommendationLifecycle operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>ConflictException Exception that the request was denied due to conflictions in state</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ResourceNotFoundException Exception that the requested resource has not been found</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.UpdateOrganizationRecommendationLifecycle
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/UpdateOrganizationRecommendationLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateOrganizationRecommendationLifecycleResponse> updateOrganizationRecommendationLifecycle(
            Consumer<UpdateOrganizationRecommendationLifecycleRequest.Builder> updateOrganizationRecommendationLifecycleRequest) {
        return updateOrganizationRecommendationLifecycle(UpdateOrganizationRecommendationLifecycleRequest.builder()
                .applyMutation(updateOrganizationRecommendationLifecycleRequest).build());
    }

    /**
     * <p>
     * Update the lifecyle of a Recommendation. This API only supports prioritized recommendations.
     * </p>
     *
     * @param updateRecommendationLifecycleRequest
     * @return A Java Future containing the result of the UpdateRecommendationLifecycle operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>ConflictException Exception that the request was denied due to conflictions in state</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ResourceNotFoundException Exception that the requested resource has not been found</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.UpdateRecommendationLifecycle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/UpdateRecommendationLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRecommendationLifecycleResponse> updateRecommendationLifecycle(
            UpdateRecommendationLifecycleRequest updateRecommendationLifecycleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the lifecyle of a Recommendation. This API only supports prioritized recommendations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRecommendationLifecycleRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateRecommendationLifecycleRequest#builder()}
     * </p>
     *
     * @param updateRecommendationLifecycleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.trustedadvisor.model.UpdateRecommendationLifecycleRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateRecommendationLifecycle operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException Exception that access has been denied due to insufficient access</li>
     *         <li>ConflictException Exception that the request was denied due to conflictions in state</li>
     *         <li>InternalServerException Exception to notify that an unexpected internal error occurred during
     *         processing of the request</li>
     *         <li>ValidationException Exception that the request failed to satisfy service constraints</li>
     *         <li>ResourceNotFoundException Exception that the requested resource has not been found</li>
     *         <li>ThrottlingException Exception to notify that requests are being throttled</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>TrustedAdvisorException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample TrustedAdvisorAsyncClient.UpdateRecommendationLifecycle
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/trustedadvisor-2022-09-15/UpdateRecommendationLifecycle"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateRecommendationLifecycleResponse> updateRecommendationLifecycle(
            Consumer<UpdateRecommendationLifecycleRequest.Builder> updateRecommendationLifecycleRequest) {
        return updateRecommendationLifecycle(UpdateRecommendationLifecycleRequest.builder()
                .applyMutation(updateRecommendationLifecycleRequest).build());
    }

    @Override
    default TrustedAdvisorServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link TrustedAdvisorAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static TrustedAdvisorAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link TrustedAdvisorAsyncClient}.
     */
    static TrustedAdvisorAsyncClientBuilder builder() {
        return new DefaultTrustedAdvisorAsyncClientBuilder();
    }
}
