/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.trustedadvisor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateRecommendationResourceExclusionResponse extends TrustedAdvisorResponse
        implements
        ToCopyableBuilder<BatchUpdateRecommendationResourceExclusionResponse.Builder, BatchUpdateRecommendationResourceExclusionResponse> {
    private static final SdkField<List<UpdateRecommendationResourceExclusionError>> BATCH_UPDATE_RECOMMENDATION_RESOURCE_EXCLUSION_ERRORS_FIELD = SdkField
            .<List<UpdateRecommendationResourceExclusionError>> builder(MarshallingType.LIST)
            .memberName("batchUpdateRecommendationResourceExclusionErrors")
            .getter(getter(BatchUpdateRecommendationResourceExclusionResponse::batchUpdateRecommendationResourceExclusionErrors))
            .setter(setter(Builder::batchUpdateRecommendationResourceExclusionErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("batchUpdateRecommendationResourceExclusionErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UpdateRecommendationResourceExclusionError> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateRecommendationResourceExclusionError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(BATCH_UPDATE_RECOMMENDATION_RESOURCE_EXCLUSION_ERRORS_FIELD));

    private final List<UpdateRecommendationResourceExclusionError> batchUpdateRecommendationResourceExclusionErrors;

    private BatchUpdateRecommendationResourceExclusionResponse(BuilderImpl builder) {
        super(builder);
        this.batchUpdateRecommendationResourceExclusionErrors = builder.batchUpdateRecommendationResourceExclusionErrors;
    }

    /**
     * For responses, this returns true if the service returned a value for the
     * BatchUpdateRecommendationResourceExclusionErrors property. This DOES NOT check that the value is non-empty (for
     * which, you should check the {@code isEmpty()} method on the property). This is useful because the SDK will never
     * return a null collection or map, but you may need to differentiate between the service returning nothing (or
     * null) and the service returning an empty collection or map. For requests, this returns true if a value for the
     * property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasBatchUpdateRecommendationResourceExclusionErrors() {
        return batchUpdateRecommendationResourceExclusionErrors != null
                && !(batchUpdateRecommendationResourceExclusionErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of recommendation resource ARNs whose exclusion status failed to update, if any
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the
     * {@link #hasBatchUpdateRecommendationResourceExclusionErrors} method.
     * </p>
     * 
     * @return A list of recommendation resource ARNs whose exclusion status failed to update, if any
     */
    public final List<UpdateRecommendationResourceExclusionError> batchUpdateRecommendationResourceExclusionErrors() {
        return batchUpdateRecommendationResourceExclusionErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31
                * hashCode
                + Objects
                        .hashCode(hasBatchUpdateRecommendationResourceExclusionErrors() ? batchUpdateRecommendationResourceExclusionErrors()
                                : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateRecommendationResourceExclusionResponse)) {
            return false;
        }
        BatchUpdateRecommendationResourceExclusionResponse other = (BatchUpdateRecommendationResourceExclusionResponse) obj;
        return hasBatchUpdateRecommendationResourceExclusionErrors() == other
                .hasBatchUpdateRecommendationResourceExclusionErrors()
                && Objects.equals(batchUpdateRecommendationResourceExclusionErrors(),
                        other.batchUpdateRecommendationResourceExclusionErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("BatchUpdateRecommendationResourceExclusionResponse")
                .add("BatchUpdateRecommendationResourceExclusionErrors",
                        hasBatchUpdateRecommendationResourceExclusionErrors() ? batchUpdateRecommendationResourceExclusionErrors()
                                : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "batchUpdateRecommendationResourceExclusionErrors":
            return Optional.ofNullable(clazz.cast(batchUpdateRecommendationResourceExclusionErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateRecommendationResourceExclusionResponse, T> g) {
        return obj -> g.apply((BatchUpdateRecommendationResourceExclusionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TrustedAdvisorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateRecommendationResourceExclusionResponse> {
        /**
         * <p>
         * A list of recommendation resource ARNs whose exclusion status failed to update, if any
         * </p>
         * 
         * @param batchUpdateRecommendationResourceExclusionErrors
         *        A list of recommendation resource ARNs whose exclusion status failed to update, if any
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchUpdateRecommendationResourceExclusionErrors(
                Collection<UpdateRecommendationResourceExclusionError> batchUpdateRecommendationResourceExclusionErrors);

        /**
         * <p>
         * A list of recommendation resource ARNs whose exclusion status failed to update, if any
         * </p>
         * 
         * @param batchUpdateRecommendationResourceExclusionErrors
         *        A list of recommendation resource ARNs whose exclusion status failed to update, if any
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchUpdateRecommendationResourceExclusionErrors(
                UpdateRecommendationResourceExclusionError... batchUpdateRecommendationResourceExclusionErrors);

        /**
         * <p>
         * A list of recommendation resource ARNs whose exclusion status failed to update, if any
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.trustedadvisor.model.UpdateRecommendationResourceExclusionError.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.trustedadvisor.model.UpdateRecommendationResourceExclusionError#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.trustedadvisor.model.UpdateRecommendationResourceExclusionError.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #batchUpdateRecommendationResourceExclusionErrors(List<UpdateRecommendationResourceExclusionError>)}.
         * 
         * @param batchUpdateRecommendationResourceExclusionErrors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.trustedadvisor.model.UpdateRecommendationResourceExclusionError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batchUpdateRecommendationResourceExclusionErrors(java.util.Collection<
         *      UpdateRecommendationResourceExclusionError>)
         */
        Builder batchUpdateRecommendationResourceExclusionErrors(
                Consumer<UpdateRecommendationResourceExclusionError.Builder>... batchUpdateRecommendationResourceExclusionErrors);
    }

    static final class BuilderImpl extends TrustedAdvisorResponse.BuilderImpl implements Builder {
        private List<UpdateRecommendationResourceExclusionError> batchUpdateRecommendationResourceExclusionErrors = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateRecommendationResourceExclusionResponse model) {
            super(model);
            batchUpdateRecommendationResourceExclusionErrors(model.batchUpdateRecommendationResourceExclusionErrors);
        }

        public final List<UpdateRecommendationResourceExclusionError.Builder> getBatchUpdateRecommendationResourceExclusionErrors() {
            List<UpdateRecommendationResourceExclusionError.Builder> result = UpdateRecommendationResourceExclusionErrorListCopier
                    .copyToBuilder(this.batchUpdateRecommendationResourceExclusionErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBatchUpdateRecommendationResourceExclusionErrors(
                Collection<UpdateRecommendationResourceExclusionError.BuilderImpl> batchUpdateRecommendationResourceExclusionErrors) {
            this.batchUpdateRecommendationResourceExclusionErrors = UpdateRecommendationResourceExclusionErrorListCopier
                    .copyFromBuilder(batchUpdateRecommendationResourceExclusionErrors);
        }

        @Override
        public final Builder batchUpdateRecommendationResourceExclusionErrors(
                Collection<UpdateRecommendationResourceExclusionError> batchUpdateRecommendationResourceExclusionErrors) {
            this.batchUpdateRecommendationResourceExclusionErrors = UpdateRecommendationResourceExclusionErrorListCopier
                    .copy(batchUpdateRecommendationResourceExclusionErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchUpdateRecommendationResourceExclusionErrors(
                UpdateRecommendationResourceExclusionError... batchUpdateRecommendationResourceExclusionErrors) {
            batchUpdateRecommendationResourceExclusionErrors(Arrays.asList(batchUpdateRecommendationResourceExclusionErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchUpdateRecommendationResourceExclusionErrors(
                Consumer<UpdateRecommendationResourceExclusionError.Builder>... batchUpdateRecommendationResourceExclusionErrors) {
            batchUpdateRecommendationResourceExclusionErrors(Stream.of(batchUpdateRecommendationResourceExclusionErrors)
                    .map(c -> UpdateRecommendationResourceExclusionError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateRecommendationResourceExclusionResponse build() {
            return new BatchUpdateRecommendationResourceExclusionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
