/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.trustedadvisor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of an AccountRecommendationLifecycle for an Organization Recommendation
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountRecommendationLifecycleSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountRecommendationLifecycleSummary.Builder, AccountRecommendationLifecycleSummary> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(AccountRecommendationLifecycleSummary::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> ACCOUNT_RECOMMENDATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountRecommendationArn")
            .getter(getter(AccountRecommendationLifecycleSummary::accountRecommendationArn))
            .setter(setter(Builder::accountRecommendationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountRecommendationArn").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(AccountRecommendationLifecycleSummary::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> LIFECYCLE_STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleStage").getter(getter(AccountRecommendationLifecycleSummary::lifecycleStageAsString))
            .setter(setter(Builder::lifecycleStage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStage").build()).build();

    private static final SdkField<String> UPDATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updateReason").getter(getter(AccountRecommendationLifecycleSummary::updateReason))
            .setter(setter(Builder::updateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateReason").build()).build();

    private static final SdkField<String> UPDATE_REASON_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updateReasonCode").getter(getter(AccountRecommendationLifecycleSummary::updateReasonCodeAsString))
            .setter(setter(Builder::updateReasonCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateReasonCode").build()).build();

    private static final SdkField<String> UPDATED_ON_BEHALF_OF_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedOnBehalfOf").getter(getter(AccountRecommendationLifecycleSummary::updatedOnBehalfOf))
            .setter(setter(Builder::updatedOnBehalfOf))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedOnBehalfOf").build()).build();

    private static final SdkField<String> UPDATED_ON_BEHALF_OF_JOB_TITLE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("updatedOnBehalfOfJobTitle")
            .getter(getter(AccountRecommendationLifecycleSummary::updatedOnBehalfOfJobTitle))
            .setter(setter(Builder::updatedOnBehalfOfJobTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedOnBehalfOfJobTitle").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            ACCOUNT_RECOMMENDATION_ARN_FIELD, LAST_UPDATED_AT_FIELD, LIFECYCLE_STAGE_FIELD, UPDATE_REASON_FIELD,
            UPDATE_REASON_CODE_FIELD, UPDATED_ON_BEHALF_OF_FIELD, UPDATED_ON_BEHALF_OF_JOB_TITLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accountId;

    private final String accountRecommendationArn;

    private final Instant lastUpdatedAt;

    private final String lifecycleStage;

    private final String updateReason;

    private final String updateReasonCode;

    private final String updatedOnBehalfOf;

    private final String updatedOnBehalfOfJobTitle;

    private AccountRecommendationLifecycleSummary(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.accountRecommendationArn = builder.accountRecommendationArn;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.lifecycleStage = builder.lifecycleStage;
        this.updateReason = builder.updateReason;
        this.updateReasonCode = builder.updateReasonCode;
        this.updatedOnBehalfOf = builder.updatedOnBehalfOf;
        this.updatedOnBehalfOfJobTitle = builder.updatedOnBehalfOfJobTitle;
    }

    /**
     * <p>
     * The AWS account ID
     * </p>
     * 
     * @return The AWS account ID
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The Recommendation ARN
     * </p>
     * 
     * @return The Recommendation ARN
     */
    public final String accountRecommendationArn() {
        return accountRecommendationArn;
    }

    /**
     * <p>
     * When the Recommendation was last updated
     * </p>
     * 
     * @return When the Recommendation was last updated
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The lifecycle stage from AWS Trusted Advisor Priority
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleStage}
     * will return {@link RecommendationLifecycleStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleStageAsString}.
     * </p>
     * 
     * @return The lifecycle stage from AWS Trusted Advisor Priority
     * @see RecommendationLifecycleStage
     */
    public final RecommendationLifecycleStage lifecycleStage() {
        return RecommendationLifecycleStage.fromValue(lifecycleStage);
    }

    /**
     * <p>
     * The lifecycle stage from AWS Trusted Advisor Priority
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleStage}
     * will return {@link RecommendationLifecycleStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleStageAsString}.
     * </p>
     * 
     * @return The lifecycle stage from AWS Trusted Advisor Priority
     * @see RecommendationLifecycleStage
     */
    public final String lifecycleStageAsString() {
        return lifecycleStage;
    }

    /**
     * <p>
     * Reason for the lifecycle stage change
     * </p>
     * 
     * @return Reason for the lifecycle stage change
     */
    public final String updateReason() {
        return updateReason;
    }

    /**
     * <p>
     * Reason code for the lifecycle state change
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateReasonCode}
     * will return {@link UpdateRecommendationLifecycleStageReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #updateReasonCodeAsString}.
     * </p>
     * 
     * @return Reason code for the lifecycle state change
     * @see UpdateRecommendationLifecycleStageReasonCode
     */
    public final UpdateRecommendationLifecycleStageReasonCode updateReasonCode() {
        return UpdateRecommendationLifecycleStageReasonCode.fromValue(updateReasonCode);
    }

    /**
     * <p>
     * Reason code for the lifecycle state change
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateReasonCode}
     * will return {@link UpdateRecommendationLifecycleStageReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #updateReasonCodeAsString}.
     * </p>
     * 
     * @return Reason code for the lifecycle state change
     * @see UpdateRecommendationLifecycleStageReasonCode
     */
    public final String updateReasonCodeAsString() {
        return updateReasonCode;
    }

    /**
     * <p>
     * The person on whose behalf a Technical Account Manager (TAM) updated the recommendation. This information is only
     * available when a Technical Account Manager takes an action on a recommendation managed by AWS Trusted Advisor
     * Priority
     * </p>
     * 
     * @return The person on whose behalf a Technical Account Manager (TAM) updated the recommendation. This information
     *         is only available when a Technical Account Manager takes an action on a recommendation managed by AWS
     *         Trusted Advisor Priority
     */
    public final String updatedOnBehalfOf() {
        return updatedOnBehalfOf;
    }

    /**
     * <p>
     * The job title of the person on whose behalf a Technical Account Manager (TAM) updated the recommendation. This
     * information is only available when a Technical Account Manager takes an action on a recommendation managed by AWS
     * Trusted Advisor Priority
     * </p>
     * 
     * @return The job title of the person on whose behalf a Technical Account Manager (TAM) updated the recommendation.
     *         This information is only available when a Technical Account Manager takes an action on a recommendation
     *         managed by AWS Trusted Advisor Priority
     */
    public final String updatedOnBehalfOfJobTitle() {
        return updatedOnBehalfOfJobTitle;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(accountRecommendationArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updateReason());
        hashCode = 31 * hashCode + Objects.hashCode(updateReasonCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedOnBehalfOf());
        hashCode = 31 * hashCode + Objects.hashCode(updatedOnBehalfOfJobTitle());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountRecommendationLifecycleSummary)) {
            return false;
        }
        AccountRecommendationLifecycleSummary other = (AccountRecommendationLifecycleSummary) obj;
        return Objects.equals(accountId(), other.accountId())
                && Objects.equals(accountRecommendationArn(), other.accountRecommendationArn())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(lifecycleStageAsString(), other.lifecycleStageAsString())
                && Objects.equals(updateReason(), other.updateReason())
                && Objects.equals(updateReasonCodeAsString(), other.updateReasonCodeAsString())
                && Objects.equals(updatedOnBehalfOf(), other.updatedOnBehalfOf())
                && Objects.equals(updatedOnBehalfOfJobTitle(), other.updatedOnBehalfOfJobTitle());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountRecommendationLifecycleSummary").add("AccountId", accountId())
                .add("AccountRecommendationArn", accountRecommendationArn()).add("LastUpdatedAt", lastUpdatedAt())
                .add("LifecycleStage", lifecycleStageAsString())
                .add("UpdateReason", updateReason() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UpdateReasonCode", updateReasonCodeAsString()).add("UpdatedOnBehalfOf", updatedOnBehalfOf())
                .add("UpdatedOnBehalfOfJobTitle", updatedOnBehalfOfJobTitle()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "accountRecommendationArn":
            return Optional.ofNullable(clazz.cast(accountRecommendationArn()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "lifecycleStage":
            return Optional.ofNullable(clazz.cast(lifecycleStageAsString()));
        case "updateReason":
            return Optional.ofNullable(clazz.cast(updateReason()));
        case "updateReasonCode":
            return Optional.ofNullable(clazz.cast(updateReasonCodeAsString()));
        case "updatedOnBehalfOf":
            return Optional.ofNullable(clazz.cast(updatedOnBehalfOf()));
        case "updatedOnBehalfOfJobTitle":
            return Optional.ofNullable(clazz.cast(updatedOnBehalfOfJobTitle()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("accountRecommendationArn", ACCOUNT_RECOMMENDATION_ARN_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("lifecycleStage", LIFECYCLE_STAGE_FIELD);
        map.put("updateReason", UPDATE_REASON_FIELD);
        map.put("updateReasonCode", UPDATE_REASON_CODE_FIELD);
        map.put("updatedOnBehalfOf", UPDATED_ON_BEHALF_OF_FIELD);
        map.put("updatedOnBehalfOfJobTitle", UPDATED_ON_BEHALF_OF_JOB_TITLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountRecommendationLifecycleSummary, T> g) {
        return obj -> g.apply((AccountRecommendationLifecycleSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountRecommendationLifecycleSummary> {
        /**
         * <p>
         * The AWS account ID
         * </p>
         * 
         * @param accountId
         *        The AWS account ID
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The Recommendation ARN
         * </p>
         * 
         * @param accountRecommendationArn
         *        The Recommendation ARN
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountRecommendationArn(String accountRecommendationArn);

        /**
         * <p>
         * When the Recommendation was last updated
         * </p>
         * 
         * @param lastUpdatedAt
         *        When the Recommendation was last updated
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The lifecycle stage from AWS Trusted Advisor Priority
         * </p>
         * 
         * @param lifecycleStage
         *        The lifecycle stage from AWS Trusted Advisor Priority
         * @see RecommendationLifecycleStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationLifecycleStage
         */
        Builder lifecycleStage(String lifecycleStage);

        /**
         * <p>
         * The lifecycle stage from AWS Trusted Advisor Priority
         * </p>
         * 
         * @param lifecycleStage
         *        The lifecycle stage from AWS Trusted Advisor Priority
         * @see RecommendationLifecycleStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationLifecycleStage
         */
        Builder lifecycleStage(RecommendationLifecycleStage lifecycleStage);

        /**
         * <p>
         * Reason for the lifecycle stage change
         * </p>
         * 
         * @param updateReason
         *        Reason for the lifecycle stage change
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateReason(String updateReason);

        /**
         * <p>
         * Reason code for the lifecycle state change
         * </p>
         * 
         * @param updateReasonCode
         *        Reason code for the lifecycle state change
         * @see UpdateRecommendationLifecycleStageReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateRecommendationLifecycleStageReasonCode
         */
        Builder updateReasonCode(String updateReasonCode);

        /**
         * <p>
         * Reason code for the lifecycle state change
         * </p>
         * 
         * @param updateReasonCode
         *        Reason code for the lifecycle state change
         * @see UpdateRecommendationLifecycleStageReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateRecommendationLifecycleStageReasonCode
         */
        Builder updateReasonCode(UpdateRecommendationLifecycleStageReasonCode updateReasonCode);

        /**
         * <p>
         * The person on whose behalf a Technical Account Manager (TAM) updated the recommendation. This information is
         * only available when a Technical Account Manager takes an action on a recommendation managed by AWS Trusted
         * Advisor Priority
         * </p>
         * 
         * @param updatedOnBehalfOf
         *        The person on whose behalf a Technical Account Manager (TAM) updated the recommendation. This
         *        information is only available when a Technical Account Manager takes an action on a recommendation
         *        managed by AWS Trusted Advisor Priority
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedOnBehalfOf(String updatedOnBehalfOf);

        /**
         * <p>
         * The job title of the person on whose behalf a Technical Account Manager (TAM) updated the recommendation.
         * This information is only available when a Technical Account Manager takes an action on a recommendation
         * managed by AWS Trusted Advisor Priority
         * </p>
         * 
         * @param updatedOnBehalfOfJobTitle
         *        The job title of the person on whose behalf a Technical Account Manager (TAM) updated the
         *        recommendation. This information is only available when a Technical Account Manager takes an action on
         *        a recommendation managed by AWS Trusted Advisor Priority
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedOnBehalfOfJobTitle(String updatedOnBehalfOfJobTitle);
    }

    static final class BuilderImpl implements Builder {
        private String accountId;

        private String accountRecommendationArn;

        private Instant lastUpdatedAt;

        private String lifecycleStage;

        private String updateReason;

        private String updateReasonCode;

        private String updatedOnBehalfOf;

        private String updatedOnBehalfOfJobTitle;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountRecommendationLifecycleSummary model) {
            accountId(model.accountId);
            accountRecommendationArn(model.accountRecommendationArn);
            lastUpdatedAt(model.lastUpdatedAt);
            lifecycleStage(model.lifecycleStage);
            updateReason(model.updateReason);
            updateReasonCode(model.updateReasonCode);
            updatedOnBehalfOf(model.updatedOnBehalfOf);
            updatedOnBehalfOfJobTitle(model.updatedOnBehalfOfJobTitle);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAccountRecommendationArn() {
            return accountRecommendationArn;
        }

        public final void setAccountRecommendationArn(String accountRecommendationArn) {
            this.accountRecommendationArn = accountRecommendationArn;
        }

        @Override
        public final Builder accountRecommendationArn(String accountRecommendationArn) {
            this.accountRecommendationArn = accountRecommendationArn;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getLifecycleStage() {
            return lifecycleStage;
        }

        public final void setLifecycleStage(String lifecycleStage) {
            this.lifecycleStage = lifecycleStage;
        }

        @Override
        public final Builder lifecycleStage(String lifecycleStage) {
            this.lifecycleStage = lifecycleStage;
            return this;
        }

        @Override
        public final Builder lifecycleStage(RecommendationLifecycleStage lifecycleStage) {
            this.lifecycleStage(lifecycleStage == null ? null : lifecycleStage.toString());
            return this;
        }

        public final String getUpdateReason() {
            return updateReason;
        }

        public final void setUpdateReason(String updateReason) {
            this.updateReason = updateReason;
        }

        @Override
        public final Builder updateReason(String updateReason) {
            this.updateReason = updateReason;
            return this;
        }

        public final String getUpdateReasonCode() {
            return updateReasonCode;
        }

        public final void setUpdateReasonCode(String updateReasonCode) {
            this.updateReasonCode = updateReasonCode;
        }

        @Override
        public final Builder updateReasonCode(String updateReasonCode) {
            this.updateReasonCode = updateReasonCode;
            return this;
        }

        @Override
        public final Builder updateReasonCode(UpdateRecommendationLifecycleStageReasonCode updateReasonCode) {
            this.updateReasonCode(updateReasonCode == null ? null : updateReasonCode.toString());
            return this;
        }

        public final String getUpdatedOnBehalfOf() {
            return updatedOnBehalfOf;
        }

        public final void setUpdatedOnBehalfOf(String updatedOnBehalfOf) {
            this.updatedOnBehalfOf = updatedOnBehalfOf;
        }

        @Override
        public final Builder updatedOnBehalfOf(String updatedOnBehalfOf) {
            this.updatedOnBehalfOf = updatedOnBehalfOf;
            return this;
        }

        public final String getUpdatedOnBehalfOfJobTitle() {
            return updatedOnBehalfOfJobTitle;
        }

        public final void setUpdatedOnBehalfOfJobTitle(String updatedOnBehalfOfJobTitle) {
            this.updatedOnBehalfOfJobTitle = updatedOnBehalfOfJobTitle;
        }

        @Override
        public final Builder updatedOnBehalfOfJobTitle(String updatedOnBehalfOfJobTitle) {
            this.updatedOnBehalfOfJobTitle = updatedOnBehalfOfJobTitle;
            return this;
        }

        @Override
        public AccountRecommendationLifecycleSummary build() {
            return new AccountRecommendationLifecycleSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
