/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.trustedadvisor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOrganizationRecommendationResponse extends TrustedAdvisorResponse implements
        ToCopyableBuilder<GetOrganizationRecommendationResponse.Builder, GetOrganizationRecommendationResponse> {
    private static final SdkField<OrganizationRecommendation> ORGANIZATION_RECOMMENDATION_FIELD = SdkField
            .<OrganizationRecommendation> builder(MarshallingType.SDK_POJO)
            .memberName("organizationRecommendation")
            .getter(getter(GetOrganizationRecommendationResponse::organizationRecommendation))
            .setter(setter(Builder::organizationRecommendation))
            .constructor(OrganizationRecommendation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationRecommendation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ORGANIZATION_RECOMMENDATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final OrganizationRecommendation organizationRecommendation;

    private GetOrganizationRecommendationResponse(BuilderImpl builder) {
        super(builder);
        this.organizationRecommendation = builder.organizationRecommendation;
    }

    /**
     * <p>
     * The Recommendation
     * </p>
     * 
     * @return The Recommendation
     */
    public final OrganizationRecommendation organizationRecommendation() {
        return organizationRecommendation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationRecommendation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOrganizationRecommendationResponse)) {
            return false;
        }
        GetOrganizationRecommendationResponse other = (GetOrganizationRecommendationResponse) obj;
        return Objects.equals(organizationRecommendation(), other.organizationRecommendation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOrganizationRecommendationResponse")
                .add("OrganizationRecommendation", organizationRecommendation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "organizationRecommendation":
            return Optional.ofNullable(clazz.cast(organizationRecommendation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("organizationRecommendation", ORGANIZATION_RECOMMENDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOrganizationRecommendationResponse, T> g) {
        return obj -> g.apply((GetOrganizationRecommendationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TrustedAdvisorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetOrganizationRecommendationResponse> {
        /**
         * <p>
         * The Recommendation
         * </p>
         * 
         * @param organizationRecommendation
         *        The Recommendation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationRecommendation(OrganizationRecommendation organizationRecommendation);

        /**
         * <p>
         * The Recommendation
         * </p>
         * This is a convenience method that creates an instance of the {@link OrganizationRecommendation.Builder}
         * avoiding the need to create one manually via {@link OrganizationRecommendation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OrganizationRecommendation.Builder#build()} is called immediately
         * and its result is passed to {@link #organizationRecommendation(OrganizationRecommendation)}.
         * 
         * @param organizationRecommendation
         *        a consumer that will call methods on {@link OrganizationRecommendation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationRecommendation(OrganizationRecommendation)
         */
        default Builder organizationRecommendation(Consumer<OrganizationRecommendation.Builder> organizationRecommendation) {
            return organizationRecommendation(OrganizationRecommendation.builder().applyMutation(organizationRecommendation)
                    .build());
        }
    }

    static final class BuilderImpl extends TrustedAdvisorResponse.BuilderImpl implements Builder {
        private OrganizationRecommendation organizationRecommendation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOrganizationRecommendationResponse model) {
            super(model);
            organizationRecommendation(model.organizationRecommendation);
        }

        public final OrganizationRecommendation.Builder getOrganizationRecommendation() {
            return organizationRecommendation != null ? organizationRecommendation.toBuilder() : null;
        }

        public final void setOrganizationRecommendation(OrganizationRecommendation.BuilderImpl organizationRecommendation) {
            this.organizationRecommendation = organizationRecommendation != null ? organizationRecommendation.build() : null;
        }

        @Override
        public final Builder organizationRecommendation(OrganizationRecommendation organizationRecommendation) {
            this.organizationRecommendation = organizationRecommendation;
            return this;
        }

        @Override
        public GetOrganizationRecommendationResponse build() {
            return new GetOrganizationRecommendationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
