/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.trustedadvisor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRecommendationLifecycleRequest extends TrustedAdvisorRequest implements
        ToCopyableBuilder<UpdateRecommendationLifecycleRequest.Builder, UpdateRecommendationLifecycleRequest> {
    private static final SdkField<String> LIFECYCLE_STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleStage").getter(getter(UpdateRecommendationLifecycleRequest::lifecycleStageAsString))
            .setter(setter(Builder::lifecycleStage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStage").build()).build();

    private static final SdkField<String> RECOMMENDATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendationIdentifier")
            .getter(getter(UpdateRecommendationLifecycleRequest::recommendationIdentifier))
            .setter(setter(Builder::recommendationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("recommendationIdentifier").build())
            .build();

    private static final SdkField<String> UPDATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updateReason").getter(getter(UpdateRecommendationLifecycleRequest::updateReason))
            .setter(setter(Builder::updateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateReason").build()).build();

    private static final SdkField<String> UPDATE_REASON_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updateReasonCode").getter(getter(UpdateRecommendationLifecycleRequest::updateReasonCodeAsString))
            .setter(setter(Builder::updateReasonCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateReasonCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_STAGE_FIELD,
            RECOMMENDATION_IDENTIFIER_FIELD, UPDATE_REASON_FIELD, UPDATE_REASON_CODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String lifecycleStage;

    private final String recommendationIdentifier;

    private final String updateReason;

    private final String updateReasonCode;

    private UpdateRecommendationLifecycleRequest(BuilderImpl builder) {
        super(builder);
        this.lifecycleStage = builder.lifecycleStage;
        this.recommendationIdentifier = builder.recommendationIdentifier;
        this.updateReason = builder.updateReason;
        this.updateReasonCode = builder.updateReasonCode;
    }

    /**
     * <p>
     * The new lifecycle stage
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleStage}
     * will return {@link UpdateRecommendationLifecycleStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #lifecycleStageAsString}.
     * </p>
     * 
     * @return The new lifecycle stage
     * @see UpdateRecommendationLifecycleStage
     */
    public final UpdateRecommendationLifecycleStage lifecycleStage() {
        return UpdateRecommendationLifecycleStage.fromValue(lifecycleStage);
    }

    /**
     * <p>
     * The new lifecycle stage
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleStage}
     * will return {@link UpdateRecommendationLifecycleStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #lifecycleStageAsString}.
     * </p>
     * 
     * @return The new lifecycle stage
     * @see UpdateRecommendationLifecycleStage
     */
    public final String lifecycleStageAsString() {
        return lifecycleStage;
    }

    /**
     * <p>
     * The Recommendation identifier for AWS Trusted Advisor Priority recommendations
     * </p>
     * 
     * @return The Recommendation identifier for AWS Trusted Advisor Priority recommendations
     */
    public final String recommendationIdentifier() {
        return recommendationIdentifier;
    }

    /**
     * <p>
     * Reason for the lifecycle stage change
     * </p>
     * 
     * @return Reason for the lifecycle stage change
     */
    public final String updateReason() {
        return updateReason;
    }

    /**
     * <p>
     * Reason code for the lifecycle state change
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateReasonCode}
     * will return {@link UpdateRecommendationLifecycleStageReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #updateReasonCodeAsString}.
     * </p>
     * 
     * @return Reason code for the lifecycle state change
     * @see UpdateRecommendationLifecycleStageReasonCode
     */
    public final UpdateRecommendationLifecycleStageReasonCode updateReasonCode() {
        return UpdateRecommendationLifecycleStageReasonCode.fromValue(updateReasonCode);
    }

    /**
     * <p>
     * Reason code for the lifecycle state change
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateReasonCode}
     * will return {@link UpdateRecommendationLifecycleStageReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #updateReasonCodeAsString}.
     * </p>
     * 
     * @return Reason code for the lifecycle state change
     * @see UpdateRecommendationLifecycleStageReasonCode
     */
    public final String updateReasonCodeAsString() {
        return updateReasonCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(updateReason());
        hashCode = 31 * hashCode + Objects.hashCode(updateReasonCodeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRecommendationLifecycleRequest)) {
            return false;
        }
        UpdateRecommendationLifecycleRequest other = (UpdateRecommendationLifecycleRequest) obj;
        return Objects.equals(lifecycleStageAsString(), other.lifecycleStageAsString())
                && Objects.equals(recommendationIdentifier(), other.recommendationIdentifier())
                && Objects.equals(updateReason(), other.updateReason())
                && Objects.equals(updateReasonCodeAsString(), other.updateReasonCodeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRecommendationLifecycleRequest").add("LifecycleStage", lifecycleStageAsString())
                .add("RecommendationIdentifier", recommendationIdentifier())
                .add("UpdateReason", updateReason() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UpdateReasonCode", updateReasonCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lifecycleStage":
            return Optional.ofNullable(clazz.cast(lifecycleStageAsString()));
        case "recommendationIdentifier":
            return Optional.ofNullable(clazz.cast(recommendationIdentifier()));
        case "updateReason":
            return Optional.ofNullable(clazz.cast(updateReason()));
        case "updateReasonCode":
            return Optional.ofNullable(clazz.cast(updateReasonCodeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lifecycleStage", LIFECYCLE_STAGE_FIELD);
        map.put("recommendationIdentifier", RECOMMENDATION_IDENTIFIER_FIELD);
        map.put("updateReason", UPDATE_REASON_FIELD);
        map.put("updateReasonCode", UPDATE_REASON_CODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRecommendationLifecycleRequest, T> g) {
        return obj -> g.apply((UpdateRecommendationLifecycleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TrustedAdvisorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateRecommendationLifecycleRequest> {
        /**
         * <p>
         * The new lifecycle stage
         * </p>
         * 
         * @param lifecycleStage
         *        The new lifecycle stage
         * @see UpdateRecommendationLifecycleStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateRecommendationLifecycleStage
         */
        Builder lifecycleStage(String lifecycleStage);

        /**
         * <p>
         * The new lifecycle stage
         * </p>
         * 
         * @param lifecycleStage
         *        The new lifecycle stage
         * @see UpdateRecommendationLifecycleStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateRecommendationLifecycleStage
         */
        Builder lifecycleStage(UpdateRecommendationLifecycleStage lifecycleStage);

        /**
         * <p>
         * The Recommendation identifier for AWS Trusted Advisor Priority recommendations
         * </p>
         * 
         * @param recommendationIdentifier
         *        The Recommendation identifier for AWS Trusted Advisor Priority recommendations
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationIdentifier(String recommendationIdentifier);

        /**
         * <p>
         * Reason for the lifecycle stage change
         * </p>
         * 
         * @param updateReason
         *        Reason for the lifecycle stage change
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateReason(String updateReason);

        /**
         * <p>
         * Reason code for the lifecycle state change
         * </p>
         * 
         * @param updateReasonCode
         *        Reason code for the lifecycle state change
         * @see UpdateRecommendationLifecycleStageReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateRecommendationLifecycleStageReasonCode
         */
        Builder updateReasonCode(String updateReasonCode);

        /**
         * <p>
         * Reason code for the lifecycle state change
         * </p>
         * 
         * @param updateReasonCode
         *        Reason code for the lifecycle state change
         * @see UpdateRecommendationLifecycleStageReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateRecommendationLifecycleStageReasonCode
         */
        Builder updateReasonCode(UpdateRecommendationLifecycleStageReasonCode updateReasonCode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TrustedAdvisorRequest.BuilderImpl implements Builder {
        private String lifecycleStage;

        private String recommendationIdentifier;

        private String updateReason;

        private String updateReasonCode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRecommendationLifecycleRequest model) {
            super(model);
            lifecycleStage(model.lifecycleStage);
            recommendationIdentifier(model.recommendationIdentifier);
            updateReason(model.updateReason);
            updateReasonCode(model.updateReasonCode);
        }

        public final String getLifecycleStage() {
            return lifecycleStage;
        }

        public final void setLifecycleStage(String lifecycleStage) {
            this.lifecycleStage = lifecycleStage;
        }

        @Override
        public final Builder lifecycleStage(String lifecycleStage) {
            this.lifecycleStage = lifecycleStage;
            return this;
        }

        @Override
        public final Builder lifecycleStage(UpdateRecommendationLifecycleStage lifecycleStage) {
            this.lifecycleStage(lifecycleStage == null ? null : lifecycleStage.toString());
            return this;
        }

        public final String getRecommendationIdentifier() {
            return recommendationIdentifier;
        }

        public final void setRecommendationIdentifier(String recommendationIdentifier) {
            this.recommendationIdentifier = recommendationIdentifier;
        }

        @Override
        public final Builder recommendationIdentifier(String recommendationIdentifier) {
            this.recommendationIdentifier = recommendationIdentifier;
            return this;
        }

        public final String getUpdateReason() {
            return updateReason;
        }

        public final void setUpdateReason(String updateReason) {
            this.updateReason = updateReason;
        }

        @Override
        public final Builder updateReason(String updateReason) {
            this.updateReason = updateReason;
            return this;
        }

        public final String getUpdateReasonCode() {
            return updateReasonCode;
        }

        public final void setUpdateReasonCode(String updateReasonCode) {
            this.updateReasonCode = updateReasonCode;
        }

        @Override
        public final Builder updateReasonCode(String updateReasonCode) {
            this.updateReasonCode = updateReasonCode;
            return this;
        }

        @Override
        public final Builder updateReasonCode(UpdateRecommendationLifecycleStageReasonCode updateReasonCode) {
            this.updateReasonCode(updateReasonCode == null ? null : updateReasonCode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRecommendationLifecycleRequest build() {
            return new UpdateRecommendationLifecycleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
