/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.trustedadvisor;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.trustedadvisor.TrustedAdvisorClient;
import software.amazon.awssdk.services.trustedadvisor.TrustedAdvisorServiceClientConfiguration;
import software.amazon.awssdk.services.trustedadvisor.internal.TrustedAdvisorServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.trustedadvisor.model.AccessDeniedException;
import software.amazon.awssdk.services.trustedadvisor.model.BatchUpdateRecommendationResourceExclusionRequest;
import software.amazon.awssdk.services.trustedadvisor.model.BatchUpdateRecommendationResourceExclusionResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ConflictException;
import software.amazon.awssdk.services.trustedadvisor.model.GetOrganizationRecommendationRequest;
import software.amazon.awssdk.services.trustedadvisor.model.GetOrganizationRecommendationResponse;
import software.amazon.awssdk.services.trustedadvisor.model.GetRecommendationRequest;
import software.amazon.awssdk.services.trustedadvisor.model.GetRecommendationResponse;
import software.amazon.awssdk.services.trustedadvisor.model.InternalServerException;
import software.amazon.awssdk.services.trustedadvisor.model.ListChecksRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListChecksResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationAccountsResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationResourcesResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListOrganizationRecommendationsResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationResourcesResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsRequest;
import software.amazon.awssdk.services.trustedadvisor.model.ListRecommendationsResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ResourceNotFoundException;
import software.amazon.awssdk.services.trustedadvisor.model.ThrottlingException;
import software.amazon.awssdk.services.trustedadvisor.model.TrustedAdvisorException;
import software.amazon.awssdk.services.trustedadvisor.model.UpdateOrganizationRecommendationLifecycleRequest;
import software.amazon.awssdk.services.trustedadvisor.model.UpdateOrganizationRecommendationLifecycleResponse;
import software.amazon.awssdk.services.trustedadvisor.model.UpdateRecommendationLifecycleRequest;
import software.amazon.awssdk.services.trustedadvisor.model.UpdateRecommendationLifecycleResponse;
import software.amazon.awssdk.services.trustedadvisor.model.ValidationException;
import software.amazon.awssdk.services.trustedadvisor.transform.BatchUpdateRecommendationResourceExclusionRequestMarshaller;
import software.amazon.awssdk.services.trustedadvisor.transform.GetOrganizationRecommendationRequestMarshaller;
import software.amazon.awssdk.services.trustedadvisor.transform.GetRecommendationRequestMarshaller;
import software.amazon.awssdk.services.trustedadvisor.transform.ListChecksRequestMarshaller;
import software.amazon.awssdk.services.trustedadvisor.transform.ListOrganizationRecommendationAccountsRequestMarshaller;
import software.amazon.awssdk.services.trustedadvisor.transform.ListOrganizationRecommendationResourcesRequestMarshaller;
import software.amazon.awssdk.services.trustedadvisor.transform.ListOrganizationRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.trustedadvisor.transform.ListRecommendationResourcesRequestMarshaller;
import software.amazon.awssdk.services.trustedadvisor.transform.ListRecommendationsRequestMarshaller;
import software.amazon.awssdk.services.trustedadvisor.transform.UpdateOrganizationRecommendationLifecycleRequestMarshaller;
import software.amazon.awssdk.services.trustedadvisor.transform.UpdateRecommendationLifecycleRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultTrustedAdvisorClient
implements TrustedAdvisorClient {
    private static final Logger log = Logger.loggerFor(DefaultTrustedAdvisorClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultTrustedAdvisorClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"TrustedAdvisor#2.32.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchUpdateRecommendationResourceExclusionResponse batchUpdateRecommendationResourceExclusion(BatchUpdateRecommendationResourceExclusionRequest batchUpdateRecommendationResourceExclusionRequest) throws AccessDeniedException, ConflictException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchUpdateRecommendationResourceExclusionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)batchUpdateRecommendationResourceExclusionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTrustedAdvisorClient.resolveMetricPublishers(clientConfiguration, batchUpdateRecommendationResourceExclusionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TrustedAdvisor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchUpdateRecommendationResourceExclusion");
            BatchUpdateRecommendationResourceExclusionResponse batchUpdateRecommendationResourceExclusionResponse = (BatchUpdateRecommendationResourceExclusionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchUpdateRecommendationResourceExclusion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)batchUpdateRecommendationResourceExclusionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchUpdateRecommendationResourceExclusionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchUpdateRecommendationResourceExclusionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTrustedAdvisorClient.lambda$batchUpdateRecommendationResourceExclusion$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetOrganizationRecommendationResponse getOrganizationRecommendation(GetOrganizationRecommendationRequest getOrganizationRecommendationRequest) throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetOrganizationRecommendationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getOrganizationRecommendationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTrustedAdvisorClient.resolveMetricPublishers(clientConfiguration, getOrganizationRecommendationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TrustedAdvisor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetOrganizationRecommendation");
            GetOrganizationRecommendationResponse getOrganizationRecommendationResponse = (GetOrganizationRecommendationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetOrganizationRecommendation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getOrganizationRecommendationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetOrganizationRecommendationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getOrganizationRecommendationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTrustedAdvisorClient.lambda$getOrganizationRecommendation$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRecommendationResponse getRecommendation(GetRecommendationRequest getRecommendationRequest) throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRecommendationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRecommendationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTrustedAdvisorClient.resolveMetricPublishers(clientConfiguration, getRecommendationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TrustedAdvisor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRecommendation");
            GetRecommendationResponse getRecommendationResponse = (GetRecommendationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRecommendation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRecommendationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRecommendationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRecommendationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTrustedAdvisorClient.lambda$getRecommendation$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListChecksResponse listChecks(ListChecksRequest listChecksRequest) throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListChecksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listChecksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTrustedAdvisorClient.resolveMetricPublishers(clientConfiguration, listChecksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TrustedAdvisor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListChecks");
            ListChecksResponse listChecksResponse = (ListChecksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListChecks").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listChecksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListChecksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listChecksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTrustedAdvisorClient.lambda$listChecks$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOrganizationRecommendationAccountsResponse listOrganizationRecommendationAccounts(ListOrganizationRecommendationAccountsRequest listOrganizationRecommendationAccountsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOrganizationRecommendationAccountsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listOrganizationRecommendationAccountsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTrustedAdvisorClient.resolveMetricPublishers(clientConfiguration, listOrganizationRecommendationAccountsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TrustedAdvisor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOrganizationRecommendationAccounts");
            ListOrganizationRecommendationAccountsResponse listOrganizationRecommendationAccountsResponse = (ListOrganizationRecommendationAccountsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOrganizationRecommendationAccounts").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listOrganizationRecommendationAccountsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListOrganizationRecommendationAccountsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listOrganizationRecommendationAccountsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTrustedAdvisorClient.lambda$listOrganizationRecommendationAccounts$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOrganizationRecommendationResourcesResponse listOrganizationRecommendationResources(ListOrganizationRecommendationResourcesRequest listOrganizationRecommendationResourcesRequest) throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOrganizationRecommendationResourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listOrganizationRecommendationResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTrustedAdvisorClient.resolveMetricPublishers(clientConfiguration, listOrganizationRecommendationResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TrustedAdvisor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOrganizationRecommendationResources");
            ListOrganizationRecommendationResourcesResponse listOrganizationRecommendationResourcesResponse = (ListOrganizationRecommendationResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOrganizationRecommendationResources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listOrganizationRecommendationResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListOrganizationRecommendationResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listOrganizationRecommendationResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTrustedAdvisorClient.lambda$listOrganizationRecommendationResources$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListOrganizationRecommendationsResponse listOrganizationRecommendations(ListOrganizationRecommendationsRequest listOrganizationRecommendationsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListOrganizationRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listOrganizationRecommendationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTrustedAdvisorClient.resolveMetricPublishers(clientConfiguration, listOrganizationRecommendationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TrustedAdvisor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListOrganizationRecommendations");
            ListOrganizationRecommendationsResponse listOrganizationRecommendationsResponse = (ListOrganizationRecommendationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListOrganizationRecommendations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listOrganizationRecommendationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListOrganizationRecommendationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listOrganizationRecommendationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTrustedAdvisorClient.lambda$listOrganizationRecommendations$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRecommendationResourcesResponse listRecommendationResources(ListRecommendationResourcesRequest listRecommendationResourcesRequest) throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRecommendationResourcesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRecommendationResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTrustedAdvisorClient.resolveMetricPublishers(clientConfiguration, listRecommendationResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TrustedAdvisor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRecommendationResources");
            ListRecommendationResourcesResponse listRecommendationResourcesResponse = (ListRecommendationResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRecommendationResources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listRecommendationResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRecommendationResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRecommendationResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTrustedAdvisorClient.lambda$listRecommendationResources$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRecommendationsResponse listRecommendations(ListRecommendationsRequest listRecommendationsRequest) throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRecommendationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRecommendationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTrustedAdvisorClient.resolveMetricPublishers(clientConfiguration, listRecommendationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TrustedAdvisor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRecommendations");
            ListRecommendationsResponse listRecommendationsResponse = (ListRecommendationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRecommendations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listRecommendationsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRecommendationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRecommendationsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTrustedAdvisorClient.lambda$listRecommendations$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateOrganizationRecommendationLifecycleResponse updateOrganizationRecommendationLifecycle(UpdateOrganizationRecommendationLifecycleRequest updateOrganizationRecommendationLifecycleRequest) throws AccessDeniedException, ConflictException, InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateOrganizationRecommendationLifecycleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateOrganizationRecommendationLifecycleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTrustedAdvisorClient.resolveMetricPublishers(clientConfiguration, updateOrganizationRecommendationLifecycleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TrustedAdvisor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateOrganizationRecommendationLifecycle");
            UpdateOrganizationRecommendationLifecycleResponse updateOrganizationRecommendationLifecycleResponse = (UpdateOrganizationRecommendationLifecycleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateOrganizationRecommendationLifecycle").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateOrganizationRecommendationLifecycleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateOrganizationRecommendationLifecycleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateOrganizationRecommendationLifecycleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTrustedAdvisorClient.lambda$updateOrganizationRecommendationLifecycle$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRecommendationLifecycleResponse updateRecommendationLifecycle(UpdateRecommendationLifecycleRequest updateRecommendationLifecycleRequest) throws AccessDeniedException, ConflictException, InternalServerException, ValidationException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, TrustedAdvisorException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRecommendationLifecycleResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(403)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(409)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(429)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateRecommendationLifecycleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultTrustedAdvisorClient.resolveMetricPublishers(clientConfiguration, updateRecommendationLifecycleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"TrustedAdvisor");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRecommendationLifecycle");
            UpdateRecommendationLifecycleResponse updateRecommendationLifecycleResponse = (UpdateRecommendationLifecycleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRecommendationLifecycle").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateRecommendationLifecycleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRecommendationLifecycleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRecommendationLifecycleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultTrustedAdvisorClient.lambda$updateRecommendationLifecycle$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "trustedadvisor";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        TrustedAdvisorServiceClientConfigurationBuilder serviceConfigBuilder = new TrustedAdvisorServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(TrustedAdvisorException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final TrustedAdvisorServiceClientConfiguration serviceClientConfiguration() {
        return new TrustedAdvisorServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateRecommendationLifecycle$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateOrganizationRecommendationLifecycle$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRecommendations$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRecommendationResources$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOrganizationRecommendations$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOrganizationRecommendationResources$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listOrganizationRecommendationAccounts$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listChecks$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRecommendation$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getOrganizationRecommendation$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchUpdateRecommendationResourceExclusion$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

