/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.trustedadvisor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateRecommendationResourceExclusionRequest extends TrustedAdvisorRequest
        implements
        ToCopyableBuilder<BatchUpdateRecommendationResourceExclusionRequest.Builder, BatchUpdateRecommendationResourceExclusionRequest> {
    private static final SdkField<List<RecommendationResourceExclusion>> RECOMMENDATION_RESOURCE_EXCLUSIONS_FIELD = SdkField
            .<List<RecommendationResourceExclusion>> builder(MarshallingType.LIST)
            .memberName("recommendationResourceExclusions")
            .getter(getter(BatchUpdateRecommendationResourceExclusionRequest::recommendationResourceExclusions))
            .setter(setter(Builder::recommendationResourceExclusions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationResourceExclusions")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecommendationResourceExclusion> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecommendationResourceExclusion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RECOMMENDATION_RESOURCE_EXCLUSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<RecommendationResourceExclusion> recommendationResourceExclusions;

    private BatchUpdateRecommendationResourceExclusionRequest(BuilderImpl builder) {
        super(builder);
        this.recommendationResourceExclusions = builder.recommendationResourceExclusions;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecommendationResourceExclusions
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasRecommendationResourceExclusions() {
        return recommendationResourceExclusions != null && !(recommendationResourceExclusions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of recommendation resource ARNs and exclusion status to update
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecommendationResourceExclusions}
     * method.
     * </p>
     * 
     * @return A list of recommendation resource ARNs and exclusion status to update
     */
    public final List<RecommendationResourceExclusion> recommendationResourceExclusions() {
        return recommendationResourceExclusions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasRecommendationResourceExclusions() ? recommendationResourceExclusions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateRecommendationResourceExclusionRequest)) {
            return false;
        }
        BatchUpdateRecommendationResourceExclusionRequest other = (BatchUpdateRecommendationResourceExclusionRequest) obj;
        return hasRecommendationResourceExclusions() == other.hasRecommendationResourceExclusions()
                && Objects.equals(recommendationResourceExclusions(), other.recommendationResourceExclusions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("BatchUpdateRecommendationResourceExclusionRequest")
                .add("RecommendationResourceExclusions",
                        hasRecommendationResourceExclusions() ? recommendationResourceExclusions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recommendationResourceExclusions":
            return Optional.ofNullable(clazz.cast(recommendationResourceExclusions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("recommendationResourceExclusions", RECOMMENDATION_RESOURCE_EXCLUSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateRecommendationResourceExclusionRequest, T> g) {
        return obj -> g.apply((BatchUpdateRecommendationResourceExclusionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TrustedAdvisorRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateRecommendationResourceExclusionRequest> {
        /**
         * <p>
         * A list of recommendation resource ARNs and exclusion status to update
         * </p>
         * 
         * @param recommendationResourceExclusions
         *        A list of recommendation resource ARNs and exclusion status to update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationResourceExclusions(Collection<RecommendationResourceExclusion> recommendationResourceExclusions);

        /**
         * <p>
         * A list of recommendation resource ARNs and exclusion status to update
         * </p>
         * 
         * @param recommendationResourceExclusions
         *        A list of recommendation resource ARNs and exclusion status to update
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationResourceExclusions(RecommendationResourceExclusion... recommendationResourceExclusions);

        /**
         * <p>
         * A list of recommendation resource ARNs and exclusion status to update
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.trustedadvisor.model.RecommendationResourceExclusion.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.trustedadvisor.model.RecommendationResourceExclusion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.trustedadvisor.model.RecommendationResourceExclusion.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #recommendationResourceExclusions(List<RecommendationResourceExclusion>)}.
         * 
         * @param recommendationResourceExclusions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.trustedadvisor.model.RecommendationResourceExclusion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendationResourceExclusions(java.util.Collection<RecommendationResourceExclusion>)
         */
        Builder recommendationResourceExclusions(
                Consumer<RecommendationResourceExclusion.Builder>... recommendationResourceExclusions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TrustedAdvisorRequest.BuilderImpl implements Builder {
        private List<RecommendationResourceExclusion> recommendationResourceExclusions = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateRecommendationResourceExclusionRequest model) {
            super(model);
            recommendationResourceExclusions(model.recommendationResourceExclusions);
        }

        public final List<RecommendationResourceExclusion.Builder> getRecommendationResourceExclusions() {
            List<RecommendationResourceExclusion.Builder> result = RecommendationResourceExclusionListCopier
                    .copyToBuilder(this.recommendationResourceExclusions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendationResourceExclusions(
                Collection<RecommendationResourceExclusion.BuilderImpl> recommendationResourceExclusions) {
            this.recommendationResourceExclusions = RecommendationResourceExclusionListCopier
                    .copyFromBuilder(recommendationResourceExclusions);
        }

        @Override
        public final Builder recommendationResourceExclusions(
                Collection<RecommendationResourceExclusion> recommendationResourceExclusions) {
            this.recommendationResourceExclusions = RecommendationResourceExclusionListCopier
                    .copy(recommendationResourceExclusions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationResourceExclusions(RecommendationResourceExclusion... recommendationResourceExclusions) {
            recommendationResourceExclusions(Arrays.asList(recommendationResourceExclusions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationResourceExclusions(
                Consumer<RecommendationResourceExclusion.Builder>... recommendationResourceExclusions) {
            recommendationResourceExclusions(Stream.of(recommendationResourceExclusions)
                    .map(c -> RecommendationResourceExclusion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateRecommendationResourceExclusionRequest build() {
            return new BatchUpdateRecommendationResourceExclusionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
