/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.trustedadvisor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of a Recommendation Resource
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationResourceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationResourceSummary.Builder, RecommendationResourceSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(RecommendationResourceSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> AWS_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("awsResourceId").getter(getter(RecommendationResourceSummary::awsResourceId))
            .setter(setter(Builder::awsResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsResourceId").build()).build();

    private static final SdkField<String> EXCLUSION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("exclusionStatus").getter(getter(RecommendationResourceSummary::exclusionStatusAsString))
            .setter(setter(Builder::exclusionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exclusionStatus").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(RecommendationResourceSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(RecommendationResourceSummary::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("metadata")
            .getter(getter(RecommendationResourceSummary::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RECOMMENDATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recommendationArn").getter(getter(RecommendationResourceSummary::recommendationArn))
            .setter(setter(Builder::recommendationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationArn").build()).build();

    private static final SdkField<String> REGION_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("regionCode").getter(getter(RecommendationResourceSummary::regionCode))
            .setter(setter(Builder::regionCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionCode").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(RecommendationResourceSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            AWS_RESOURCE_ID_FIELD, EXCLUSION_STATUS_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, METADATA_FIELD,
            RECOMMENDATION_ARN_FIELD, REGION_CODE_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String awsResourceId;

    private final String exclusionStatus;

    private final String id;

    private final Instant lastUpdatedAt;

    private final Map<String, String> metadata;

    private final String recommendationArn;

    private final String regionCode;

    private final String status;

    private RecommendationResourceSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.awsResourceId = builder.awsResourceId;
        this.exclusionStatus = builder.exclusionStatus;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.metadata = builder.metadata;
        this.recommendationArn = builder.recommendationArn;
        this.regionCode = builder.regionCode;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ARN of the Recommendation Resource
     * </p>
     * 
     * @return The ARN of the Recommendation Resource
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The AWS resource identifier
     * </p>
     * 
     * @return The AWS resource identifier
     */
    public final String awsResourceId() {
        return awsResourceId;
    }

    /**
     * <p>
     * The exclusion status of the Recommendation Resource
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exclusionStatus}
     * will return {@link ExclusionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exclusionStatusAsString}.
     * </p>
     * 
     * @return The exclusion status of the Recommendation Resource
     * @see ExclusionStatus
     */
    public final ExclusionStatus exclusionStatus() {
        return ExclusionStatus.fromValue(exclusionStatus);
    }

    /**
     * <p>
     * The exclusion status of the Recommendation Resource
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exclusionStatus}
     * will return {@link ExclusionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #exclusionStatusAsString}.
     * </p>
     * 
     * @return The exclusion status of the Recommendation Resource
     * @see ExclusionStatus
     */
    public final String exclusionStatusAsString() {
        return exclusionStatus;
    }

    /**
     * <p>
     * The ID of the Recommendation Resource
     * </p>
     * 
     * @return The ID of the Recommendation Resource
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * When the Recommendation Resource was last updated
     * </p>
     * 
     * @return When the Recommendation Resource was last updated
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metadata property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetadata() {
        return metadata != null && !(metadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata associated with the Recommendation Resource
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadata} method.
     * </p>
     * 
     * @return Metadata associated with the Recommendation Resource
     */
    public final Map<String, String> metadata() {
        return metadata;
    }

    /**
     * <p>
     * The Recommendation ARN
     * </p>
     * 
     * @return The Recommendation ARN
     */
    public final String recommendationArn() {
        return recommendationArn;
    }

    /**
     * <p>
     * The AWS Region code that the Recommendation Resource is in
     * </p>
     * 
     * @return The AWS Region code that the Recommendation Resource is in
     */
    public final String regionCode() {
        return regionCode;
    }

    /**
     * <p>
     * The current status of the Recommendation Resource
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Recommendation Resource
     * @see ResourceStatus
     */
    public final ResourceStatus status() {
        return ResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the Recommendation Resource
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the Recommendation Resource
     * @see ResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(awsResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(exclusionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadata() ? metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recommendationArn());
        hashCode = 31 * hashCode + Objects.hashCode(regionCode());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationResourceSummary)) {
            return false;
        }
        RecommendationResourceSummary other = (RecommendationResourceSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(awsResourceId(), other.awsResourceId())
                && Objects.equals(exclusionStatusAsString(), other.exclusionStatusAsString()) && Objects.equals(id(), other.id())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && hasMetadata() == other.hasMetadata()
                && Objects.equals(metadata(), other.metadata()) && Objects.equals(recommendationArn(), other.recommendationArn())
                && Objects.equals(regionCode(), other.regionCode()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationResourceSummary").add("Arn", arn()).add("AwsResourceId", awsResourceId())
                .add("ExclusionStatus", exclusionStatusAsString()).add("Id", id()).add("LastUpdatedAt", lastUpdatedAt())
                .add("Metadata", hasMetadata() ? metadata() : null).add("RecommendationArn", recommendationArn())
                .add("RegionCode", regionCode()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "awsResourceId":
            return Optional.ofNullable(clazz.cast(awsResourceId()));
        case "exclusionStatus":
            return Optional.ofNullable(clazz.cast(exclusionStatusAsString()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "recommendationArn":
            return Optional.ofNullable(clazz.cast(recommendationArn()));
        case "regionCode":
            return Optional.ofNullable(clazz.cast(regionCode()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("awsResourceId", AWS_RESOURCE_ID_FIELD);
        map.put("exclusionStatus", EXCLUSION_STATUS_FIELD);
        map.put("id", ID_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("recommendationArn", RECOMMENDATION_ARN_FIELD);
        map.put("regionCode", REGION_CODE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendationResourceSummary, T> g) {
        return obj -> g.apply((RecommendationResourceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationResourceSummary> {
        /**
         * <p>
         * The ARN of the Recommendation Resource
         * </p>
         * 
         * @param arn
         *        The ARN of the Recommendation Resource
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The AWS resource identifier
         * </p>
         * 
         * @param awsResourceId
         *        The AWS resource identifier
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsResourceId(String awsResourceId);

        /**
         * <p>
         * The exclusion status of the Recommendation Resource
         * </p>
         * 
         * @param exclusionStatus
         *        The exclusion status of the Recommendation Resource
         * @see ExclusionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExclusionStatus
         */
        Builder exclusionStatus(String exclusionStatus);

        /**
         * <p>
         * The exclusion status of the Recommendation Resource
         * </p>
         * 
         * @param exclusionStatus
         *        The exclusion status of the Recommendation Resource
         * @see ExclusionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExclusionStatus
         */
        Builder exclusionStatus(ExclusionStatus exclusionStatus);

        /**
         * <p>
         * The ID of the Recommendation Resource
         * </p>
         * 
         * @param id
         *        The ID of the Recommendation Resource
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * When the Recommendation Resource was last updated
         * </p>
         * 
         * @param lastUpdatedAt
         *        When the Recommendation Resource was last updated
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * Metadata associated with the Recommendation Resource
         * </p>
         * 
         * @param metadata
         *        Metadata associated with the Recommendation Resource
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Map<String, String> metadata);

        /**
         * <p>
         * The Recommendation ARN
         * </p>
         * 
         * @param recommendationArn
         *        The Recommendation ARN
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationArn(String recommendationArn);

        /**
         * <p>
         * The AWS Region code that the Recommendation Resource is in
         * </p>
         * 
         * @param regionCode
         *        The AWS Region code that the Recommendation Resource is in
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionCode(String regionCode);

        /**
         * <p>
         * The current status of the Recommendation Resource
         * </p>
         * 
         * @param status
         *        The current status of the Recommendation Resource
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the Recommendation Resource
         * </p>
         * 
         * @param status
         *        The current status of the Recommendation Resource
         * @see ResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceStatus
         */
        Builder status(ResourceStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String awsResourceId;

        private String exclusionStatus;

        private String id;

        private Instant lastUpdatedAt;

        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();

        private String recommendationArn;

        private String regionCode;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationResourceSummary model) {
            arn(model.arn);
            awsResourceId(model.awsResourceId);
            exclusionStatus(model.exclusionStatus);
            id(model.id);
            lastUpdatedAt(model.lastUpdatedAt);
            metadata(model.metadata);
            recommendationArn(model.recommendationArn);
            regionCode(model.regionCode);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAwsResourceId() {
            return awsResourceId;
        }

        public final void setAwsResourceId(String awsResourceId) {
            this.awsResourceId = awsResourceId;
        }

        @Override
        public final Builder awsResourceId(String awsResourceId) {
            this.awsResourceId = awsResourceId;
            return this;
        }

        public final String getExclusionStatus() {
            return exclusionStatus;
        }

        public final void setExclusionStatus(String exclusionStatus) {
            this.exclusionStatus = exclusionStatus;
        }

        @Override
        public final Builder exclusionStatus(String exclusionStatus) {
            this.exclusionStatus = exclusionStatus;
            return this;
        }

        @Override
        public final Builder exclusionStatus(ExclusionStatus exclusionStatus) {
            this.exclusionStatus(exclusionStatus == null ? null : exclusionStatus.toString());
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = StringMapCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = StringMapCopier.copy(metadata);
            return this;
        }

        public final String getRecommendationArn() {
            return recommendationArn;
        }

        public final void setRecommendationArn(String recommendationArn) {
            this.recommendationArn = recommendationArn;
        }

        @Override
        public final Builder recommendationArn(String recommendationArn) {
            this.recommendationArn = recommendationArn;
            return this;
        }

        public final String getRegionCode() {
            return regionCode;
        }

        public final void setRegionCode(String regionCode) {
            this.regionCode = regionCode;
        }

        @Override
        public final Builder regionCode(String regionCode) {
            this.regionCode = regionCode;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public RecommendationResourceSummary build() {
            return new RecommendationResourceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
