/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.trustedadvisor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Aggregation of Recommendation Resources
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationResourcesAggregates implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationResourcesAggregates.Builder, RecommendationResourcesAggregates> {
    private static final SdkField<Long> ERROR_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("errorCount").getter(getter(RecommendationResourcesAggregates::errorCount))
            .setter(setter(Builder::errorCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCount").build()).build();

    private static final SdkField<Long> OK_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("okCount")
            .getter(getter(RecommendationResourcesAggregates::okCount)).setter(setter(Builder::okCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("okCount").build()).build();

    private static final SdkField<Long> WARNING_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("warningCount").getter(getter(RecommendationResourcesAggregates::warningCount))
            .setter(setter(Builder::warningCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warningCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_COUNT_FIELD,
            OK_COUNT_FIELD, WARNING_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long errorCount;

    private final Long okCount;

    private final Long warningCount;

    private RecommendationResourcesAggregates(BuilderImpl builder) {
        this.errorCount = builder.errorCount;
        this.okCount = builder.okCount;
        this.warningCount = builder.warningCount;
    }

    /**
     * <p>
     * The number of AWS resources that were flagged to have errors according to the Trusted Advisor check
     * </p>
     * 
     * @return The number of AWS resources that were flagged to have errors according to the Trusted Advisor check
     */
    public final Long errorCount() {
        return errorCount;
    }

    /**
     * <p>
     * The number of AWS resources that were flagged to be OK according to the Trusted Advisor check
     * </p>
     * 
     * @return The number of AWS resources that were flagged to be OK according to the Trusted Advisor check
     */
    public final Long okCount() {
        return okCount;
    }

    /**
     * <p>
     * The number of AWS resources that were flagged to have warning according to the Trusted Advisor check
     * </p>
     * 
     * @return The number of AWS resources that were flagged to have warning according to the Trusted Advisor check
     */
    public final Long warningCount() {
        return warningCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorCount());
        hashCode = 31 * hashCode + Objects.hashCode(okCount());
        hashCode = 31 * hashCode + Objects.hashCode(warningCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationResourcesAggregates)) {
            return false;
        }
        RecommendationResourcesAggregates other = (RecommendationResourcesAggregates) obj;
        return Objects.equals(errorCount(), other.errorCount()) && Objects.equals(okCount(), other.okCount())
                && Objects.equals(warningCount(), other.warningCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationResourcesAggregates").add("ErrorCount", errorCount()).add("OkCount", okCount())
                .add("WarningCount", warningCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorCount":
            return Optional.ofNullable(clazz.cast(errorCount()));
        case "okCount":
            return Optional.ofNullable(clazz.cast(okCount()));
        case "warningCount":
            return Optional.ofNullable(clazz.cast(warningCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errorCount", ERROR_COUNT_FIELD);
        map.put("okCount", OK_COUNT_FIELD);
        map.put("warningCount", WARNING_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendationResourcesAggregates, T> g) {
        return obj -> g.apply((RecommendationResourcesAggregates) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationResourcesAggregates> {
        /**
         * <p>
         * The number of AWS resources that were flagged to have errors according to the Trusted Advisor check
         * </p>
         * 
         * @param errorCount
         *        The number of AWS resources that were flagged to have errors according to the Trusted Advisor check
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCount(Long errorCount);

        /**
         * <p>
         * The number of AWS resources that were flagged to be OK according to the Trusted Advisor check
         * </p>
         * 
         * @param okCount
         *        The number of AWS resources that were flagged to be OK according to the Trusted Advisor check
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder okCount(Long okCount);

        /**
         * <p>
         * The number of AWS resources that were flagged to have warning according to the Trusted Advisor check
         * </p>
         * 
         * @param warningCount
         *        The number of AWS resources that were flagged to have warning according to the Trusted Advisor check
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warningCount(Long warningCount);
    }

    static final class BuilderImpl implements Builder {
        private Long errorCount;

        private Long okCount;

        private Long warningCount;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationResourcesAggregates model) {
            errorCount(model.errorCount);
            okCount(model.okCount);
            warningCount(model.warningCount);
        }

        public final Long getErrorCount() {
            return errorCount;
        }

        public final void setErrorCount(Long errorCount) {
            this.errorCount = errorCount;
        }

        @Override
        public final Builder errorCount(Long errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        public final Long getOkCount() {
            return okCount;
        }

        public final void setOkCount(Long okCount) {
            this.okCount = okCount;
        }

        @Override
        public final Builder okCount(Long okCount) {
            this.okCount = okCount;
            return this;
        }

        public final Long getWarningCount() {
            return warningCount;
        }

        public final void setWarningCount(Long warningCount) {
            this.warningCount = warningCount;
        }

        @Override
        public final Builder warningCount(Long warningCount) {
            this.warningCount = warningCount;
            return this;
        }

        @Override
        public RecommendationResourcesAggregates build() {
            return new RecommendationResourcesAggregates(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
