/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.trustedadvisor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of Recommendation for an Account
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendationSummary.Builder, RecommendationSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(RecommendationSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<List<String>> AWS_SERVICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("awsServices")
            .getter(getter(RecommendationSummary::awsServices))
            .setter(setter(Builder::awsServices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsServices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHECK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("checkArn").getter(getter(RecommendationSummary::checkArn)).setter(setter(Builder::checkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(RecommendationSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(RecommendationSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(RecommendationSummary::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> LIFECYCLE_STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleStage").getter(getter(RecommendationSummary::lifecycleStageAsString))
            .setter(setter(Builder::lifecycleStage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStage").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RecommendationSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<RecommendationPillarSpecificAggregates> PILLAR_SPECIFIC_AGGREGATES_FIELD = SdkField
            .<RecommendationPillarSpecificAggregates> builder(MarshallingType.SDK_POJO).memberName("pillarSpecificAggregates")
            .getter(getter(RecommendationSummary::pillarSpecificAggregates)).setter(setter(Builder::pillarSpecificAggregates))
            .constructor(RecommendationPillarSpecificAggregates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pillarSpecificAggregates").build())
            .build();

    private static final SdkField<List<String>> PILLARS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("pillars")
            .getter(getter(RecommendationSummary::pillarsAsStrings))
            .setter(setter(Builder::pillarsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pillars").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RecommendationResourcesAggregates> RESOURCES_AGGREGATES_FIELD = SdkField
            .<RecommendationResourcesAggregates> builder(MarshallingType.SDK_POJO).memberName("resourcesAggregates")
            .getter(getter(RecommendationSummary::resourcesAggregates)).setter(setter(Builder::resourcesAggregates))
            .constructor(RecommendationResourcesAggregates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesAggregates").build())
            .build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(RecommendationSummary::sourceAsString)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(RecommendationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(RecommendationSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, AWS_SERVICES_FIELD,
            CHECK_ARN_FIELD, CREATED_AT_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, LIFECYCLE_STAGE_FIELD, NAME_FIELD,
            PILLAR_SPECIFIC_AGGREGATES_FIELD, PILLARS_FIELD, RESOURCES_AGGREGATES_FIELD, SOURCE_FIELD, STATUS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final List<String> awsServices;

    private final String checkArn;

    private final Instant createdAt;

    private final String id;

    private final Instant lastUpdatedAt;

    private final String lifecycleStage;

    private final String name;

    private final RecommendationPillarSpecificAggregates pillarSpecificAggregates;

    private final List<String> pillars;

    private final RecommendationResourcesAggregates resourcesAggregates;

    private final String source;

    private final String status;

    private final String type;

    private RecommendationSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.awsServices = builder.awsServices;
        this.checkArn = builder.checkArn;
        this.createdAt = builder.createdAt;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.lifecycleStage = builder.lifecycleStage;
        this.name = builder.name;
        this.pillarSpecificAggregates = builder.pillarSpecificAggregates;
        this.pillars = builder.pillars;
        this.resourcesAggregates = builder.resourcesAggregates;
        this.source = builder.source;
        this.status = builder.status;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ARN of the Recommendation
     * </p>
     * 
     * @return The ARN of the Recommendation
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AwsServices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAwsServices() {
        return awsServices != null && !(awsServices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The AWS Services that the Recommendation applies to
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAwsServices} method.
     * </p>
     * 
     * @return The AWS Services that the Recommendation applies to
     */
    public final List<String> awsServices() {
        return awsServices;
    }

    /**
     * <p>
     * The AWS Trusted Advisor Check ARN that relates to the Recommendation
     * </p>
     * 
     * @return The AWS Trusted Advisor Check ARN that relates to the Recommendation
     */
    public final String checkArn() {
        return checkArn;
    }

    /**
     * <p>
     * When the Recommendation was created, if created by AWS Trusted Advisor Priority
     * </p>
     * 
     * @return When the Recommendation was created, if created by AWS Trusted Advisor Priority
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The ID which identifies where the Recommendation was produced
     * </p>
     * 
     * @return The ID which identifies where the Recommendation was produced
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * When the Recommendation was last updated
     * </p>
     * 
     * @return When the Recommendation was last updated
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The lifecycle stage from AWS Trusted Advisor Priority
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleStage}
     * will return {@link RecommendationLifecycleStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleStageAsString}.
     * </p>
     * 
     * @return The lifecycle stage from AWS Trusted Advisor Priority
     * @see RecommendationLifecycleStage
     */
    public final RecommendationLifecycleStage lifecycleStage() {
        return RecommendationLifecycleStage.fromValue(lifecycleStage);
    }

    /**
     * <p>
     * The lifecycle stage from AWS Trusted Advisor Priority
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleStage}
     * will return {@link RecommendationLifecycleStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleStageAsString}.
     * </p>
     * 
     * @return The lifecycle stage from AWS Trusted Advisor Priority
     * @see RecommendationLifecycleStage
     */
    public final String lifecycleStageAsString() {
        return lifecycleStage;
    }

    /**
     * <p>
     * The name of the AWS Trusted Advisor Recommendation
     * </p>
     * 
     * @return The name of the AWS Trusted Advisor Recommendation
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The pillar aggregations for cost savings
     * </p>
     * 
     * @return The pillar aggregations for cost savings
     */
    public final RecommendationPillarSpecificAggregates pillarSpecificAggregates() {
        return pillarSpecificAggregates;
    }

    /**
     * <p>
     * The Pillars that the Recommendation is optimizing
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPillars} method.
     * </p>
     * 
     * @return The Pillars that the Recommendation is optimizing
     */
    public final List<RecommendationPillar> pillars() {
        return RecommendationPillarListCopier.copyStringToEnum(pillars);
    }

    /**
     * For responses, this returns true if the service returned a value for the Pillars property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPillars() {
        return pillars != null && !(pillars instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Pillars that the Recommendation is optimizing
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPillars} method.
     * </p>
     * 
     * @return The Pillars that the Recommendation is optimizing
     */
    public final List<String> pillarsAsStrings() {
        return pillars;
    }

    /**
     * <p>
     * An aggregation of all resources
     * </p>
     * 
     * @return An aggregation of all resources
     */
    public final RecommendationResourcesAggregates resourcesAggregates() {
        return resourcesAggregates;
    }

    /**
     * <p>
     * The source of the Recommendation
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link RecommendationSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceAsString}.
     * </p>
     * 
     * @return The source of the Recommendation
     * @see RecommendationSource
     */
    public final RecommendationSource source() {
        return RecommendationSource.fromValue(source);
    }

    /**
     * <p>
     * The source of the Recommendation
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link RecommendationSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceAsString}.
     * </p>
     * 
     * @return The source of the Recommendation
     * @see RecommendationSource
     */
    public final String sourceAsString() {
        return source;
    }

    /**
     * <p>
     * The status of the Recommendation
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecommendationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Recommendation
     * @see RecommendationStatus
     */
    public final RecommendationStatus status() {
        return RecommendationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Recommendation
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RecommendationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Recommendation
     * @see RecommendationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Whether the Recommendation was automated or generated by AWS Trusted Advisor Priority
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RecommendationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Whether the Recommendation was automated or generated by AWS Trusted Advisor Priority
     * @see RecommendationType
     */
    public final RecommendationType type() {
        return RecommendationType.fromValue(type);
    }

    /**
     * <p>
     * Whether the Recommendation was automated or generated by AWS Trusted Advisor Priority
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link RecommendationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Whether the Recommendation was automated or generated by AWS Trusted Advisor Priority
     * @see RecommendationType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAwsServices() ? awsServices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(checkArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleStageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(pillarSpecificAggregates());
        hashCode = 31 * hashCode + Objects.hashCode(hasPillars() ? pillarsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourcesAggregates());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationSummary)) {
            return false;
        }
        RecommendationSummary other = (RecommendationSummary) obj;
        return Objects.equals(arn(), other.arn()) && hasAwsServices() == other.hasAwsServices()
                && Objects.equals(awsServices(), other.awsServices()) && Objects.equals(checkArn(), other.checkArn())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(id(), other.id())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(lifecycleStageAsString(), other.lifecycleStageAsString())
                && Objects.equals(name(), other.name())
                && Objects.equals(pillarSpecificAggregates(), other.pillarSpecificAggregates())
                && hasPillars() == other.hasPillars() && Objects.equals(pillarsAsStrings(), other.pillarsAsStrings())
                && Objects.equals(resourcesAggregates(), other.resourcesAggregates())
                && Objects.equals(sourceAsString(), other.sourceAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendationSummary").add("Arn", arn())
                .add("AwsServices", hasAwsServices() ? awsServices() : null).add("CheckArn", checkArn())
                .add("CreatedAt", createdAt()).add("Id", id()).add("LastUpdatedAt", lastUpdatedAt())
                .add("LifecycleStage", lifecycleStageAsString()).add("Name", name())
                .add("PillarSpecificAggregates", pillarSpecificAggregates())
                .add("Pillars", hasPillars() ? pillarsAsStrings() : null).add("ResourcesAggregates", resourcesAggregates())
                .add("Source", sourceAsString()).add("Status", statusAsString()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "awsServices":
            return Optional.ofNullable(clazz.cast(awsServices()));
        case "checkArn":
            return Optional.ofNullable(clazz.cast(checkArn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "lifecycleStage":
            return Optional.ofNullable(clazz.cast(lifecycleStageAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "pillarSpecificAggregates":
            return Optional.ofNullable(clazz.cast(pillarSpecificAggregates()));
        case "pillars":
            return Optional.ofNullable(clazz.cast(pillarsAsStrings()));
        case "resourcesAggregates":
            return Optional.ofNullable(clazz.cast(resourcesAggregates()));
        case "source":
            return Optional.ofNullable(clazz.cast(sourceAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("awsServices", AWS_SERVICES_FIELD);
        map.put("checkArn", CHECK_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("id", ID_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("lifecycleStage", LIFECYCLE_STAGE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("pillarSpecificAggregates", PILLAR_SPECIFIC_AGGREGATES_FIELD);
        map.put("pillars", PILLARS_FIELD);
        map.put("resourcesAggregates", RESOURCES_AGGREGATES_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendationSummary, T> g) {
        return obj -> g.apply((RecommendationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendationSummary> {
        /**
         * <p>
         * The ARN of the Recommendation
         * </p>
         * 
         * @param arn
         *        The ARN of the Recommendation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The AWS Services that the Recommendation applies to
         * </p>
         * 
         * @param awsServices
         *        The AWS Services that the Recommendation applies to
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsServices(Collection<String> awsServices);

        /**
         * <p>
         * The AWS Services that the Recommendation applies to
         * </p>
         * 
         * @param awsServices
         *        The AWS Services that the Recommendation applies to
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsServices(String... awsServices);

        /**
         * <p>
         * The AWS Trusted Advisor Check ARN that relates to the Recommendation
         * </p>
         * 
         * @param checkArn
         *        The AWS Trusted Advisor Check ARN that relates to the Recommendation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkArn(String checkArn);

        /**
         * <p>
         * When the Recommendation was created, if created by AWS Trusted Advisor Priority
         * </p>
         * 
         * @param createdAt
         *        When the Recommendation was created, if created by AWS Trusted Advisor Priority
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The ID which identifies where the Recommendation was produced
         * </p>
         * 
         * @param id
         *        The ID which identifies where the Recommendation was produced
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * When the Recommendation was last updated
         * </p>
         * 
         * @param lastUpdatedAt
         *        When the Recommendation was last updated
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The lifecycle stage from AWS Trusted Advisor Priority
         * </p>
         * 
         * @param lifecycleStage
         *        The lifecycle stage from AWS Trusted Advisor Priority
         * @see RecommendationLifecycleStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationLifecycleStage
         */
        Builder lifecycleStage(String lifecycleStage);

        /**
         * <p>
         * The lifecycle stage from AWS Trusted Advisor Priority
         * </p>
         * 
         * @param lifecycleStage
         *        The lifecycle stage from AWS Trusted Advisor Priority
         * @see RecommendationLifecycleStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationLifecycleStage
         */
        Builder lifecycleStage(RecommendationLifecycleStage lifecycleStage);

        /**
         * <p>
         * The name of the AWS Trusted Advisor Recommendation
         * </p>
         * 
         * @param name
         *        The name of the AWS Trusted Advisor Recommendation
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The pillar aggregations for cost savings
         * </p>
         * 
         * @param pillarSpecificAggregates
         *        The pillar aggregations for cost savings
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarSpecificAggregates(RecommendationPillarSpecificAggregates pillarSpecificAggregates);

        /**
         * <p>
         * The pillar aggregations for cost savings
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RecommendationPillarSpecificAggregates.Builder} avoiding the need to create one manually via
         * {@link RecommendationPillarSpecificAggregates#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationPillarSpecificAggregates.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #pillarSpecificAggregates(RecommendationPillarSpecificAggregates)}.
         * 
         * @param pillarSpecificAggregates
         *        a consumer that will call methods on {@link RecommendationPillarSpecificAggregates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pillarSpecificAggregates(RecommendationPillarSpecificAggregates)
         */
        default Builder pillarSpecificAggregates(Consumer<RecommendationPillarSpecificAggregates.Builder> pillarSpecificAggregates) {
            return pillarSpecificAggregates(RecommendationPillarSpecificAggregates.builder()
                    .applyMutation(pillarSpecificAggregates).build());
        }

        /**
         * <p>
         * The Pillars that the Recommendation is optimizing
         * </p>
         * 
         * @param pillars
         *        The Pillars that the Recommendation is optimizing
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarsWithStrings(Collection<String> pillars);

        /**
         * <p>
         * The Pillars that the Recommendation is optimizing
         * </p>
         * 
         * @param pillars
         *        The Pillars that the Recommendation is optimizing
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillarsWithStrings(String... pillars);

        /**
         * <p>
         * The Pillars that the Recommendation is optimizing
         * </p>
         * 
         * @param pillars
         *        The Pillars that the Recommendation is optimizing
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillars(Collection<RecommendationPillar> pillars);

        /**
         * <p>
         * The Pillars that the Recommendation is optimizing
         * </p>
         * 
         * @param pillars
         *        The Pillars that the Recommendation is optimizing
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pillars(RecommendationPillar... pillars);

        /**
         * <p>
         * An aggregation of all resources
         * </p>
         * 
         * @param resourcesAggregates
         *        An aggregation of all resources
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesAggregates(RecommendationResourcesAggregates resourcesAggregates);

        /**
         * <p>
         * An aggregation of all resources
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RecommendationResourcesAggregates.Builder} avoiding the need to create one manually via
         * {@link RecommendationResourcesAggregates#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecommendationResourcesAggregates.Builder#build()} is called
         * immediately and its result is passed to {@link #resourcesAggregates(RecommendationResourcesAggregates)}.
         * 
         * @param resourcesAggregates
         *        a consumer that will call methods on {@link RecommendationResourcesAggregates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcesAggregates(RecommendationResourcesAggregates)
         */
        default Builder resourcesAggregates(Consumer<RecommendationResourcesAggregates.Builder> resourcesAggregates) {
            return resourcesAggregates(RecommendationResourcesAggregates.builder().applyMutation(resourcesAggregates).build());
        }

        /**
         * <p>
         * The source of the Recommendation
         * </p>
         * 
         * @param source
         *        The source of the Recommendation
         * @see RecommendationSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationSource
         */
        Builder source(String source);

        /**
         * <p>
         * The source of the Recommendation
         * </p>
         * 
         * @param source
         *        The source of the Recommendation
         * @see RecommendationSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationSource
         */
        Builder source(RecommendationSource source);

        /**
         * <p>
         * The status of the Recommendation
         * </p>
         * 
         * @param status
         *        The status of the Recommendation
         * @see RecommendationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Recommendation
         * </p>
         * 
         * @param status
         *        The status of the Recommendation
         * @see RecommendationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationStatus
         */
        Builder status(RecommendationStatus status);

        /**
         * <p>
         * Whether the Recommendation was automated or generated by AWS Trusted Advisor Priority
         * </p>
         * 
         * @param type
         *        Whether the Recommendation was automated or generated by AWS Trusted Advisor Priority
         * @see RecommendationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationType
         */
        Builder type(String type);

        /**
         * <p>
         * Whether the Recommendation was automated or generated by AWS Trusted Advisor Priority
         * </p>
         * 
         * @param type
         *        Whether the Recommendation was automated or generated by AWS Trusted Advisor Priority
         * @see RecommendationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecommendationType
         */
        Builder type(RecommendationType type);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private List<String> awsServices = DefaultSdkAutoConstructList.getInstance();

        private String checkArn;

        private Instant createdAt;

        private String id;

        private Instant lastUpdatedAt;

        private String lifecycleStage;

        private String name;

        private RecommendationPillarSpecificAggregates pillarSpecificAggregates;

        private List<String> pillars = DefaultSdkAutoConstructList.getInstance();

        private RecommendationResourcesAggregates resourcesAggregates;

        private String source;

        private String status;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationSummary model) {
            arn(model.arn);
            awsServices(model.awsServices);
            checkArn(model.checkArn);
            createdAt(model.createdAt);
            id(model.id);
            lastUpdatedAt(model.lastUpdatedAt);
            lifecycleStage(model.lifecycleStage);
            name(model.name);
            pillarSpecificAggregates(model.pillarSpecificAggregates);
            pillarsWithStrings(model.pillars);
            resourcesAggregates(model.resourcesAggregates);
            source(model.source);
            status(model.status);
            type(model.type);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getAwsServices() {
            if (awsServices instanceof SdkAutoConstructList) {
                return null;
            }
            return awsServices;
        }

        public final void setAwsServices(Collection<String> awsServices) {
            this.awsServices = RecommendationAwsServiceListCopier.copy(awsServices);
        }

        @Override
        public final Builder awsServices(Collection<String> awsServices) {
            this.awsServices = RecommendationAwsServiceListCopier.copy(awsServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsServices(String... awsServices) {
            awsServices(Arrays.asList(awsServices));
            return this;
        }

        public final String getCheckArn() {
            return checkArn;
        }

        public final void setCheckArn(String checkArn) {
            this.checkArn = checkArn;
        }

        @Override
        public final Builder checkArn(String checkArn) {
            this.checkArn = checkArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getLifecycleStage() {
            return lifecycleStage;
        }

        public final void setLifecycleStage(String lifecycleStage) {
            this.lifecycleStage = lifecycleStage;
        }

        @Override
        public final Builder lifecycleStage(String lifecycleStage) {
            this.lifecycleStage = lifecycleStage;
            return this;
        }

        @Override
        public final Builder lifecycleStage(RecommendationLifecycleStage lifecycleStage) {
            this.lifecycleStage(lifecycleStage == null ? null : lifecycleStage.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final RecommendationPillarSpecificAggregates.Builder getPillarSpecificAggregates() {
            return pillarSpecificAggregates != null ? pillarSpecificAggregates.toBuilder() : null;
        }

        public final void setPillarSpecificAggregates(RecommendationPillarSpecificAggregates.BuilderImpl pillarSpecificAggregates) {
            this.pillarSpecificAggregates = pillarSpecificAggregates != null ? pillarSpecificAggregates.build() : null;
        }

        @Override
        public final Builder pillarSpecificAggregates(RecommendationPillarSpecificAggregates pillarSpecificAggregates) {
            this.pillarSpecificAggregates = pillarSpecificAggregates;
            return this;
        }

        public final Collection<String> getPillars() {
            if (pillars instanceof SdkAutoConstructList) {
                return null;
            }
            return pillars;
        }

        public final void setPillars(Collection<String> pillars) {
            this.pillars = RecommendationPillarListCopier.copy(pillars);
        }

        @Override
        public final Builder pillarsWithStrings(Collection<String> pillars) {
            this.pillars = RecommendationPillarListCopier.copy(pillars);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillarsWithStrings(String... pillars) {
            pillarsWithStrings(Arrays.asList(pillars));
            return this;
        }

        @Override
        public final Builder pillars(Collection<RecommendationPillar> pillars) {
            this.pillars = RecommendationPillarListCopier.copyEnumToString(pillars);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pillars(RecommendationPillar... pillars) {
            pillars(Arrays.asList(pillars));
            return this;
        }

        public final RecommendationResourcesAggregates.Builder getResourcesAggregates() {
            return resourcesAggregates != null ? resourcesAggregates.toBuilder() : null;
        }

        public final void setResourcesAggregates(RecommendationResourcesAggregates.BuilderImpl resourcesAggregates) {
            this.resourcesAggregates = resourcesAggregates != null ? resourcesAggregates.build() : null;
        }

        @Override
        public final Builder resourcesAggregates(RecommendationResourcesAggregates resourcesAggregates) {
            this.resourcesAggregates = resourcesAggregates;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(RecommendationSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecommendationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RecommendationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public RecommendationSummary build() {
            return new RecommendationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
