/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.utils.async;

import java.util.concurrent.LinkedBlockingQueue;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.async.BaseSubscriberAdapter;

@SdkProtectedApi
public class FlatteningSubscriber<U>
extends BaseSubscriberAdapter<Iterable<U>, U> {
    private final LinkedBlockingQueue<U> allItems = new LinkedBlockingQueue();

    public FlatteningSubscriber(Subscriber<? super U> subscriber) {
        super(subscriber);
    }

    @Override
    void doWithItem(Iterable<U> nextItems) {
        nextItems.forEach(item -> {
            Validate.notNull(nextItems, "Collections flattened by the flattening subscriber must not contain null.", new Object[0]);
            this.allItems.add(item);
        });
    }

    @Override
    protected void fulfillDownstreamDemand() {
        this.downstreamDemand.decrementAndGet();
        this.subscriber.onNext(this.allItems.poll());
    }

    @Override
    boolean additionalOnNextNeededCheck() {
        return !this.allItems.isEmpty();
    }

    @Override
    boolean additionalUpstreamDemandNeededCheck() {
        return this.allItems.isEmpty();
    }

    @Override
    boolean additionalOnCompleteNeededCheck() {
        return this.allItems.isEmpty();
    }

    @Override
    public void onNext(Iterable<U> item) {
        super.onNext(item);
    }
}

