/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration.internal.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.ContainerCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.EnvironmentVariableCredentialsProvider;
import software.amazon.awssdk.auth.credentials.InstanceProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProcessCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleWithWebIdentityCredentialsProvider;
import software.amazon.awssdk.services.sts.auth.StsGetSessionTokenCredentialsProvider;
import software.amazon.awssdk.utils.ImmutableMap;

@SdkInternalApi
public final class SdkTypeUtils {
    public static final Map<String, Integer> V2_CORE_CLASSES_WITH_STATIC_FACTORY = ImmutableMap.builder().put((Object)EnvironmentVariableCredentialsProvider.class.getCanonicalName(), (Object)0).put((Object)InstanceProfileCredentialsProvider.class.getCanonicalName(), (Object)0).put((Object)AwsBasicCredentials.class.getCanonicalName(), (Object)2).put((Object)AwsSessionCredentials.class.getCanonicalName(), (Object)3).put((Object)StaticCredentialsProvider.class.getCanonicalName(), (Object)1).build();
    private static final Pattern V1_SERVICE_CLASS_PATTERN = Pattern.compile("com\\.amazonaws\\.services\\.[a-zA-Z0-9]+\\.[a-zA-Z0-9]+");
    private static final Pattern V1_SERVICE_MODEL_CLASS_PATTERN = Pattern.compile("com\\.amazonaws\\.services\\.[a-zA-Z0-9]+\\.model\\.[a-zA-Z0-9]+");
    private static final Pattern V1_SERVICE_CLIENT_CLASS_PATTERN = Pattern.compile("com\\.amazonaws\\.services\\.[a-zA-Z0-9]+\\.[a-zA-Z0-9]+");
    private static final Pattern V1_SERVICE_CLIENT_BUILDER_CLASS_PATTERN = Pattern.compile("com\\.amazonaws\\.services\\.[a-zA-Z0-9]+\\.[a-zA-Z0-9]+Builder");
    private static final Pattern V2_MODEL_BUILDER_PATTERN = Pattern.compile("software\\.amazon\\.awssdk\\.services\\.[a-zA-Z0-9]+\\.model\\.[a-zA-Z0-9]+\\.Builder");
    private static final Pattern V2_MODEL_CLASS_PATTERN = Pattern.compile("software\\.amazon\\.awssdk\\.services\\.[a-zA-Z0-9]+\\.model\\..[a-zA-Z0-9]+");
    private static final Pattern V2_CLIENT_CLASS_PATTERN = Pattern.compile("software\\.amazon\\.awssdk\\.services\\.[a-zA-Z0-9]+\\.[a-zA-Z0-9]+");
    private static final Pattern V2_ASYNC_CLIENT_CLASS_PATTERN = Pattern.compile("software\\.amazon\\.awssdk\\.services\\.[a-zA-Z0-9]+\\.[a-zA-Z0-9]+AsyncClient");
    private static final Set<String> V2_CORE_CLASSES_WITH_BUILDER = new HashSet<String>(Arrays.asList(ClientOverrideConfiguration.class.getCanonicalName(), DefaultCredentialsProvider.class.getCanonicalName(), ProfileCredentialsProvider.class.getCanonicalName(), ContainerCredentialsProvider.class.getCanonicalName(), InstanceProfileCredentialsProvider.class.getCanonicalName(), StsAssumeRoleCredentialsProvider.class.getCanonicalName(), StsGetSessionTokenCredentialsProvider.class.getCanonicalName(), StsAssumeRoleWithWebIdentityCredentialsProvider.class.getCanonicalName(), ProcessCredentialsProvider.class.getCanonicalName()));
    private static final Pattern V2_CLIENT_BUILDER_PATTERN = Pattern.compile("software\\.amazon\\.awssdk\\.services\\.[a-zA-Z0-9]+\\.[a-zA-Z0-9]+Builder");

    private SdkTypeUtils() {
    }

    public static boolean isV1Class(JavaType type) {
        return type != null && type.isAssignableFrom(V1_SERVICE_CLASS_PATTERN);
    }

    public static boolean isV1ModelClass(JavaType type) {
        return type != null && type instanceof JavaType.FullyQualified && type.isAssignableFrom(V1_SERVICE_MODEL_CLASS_PATTERN);
    }

    public static boolean isV1ClientClass(JavaType type) {
        return type != null && type instanceof JavaType.FullyQualified && type.isAssignableFrom(V1_SERVICE_CLIENT_CLASS_PATTERN);
    }

    public static boolean isV2ModelBuilder(JavaType type) {
        return type != null && type.isAssignableFrom(V2_MODEL_BUILDER_PATTERN);
    }

    public static boolean isV2ModelClass(JavaType type) {
        return type != null && type.isAssignableFrom(V2_MODEL_CLASS_PATTERN);
    }

    public static boolean isV2ClientClass(JavaType type) {
        return type != null && type.isAssignableFrom(V2_CLIENT_CLASS_PATTERN);
    }

    public static boolean isV2AsyncClientClass(JavaType type) {
        return type != null && type.isAssignableFrom(V2_ASYNC_CLIENT_CLASS_PATTERN);
    }

    public static boolean isV2ClientBuilder(JavaType type) {
        return type != null && type.isAssignableFrom(V2_CLIENT_BUILDER_PATTERN);
    }

    public static boolean isEligibleToConvertToBuilder(JavaType.FullyQualified type) {
        if (type == null) {
            return false;
        }
        return SdkTypeUtils.isV2ModelClass((JavaType)type) || SdkTypeUtils.isV2ClientClass((JavaType)type) || SdkTypeUtils.isV2CoreClassesWithBuilder(type.getFullyQualifiedName());
    }

    public static boolean isEligibleToConvertToStaticFactory(JavaType.FullyQualified type) {
        return type != null && V2_CORE_CLASSES_WITH_STATIC_FACTORY.containsKey(type.getFullyQualifiedName());
    }

    private static boolean isV2CoreClassesWithBuilder(String fqcn) {
        return V2_CORE_CLASSES_WITH_BUILDER.contains(fqcn);
    }

    public static JavaType.FullyQualified v2Builder(JavaType.FullyQualified type) {
        if (!SdkTypeUtils.isEligibleToConvertToBuilder(type)) {
            throw new IllegalArgumentException(String.format("%s cannot be converted to builder", type));
        }
        String fqcn = SdkTypeUtils.isV2ModelClass((JavaType)type) ? String.format("%s.%s", type.getFullyQualifiedName(), "Builder") : String.format("%s%s", type.getFullyQualifiedName(), "Builder");
        return TypeUtils.asFullyQualified((JavaType)JavaType.buildType((String)fqcn));
    }

    public static JavaType.FullyQualified v2ClientFromClientBuilder(JavaType.FullyQualified type) {
        if (!SdkTypeUtils.isV2ClientBuilder((JavaType)type)) {
            throw new IllegalArgumentException(String.format("%s is not a client builder", type));
        }
        String builder = type.getFullyQualifiedName().replace("Builder", "");
        return TypeUtils.asFullyQualified((JavaType)JavaType.buildType((String)builder));
    }
}

