/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.RemoveImport;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.java.tree.TypedTree;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Pair;
import software.amazon.awssdk.v2migration.internal.utils.NamingConversionUtils;
import software.amazon.awssdk.v2migration.internal.utils.SdkTypeUtils;

@SdkInternalApi
public class ChangeSdkType
extends Recipe {
    private static final Logger log = Logger.loggerFor(ChangeSdkType.class);
    private static final String V1_SERVICE_MODEL_WILD_CARD_CLASS_PATTERN = "com\\.amazonaws\\.services\\.[a-zA-Z0-9]+\\.model\\.\\*";
    private static final String V1_SERVICE_WILD_CARD_CLASS_PATTERN = "com\\.amazonaws\\.services\\.[a-zA-Z0-9]+\\.\\*";
    private static final Set<String> PACKAGES_TO_SKIP = new HashSet<String>(Arrays.asList("com.amazonaws.services.s3.transfer", "com.amazonaws.services.dynamodbv2.datamodeling"));

    public String getDisplayName() {
        return "Change AWS SDK for Java v1 types to v2 equivalents";
    }

    public String getDescription() {
        return "Change AWS SDK for Java v1 types to v2 equivalents.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangeTypeVisitor();
    }

    private static JavaType.FullyQualified getTopLevelClassName(JavaType.FullyQualified classType) {
        while (classType.getOwningClass() != null) {
            classType = classType.getOwningClass();
        }
        return classType;
    }

    private static class ChangeTypeVisitor
    extends JavaVisitor<ExecutionContext> {
        private J.Identifier importAlias;
        private final Map<JavaType, JavaType> oldNameToChangedType = new IdentityHashMap<JavaType, JavaType>();
        private final Set<String> topLevelClassnames = new HashSet<String>();
        private final List<String> wildcardImports = new ArrayList<String>();
        private Map<String, Pair<JavaType.Class, JavaType>> oldTypeToNewType = new HashMap<String, Pair<JavaType.Class, JavaType>>();

        private ChangeTypeVisitor() {
        }

        public J visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = (J.ClassDeclaration)super.visitClassDeclaration(classDecl, (Object)ctx);
            if (cd.getType() != null) {
                this.topLevelClassnames.add(ChangeSdkType.getTopLevelClassName(cd.getType()).getFullyQualifiedName());
            }
            return cd;
        }

        public J visitImport(J.Import anImport, ExecutionContext ctx) {
            JavaType.FullyQualified fullyQualified = Optional.ofNullable(anImport.getQualid()).map(J.FieldAccess::getType).map(TypeUtils::asFullyQualified).orElse(null);
            if (fullyQualified == null) {
                String fullName = anImport.getTypeName();
                if (ChangeTypeVisitor.isWildcard(fullName)) {
                    this.maybeAddImport(NamingConversionUtils.getV2ModelPackageWildCardEquivalent(fullName));
                    this.wildcardImports.add(fullName);
                }
                return anImport;
            }
            String currentFqcn = fullyQualified.getFullyQualifiedName();
            if (ChangeTypeVisitor.isV1Class(fullyQualified)) {
                this.storeV1ClassMetadata(currentFqcn);
                if (anImport.getAlias() != null) {
                    this.importAlias = anImport.getAlias();
                }
            }
            return anImport;
        }

        private static boolean isWildcard(String fullName) {
            return fullName.matches(ChangeSdkType.V1_SERVICE_MODEL_WILD_CARD_CLASS_PATTERN) || fullName.matches(ChangeSdkType.V1_SERVICE_WILD_CARD_CLASS_PATTERN);
        }

        private static boolean isV1Class(JavaType.FullyQualified fullyQualified) {
            String fullyQualifiedName = fullyQualified.getFullyQualifiedName();
            if (ChangeTypeVisitor.shouldSkip(fullyQualifiedName)) {
                log.info(() -> String.format("Skipping transformation for %s because it is not supported in the migration tooling at the moment", fullyQualifiedName));
                return false;
            }
            return SdkTypeUtils.isV1ModelClass((JavaType)fullyQualified) || SdkTypeUtils.isV1ClientClass((JavaType)fullyQualified);
        }

        private static boolean shouldSkip(String fqcn) {
            return PACKAGES_TO_SKIP.stream().anyMatch(fqcn::startsWith);
        }

        public JavaType visitType(JavaType javaType, ExecutionContext ctx) {
            if (javaType == null || javaType instanceof JavaType.Unknown) {
                return javaType;
            }
            return this.updateType(javaType);
        }

        private void addImport(JavaType.FullyQualified owningClass) {
            if (this.importAlias != null) {
                this.maybeAddImport(owningClass.getPackageName(), owningClass.getClassName(), null, this.importAlias.getSimpleName(), true);
            }
            this.maybeAddImport(owningClass.getPackageName(), owningClass.getClassName(), null, null, true);
        }

        public J postVisit(J tree, ExecutionContext ctx) {
            J currentTree = (J)super.postVisit((Tree)tree, (Object)ctx);
            if (currentTree instanceof J.ArrayType) {
                J.ArrayType arrayType = (J.ArrayType)currentTree;
                JavaType type = this.updateType(arrayType.getType());
                currentTree = arrayType.withType(type);
            } else if (currentTree instanceof J.MethodDeclaration) {
                J.MethodDeclaration method = (J.MethodDeclaration)currentTree;
                JavaType.Method mt = this.updateType(method.getMethodType());
                currentTree = method.withMethodType(mt).withName(method.getName().withType((JavaType)mt));
            } else if (currentTree instanceof J.MethodInvocation) {
                J.MethodInvocation method = (J.MethodInvocation)currentTree;
                JavaType.Method mt = this.updateType(method.getMethodType());
                currentTree = method.withMethodType(mt).withName(method.getName().withType((JavaType)mt));
            } else if (currentTree instanceof J.NewClass) {
                J.NewClass n = (J.NewClass)currentTree;
                currentTree = n.withConstructorType(this.updateType(n.getConstructorType()));
            } else if (tree instanceof TypedTree) {
                currentTree = ((TypedTree)tree).withType(this.updateType(((TypedTree)tree).getType()));
            } else if (tree instanceof JavaSourceFile) {
                currentTree = this.postVisitSourceFile((JavaSourceFile)tree, ctx, currentTree);
            }
            return currentTree;
        }

        private J postVisitSourceFile(JavaSourceFile tree, ExecutionContext ctx, J currentTree) {
            JavaSourceFile sourceFile = tree;
            for (Pair<JavaType.Class, JavaType> oldToNew : this.oldTypeToNewType.values()) {
                JavaType.FullyQualified fullyQualifiedTarget;
                JavaType.Class originalType = (JavaType.Class)oldToNew.left();
                JavaType targetType = (JavaType)oldToNew.right();
                if (targetType instanceof JavaType.FullyQualified) {
                    for (J.Import anImport : sourceFile.getImports()) {
                        JavaType maybeType;
                        if (anImport.isStatic() || !((maybeType = anImport.getQualid().getType()) instanceof JavaType.FullyQualified)) continue;
                        JavaType.FullyQualified type = (JavaType.FullyQualified)maybeType;
                        String fullyQualifiedName = originalType.getFullyQualifiedName();
                        if (fullyQualifiedName.equals(type.getFullyQualifiedName())) {
                            sourceFile = (JavaSourceFile)new RemoveImport(fullyQualifiedName).visit((Tree)sourceFile, (Object)ctx, this.getCursor().getParentOrThrow());
                            continue;
                        }
                        if (originalType.getOwningClass() == null || !originalType.getOwningClass().getFullyQualifiedName().equals(type.getFullyQualifiedName())) continue;
                        sourceFile = (JavaSourceFile)new RemoveImport(originalType.getOwningClass().getFullyQualifiedName()).visit((Tree)sourceFile, (Object)ctx, this.getCursor().getParentOrThrow());
                    }
                }
                if ((fullyQualifiedTarget = TypeUtils.asFullyQualified((JavaType)targetType)) != null) {
                    JavaType.FullyQualified owningClass = fullyQualifiedTarget.getOwningClass();
                    if (!this.topLevelClassnames.contains(ChangeSdkType.getTopLevelClassName(fullyQualifiedTarget).getFullyQualifiedName())) {
                        if (owningClass != null) {
                            this.addImport(owningClass);
                        }
                        this.addImport(fullyQualifiedTarget);
                    }
                }
                if (sourceFile != null) {
                    sourceFile = sourceFile.withImports(ListUtils.map((List)sourceFile.getImports(), i -> (J.Import)this.visitAndCast((Tree)i, ctx, (x$0, x$1) -> super.visitImport(x$0, x$1))));
                }
                currentTree = sourceFile;
            }
            return this.removeWildcardImports(ctx, currentTree, sourceFile);
        }

        private J removeWildcardImports(ExecutionContext ctx, J currentTree, JavaSourceFile sourceFile) {
            for (String fqcn : this.wildcardImports) {
                sourceFile = (JavaSourceFile)new RemoveImport(fqcn).visit((Tree)sourceFile, (Object)ctx, this.getCursor().getParentOrThrow());
                if (sourceFile != null) {
                    sourceFile = sourceFile.withImports(ListUtils.map((List)sourceFile.getImports(), i -> (J.Import)this.visitAndCast((Tree)i, ctx, (x$0, x$1) -> super.visitImport(x$0, x$1))));
                }
                currentTree = sourceFile;
            }
            return currentTree;
        }

        public J visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
            for (Pair<JavaType.Class, JavaType> entry : this.oldTypeToNewType.values()) {
                JavaType.Class originalType = (JavaType.Class)entry.left();
                JavaType targetType = (JavaType)entry.right();
                if (fieldAccess.isFullyQualifiedClassReference(originalType.getFullyQualifiedName())) {
                    if (!(targetType instanceof JavaType.FullyQualified)) continue;
                    return this.updateOuterClassTypes((Expression)TypeTree.build((String)((JavaType.FullyQualified)targetType).getFullyQualifiedName()).withPrefix(fieldAccess.getPrefix()), targetType);
                }
                StringBuilder maybeClass = new StringBuilder();
                J.FieldAccess target = fieldAccess;
                while (target != null) {
                    if (target instanceof J.FieldAccess) {
                        J.FieldAccess fa = target;
                        maybeClass.insert(0, fa.getSimpleName()).insert(0, '.');
                        target = fa.getTarget();
                        continue;
                    }
                    if (target instanceof J.Identifier) {
                        maybeClass.insert(0, ((J.Identifier)target).getSimpleName());
                        target = null;
                        continue;
                    }
                    maybeClass = new StringBuilder("__NOT_IT__");
                    break;
                }
                JavaType.ShallowClass oldType = JavaType.ShallowClass.build((String)originalType.getFullyQualifiedName());
                if (!maybeClass.toString().equals(oldType.getClassName())) continue;
                this.maybeRemoveImport(oldType.getOwningClass());
                Expression e = this.updateOuterClassTypes((Expression)TypeTree.build((String)((JavaType.FullyQualified)targetType).getClassName()).withPrefix(fieldAccess.getPrefix()), targetType);
                if (e instanceof J.Identifier && e.getType() == null) {
                    J.Identifier i = (J.Identifier)e;
                    e = i.withType(targetType);
                }
                return e;
            }
            return super.visitFieldAccess(fieldAccess, (Object)ctx);
        }

        public J visitIdentifier(J.Identifier ident, ExecutionContext ctx) {
            JavaType currentType = ident.getType();
            if (!(currentType instanceof JavaType.FullyQualified)) {
                return (J)this.visitAndCast((Tree)ident, ctx, (x$0, x$1) -> super.visitIdentifier(x$0, x$1));
            }
            JavaType.FullyQualified original = TypeUtils.asFullyQualified((JavaType)currentType);
            if (original != null && TypeUtils.isOfClassType((JavaType)ident.getType(), (String)original.getFullyQualifiedName())) {
                String fullyQualifiedName = original.getFullyQualifiedName();
                if (ChangeTypeVisitor.isV1Class(original)) {
                    this.storeV1ClassMetadata(fullyQualifiedName);
                    JavaType.Class originalType = (JavaType.Class)this.oldTypeToNewType.get(fullyQualifiedName).left();
                    String className = originalType.getClassName();
                    if (ident.getSimpleName().equals(className)) {
                        JavaType targetType = (JavaType)this.oldTypeToNewType.get(fullyQualifiedName).right();
                        ident = ident.withSimpleName(((JavaType.FullyQualified)targetType).getClassName());
                        ident = ident.withType(this.updateType(currentType));
                    }
                }
            }
            return (J)this.visitAndCast((Tree)ident, ctx, (x$0, x$1) -> super.visitIdentifier(x$0, x$1));
        }

        private void storeV1ClassMetadata(String currentFqcn) {
            JavaType.ShallowClass originalType = JavaType.ShallowClass.build((String)currentFqcn);
            String v2Equivalent = NamingConversionUtils.getV2Equivalent(currentFqcn);
            JavaType targetType = JavaType.buildType((String)v2Equivalent);
            this.oldTypeToNewType.put(currentFqcn, (Pair<JavaType.Class, JavaType>)Pair.of((Object)originalType, (Object)targetType));
        }

        public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (method.getMethodType() == null) {
                return method;
            }
            JavaType.FullyQualified declaringType = method.getMethodType().getDeclaringType();
            if (ChangeTypeVisitor.isV1Class(declaringType)) {
                String fullyQualifiedName = declaringType.getFullyQualifiedName();
                this.storeV1ClassMetadata(fullyQualifiedName);
                Pair<JavaType.Class, JavaType> oldTypeToNewTypePair = this.oldTypeToNewType.get(fullyQualifiedName);
                JavaType.Class originalType = (JavaType.Class)oldTypeToNewTypePair.left();
                JavaType targetType = (JavaType)oldTypeToNewTypePair.right();
                if (method.getMethodType().hasFlags(new Flag[]{Flag.Static}) && method.getMethodType().getDeclaringType().isAssignableFrom((JavaType)originalType)) {
                    JavaSourceFile cu = (JavaSourceFile)this.getCursor().firstEnclosingOrThrow(JavaSourceFile.class);
                    for (J.Import anImport : cu.getImports()) {
                        JavaType.FullyQualified fqn;
                        if (!anImport.isStatic() || anImport.getQualid().getTarget().getType() == null || (fqn = TypeUtils.asFullyQualified((JavaType)anImport.getQualid().getTarget().getType())) == null || !TypeUtils.isOfClassType((JavaType)fqn, (String)originalType.getFullyQualifiedName()) || !method.getSimpleName().equals(anImport.getQualid().getSimpleName())) continue;
                        JavaType.FullyQualified targetFqn = (JavaType.FullyQualified)targetType;
                        this.addImport(targetFqn);
                        this.maybeAddImport(targetFqn.getFullyQualifiedName(), method.getName().getSimpleName());
                        break;
                    }
                }
            }
            return super.visitMethodInvocation(method, (Object)ctx);
        }

        private Expression updateOuterClassTypes(Expression typeTree, JavaType targetType) {
            if (!(typeTree instanceof J.FieldAccess)) {
                return typeTree;
            }
            JavaType.FullyQualified type = (JavaType.FullyQualified)targetType;
            if (type.getOwningClass() == null) {
                typeTree.withType(this.updateType(targetType));
            }
            Stack<Expression> typeStack = new Stack<Expression>();
            typeStack.push(typeTree);
            Stack<JavaType.FullyQualified> attrStack = new Stack<JavaType.FullyQualified>();
            attrStack.push(type);
            Expression t = ((J.FieldAccess)typeTree).getTarget();
            while (true) {
                typeStack.push(t);
                if (t instanceof J.FieldAccess) {
                    if (Character.isUpperCase(((J.FieldAccess)t).getSimpleName().charAt(0)) && ((JavaType.FullyQualified)attrStack.peek()).getOwningClass() != null) {
                        attrStack.push(((JavaType.FullyQualified)attrStack.peek()).getOwningClass());
                    }
                    t = ((J.FieldAccess)t).getTarget();
                    continue;
                }
                if (t instanceof J.Identifier) break;
            }
            if (Character.isUpperCase(((J.Identifier)t).getSimpleName().charAt(0)) && ((JavaType.FullyQualified)attrStack.peek()).getOwningClass() != null) {
                attrStack.push(((JavaType.FullyQualified)attrStack.peek()).getOwningClass());
            }
            Object attributed = null;
            Expression e = (Expression)typeStack.pop();
            while (true) {
                if (e instanceof J.Identifier) {
                    attributed = attrStack.size() == typeStack.size() + 1 ? ((J.Identifier)e).withType((JavaType)attrStack.pop()) : e;
                } else if (e instanceof J.FieldAccess) {
                    attributed = attrStack.size() == typeStack.size() + 1 ? ((J.FieldAccess)e).withTarget(attributed).withType((JavaType)attrStack.pop()) : ((J.FieldAccess)e).withTarget(attributed);
                }
                if (typeStack.isEmpty()) break;
                e = (Expression)typeStack.pop();
            }
            assert (attributed != null);
            return attributed;
        }

        private JavaType updateType(JavaType currentType) {
            JavaType type = this.oldNameToChangedType.get(currentType);
            if (type != null) {
                return type;
            }
            if (currentType instanceof JavaType.FullyQualified) {
                return this.updateFullyQualifiedType(currentType);
            }
            if (currentType instanceof JavaType.Variable) {
                return this.updateVariableType(currentType);
            }
            if (currentType instanceof JavaType.Array) {
                return this.updateArrayType(currentType);
            }
            return currentType;
        }

        private JavaType.Array updateArrayType(JavaType currentType) {
            JavaType.Array array = (JavaType.Array)currentType;
            array = array.withElemType(this.updateType(array.getElemType()));
            this.oldNameToChangedType.put(currentType, (JavaType)array);
            this.oldNameToChangedType.put((JavaType)array, (JavaType)array);
            return array;
        }

        private JavaType.Variable updateVariableType(JavaType currentType) {
            JavaType.Variable variable = (JavaType.Variable)currentType;
            variable = variable.withOwner(this.updateType(variable.getOwner()));
            variable = variable.withType(this.updateType(variable.getType()));
            this.oldNameToChangedType.put(currentType, (JavaType)variable);
            this.oldNameToChangedType.put((JavaType)variable, (JavaType)variable);
            return variable;
        }

        private JavaType updateFullyQualifiedType(JavaType currentType) {
            JavaType.FullyQualified targetTypeEnum;
            JavaType.FullyQualified original = TypeUtils.asFullyQualified((JavaType)currentType);
            if (original == null) {
                return currentType;
            }
            String fullyQualifiedName = original.getFullyQualifiedName();
            if (!this.oldTypeToNewType.keySet().contains(fullyQualifiedName)) {
                return currentType;
            }
            Pair<JavaType.Class, JavaType> oldToNewPair = this.oldTypeToNewType.get(fullyQualifiedName);
            JavaType targetType = (JavaType)oldToNewPair.right();
            if (original.getKind() == JavaType.FullyQualified.Kind.Enum && (targetTypeEnum = TypeUtils.asFullyQualified((JavaType)targetType)) != null) {
                JavaType.Class enumType = JavaType.ShallowClass.build((String)targetTypeEnum.getFullyQualifiedName()).withKind(JavaType.FullyQualified.Kind.Enum);
                this.oldNameToChangedType.put(currentType, (JavaType)enumType);
                return enumType;
            }
            this.oldNameToChangedType.put(currentType, targetType);
            return targetType;
        }

        private JavaType.Method updateType(JavaType.Method oldMethodType) {
            if (oldMethodType != null) {
                JavaType.Method method = (JavaType.Method)this.oldNameToChangedType.get(oldMethodType);
                if (method != null) {
                    return method;
                }
                method = oldMethodType;
                method = method.withDeclaringType((JavaType.FullyQualified)this.updateType((JavaType)method.getDeclaringType())).withReturnType(this.updateType(method.getReturnType())).withParameterTypes(ListUtils.map((List)method.getParameterTypes(), this::updateType));
                this.oldNameToChangedType.put((JavaType)oldMethodType, (JavaType)method);
                this.oldNameToChangedType.put((JavaType)method, (JavaType)method);
                return method;
            }
            return null;
        }
    }
}

