/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains configuration information used when creating a new identity source.
 * </p>
 * <note>
 * <p>
 * At this time, the only valid member of this structure is a Amazon Cognito user pool configuration.
 * </p>
 * <p>
 * You must specify a <code>userPoolArn</code>, and optionally, a <code>ClientId</code>.
 * </p>
 * </note>
 * <p>
 * This data type is used as a request parameter for the <a
 * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_CreateIdentitySource.html"
 * >CreateIdentitySource</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Configuration implements SdkPojo, Serializable, ToCopyableBuilder<Configuration.Builder, Configuration> {
    private static final SdkField<CognitoUserPoolConfiguration> COGNITO_USER_POOL_CONFIGURATION_FIELD = SdkField
            .<CognitoUserPoolConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("cognitoUserPoolConfiguration")
            .getter(getter(Configuration::cognitoUserPoolConfiguration))
            .setter(setter(Builder::cognitoUserPoolConfiguration))
            .constructor(CognitoUserPoolConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cognitoUserPoolConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COGNITO_USER_POOL_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final CognitoUserPoolConfiguration cognitoUserPoolConfiguration;

    private final Type type;

    private Configuration(BuilderImpl builder) {
        this.cognitoUserPoolConfiguration = builder.cognitoUserPoolConfiguration;
        this.type = builder.type;
    }

    /**
     * <p>
     * Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a source of
     * authenticated identities as entities. It specifies the <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a>
     * of a Amazon Cognito user pool and one or more application client IDs.
     * </p>
     * <p>
     * Example:
     * <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"]}}</code>
     * </p>
     * 
     * @return Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a
     *         source of authenticated identities as entities. It specifies the <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *         (ARN)</a> of a Amazon Cognito user pool and one or more application client IDs.</p>
     *         <p>
     *         Example:
     *         <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"]}}</code>
     */
    public final CognitoUserPoolConfiguration cognitoUserPoolConfiguration() {
        return cognitoUserPoolConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cognitoUserPoolConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration) obj;
        return Objects.equals(cognitoUserPoolConfiguration(), other.cognitoUserPoolConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Configuration").add("CognitoUserPoolConfiguration", cognitoUserPoolConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cognitoUserPoolConfiguration":
            return Optional.ofNullable(clazz.cast(cognitoUserPoolConfiguration()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #cognitoUserPoolConfiguration()} initialized to the given value.
     *
     * <p>
     * Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a source of
     * authenticated identities as entities. It specifies the <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a>
     * of a Amazon Cognito user pool and one or more application client IDs.
     * </p>
     * <p>
     * Example:
     * <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"]}}</code>
     * </p>
     * 
     * @param cognitoUserPoolConfiguration
     *        Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a source
     *        of authenticated identities as entities. It specifies the <a
     *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *        (ARN)</a> of a Amazon Cognito user pool and one or more application client IDs.</p>
     *        <p>
     *        Example:
     *        <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"]}}</code>
     */
    public static Configuration fromCognitoUserPoolConfiguration(CognitoUserPoolConfiguration cognitoUserPoolConfiguration) {
        return builder().cognitoUserPoolConfiguration(cognitoUserPoolConfiguration).build();
    }

    /**
     * Create an instance of this class with {@link #cognitoUserPoolConfiguration()} initialized to the given value.
     *
     * <p>
     * Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a source of
     * authenticated identities as entities. It specifies the <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name (ARN)</a>
     * of a Amazon Cognito user pool and one or more application client IDs.
     * </p>
     * <p>
     * Example:
     * <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"]}}</code>
     * </p>
     * 
     * @param cognitoUserPoolConfiguration
     *        Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a source
     *        of authenticated identities as entities. It specifies the <a
     *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
     *        (ARN)</a> of a Amazon Cognito user pool and one or more application client IDs.</p>
     *        <p>
     *        Example:
     *        <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"]}}</code>
     */
    public static Configuration fromCognitoUserPoolConfiguration(
            Consumer<CognitoUserPoolConfiguration.Builder> cognitoUserPoolConfiguration) {
        CognitoUserPoolConfiguration.Builder builder = CognitoUserPoolConfiguration.builder();
        cognitoUserPoolConfiguration.accept(builder);
        return fromCognitoUserPoolConfiguration(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Configuration, T> g) {
        return obj -> g.apply((Configuration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Configuration> {
        /**
         * <p>
         * Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a source of
         * authenticated identities as entities. It specifies the <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         * (ARN)</a> of a Amazon Cognito user pool and one or more application client IDs.
         * </p>
         * <p>
         * Example:
         * <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"]}}</code>
         * </p>
         * 
         * @param cognitoUserPoolConfiguration
         *        Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a
         *        source of authenticated identities as entities. It specifies the <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         *        (ARN)</a> of a Amazon Cognito user pool and one or more application client IDs.</p>
         *        <p>
         *        Example:
         *        <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"]}}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cognitoUserPoolConfiguration(CognitoUserPoolConfiguration cognitoUserPoolConfiguration);

        /**
         * <p>
         * Contains configuration details of a Amazon Cognito user pool that Verified Permissions can use as a source of
         * authenticated identities as entities. It specifies the <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Name
         * (ARN)</a> of a Amazon Cognito user pool and one or more application client IDs.
         * </p>
         * <p>
         * Example:
         * <code>"configuration":{"cognitoUserPoolConfiguration":{"userPoolArn":"cognito-idp:us-east-1:123456789012:userpool/us-east-1_1a2b3c4d5","clientIds": ["a1b2c3d4e5f6g7h8i9j0kalbmc"]}}</code>
         * </p>
         * This is a convenience method that creates an instance of the {@link CognitoUserPoolConfiguration.Builder}
         * avoiding the need to create one manually via {@link CognitoUserPoolConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CognitoUserPoolConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #cognitoUserPoolConfiguration(CognitoUserPoolConfiguration)}.
         * 
         * @param cognitoUserPoolConfiguration
         *        a consumer that will call methods on {@link CognitoUserPoolConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cognitoUserPoolConfiguration(CognitoUserPoolConfiguration)
         */
        default Builder cognitoUserPoolConfiguration(Consumer<CognitoUserPoolConfiguration.Builder> cognitoUserPoolConfiguration) {
            return cognitoUserPoolConfiguration(CognitoUserPoolConfiguration.builder()
                    .applyMutation(cognitoUserPoolConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CognitoUserPoolConfiguration cognitoUserPoolConfiguration;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Configuration model) {
            cognitoUserPoolConfiguration(model.cognitoUserPoolConfiguration);
        }

        public final CognitoUserPoolConfiguration.Builder getCognitoUserPoolConfiguration() {
            return cognitoUserPoolConfiguration != null ? cognitoUserPoolConfiguration.toBuilder() : null;
        }

        public final void setCognitoUserPoolConfiguration(CognitoUserPoolConfiguration.BuilderImpl cognitoUserPoolConfiguration) {
            Object oldValue = this.cognitoUserPoolConfiguration;
            this.cognitoUserPoolConfiguration = cognitoUserPoolConfiguration != null ? cognitoUserPoolConfiguration.build()
                    : null;
            handleUnionValueChange(Type.COGNITO_USER_POOL_CONFIGURATION, oldValue, this.cognitoUserPoolConfiguration);
        }

        @Override
        public final Builder cognitoUserPoolConfiguration(CognitoUserPoolConfiguration cognitoUserPoolConfiguration) {
            Object oldValue = this.cognitoUserPoolConfiguration;
            this.cognitoUserPoolConfiguration = cognitoUserPoolConfiguration;
            handleUnionValueChange(Type.COGNITO_USER_POOL_CONFIGURATION, oldValue, this.cognitoUserPoolConfiguration);
            return this;
        }

        @Override
        public Configuration build() {
            return new Configuration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Configuration#type()
     */
    public enum Type {
        COGNITO_USER_POOL_CONFIGURATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
