/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSchemaRequest extends VerifiedPermissionsRequest implements
        ToCopyableBuilder<PutSchemaRequest.Builder, PutSchemaRequest> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyStoreId").getter(getter(PutSchemaRequest::policyStoreId)).setter(setter(Builder::policyStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()).build();

    private static final SdkField<SchemaDefinition> DEFINITION_FIELD = SdkField
            .<SchemaDefinition> builder(MarshallingType.SDK_POJO).memberName("definition")
            .getter(getter(PutSchemaRequest::definition)).setter(setter(Builder::definition))
            .constructor(SchemaDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD,
            DEFINITION_FIELD));

    private final String policyStoreId;

    private final SchemaDefinition definition;

    private PutSchemaRequest(BuilderImpl builder) {
        super(builder);
        this.policyStoreId = builder.policyStoreId;
        this.definition = builder.definition;
    }

    /**
     * <p>
     * Specifies the ID of the policy store in which to place the schema.
     * </p>
     * 
     * @return Specifies the ID of the policy store in which to place the schema.
     */
    public final String policyStoreId() {
        return policyStoreId;
    }

    /**
     * <p>
     * Specifies the definition of the schema to be stored. The schema definition must be written in Cedar schema JSON.
     * </p>
     * 
     * @return Specifies the definition of the schema to be stored. The schema definition must be written in Cedar
     *         schema JSON.
     */
    public final SchemaDefinition definition() {
        return definition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSchemaRequest)) {
            return false;
        }
        PutSchemaRequest other = (PutSchemaRequest) obj;
        return Objects.equals(policyStoreId(), other.policyStoreId()) && Objects.equals(definition(), other.definition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSchemaRequest").add("PolicyStoreId", policyStoreId()).add("Definition", definition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyStoreId":
            return Optional.ofNullable(clazz.cast(policyStoreId()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSchemaRequest, T> g) {
        return obj -> g.apply((PutSchemaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VerifiedPermissionsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutSchemaRequest> {
        /**
         * <p>
         * Specifies the ID of the policy store in which to place the schema.
         * </p>
         * 
         * @param policyStoreId
         *        Specifies the ID of the policy store in which to place the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStoreId(String policyStoreId);

        /**
         * <p>
         * Specifies the definition of the schema to be stored. The schema definition must be written in Cedar schema
         * JSON.
         * </p>
         * 
         * @param definition
         *        Specifies the definition of the schema to be stored. The schema definition must be written in Cedar
         *        schema JSON.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(SchemaDefinition definition);

        /**
         * <p>
         * Specifies the definition of the schema to be stored. The schema definition must be written in Cedar schema
         * JSON.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaDefinition.Builder} avoiding the
         * need to create one manually via {@link SchemaDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #definition(SchemaDefinition)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link SchemaDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(SchemaDefinition)
         */
        default Builder definition(Consumer<SchemaDefinition.Builder> definition) {
            return definition(SchemaDefinition.builder().applyMutation(definition).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VerifiedPermissionsRequest.BuilderImpl implements Builder {
        private String policyStoreId;

        private SchemaDefinition definition;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSchemaRequest model) {
            super(model);
            policyStoreId(model.policyStoreId);
            definition(model.definition);
        }

        public final String getPolicyStoreId() {
            return policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final SchemaDefinition.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        public final void setDefinition(SchemaDefinition.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public final Builder definition(SchemaDefinition definition) {
            this.definition = definition;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSchemaRequest build() {
            return new PutSchemaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
