/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The decision, based on policy evaluation, from an individual authorization request in a
 * <code>BatchIsAuthorized</code> API request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchIsAuthorizedOutputItem implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchIsAuthorizedOutputItem.Builder, BatchIsAuthorizedOutputItem> {
    private static final SdkField<BatchIsAuthorizedInputItem> REQUEST_FIELD = SdkField
            .<BatchIsAuthorizedInputItem> builder(MarshallingType.SDK_POJO).memberName("request")
            .getter(getter(BatchIsAuthorizedOutputItem::request)).setter(setter(Builder::request))
            .constructor(BatchIsAuthorizedInputItem::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("request").build()).build();

    private static final SdkField<String> DECISION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("decision").getter(getter(BatchIsAuthorizedOutputItem::decisionAsString))
            .setter(setter(Builder::decision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decision").build()).build();

    private static final SdkField<List<DeterminingPolicyItem>> DETERMINING_POLICIES_FIELD = SdkField
            .<List<DeterminingPolicyItem>> builder(MarshallingType.LIST)
            .memberName("determiningPolicies")
            .getter(getter(BatchIsAuthorizedOutputItem::determiningPolicies))
            .setter(setter(Builder::determiningPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("determiningPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeterminingPolicyItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeterminingPolicyItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EvaluationErrorItem>> ERRORS_FIELD = SdkField
            .<List<EvaluationErrorItem>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchIsAuthorizedOutputItem::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationErrorItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(EvaluationErrorItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_FIELD, DECISION_FIELD,
            DETERMINING_POLICIES_FIELD, ERRORS_FIELD));

    private static final long serialVersionUID = 1L;

    private final BatchIsAuthorizedInputItem request;

    private final String decision;

    private final List<DeterminingPolicyItem> determiningPolicies;

    private final List<EvaluationErrorItem> errors;

    private BatchIsAuthorizedOutputItem(BuilderImpl builder) {
        this.request = builder.request;
        this.decision = builder.decision;
        this.determiningPolicies = builder.determiningPolicies;
        this.errors = builder.errors;
    }

    /**
     * <p>
     * The authorization request that initiated the decision.
     * </p>
     * 
     * @return The authorization request that initiated the decision.
     */
    public final BatchIsAuthorizedInputItem request() {
        return request;
    }

    /**
     * <p>
     * An authorization decision that indicates if the authorization request should be allowed or denied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #decision} will
     * return {@link Decision#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #decisionAsString}.
     * </p>
     * 
     * @return An authorization decision that indicates if the authorization request should be allowed or denied.
     * @see Decision
     */
    public final Decision decision() {
        return Decision.fromValue(decision);
    }

    /**
     * <p>
     * An authorization decision that indicates if the authorization request should be allowed or denied.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #decision} will
     * return {@link Decision#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #decisionAsString}.
     * </p>
     * 
     * @return An authorization decision that indicates if the authorization request should be allowed or denied.
     * @see Decision
     */
    public final String decisionAsString() {
        return decision;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeterminingPolicies property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeterminingPolicies() {
        return determiningPolicies != null && !(determiningPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of determining policies used to make the authorization decision. For example, if there are two matching
     * policies, where one is a forbid and the other is a permit, then the forbid policy will be the determining policy.
     * In the case of multiple matching permit policies then there would be multiple determining policies. In the case
     * that no policies match, and hence the response is DENY, there would be no determining policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeterminingPolicies} method.
     * </p>
     * 
     * @return The list of determining policies used to make the authorization decision. For example, if there are two
     *         matching policies, where one is a forbid and the other is a permit, then the forbid policy will be the
     *         determining policy. In the case of multiple matching permit policies then there would be multiple
     *         determining policies. In the case that no policies match, and hence the response is DENY, there would be
     *         no determining policies.
     */
    public final List<DeterminingPolicyItem> determiningPolicies() {
        return determiningPolicies;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Errors that occurred while making an authorization decision, for example, a policy references an Entity or entity
     * Attribute that does not exist in the slice.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Errors that occurred while making an authorization decision, for example, a policy references an Entity
     *         or entity Attribute that does not exist in the slice.
     */
    public final List<EvaluationErrorItem> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(request());
        hashCode = 31 * hashCode + Objects.hashCode(decisionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasDeterminingPolicies() ? determiningPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchIsAuthorizedOutputItem)) {
            return false;
        }
        BatchIsAuthorizedOutputItem other = (BatchIsAuthorizedOutputItem) obj;
        return Objects.equals(request(), other.request()) && Objects.equals(decisionAsString(), other.decisionAsString())
                && hasDeterminingPolicies() == other.hasDeterminingPolicies()
                && Objects.equals(determiningPolicies(), other.determiningPolicies()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchIsAuthorizedOutputItem").add("Request", request()).add("Decision", decisionAsString())
                .add("DeterminingPolicies", hasDeterminingPolicies() ? determiningPolicies() : null)
                .add("Errors", errors() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "request":
            return Optional.ofNullable(clazz.cast(request()));
        case "decision":
            return Optional.ofNullable(clazz.cast(decisionAsString()));
        case "determiningPolicies":
            return Optional.ofNullable(clazz.cast(determiningPolicies()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchIsAuthorizedOutputItem, T> g) {
        return obj -> g.apply((BatchIsAuthorizedOutputItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchIsAuthorizedOutputItem> {
        /**
         * <p>
         * The authorization request that initiated the decision.
         * </p>
         * 
         * @param request
         *        The authorization request that initiated the decision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder request(BatchIsAuthorizedInputItem request);

        /**
         * <p>
         * The authorization request that initiated the decision.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchIsAuthorizedInputItem.Builder}
         * avoiding the need to create one manually via {@link BatchIsAuthorizedInputItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchIsAuthorizedInputItem.Builder#build()} is called immediately
         * and its result is passed to {@link #request(BatchIsAuthorizedInputItem)}.
         * 
         * @param request
         *        a consumer that will call methods on {@link BatchIsAuthorizedInputItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #request(BatchIsAuthorizedInputItem)
         */
        default Builder request(Consumer<BatchIsAuthorizedInputItem.Builder> request) {
            return request(BatchIsAuthorizedInputItem.builder().applyMutation(request).build());
        }

        /**
         * <p>
         * An authorization decision that indicates if the authorization request should be allowed or denied.
         * </p>
         * 
         * @param decision
         *        An authorization decision that indicates if the authorization request should be allowed or denied.
         * @see Decision
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Decision
         */
        Builder decision(String decision);

        /**
         * <p>
         * An authorization decision that indicates if the authorization request should be allowed or denied.
         * </p>
         * 
         * @param decision
         *        An authorization decision that indicates if the authorization request should be allowed or denied.
         * @see Decision
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Decision
         */
        Builder decision(Decision decision);

        /**
         * <p>
         * The list of determining policies used to make the authorization decision. For example, if there are two
         * matching policies, where one is a forbid and the other is a permit, then the forbid policy will be the
         * determining policy. In the case of multiple matching permit policies then there would be multiple determining
         * policies. In the case that no policies match, and hence the response is DENY, there would be no determining
         * policies.
         * </p>
         * 
         * @param determiningPolicies
         *        The list of determining policies used to make the authorization decision. For example, if there are
         *        two matching policies, where one is a forbid and the other is a permit, then the forbid policy will be
         *        the determining policy. In the case of multiple matching permit policies then there would be multiple
         *        determining policies. In the case that no policies match, and hence the response is DENY, there would
         *        be no determining policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder determiningPolicies(Collection<DeterminingPolicyItem> determiningPolicies);

        /**
         * <p>
         * The list of determining policies used to make the authorization decision. For example, if there are two
         * matching policies, where one is a forbid and the other is a permit, then the forbid policy will be the
         * determining policy. In the case of multiple matching permit policies then there would be multiple determining
         * policies. In the case that no policies match, and hence the response is DENY, there would be no determining
         * policies.
         * </p>
         * 
         * @param determiningPolicies
         *        The list of determining policies used to make the authorization decision. For example, if there are
         *        two matching policies, where one is a forbid and the other is a permit, then the forbid policy will be
         *        the determining policy. In the case of multiple matching permit policies then there would be multiple
         *        determining policies. In the case that no policies match, and hence the response is DENY, there would
         *        be no determining policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder determiningPolicies(DeterminingPolicyItem... determiningPolicies);

        /**
         * <p>
         * The list of determining policies used to make the authorization decision. For example, if there are two
         * matching policies, where one is a forbid and the other is a permit, then the forbid policy will be the
         * determining policy. In the case of multiple matching permit policies then there would be multiple determining
         * policies. In the case that no policies match, and hence the response is DENY, there would be no determining
         * policies.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.DeterminingPolicyItem.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.DeterminingPolicyItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.DeterminingPolicyItem.Builder#build()} is
         * called immediately and its result is passed to {@link #determiningPolicies(List<DeterminingPolicyItem>)}.
         * 
         * @param determiningPolicies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.verifiedpermissions.model.DeterminingPolicyItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #determiningPolicies(java.util.Collection<DeterminingPolicyItem>)
         */
        Builder determiningPolicies(Consumer<DeterminingPolicyItem.Builder>... determiningPolicies);

        /**
         * <p>
         * Errors that occurred while making an authorization decision, for example, a policy references an Entity or
         * entity Attribute that does not exist in the slice.
         * </p>
         * 
         * @param errors
         *        Errors that occurred while making an authorization decision, for example, a policy references an
         *        Entity or entity Attribute that does not exist in the slice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<EvaluationErrorItem> errors);

        /**
         * <p>
         * Errors that occurred while making an authorization decision, for example, a policy references an Entity or
         * entity Attribute that does not exist in the slice.
         * </p>
         * 
         * @param errors
         *        Errors that occurred while making an authorization decision, for example, a policy references an
         *        Entity or entity Attribute that does not exist in the slice.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(EvaluationErrorItem... errors);

        /**
         * <p>
         * Errors that occurred while making an authorization decision, for example, a policy references an Entity or
         * entity Attribute that does not exist in the slice.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.EvaluationErrorItem.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.EvaluationErrorItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.verifiedpermissions.model.EvaluationErrorItem.Builder#build()} is
         * called immediately and its result is passed to {@link #errors(List<EvaluationErrorItem>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.verifiedpermissions.model.EvaluationErrorItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<EvaluationErrorItem>)
         */
        Builder errors(Consumer<EvaluationErrorItem.Builder>... errors);
    }

    static final class BuilderImpl implements Builder {
        private BatchIsAuthorizedInputItem request;

        private String decision;

        private List<DeterminingPolicyItem> determiningPolicies = DefaultSdkAutoConstructList.getInstance();

        private List<EvaluationErrorItem> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchIsAuthorizedOutputItem model) {
            request(model.request);
            decision(model.decision);
            determiningPolicies(model.determiningPolicies);
            errors(model.errors);
        }

        public final BatchIsAuthorizedInputItem.Builder getRequest() {
            return request != null ? request.toBuilder() : null;
        }

        public final void setRequest(BatchIsAuthorizedInputItem.BuilderImpl request) {
            this.request = request != null ? request.build() : null;
        }

        @Override
        public final Builder request(BatchIsAuthorizedInputItem request) {
            this.request = request;
            return this;
        }

        public final String getDecision() {
            return decision;
        }

        public final void setDecision(String decision) {
            this.decision = decision;
        }

        @Override
        public final Builder decision(String decision) {
            this.decision = decision;
            return this;
        }

        @Override
        public final Builder decision(Decision decision) {
            this.decision(decision == null ? null : decision.toString());
            return this;
        }

        public final List<DeterminingPolicyItem.Builder> getDeterminingPolicies() {
            List<DeterminingPolicyItem.Builder> result = DeterminingPolicyListCopier.copyToBuilder(this.determiningPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeterminingPolicies(Collection<DeterminingPolicyItem.BuilderImpl> determiningPolicies) {
            this.determiningPolicies = DeterminingPolicyListCopier.copyFromBuilder(determiningPolicies);
        }

        @Override
        public final Builder determiningPolicies(Collection<DeterminingPolicyItem> determiningPolicies) {
            this.determiningPolicies = DeterminingPolicyListCopier.copy(determiningPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder determiningPolicies(DeterminingPolicyItem... determiningPolicies) {
            determiningPolicies(Arrays.asList(determiningPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder determiningPolicies(Consumer<DeterminingPolicyItem.Builder>... determiningPolicies) {
            determiningPolicies(Stream.of(determiningPolicies).map(c -> DeterminingPolicyItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<EvaluationErrorItem.Builder> getErrors() {
            List<EvaluationErrorItem.Builder> result = EvaluationErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<EvaluationErrorItem.BuilderImpl> errors) {
            this.errors = EvaluationErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<EvaluationErrorItem> errors) {
            this.errors = EvaluationErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(EvaluationErrorItem... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<EvaluationErrorItem.Builder>... errors) {
            errors(Stream.of(errors).map(c -> EvaluationErrorItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchIsAuthorizedOutputItem build() {
            return new BatchIsAuthorizedOutputItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
