/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.verifiedpermissions.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.verifiedpermissions.model.ValidationSettings;
import software.amazon.awssdk.services.verifiedpermissions.model.VerifiedPermissionsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPolicyStoreResponse
extends VerifiedPermissionsResponse
implements ToCopyableBuilder<Builder, GetPolicyStoreResponse> {
    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyStoreId").getter(GetPolicyStoreResponse.getter(GetPolicyStoreResponse::policyStoreId)).setter(GetPolicyStoreResponse.setter(Builder::policyStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetPolicyStoreResponse.getter(GetPolicyStoreResponse::arn)).setter(GetPolicyStoreResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<ValidationSettings> VALIDATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("validationSettings").getter(GetPolicyStoreResponse.getter(GetPolicyStoreResponse::validationSettings)).setter(GetPolicyStoreResponse.setter(Builder::validationSettings)).constructor(ValidationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationSettings").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdDate").getter(GetPolicyStoreResponse.getter(GetPolicyStoreResponse::createdDate)).setter(GetPolicyStoreResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDate").getter(GetPolicyStoreResponse.getter(GetPolicyStoreResponse::lastUpdatedDate)).setter(GetPolicyStoreResponse.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetPolicyStoreResponse.getter(GetPolicyStoreResponse::description)).setter(GetPolicyStoreResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_STORE_ID_FIELD, ARN_FIELD, VALIDATION_SETTINGS_FIELD, CREATED_DATE_FIELD, LAST_UPDATED_DATE_FIELD, DESCRIPTION_FIELD));
    private final String policyStoreId;
    private final String arn;
    private final ValidationSettings validationSettings;
    private final Instant createdDate;
    private final Instant lastUpdatedDate;
    private final String description;

    private GetPolicyStoreResponse(BuilderImpl builder) {
        super(builder);
        this.policyStoreId = builder.policyStoreId;
        this.arn = builder.arn;
        this.validationSettings = builder.validationSettings;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.description = builder.description;
    }

    public final String policyStoreId() {
        return this.policyStoreId;
    }

    public final String arn() {
        return this.arn;
    }

    public final ValidationSettings validationSettings() {
        return this.validationSettings;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPolicyStoreResponse)) {
            return false;
        }
        GetPolicyStoreResponse other = (GetPolicyStoreResponse)((Object)obj);
        return Objects.equals(this.policyStoreId(), other.policyStoreId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.validationSettings(), other.validationSettings()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"GetPolicyStoreResponse").add("PolicyStoreId", (Object)this.policyStoreId()).add("Arn", (Object)this.arn()).add("ValidationSettings", (Object)this.validationSettings()).add("CreatedDate", (Object)this.createdDate()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyStoreId": {
                return Optional.ofNullable(clazz.cast(this.policyStoreId()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "validationSettings": {
                return Optional.ofNullable(clazz.cast(this.validationSettings()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "lastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPolicyStoreResponse, T> g) {
        return obj -> g.apply((GetPolicyStoreResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends VerifiedPermissionsResponse.BuilderImpl
    implements Builder {
        private String policyStoreId;
        private String arn;
        private ValidationSettings validationSettings;
        private Instant createdDate;
        private Instant lastUpdatedDate;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPolicyStoreResponse model) {
            super(model);
            this.policyStoreId(model.policyStoreId);
            this.arn(model.arn);
            this.validationSettings(model.validationSettings);
            this.createdDate(model.createdDate);
            this.lastUpdatedDate(model.lastUpdatedDate);
            this.description(model.description);
        }

        public final String getPolicyStoreId() {
            return this.policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final ValidationSettings.Builder getValidationSettings() {
            return this.validationSettings != null ? this.validationSettings.toBuilder() : null;
        }

        public final void setValidationSettings(ValidationSettings.BuilderImpl validationSettings) {
            this.validationSettings = validationSettings != null ? validationSettings.build() : null;
        }

        @Override
        public final Builder validationSettings(ValidationSettings validationSettings) {
            this.validationSettings = validationSettings;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public GetPolicyStoreResponse build() {
            return new GetPolicyStoreResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends VerifiedPermissionsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPolicyStoreResponse> {
        public Builder policyStoreId(String var1);

        public Builder arn(String var1);

        public Builder validationSettings(ValidationSettings var1);

        default public Builder validationSettings(Consumer<ValidationSettings.Builder> validationSettings) {
            return this.validationSettings((ValidationSettings)((ValidationSettings.Builder)ValidationSettings.builder().applyMutation(validationSettings)).build());
        }

        public Builder createdDate(Instant var1);

        public Builder lastUpdatedDate(Instant var1);

        public Builder description(String var1);
    }
}

