/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateIdentitySourceResponse extends VerifiedPermissionsResponse implements
        ToCopyableBuilder<UpdateIdentitySourceResponse.Builder, UpdateIdentitySourceResponse> {
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate")
            .getter(getter(UpdateIdentitySourceResponse::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> IDENTITY_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identitySourceId").getter(getter(UpdateIdentitySourceResponse::identitySourceId))
            .setter(setter(Builder::identitySourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identitySourceId").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDate")
            .getter(getter(UpdateIdentitySourceResponse::lastUpdatedDate))
            .setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> POLICY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyStoreId").getter(getter(UpdateIdentitySourceResponse::policyStoreId))
            .setter(setter(Builder::policyStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyStoreId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_DATE_FIELD,
            IDENTITY_SOURCE_ID_FIELD, LAST_UPDATED_DATE_FIELD, POLICY_STORE_ID_FIELD));

    private final Instant createdDate;

    private final String identitySourceId;

    private final Instant lastUpdatedDate;

    private final String policyStoreId;

    private UpdateIdentitySourceResponse(BuilderImpl builder) {
        super(builder);
        this.createdDate = builder.createdDate;
        this.identitySourceId = builder.identitySourceId;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.policyStoreId = builder.policyStoreId;
    }

    /**
     * <p>
     * The date and time that the updated identity source was originally created.
     * </p>
     * 
     * @return The date and time that the updated identity source was originally created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The ID of the updated identity source.
     * </p>
     * 
     * @return The ID of the updated identity source.
     */
    public final String identitySourceId() {
        return identitySourceId;
    }

    /**
     * <p>
     * The date and time that the identity source was most recently updated.
     * </p>
     * 
     * @return The date and time that the identity source was most recently updated.
     */
    public final Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * The ID of the policy store that contains the updated identity source.
     * </p>
     * 
     * @return The ID of the policy store that contains the updated identity source.
     */
    public final String policyStoreId() {
        return policyStoreId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(identitySourceId());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(policyStoreId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateIdentitySourceResponse)) {
            return false;
        }
        UpdateIdentitySourceResponse other = (UpdateIdentitySourceResponse) obj;
        return Objects.equals(createdDate(), other.createdDate()) && Objects.equals(identitySourceId(), other.identitySourceId())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate())
                && Objects.equals(policyStoreId(), other.policyStoreId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateIdentitySourceResponse").add("CreatedDate", createdDate())
                .add("IdentitySourceId", identitySourceId()).add("LastUpdatedDate", lastUpdatedDate())
                .add("PolicyStoreId", policyStoreId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "identitySourceId":
            return Optional.ofNullable(clazz.cast(identitySourceId()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "policyStoreId":
            return Optional.ofNullable(clazz.cast(policyStoreId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateIdentitySourceResponse, T> g) {
        return obj -> g.apply((UpdateIdentitySourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VerifiedPermissionsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateIdentitySourceResponse> {
        /**
         * <p>
         * The date and time that the updated identity source was originally created.
         * </p>
         * 
         * @param createdDate
         *        The date and time that the updated identity source was originally created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * The ID of the updated identity source.
         * </p>
         * 
         * @param identitySourceId
         *        The ID of the updated identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identitySourceId(String identitySourceId);

        /**
         * <p>
         * The date and time that the identity source was most recently updated.
         * </p>
         * 
         * @param lastUpdatedDate
         *        The date and time that the identity source was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * The ID of the policy store that contains the updated identity source.
         * </p>
         * 
         * @param policyStoreId
         *        The ID of the policy store that contains the updated identity source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyStoreId(String policyStoreId);
    }

    static final class BuilderImpl extends VerifiedPermissionsResponse.BuilderImpl implements Builder {
        private Instant createdDate;

        private String identitySourceId;

        private Instant lastUpdatedDate;

        private String policyStoreId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateIdentitySourceResponse model) {
            super(model);
            createdDate(model.createdDate);
            identitySourceId(model.identitySourceId);
            lastUpdatedDate(model.lastUpdatedDate);
            policyStoreId(model.policyStoreId);
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getIdentitySourceId() {
            return identitySourceId;
        }

        public final void setIdentitySourceId(String identitySourceId) {
            this.identitySourceId = identitySourceId;
        }

        @Override
        public final Builder identitySourceId(String identitySourceId) {
            this.identitySourceId = identitySourceId;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final String getPolicyStoreId() {
            return policyStoreId;
        }

        public final void setPolicyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
        }

        @Override
        public final Builder policyStoreId(String policyStoreId) {
            this.policyStoreId = policyStoreId;
            return this;
        }

        @Override
        public UpdateIdentitySourceResponse build() {
            return new UpdateIdentitySourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
