/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePolicyStoreRequest extends VerifiedPermissionsRequest implements
        ToCopyableBuilder<CreatePolicyStoreRequest.Builder, CreatePolicyStoreRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreatePolicyStoreRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<ValidationSettings> VALIDATION_SETTINGS_FIELD = SdkField
            .<ValidationSettings> builder(MarshallingType.SDK_POJO).memberName("validationSettings")
            .getter(getter(CreatePolicyStoreRequest::validationSettings)).setter(setter(Builder::validationSettings))
            .constructor(ValidationSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationSettings").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreatePolicyStoreRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            VALIDATION_SETTINGS_FIELD, DESCRIPTION_FIELD));

    private final String clientToken;

    private final ValidationSettings validationSettings;

    private final String description;

    private CreatePolicyStoreRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.validationSettings = builder.validationSettings;
        this.description = builder.description;
    }

    /**
     * <p>
     * Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets you
     * safely retry the request without accidentally performing the same operation a second time. Passing the same value
     * to a later call to an operation requires that you also pass the same value for all other parameters. We recommend
     * that you use a <a href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.
     * </p>
     * <p>
     * If you don't provide this value, then Amazon Web Services generates a random one for you.
     * </p>
     * <p>
     * If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry fails
     * with an <code>IdempotentParameterMismatch</code> error.
     * </p>
     * 
     * @return Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This
     *         lets you safely retry the request without accidentally performing the same operation a second time.
     *         Passing the same value to a later call to an operation requires that you also pass the same value for all
     *         other parameters. We recommend that you use a <a
     *         href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
     *         <p>
     *         If you don't provide this value, then Amazon Web Services generates a random one for you.
     *         </p>
     *         <p>
     *         If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the
     *         retry fails with an <code>IdempotentParameterMismatch</code> error.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Specifies the validation setting for this policy store.
     * </p>
     * <p>
     * Currently, the only valid and required value is <code>Mode</code>.
     * </p>
     * <important>
     * <p>
     * We recommend that you turn on <code>STRICT</code> mode only after you define a schema. If a schema doesn't exist,
     * then <code>STRICT</code> mode causes any policy to fail validation, and Verified Permissions rejects the policy.
     * You can turn off validation by using the <a
     * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore"
     * >UpdatePolicyStore</a>. Then, when you have a schema defined, use <a
     * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore"
     * >UpdatePolicyStore</a> again to turn validation back on.
     * </p>
     * </important>
     * 
     * @return Specifies the validation setting for this policy store.</p>
     *         <p>
     *         Currently, the only valid and required value is <code>Mode</code>.
     *         </p>
     *         <important>
     *         <p>
     *         We recommend that you turn on <code>STRICT</code> mode only after you define a schema. If a schema
     *         doesn't exist, then <code>STRICT</code> mode causes any policy to fail validation, and Verified
     *         Permissions rejects the policy. You can turn off validation by using the <a
     *         href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore"
     *         >UpdatePolicyStore</a>. Then, when you have a schema defined, use <a
     *         href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore"
     *         >UpdatePolicyStore</a> again to turn validation back on.
     *         </p>
     */
    public final ValidationSettings validationSettings() {
        return validationSettings;
    }

    /**
     * <p>
     * Descriptive text that you can provide to help with identification of the current policy store.
     * </p>
     * 
     * @return Descriptive text that you can provide to help with identification of the current policy store.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(validationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePolicyStoreRequest)) {
            return false;
        }
        CreatePolicyStoreRequest other = (CreatePolicyStoreRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(validationSettings(), other.validationSettings())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePolicyStoreRequest").add("ClientToken", clientToken())
                .add("ValidationSettings", validationSettings())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "validationSettings":
            return Optional.ofNullable(clazz.cast(validationSettings()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePolicyStoreRequest, T> g) {
        return obj -> g.apply((CreatePolicyStoreRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends VerifiedPermissionsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePolicyStoreRequest> {
        /**
         * <p>
         * Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This lets
         * you safely retry the request without accidentally performing the same operation a second time. Passing the
         * same value to a later call to an operation requires that you also pass the same value for all other
         * parameters. We recommend that you use a <a
         * href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.
         * </p>
         * <p>
         * If you don't provide this value, then Amazon Web Services generates a random one for you.
         * </p>
         * <p>
         * If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the retry
         * fails with an <code>IdempotentParameterMismatch</code> error.
         * </p>
         * 
         * @param clientToken
         *        Specifies a unique, case-sensitive ID that you provide to ensure the idempotency of the request. This
         *        lets you safely retry the request without accidentally performing the same operation a second time.
         *        Passing the same value to a later call to an operation requires that you also pass the same value for
         *        all other parameters. We recommend that you use a <a
         *        href="https://wikipedia.org/wiki/Universally_unique_identifier">UUID type of value.</a>.</p>
         *        <p>
         *        If you don't provide this value, then Amazon Web Services generates a random one for you.
         *        </p>
         *        <p>
         *        If you retry the operation with the same <code>ClientToken</code>, but with different parameters, the
         *        retry fails with an <code>IdempotentParameterMismatch</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Specifies the validation setting for this policy store.
         * </p>
         * <p>
         * Currently, the only valid and required value is <code>Mode</code>.
         * </p>
         * <important>
         * <p>
         * We recommend that you turn on <code>STRICT</code> mode only after you define a schema. If a schema doesn't
         * exist, then <code>STRICT</code> mode causes any policy to fail validation, and Verified Permissions rejects
         * the policy. You can turn off validation by using the <a
         * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore"
         * >UpdatePolicyStore</a>. Then, when you have a schema defined, use <a
         * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore"
         * >UpdatePolicyStore</a> again to turn validation back on.
         * </p>
         * </important>
         * 
         * @param validationSettings
         *        Specifies the validation setting for this policy store.</p>
         *        <p>
         *        Currently, the only valid and required value is <code>Mode</code>.
         *        </p>
         *        <important>
         *        <p>
         *        We recommend that you turn on <code>STRICT</code> mode only after you define a schema. If a schema
         *        doesn't exist, then <code>STRICT</code> mode causes any policy to fail validation, and Verified
         *        Permissions rejects the policy. You can turn off validation by using the <a
         *        href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore"
         *        >UpdatePolicyStore</a>. Then, when you have a schema defined, use <a
         *        href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore"
         *        >UpdatePolicyStore</a> again to turn validation back on.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationSettings(ValidationSettings validationSettings);

        /**
         * <p>
         * Specifies the validation setting for this policy store.
         * </p>
         * <p>
         * Currently, the only valid and required value is <code>Mode</code>.
         * </p>
         * <important>
         * <p>
         * We recommend that you turn on <code>STRICT</code> mode only after you define a schema. If a schema doesn't
         * exist, then <code>STRICT</code> mode causes any policy to fail validation, and Verified Permissions rejects
         * the policy. You can turn off validation by using the <a
         * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore"
         * >UpdatePolicyStore</a>. Then, when you have a schema defined, use <a
         * href="https://docs.aws.amazon.com/verifiedpermissions/latest/apireference/API_UpdatePolicyStore"
         * >UpdatePolicyStore</a> again to turn validation back on.
         * </p>
         * </important> This is a convenience method that creates an instance of the {@link ValidationSettings.Builder}
         * avoiding the need to create one manually via {@link ValidationSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ValidationSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #validationSettings(ValidationSettings)}.
         * 
         * @param validationSettings
         *        a consumer that will call methods on {@link ValidationSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationSettings(ValidationSettings)
         */
        default Builder validationSettings(Consumer<ValidationSettings.Builder> validationSettings) {
            return validationSettings(ValidationSettings.builder().applyMutation(validationSettings).build());
        }

        /**
         * <p>
         * Descriptive text that you can provide to help with identification of the current policy store.
         * </p>
         * 
         * @param description
         *        Descriptive text that you can provide to help with identification of the current policy store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends VerifiedPermissionsRequest.BuilderImpl implements Builder {
        private String clientToken;

        private ValidationSettings validationSettings;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePolicyStoreRequest model) {
            super(model);
            clientToken(model.clientToken);
            validationSettings(model.validationSettings);
            description(model.description);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final ValidationSettings.Builder getValidationSettings() {
            return validationSettings != null ? validationSettings.toBuilder() : null;
        }

        public final void setValidationSettings(ValidationSettings.BuilderImpl validationSettings) {
            this.validationSettings = validationSettings != null ? validationSettings.build() : null;
        }

        @Override
        public final Builder validationSettings(ValidationSettings validationSettings) {
            this.validationSettings = validationSettings;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePolicyStoreRequest build() {
            return new CreatePolicyStoreRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
