/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.verifiedpermissions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of user groups and entities from an Amazon Cognito user pool identity source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCognitoGroupConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateCognitoGroupConfiguration.Builder, UpdateCognitoGroupConfiguration> {
    private static final SdkField<String> GROUP_ENTITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupEntityType").getter(getter(UpdateCognitoGroupConfiguration::groupEntityType))
            .setter(setter(Builder::groupEntityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupEntityType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ENTITY_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupEntityType;

    private UpdateCognitoGroupConfiguration(BuilderImpl builder) {
        this.groupEntityType = builder.groupEntityType;
    }

    /**
     * <p>
     * The name of the schema entity type that's mapped to the user pool group. Defaults to
     * <code>AWS::CognitoGroup</code>.
     * </p>
     * 
     * @return The name of the schema entity type that's mapped to the user pool group. Defaults to
     *         <code>AWS::CognitoGroup</code>.
     */
    public final String groupEntityType() {
        return groupEntityType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupEntityType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCognitoGroupConfiguration)) {
            return false;
        }
        UpdateCognitoGroupConfiguration other = (UpdateCognitoGroupConfiguration) obj;
        return Objects.equals(groupEntityType(), other.groupEntityType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCognitoGroupConfiguration")
                .add("GroupEntityType", groupEntityType() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "groupEntityType":
            return Optional.ofNullable(clazz.cast(groupEntityType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCognitoGroupConfiguration, T> g) {
        return obj -> g.apply((UpdateCognitoGroupConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateCognitoGroupConfiguration> {
        /**
         * <p>
         * The name of the schema entity type that's mapped to the user pool group. Defaults to
         * <code>AWS::CognitoGroup</code>.
         * </p>
         * 
         * @param groupEntityType
         *        The name of the schema entity type that's mapped to the user pool group. Defaults to
         *        <code>AWS::CognitoGroup</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupEntityType(String groupEntityType);
    }

    static final class BuilderImpl implements Builder {
        private String groupEntityType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCognitoGroupConfiguration model) {
            groupEntityType(model.groupEntityType);
        }

        public final String getGroupEntityType() {
            return groupEntityType;
        }

        public final void setGroupEntityType(String groupEntityType) {
            this.groupEntityType = groupEntityType;
        }

        @Override
        public final Builder groupEntityType(String groupEntityType) {
            this.groupEntityType = groupEntityType;
            return this;
        }

        @Override
        public UpdateCognitoGroupConfiguration build() {
            return new UpdateCognitoGroupConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
